/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.ToRubyEncodingNode;
import org.truffleruby.core.cast.ToRubyEncodingNodeGen;
import org.truffleruby.core.encoding.EncodingNodes;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.interop.ToJavaStringNodeGen;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyTypes;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.yield.CallBlockNode;
import org.truffleruby.language.yield.CallBlockNodeGen;

@GeneratedBy(value=EncodingNodes.class)
public final class EncodingNodesFactory {
    public static List<NodeFactory<? extends RubyContextSourceNode>> getFactories() {
        return List.of(AsciiCompatibleNodeFactory.getInstance(), CompatibleQueryNodeFactory.getInstance(), AreStringsCompatibleNodeFactory.getInstance(), ListNodeFactory.getInstance(), LocaleCharacterMapNodeFactory.getInstance(), DummyNodeFactory.getInstance(), ToSNodeFactory.getInstance(), AllocateNodeFactory.getInstance(), EachAliasNodeFactory.getInstance(), DefineAliasNodeFactory.getInstance(), IsUnicodeNodeFactory.getInstance(), GetActualEncodingPrimitiveNodeFactory.getInstance(), GetDefaultEncodingNodeFactory.getInstance(), SetDefaultExternalNodeFactory.getInstance(), SetDefaultInternalNodeFactory.getInstance(), EncodingGetObjectEncodingNodeFactory.getInstance(), DummyEncodingNodeFactory.getInstance(), GetEncodingObjectByIndexNodeFactory.getInstance(), GetEncodingIndexNodeFactory.getInstance(), CheckStringEncodingPrimitiveNodeFactory.getInstance(), UnicodeVersionNodeFactory.getInstance(), UnicodeEmojiVersionNodeFactory.getInstance());
    }

    @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
    public static final class AsciiCompatibleNodeFactory
    implements NodeFactory<EncodingNodes.AsciiCompatibleNode> {
        private static final AsciiCompatibleNodeFactory ASCII_COMPATIBLE_NODE_FACTORY_INSTANCE = new AsciiCompatibleNodeFactory();

        private AsciiCompatibleNodeFactory() {
        }

        public Class<EncodingNodes.AsciiCompatibleNode> getNodeClass() {
            return EncodingNodes.AsciiCompatibleNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.AsciiCompatibleNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AsciiCompatibleNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.AsciiCompatibleNode> getInstance() {
            return ASCII_COMPATIBLE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.AsciiCompatibleNode create(RubyNode[] argumentNodes) {
            return new AsciiCompatibleNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
        public static final class AsciiCompatibleNodeGen
        extends EncodingNodes.AsciiCompatibleNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private AsciiCompatibleNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                    return this.isAsciiCompatible(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.isAsciiCompatible(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
    public static final class CompatibleQueryNodeFactory
    implements NodeFactory<EncodingNodes.CompatibleQueryNode> {
        private static final CompatibleQueryNodeFactory COMPATIBLE_QUERY_NODE_FACTORY_INSTANCE = new CompatibleQueryNodeFactory();

        private CompatibleQueryNodeFactory() {
        }

        public Class<EncodingNodes.CompatibleQueryNode> getNodeClass() {
            return EncodingNodes.CompatibleQueryNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.CompatibleQueryNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CompatibleQueryNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.CompatibleQueryNode> getInstance() {
            return COMPATIBLE_QUERY_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.CompatibleQueryNode create(RubyNode[] argumentNodes) {
            return new CompatibleQueryNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
        public static final class CompatibleQueryNodeGen
        extends EncodingNodes.CompatibleQueryNode {
            private static final InlineSupport.StateField STATE_0_CompatibleQueryNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlineSupport.StateField STATE_1_CompatibleQueryNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_1_");
            private static final EncodingNodes.NegotiateCompatibleEncodingNode INLINED_NEGOTIATE_COMPATIBLE_ENCODING_NODE_ = NegotiateCompatibleEncodingNodeGen.inline(InlineSupport.InlineTarget.create(EncodingNodes.NegotiateCompatibleEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_CompatibleQueryNode_UPDATER.subUpdater(0, 32), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"negotiateCompatibleEncodingNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"negotiateCompatibleEncodingNode__field2_", Node.class)}));
            private static final ToRubyEncodingNode INLINED_TO_RUBY_ENCODING_NODE_ = ToRubyEncodingNodeGen.inline(InlineSupport.InlineTarget.create(ToRubyEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_CompatibleQueryNode_UPDATER.subUpdater(0, 18)}));
            private static final InlinedConditionProfile INLINED_NULL_ENCODING_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_CompatibleQueryNode_UPDATER.subUpdater(18, 2)}));
            private static final InlinedConditionProfile INLINED_NO_NEGOTIATED_ENCODING_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_CompatibleQueryNode_UPDATER.subUpdater(20, 2)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node negotiateCompatibleEncodingNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node negotiateCompatibleEncodingNode__field2_;

            private CompatibleQueryNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                return this.isCompatible(argumentNodes0Value_, argumentNodes1Value_, INLINED_NEGOTIATE_COMPATIBLE_ENCODING_NODE_, INLINED_TO_RUBY_ENCODING_NODE_, INLINED_NULL_ENCODING_PROFILE_, INLINED_NO_NEGOTIATED_ENCODING_PROFILE_);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.AreStringsCompatibleNode.class)
    public static final class AreStringsCompatibleNodeFactory
    implements NodeFactory<EncodingNodes.AreStringsCompatibleNode> {
        private static final AreStringsCompatibleNodeFactory ARE_STRINGS_COMPATIBLE_NODE_FACTORY_INSTANCE = new AreStringsCompatibleNodeFactory();

        private AreStringsCompatibleNodeFactory() {
        }

        public Class<EncodingNodes.AreStringsCompatibleNode> getNodeClass() {
            return EncodingNodes.AreStringsCompatibleNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.AreStringsCompatibleNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AreStringsCompatibleNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.AreStringsCompatibleNode> getInstance() {
            return ARE_STRINGS_COMPATIBLE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.AreStringsCompatibleNode create(RubyNode[] argumentNodes) {
            return new AreStringsCompatibleNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.AreStringsCompatibleNode.class)
        public static final class AreStringsCompatibleNodeGen
        extends EncodingNodes.AreStringsCompatibleNode {
            private static final InlineSupport.StateField STATE_0_AreStringsCompatibleNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final RubyStringLibrary INLINED_LIB_FIRST_ = RubyStringLibrary.inline(InlineSupport.InlineTarget.create(RubyStringLibrary.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_AreStringsCompatibleNode_UPDATER.subUpdater(0, 6)}));
            private static final RubyStringLibrary INLINED_LIB_SECOND_ = RubyStringLibrary.inline(InlineSupport.InlineTarget.create(RubyStringLibrary.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_AreStringsCompatibleNode_UPDATER.subUpdater(6, 6)}));
            private static final EncodingNodes.NegotiateCompatibleStringEncodingNode INLINED_NEGOTIATE_COMPATIBLE_STRING_ENCODING_NODE_ = NegotiateCompatibleStringEncodingNodeGen.inline(InlineSupport.InlineTarget.create(EncodingNodes.NegotiateCompatibleStringEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_AreStringsCompatibleNode_UPDATER.subUpdater(12, 11), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"negotiateCompatibleStringEncodingNode__field1_", Node.class)}));
            private static final InlinedConditionProfile INLINED_NO_NEGOTIATED_ENCODING_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_AreStringsCompatibleNode_UPDATER.subUpdater(23, 2)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node negotiateCompatibleStringEncodingNode__field1_;

            private AreStringsCompatibleNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                return this.areCompatible(argumentNodes0Value_, argumentNodes1Value_, INLINED_LIB_FIRST_, INLINED_LIB_SECOND_, INLINED_NEGOTIATE_COMPATIBLE_STRING_ENCODING_NODE_, INLINED_NO_NEGOTIATED_ENCODING_PROFILE_);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.ListNode.class)
    public static final class ListNodeFactory
    implements NodeFactory<EncodingNodes.ListNode> {
        private static final ListNodeFactory LIST_NODE_FACTORY_INSTANCE = new ListNodeFactory();

        private ListNodeFactory() {
        }

        public Class<EncodingNodes.ListNode> getNodeClass() {
            return EncodingNodes.ListNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.ListNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ListNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.ListNode> getInstance() {
            return LIST_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.ListNode create(RubyNode[] argumentNodes) {
            return new ListNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.ListNode.class)
        public static final class ListNodeGen
        extends EncodingNodes.ListNode {
            private ListNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.list();
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.LocaleCharacterMapNode.class)
    public static final class LocaleCharacterMapNodeFactory
    implements NodeFactory<EncodingNodes.LocaleCharacterMapNode> {
        private static final LocaleCharacterMapNodeFactory LOCALE_CHARACTER_MAP_NODE_FACTORY_INSTANCE = new LocaleCharacterMapNodeFactory();

        private LocaleCharacterMapNodeFactory() {
        }

        public Class<EncodingNodes.LocaleCharacterMapNode> getNodeClass() {
            return EncodingNodes.LocaleCharacterMapNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.LocaleCharacterMapNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return LocaleCharacterMapNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.LocaleCharacterMapNode> getInstance() {
            return LOCALE_CHARACTER_MAP_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.LocaleCharacterMapNode create(RubyNode[] argumentNodes) {
            return new LocaleCharacterMapNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.LocaleCharacterMapNode.class)
        public static final class LocaleCharacterMapNodeGen
        extends EncodingNodes.LocaleCharacterMapNode {
            private LocaleCharacterMapNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.localeCharacterMap();
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.DummyNode.class)
    public static final class DummyNodeFactory
    implements NodeFactory<EncodingNodes.DummyNode> {
        private static final DummyNodeFactory DUMMY_NODE_FACTORY_INSTANCE = new DummyNodeFactory();

        private DummyNodeFactory() {
        }

        public Class<EncodingNodes.DummyNode> getNodeClass() {
            return EncodingNodes.DummyNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.DummyNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DummyNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.DummyNode> getInstance() {
            return DUMMY_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.DummyNode create(RubyNode[] argumentNodes) {
            return new DummyNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.DummyNode.class)
        public static final class DummyNodeGen
        extends EncodingNodes.DummyNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private DummyNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                    return this.isDummy(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.isDummy(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.ToSNode.class)
    public static final class ToSNodeFactory
    implements NodeFactory<EncodingNodes.ToSNode> {
        private static final ToSNodeFactory TO_SNODE_FACTORY_INSTANCE = new ToSNodeFactory();

        private ToSNodeFactory() {
        }

        public Class<EncodingNodes.ToSNode> getNodeClass() {
            return EncodingNodes.ToSNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.ToSNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ToSNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.ToSNode> getInstance() {
            return TO_SNODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.ToSNode create(RubyNode[] argumentNodes) {
            return new ToSNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends EncodingNodes.ToSNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ToSNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                    return this.toS(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private ImmutableRubyString executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.toS(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    implements NodeFactory<EncodingNodes.AllocateNode> {
        private static final AllocateNodeFactory ALLOCATE_NODE_FACTORY_INSTANCE = new AllocateNodeFactory();

        private AllocateNodeFactory() {
        }

        public Class<EncodingNodes.AllocateNode> getNodeClass() {
            return EncodingNodes.AllocateNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AllocateNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.AllocateNode> getInstance() {
            return ALLOCATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.AllocateNode create(RubyNode[] argumentNodes) {
            return new AllocateNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends EncodingNodes.AllocateNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private AllocateNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyClass) {
                    RubyClass argumentNodes0Value__ = (RubyClass)argumentNodes0Value_;
                    return this.allocate(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyClass) {
                    RubyClass argumentNodes0Value_ = (RubyClass)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.allocate(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.EachAliasNode.class)
    public static final class EachAliasNodeFactory
    implements NodeFactory<EncodingNodes.EachAliasNode> {
        private static final EachAliasNodeFactory EACH_ALIAS_NODE_FACTORY_INSTANCE = new EachAliasNodeFactory();

        private EachAliasNodeFactory() {
        }

        public Class<EncodingNodes.EachAliasNode> getNodeClass() {
            return EncodingNodes.EachAliasNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.EachAliasNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EachAliasNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.EachAliasNode> getInstance() {
            return EACH_ALIAS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.EachAliasNode create(RubyNode[] argumentNodes) {
            return new EachAliasNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.EachAliasNode.class)
        public static final class EachAliasNodeGen
        extends EncodingNodes.EachAliasNode {
            private static final InlineSupport.StateField STATE_0_EachAliasNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final CallBlockNode INLINED_YIELD_NODE_ = CallBlockNodeGen.inline(InlineSupport.InlineTarget.create(CallBlockNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_EachAliasNode_UPDATER.subUpdater(1, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"yieldNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"yieldNode__field2_", Node.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node yieldNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node yieldNode__field2_;

            private EachAliasNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if ((state_0 & 1) != 0 && argumentNodes0Value_ instanceof RubyProc) {
                    RubyProc argumentNodes0Value__ = (RubyProc)argumentNodes0Value_;
                    return this.eachAlias(argumentNodes0Value__, INLINED_YIELD_NODE_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyProc) {
                    RubyProc argumentNodes0Value_ = (RubyProc)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.eachAlias(argumentNodes0Value_, INLINED_YIELD_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.DefineAliasNode.class)
    public static final class DefineAliasNodeFactory
    implements NodeFactory<EncodingNodes.DefineAliasNode> {
        private static final DefineAliasNodeFactory DEFINE_ALIAS_NODE_FACTORY_INSTANCE = new DefineAliasNodeFactory();

        private DefineAliasNodeFactory() {
        }

        public Class<EncodingNodes.DefineAliasNode> getNodeClass() {
            return EncodingNodes.DefineAliasNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.DefineAliasNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DefineAliasNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.DefineAliasNode> getInstance() {
            return DEFINE_ALIAS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.DefineAliasNode create(RubyNode[] argumentNodes) {
            return new DefineAliasNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.DefineAliasNode.class)
        public static final class DefineAliasNodeGen
        extends EncodingNodes.DefineAliasNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private DefineAliasNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof RubySymbol) {
                        RubySymbol argumentNodes1Value__ = (RubySymbol)argumentNodes1Value_;
                        return this.defineAlias(argumentNodes0Value__, argumentNodes1Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private RubyEncoding executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    if (argumentNodes1Value instanceof RubySymbol) {
                        RubySymbol argumentNodes1Value_ = (RubySymbol)argumentNodes1Value;
                        this.state_0_ = state_0 |= 1;
                        return this.defineAlias(argumentNodes0Value_, argumentNodes1Value_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.IsUnicodeNode.class)
    public static final class IsUnicodeNodeFactory
    implements NodeFactory<EncodingNodes.IsUnicodeNode> {
        private static final IsUnicodeNodeFactory IS_UNICODE_NODE_FACTORY_INSTANCE = new IsUnicodeNodeFactory();

        private IsUnicodeNodeFactory() {
        }

        public Class<EncodingNodes.IsUnicodeNode> getNodeClass() {
            return EncodingNodes.IsUnicodeNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.IsUnicodeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return IsUnicodeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.IsUnicodeNode> getInstance() {
            return IS_UNICODE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.IsUnicodeNode create(RubyNode[] argumentNodes) {
            return new IsUnicodeNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.IsUnicodeNode.class)
        public static final class IsUnicodeNodeGen
        extends EncodingNodes.IsUnicodeNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private IsUnicodeNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                    return this.isUnicode(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.isUnicode(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.GetActualEncodingPrimitiveNode.class)
    public static final class GetActualEncodingPrimitiveNodeFactory
    implements NodeFactory<EncodingNodes.GetActualEncodingPrimitiveNode> {
        private static final GetActualEncodingPrimitiveNodeFactory GET_ACTUAL_ENCODING_PRIMITIVE_NODE_FACTORY_INSTANCE = new GetActualEncodingPrimitiveNodeFactory();

        private GetActualEncodingPrimitiveNodeFactory() {
        }

        public Class<EncodingNodes.GetActualEncodingPrimitiveNode> getNodeClass() {
            return EncodingNodes.GetActualEncodingPrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.GetActualEncodingPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetActualEncodingPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.GetActualEncodingPrimitiveNode> getInstance() {
            return GET_ACTUAL_ENCODING_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.GetActualEncodingPrimitiveNode create(RubyNode[] argumentNodes) {
            return new GetActualEncodingPrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.GetActualEncodingPrimitiveNode.class)
        public static final class GetActualEncodingPrimitiveNodeGen
        extends EncodingNodes.GetActualEncodingPrimitiveNode {
            private static final InlineSupport.StateField STATE_0_GetActualEncodingPrimitiveNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final EncodingNodes.GetActualEncodingNode INLINED_GET_ACTUAL_ENCODING_NODE_ = GetActualEncodingNodeGen.inline(InlineSupport.InlineTarget.create(EncodingNodes.GetActualEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GetActualEncodingPrimitiveNode_UPDATER.subUpdater(0, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getActualEncodingNode__field1_", Node.class)}));
            private static final RubyStringLibrary INLINED_LIB_STRING_ = RubyStringLibrary.inline(InlineSupport.InlineTarget.create(RubyStringLibrary.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GetActualEncodingPrimitiveNode_UPDATER.subUpdater(2, 6)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getActualEncodingNode__field1_;

            private GetActualEncodingPrimitiveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                GetActualEncodingPrimitiveNodeGen node__ = this;
                return EncodingNodes.GetActualEncodingPrimitiveNode.getActualEncoding(argumentNodes0Value_, INLINED_GET_ACTUAL_ENCODING_NODE_, INLINED_LIB_STRING_, node__);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.GetDefaultEncodingNode.class)
    public static final class GetDefaultEncodingNodeFactory
    implements NodeFactory<EncodingNodes.GetDefaultEncodingNode> {
        private static final GetDefaultEncodingNodeFactory GET_DEFAULT_ENCODING_NODE_FACTORY_INSTANCE = new GetDefaultEncodingNodeFactory();

        private GetDefaultEncodingNodeFactory() {
        }

        public Class<EncodingNodes.GetDefaultEncodingNode> getNodeClass() {
            return EncodingNodes.GetDefaultEncodingNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.GetDefaultEncodingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetDefaultEncodingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.GetDefaultEncodingNode> getInstance() {
            return GET_DEFAULT_ENCODING_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.GetDefaultEncodingNode create(RubyNode[] argumentNodes) {
            return new GetDefaultEncodingNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.GetDefaultEncodingNode.class)
        public static final class GetDefaultEncodingNodeGen
        extends EncodingNodes.GetDefaultEncodingNode {
            @Node.Child
            private RubyNode argumentNodes0_;

            private GetDefaultEncodingNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                return this.getDefaultEncoding(argumentNodes0Value_);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
    public static final class SetDefaultExternalNodeFactory
    implements NodeFactory<EncodingNodes.SetDefaultExternalNode> {
        private static final SetDefaultExternalNodeFactory SET_DEFAULT_EXTERNAL_NODE_FACTORY_INSTANCE = new SetDefaultExternalNodeFactory();

        private SetDefaultExternalNodeFactory() {
        }

        public Class<EncodingNodes.SetDefaultExternalNode> getNodeClass() {
            return EncodingNodes.SetDefaultExternalNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.SetDefaultExternalNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetDefaultExternalNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.SetDefaultExternalNode> getInstance() {
            return SET_DEFAULT_EXTERNAL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.SetDefaultExternalNode create(RubyNode[] argumentNodes) {
            return new SetDefaultExternalNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
        public static final class SetDefaultExternalNodeGen
        extends EncodingNodes.SetDefaultExternalNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private SetDefaultExternalNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                        RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                        return this.setDefaultExternal(argumentNodes0Value__);
                    }
                    if ((state_0 & 2) != 0 && RubyTypes.isNil(argumentNodes0Value_)) {
                        Nil argumentNodes0Value__ = RubyTypes.asNil(argumentNodes0Value_);
                        return this.noDefaultExternal(argumentNodes0Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyEncoding executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.setDefaultExternal(argumentNodes0Value_);
                }
                if (RubyTypes.isNil(argumentNodes0Value)) {
                    Nil argumentNodes0Value_ = RubyTypes.asNil(argumentNodes0Value);
                    this.state_0_ = state_0 |= 2;
                    return this.noDefaultExternal(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
    public static final class SetDefaultInternalNodeFactory
    implements NodeFactory<EncodingNodes.SetDefaultInternalNode> {
        private static final SetDefaultInternalNodeFactory SET_DEFAULT_INTERNAL_NODE_FACTORY_INSTANCE = new SetDefaultInternalNodeFactory();

        private SetDefaultInternalNodeFactory() {
        }

        public Class<EncodingNodes.SetDefaultInternalNode> getNodeClass() {
            return EncodingNodes.SetDefaultInternalNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.SetDefaultInternalNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetDefaultInternalNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.SetDefaultInternalNode> getInstance() {
            return SET_DEFAULT_INTERNAL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.SetDefaultInternalNode create(RubyNode[] argumentNodes) {
            return new SetDefaultInternalNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
        public static final class SetDefaultInternalNodeGen
        extends EncodingNodes.SetDefaultInternalNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private SetDefaultInternalNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                        RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                        return this.setDefaultInternal(argumentNodes0Value__);
                    }
                    if ((state_0 & 2) != 0 && RubyTypes.isNil(argumentNodes0Value_)) {
                        Nil argumentNodes0Value__ = RubyTypes.asNil(argumentNodes0Value_);
                        return this.noDefaultInternal(argumentNodes0Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.setDefaultInternal(argumentNodes0Value_);
                }
                if (RubyTypes.isNil(argumentNodes0Value)) {
                    Nil argumentNodes0Value_ = RubyTypes.asNil(argumentNodes0Value);
                    this.state_0_ = state_0 |= 2;
                    return this.noDefaultInternal(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingNode.class)
    public static final class EncodingGetObjectEncodingNodeFactory
    implements NodeFactory<EncodingNodes.EncodingGetObjectEncodingNode> {
        private static final EncodingGetObjectEncodingNodeFactory ENCODING_GET_OBJECT_ENCODING_NODE_FACTORY_INSTANCE = new EncodingGetObjectEncodingNodeFactory();

        private EncodingGetObjectEncodingNodeFactory() {
        }

        public Class<EncodingNodes.EncodingGetObjectEncodingNode> getNodeClass() {
            return EncodingNodes.EncodingGetObjectEncodingNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.EncodingGetObjectEncodingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EncodingGetObjectEncodingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.EncodingGetObjectEncodingNode> getInstance() {
            return ENCODING_GET_OBJECT_ENCODING_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.EncodingGetObjectEncodingNode create(RubyNode[] argumentNodes) {
            return new EncodingGetObjectEncodingNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingNode.class)
        public static final class EncodingGetObjectEncodingNodeGen
        extends EncodingNodes.EncodingGetObjectEncodingNode {
            private static final InlineSupport.StateField STATE_0_EncodingGetObjectEncodingNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final ToRubyEncodingNode INLINED_TO_RUBY_ENCODING_NODE_ = ToRubyEncodingNodeGen.inline(InlineSupport.InlineTarget.create(ToRubyEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_EncodingGetObjectEncodingNode_UPDATER.subUpdater(0, 18)}));
            private static final InlinedConditionProfile INLINED_NULL_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_EncodingGetObjectEncodingNode_UPDATER.subUpdater(18, 2)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private EncodingGetObjectEncodingNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                return this.getObjectEncoding(argumentNodes0Value_, INLINED_TO_RUBY_ENCODING_NODE_, INLINED_NULL_PROFILE_);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.DummyEncodingNode.class)
    public static final class DummyEncodingNodeFactory
    implements NodeFactory<EncodingNodes.DummyEncodingNode> {
        private static final DummyEncodingNodeFactory DUMMY_ENCODING_NODE_FACTORY_INSTANCE = new DummyEncodingNodeFactory();

        private DummyEncodingNodeFactory() {
        }

        public Class<EncodingNodes.DummyEncodingNode> getNodeClass() {
            return EncodingNodes.DummyEncodingNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.DummyEncodingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DummyEncodingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.DummyEncodingNode> getInstance() {
            return DUMMY_ENCODING_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.DummyEncodingNode create(RubyNode[] argumentNodes) {
            return new DummyEncodingNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.DummyEncodingNode.class)
        public static final class DummyEncodingNodeGen
        extends EncodingNodes.DummyEncodingNode {
            private static final InlineSupport.StateField STATE_1_DummyEncodingNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_1_");
            private static final InlineSupport.StateField STATE_0_DummyEncodingNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final RubyStringLibrary INLINED_STRINGS_ = RubyStringLibrary.inline(InlineSupport.InlineTarget.create(RubyStringLibrary.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_DummyEncodingNode_UPDATER.subUpdater(0, 6)}));
            private static final ToJavaStringNode INLINED_TO_JAVA_STRING_NODE_ = ToJavaStringNodeGen.inline(InlineSupport.InlineTarget.create(ToJavaStringNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_DummyEncodingNode_UPDATER.subUpdater(1, 12), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"toJavaStringNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"toJavaStringNode__field2_", Node.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node toJavaStringNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node toJavaStringNode__field2_;

            private DummyEncodingNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if ((state_0 & 1) != 0 && INLINED_STRINGS_.isRubyString(this, argumentNodes0Value_)) {
                    DummyEncodingNodeGen node__ = this;
                    return EncodingNodes.DummyEncodingNode.createDummyEncoding(argumentNodes0Value_, INLINED_STRINGS_, INLINED_TO_JAVA_STRING_NODE_, node__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyArray executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                DummyEncodingNodeGen node__ = null;
                boolean CreateDummyEncoding_duplicateFound_ = false;
                if ((state_0 & 1) != 0 && INLINED_STRINGS_.isRubyString(this, argumentNodes0Value)) {
                    CreateDummyEncoding_duplicateFound_ = true;
                    node__ = this;
                }
                if (!CreateDummyEncoding_duplicateFound_ && INLINED_STRINGS_.isRubyString(this, argumentNodes0Value) && (state_0 & 1) == 0) {
                    node__ = this;
                    this.state_0_ = state_0 |= 1;
                    CreateDummyEncoding_duplicateFound_ = true;
                }
                if (CreateDummyEncoding_duplicateFound_) {
                    return EncodingNodes.DummyEncodingNode.createDummyEncoding(argumentNodes0Value, INLINED_STRINGS_, INLINED_TO_JAVA_STRING_NODE_, node__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.GetEncodingObjectByIndexNode.class)
    public static final class GetEncodingObjectByIndexNodeFactory
    implements NodeFactory<EncodingNodes.GetEncodingObjectByIndexNode> {
        private static final GetEncodingObjectByIndexNodeFactory GET_ENCODING_OBJECT_BY_INDEX_NODE_FACTORY_INSTANCE = new GetEncodingObjectByIndexNodeFactory();

        private GetEncodingObjectByIndexNodeFactory() {
        }

        public Class<EncodingNodes.GetEncodingObjectByIndexNode> getNodeClass() {
            return EncodingNodes.GetEncodingObjectByIndexNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.GetEncodingObjectByIndexNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetEncodingObjectByIndexNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.GetEncodingObjectByIndexNode> getInstance() {
            return GET_ENCODING_OBJECT_BY_INDEX_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.GetEncodingObjectByIndexNode create(RubyNode[] argumentNodes) {
            return new GetEncodingObjectByIndexNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.GetEncodingObjectByIndexNode.class)
        public static final class GetEncodingObjectByIndexNodeGen
        extends EncodingNodes.GetEncodingObjectByIndexNode {
            static final InlineSupport.ReferenceField<GetEncodingData> GET_ENCODING_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getEncoding_cache", GetEncodingData.class);
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private GetEncodingData getEncoding_cache;

            private GetEncodingObjectByIndexNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof Integer) {
                    int argumentNodes0Value__ = (Integer)argumentNodes0Value_;
                    if ((state_0 & 1) != 0) {
                        assert (DSLSupport.assertIdempotence((boolean)this.isSingleContext()));
                        GetEncodingData s0_ = this.getEncoding_cache;
                        while (s0_ != null) {
                            if (argumentNodes0Value__ == s0_.cachedIndex_) {
                                return this.getEncoding(argumentNodes0Value__, s0_.cachedIndex_, s0_.cachedEncoding_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        return this.getEncodingUncached(argumentNodes0Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyEncoding executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof Integer) {
                    int argumentNodes0Value_ = (Integer)argumentNodes0Value;
                    if ((state_0 & 2) == 0 && this.isSingleContext()) {
                        GetEncodingData s0_;
                        block5: {
                            GetEncodingData s0_original;
                            do {
                                int count0_ = 0;
                                s0_original = s0_ = (GetEncodingData)GET_ENCODING_CACHE_UPDATER.getVolatile((Node)this);
                                while (s0_ != null && argumentNodes0Value_ != s0_.cachedIndex_) {
                                    ++count0_;
                                    s0_ = s0_.next_;
                                }
                                if (s0_ != null || count0_ >= this.getCacheLimit()) break block5;
                                s0_ = new GetEncodingData(s0_original);
                                s0_.cachedIndex_ = argumentNodes0Value_;
                                s0_.cachedEncoding_ = this.getContext().getEncodingManager().getRubyEncoding(argumentNodes0Value_);
                            } while (!GET_ENCODING_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s0_ != null) {
                            return this.getEncoding(argumentNodes0Value_, s0_.cachedIndex_, s0_.cachedEncoding_);
                        }
                    }
                    this.getEncoding_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    return this.getEncodingUncached(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            @GeneratedBy(value=EncodingNodes.GetEncodingObjectByIndexNode.class)
            @DenyReplace
            private static final class GetEncodingData
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                final GetEncodingData next_;
                @CompilerDirectives.CompilationFinal
                int cachedIndex_;
                @CompilerDirectives.CompilationFinal
                RubyEncoding cachedEncoding_;

                GetEncodingData(GetEncodingData next_) {
                    this.next_ = next_;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.GetEncodingIndexNode.class)
    public static final class GetEncodingIndexNodeFactory
    implements NodeFactory<EncodingNodes.GetEncodingIndexNode> {
        private static final GetEncodingIndexNodeFactory GET_ENCODING_INDEX_NODE_FACTORY_INSTANCE = new GetEncodingIndexNodeFactory();

        private GetEncodingIndexNodeFactory() {
        }

        public Class<EncodingNodes.GetEncodingIndexNode> getNodeClass() {
            return EncodingNodes.GetEncodingIndexNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.GetEncodingIndexNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetEncodingIndexNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.GetEncodingIndexNode> getInstance() {
            return GET_ENCODING_INDEX_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.GetEncodingIndexNode create(RubyNode[] argumentNodes) {
            return new GetEncodingIndexNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.GetEncodingIndexNode.class)
        public static final class GetEncodingIndexNodeGen
        extends EncodingNodes.GetEncodingIndexNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private GetEncodingIndexNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                    return this.getIndex(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private int executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.getIndex(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.CheckStringEncodingPrimitiveNode.class)
    public static final class CheckStringEncodingPrimitiveNodeFactory
    implements NodeFactory<EncodingNodes.CheckStringEncodingPrimitiveNode> {
        private static final CheckStringEncodingPrimitiveNodeFactory CHECK_STRING_ENCODING_PRIMITIVE_NODE_FACTORY_INSTANCE = new CheckStringEncodingPrimitiveNodeFactory();

        private CheckStringEncodingPrimitiveNodeFactory() {
        }

        public Class<EncodingNodes.CheckStringEncodingPrimitiveNode> getNodeClass() {
            return EncodingNodes.CheckStringEncodingPrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.CheckStringEncodingPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CheckStringEncodingPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.CheckStringEncodingPrimitiveNode> getInstance() {
            return CHECK_STRING_ENCODING_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.CheckStringEncodingPrimitiveNode create(RubyNode[] argumentNodes) {
            return new CheckStringEncodingPrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.CheckStringEncodingPrimitiveNode.class)
        public static final class CheckStringEncodingPrimitiveNodeGen
        extends EncodingNodes.CheckStringEncodingPrimitiveNode {
            private static final InlineSupport.StateField STATE_1_CheckStringEncodingPrimitiveNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_1_");
            private static final InlineSupport.StateField STATE_0_CheckStringEncodingPrimitiveNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final RubyStringLibrary INLINED_LIB_FIRST_ = RubyStringLibrary.inline(InlineSupport.InlineTarget.create(RubyStringLibrary.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_CheckStringEncodingPrimitiveNode_UPDATER.subUpdater(0, 6)}));
            private static final RubyStringLibrary INLINED_LIB_SECOND_ = RubyStringLibrary.inline(InlineSupport.InlineTarget.create(RubyStringLibrary.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_CheckStringEncodingPrimitiveNode_UPDATER.subUpdater(6, 6)}));
            private static final InlinedBranchProfile INLINED_ERROR_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_CheckStringEncodingPrimitiveNode_UPDATER.subUpdater(1, 1)}));
            private static final EncodingNodes.NegotiateCompatibleStringEncodingNode INLINED_NEGOTIATE_COMPATIBLE_STRING_ENCODING_NODE_ = NegotiateCompatibleStringEncodingNodeGen.inline(InlineSupport.InlineTarget.create(EncodingNodes.NegotiateCompatibleStringEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_CheckStringEncodingPrimitiveNode_UPDATER.subUpdater(2, 11), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"negotiateCompatibleStringEncodingNode__field1_", Node.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node negotiateCompatibleStringEncodingNode__field1_;

            private CheckStringEncodingPrimitiveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if ((state_0 & 1) != 0 && INLINED_LIB_FIRST_.isRubyString(this, argumentNodes0Value_) && INLINED_LIB_SECOND_.isRubyString(this, argumentNodes1Value_)) {
                    CheckStringEncodingPrimitiveNodeGen node__ = this;
                    return EncodingNodes.CheckStringEncodingPrimitiveNode.checkEncodingStringString(argumentNodes0Value_, argumentNodes1Value_, INLINED_LIB_FIRST_, INLINED_LIB_SECOND_, INLINED_ERROR_PROFILE_, INLINED_NEGOTIATE_COMPATIBLE_STRING_ENCODING_NODE_, node__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private RubyEncoding executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                CheckStringEncodingPrimitiveNodeGen node__ = null;
                boolean CheckEncodingStringString_duplicateFound_ = false;
                if ((state_0 & 1) != 0 && INLINED_LIB_FIRST_.isRubyString(this, argumentNodes0Value) && INLINED_LIB_SECOND_.isRubyString(this, argumentNodes1Value)) {
                    CheckEncodingStringString_duplicateFound_ = true;
                    node__ = this;
                }
                if (!CheckEncodingStringString_duplicateFound_ && INLINED_LIB_FIRST_.isRubyString(this, argumentNodes0Value) && INLINED_LIB_SECOND_.isRubyString(this, argumentNodes1Value) && (state_0 & 1) == 0) {
                    node__ = this;
                    this.state_0_ = state_0 |= 1;
                    CheckEncodingStringString_duplicateFound_ = true;
                }
                if (CheckEncodingStringString_duplicateFound_) {
                    return EncodingNodes.CheckStringEncodingPrimitiveNode.checkEncodingStringString(argumentNodes0Value, argumentNodes1Value, INLINED_LIB_FIRST_, INLINED_LIB_SECOND_, INLINED_ERROR_PROFILE_, INLINED_NEGOTIATE_COMPATIBLE_STRING_ENCODING_NODE_, node__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.UnicodeVersionNode.class)
    public static final class UnicodeVersionNodeFactory
    implements NodeFactory<EncodingNodes.UnicodeVersionNode> {
        private static final UnicodeVersionNodeFactory UNICODE_VERSION_NODE_FACTORY_INSTANCE = new UnicodeVersionNodeFactory();

        private UnicodeVersionNodeFactory() {
        }

        public Class<EncodingNodes.UnicodeVersionNode> getNodeClass() {
            return EncodingNodes.UnicodeVersionNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.UnicodeVersionNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return UnicodeVersionNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.UnicodeVersionNode> getInstance() {
            return UNICODE_VERSION_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.UnicodeVersionNode create(RubyNode[] argumentNodes) {
            return new UnicodeVersionNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.UnicodeVersionNode.class)
        public static final class UnicodeVersionNodeGen
        extends EncodingNodes.UnicodeVersionNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private TruffleString.FromJavaStringNode fromJavaStringNode_;

            private UnicodeVersionNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[0];
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                TruffleString.FromJavaStringNode fromJavaStringNode__;
                int state_0 = this.state_0_;
                if (state_0 != 0 && (fromJavaStringNode__ = this.fromJavaStringNode_) != null) {
                    return this.getUnicodeVersion(fromJavaStringNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize();
            }

            private RubyString executeAndSpecialize() {
                int state_0 = this.state_0_;
                TruffleString.FromJavaStringNode fromJavaStringNode__ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fromJavaStringNode_ = fromJavaStringNode__;
                this.state_0_ = state_0 |= 1;
                return this.getUnicodeVersion(fromJavaStringNode__);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.UnicodeEmojiVersionNode.class)
    public static final class UnicodeEmojiVersionNodeFactory
    implements NodeFactory<EncodingNodes.UnicodeEmojiVersionNode> {
        private static final UnicodeEmojiVersionNodeFactory UNICODE_EMOJI_VERSION_NODE_FACTORY_INSTANCE = new UnicodeEmojiVersionNodeFactory();

        private UnicodeEmojiVersionNodeFactory() {
        }

        public Class<EncodingNodes.UnicodeEmojiVersionNode> getNodeClass() {
            return EncodingNodes.UnicodeEmojiVersionNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.UnicodeEmojiVersionNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return UnicodeEmojiVersionNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.UnicodeEmojiVersionNode> getInstance() {
            return UNICODE_EMOJI_VERSION_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.UnicodeEmojiVersionNode create(RubyNode[] argumentNodes) {
            return new UnicodeEmojiVersionNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.UnicodeEmojiVersionNode.class)
        public static final class UnicodeEmojiVersionNodeGen
        extends EncodingNodes.UnicodeEmojiVersionNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private TruffleString.FromJavaStringNode fromJavaStringNode_;

            private UnicodeEmojiVersionNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[0];
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                TruffleString.FromJavaStringNode fromJavaStringNode__;
                int state_0 = this.state_0_;
                if (state_0 != 0 && (fromJavaStringNode__ = this.fromJavaStringNode_) != null) {
                    return this.getUnicodeEmojiVersion(fromJavaStringNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize();
            }

            private RubyString executeAndSpecialize() {
                int state_0 = this.state_0_;
                TruffleString.FromJavaStringNode fromJavaStringNode__ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fromJavaStringNode_ = fromJavaStringNode__;
                this.state_0_ = state_0 |= 1;
                return this.getUnicodeEmojiVersion(fromJavaStringNode__);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.CheckStringEncodingNode.class)
    public static final class CheckStringEncodingNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static EncodingNodes.CheckStringEncodingNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static EncodingNodes.CheckStringEncodingNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=12, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=EncodingNodes.CheckStringEncodingNode.class)
        @DenyReplace
        private static final class Uncached
        extends EncodingNodes.CheckStringEncodingNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public RubyEncoding execute(Node arg0Value, AbstractTruffleString arg1Value, RubyEncoding arg2Value, AbstractTruffleString arg3Value, RubyEncoding arg4Value) {
                return EncodingNodes.CheckStringEncodingNode.checkEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, InlinedBranchProfile.getUncached(), NegotiateCompatibleStringEncodingNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=EncodingNodes.CheckStringEncodingNode.class)
        @DenyReplace
        private static final class Inlined
        extends EncodingNodes.CheckStringEncodingNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<Node> negotiateCompatibleEncodingNode__field1_;
            private final InlinedBranchProfile errorProfile_;
            private final EncodingNodes.NegotiateCompatibleStringEncodingNode negotiateCompatibleEncodingNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(EncodingNodes.CheckStringEncodingNode.class));
                this.state_0_ = target.getState(0, 12);
                this.negotiateCompatibleEncodingNode__field1_ = target.getReference(1, Node.class);
                this.errorProfile_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(0, 1)}));
                this.negotiateCompatibleEncodingNode_ = NegotiateCompatibleStringEncodingNodeGen.inline(InlineSupport.InlineTarget.create(EncodingNodes.NegotiateCompatibleStringEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(1, 11), this.negotiateCompatibleEncodingNode__field1_}));
            }

            @Override
            public RubyEncoding execute(Node arg0Value, AbstractTruffleString arg1Value, RubyEncoding arg2Value, AbstractTruffleString arg3Value, RubyEncoding arg4Value) {
                assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.negotiateCompatibleEncodingNode__field1_}));
                return EncodingNodes.CheckStringEncodingNode.checkEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.errorProfile_, this.negotiateCompatibleEncodingNode_);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.GetActualEncodingNode.class)
    public static final class GetActualEncodingNodeGen {
        @NeverDefault
        public static EncodingNodes.GetActualEncodingNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=2, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=EncodingNodes.GetActualEncodingNode.class)
        @DenyReplace
        private static final class Inlined
        extends EncodingNodes.GetActualEncodingNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<TruffleString.ReadByteNode> getActualEncodingDummy_readByteNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(EncodingNodes.GetActualEncodingNode.class));
                this.state_0_ = target.getState(0, 2);
                this.getActualEncodingDummy_readByteNode_ = target.getReference(1, TruffleString.ReadByteNode.class);
            }

            @Override
            public RubyEncoding execute(Node arg0Value, AbstractTruffleString arg1Value, RubyEncoding arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    TruffleString.ReadByteNode readByteNode__;
                    if ((state_0 & 1) != 0 && !arg2Value.isDummy) {
                        return EncodingNodes.GetActualEncodingNode.getActualEncoding(arg1Value, arg2Value);
                    }
                    if ((state_0 & 2) != 0 && (readByteNode__ = (TruffleString.ReadByteNode)this.getActualEncodingDummy_readByteNode_.get(arg0Value)) != null && arg2Value.isDummy) {
                        return EncodingNodes.GetActualEncodingNode.getActualEncodingDummy(arg1Value, arg2Value, readByteNode__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private RubyEncoding executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, RubyEncoding arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (!arg2Value.isDummy) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return EncodingNodes.GetActualEncodingNode.getActualEncoding(arg1Value, arg2Value);
                }
                if (arg2Value.isDummy) {
                    TruffleString.ReadByteNode readByteNode__ = (TruffleString.ReadByteNode)arg0Value.insert((Node)TruffleString.ReadByteNode.create());
                    Objects.requireNonNull(readByteNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.getActualEncodingDummy_readByteNode_.set(arg0Value, (Object)readByteNode__);
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return EncodingNodes.GetActualEncodingNode.getActualEncodingDummy(arg1Value, arg2Value, readByteNode__);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
    public static final class NegotiateCompatibleEncodingNodeGen {
        @NeverDefault
        public static EncodingNodes.NegotiateCompatibleEncodingNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=32, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        @DenyReplace
        private static final class Inlined
        extends EncodingNodes.NegotiateCompatibleEncodingNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<TruffleString.GetByteCodeRangeNode> codeRangeNode_;
            private final InlineSupport.ReferenceField<Node> negotiateForStringsNode__field1_;
            private final RubyStringLibrary libFirst_;
            private final RubyStringLibrary libSecond_;
            private final InlinedConditionProfile equalEncodingsProfile_;
            private final InlinedConditionProfile stringStringProfile_;
            private final InlinedConditionProfile incompatibleProfile_;
            private final InlinedConditionProfile objectStringProfile_;
            private final EncodingNodes.NegotiateCompatibleStringEncodingNode negotiateForStringsNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(EncodingNodes.NegotiateCompatibleEncodingNode.class));
                this.state_0_ = target.getState(0, 32);
                this.codeRangeNode_ = target.getReference(1, TruffleString.GetByteCodeRangeNode.class);
                this.negotiateForStringsNode__field1_ = target.getReference(2, Node.class);
                this.libFirst_ = RubyStringLibrary.inline(InlineSupport.InlineTarget.create(RubyStringLibrary.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(1, 6)}));
                this.libSecond_ = RubyStringLibrary.inline(InlineSupport.InlineTarget.create(RubyStringLibrary.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(7, 6)}));
                this.equalEncodingsProfile_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(13, 2)}));
                this.stringStringProfile_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(15, 2)}));
                this.incompatibleProfile_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(17, 2)}));
                this.objectStringProfile_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(19, 2)}));
                this.negotiateForStringsNode_ = NegotiateCompatibleStringEncodingNodeGen.inline(InlineSupport.InlineTarget.create(EncodingNodes.NegotiateCompatibleStringEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(21, 11), this.negotiateForStringsNode__field1_}));
            }

            @Override
            public RubyEncoding execute(Node arg0Value, Object arg1Value, RubyEncoding arg2Value, Object arg3Value, RubyEncoding arg4Value) {
                TruffleString.GetByteCodeRangeNode codeRangeNode__;
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 1) != 0 && (codeRangeNode__ = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode_.get(arg0Value)) != null) {
                    assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.negotiateForStringsNode__field1_}));
                    return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.libFirst_, this.libSecond_, this.equalEncodingsProfile_, this.stringStringProfile_, this.incompatibleProfile_, this.objectStringProfile_, codeRangeNode__, this.negotiateForStringsNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private RubyEncoding executeAndSpecialize(Node arg0Value, Object arg1Value, RubyEncoding arg2Value, Object arg3Value, RubyEncoding arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                TruffleString.GetByteCodeRangeNode codeRangeNode__ = (TruffleString.GetByteCodeRangeNode)arg0Value.insert((Node)TruffleString.GetByteCodeRangeNode.create());
                Objects.requireNonNull(codeRangeNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.codeRangeNode_.set(arg0Value, (Object)codeRangeNode__);
                this.state_0_.set(arg0Value, state_0 |= 1);
                assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.negotiateForStringsNode__field1_}));
                return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.libFirst_, this.libSecond_, this.equalEncodingsProfile_, this.stringStringProfile_, this.incompatibleProfile_, this.objectStringProfile_, codeRangeNode__, this.negotiateForStringsNode_);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.NegotiateCompatibleStringEncodingNode.class)
    public static final class NegotiateCompatibleStringEncodingNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static EncodingNodes.NegotiateCompatibleStringEncodingNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static EncodingNodes.NegotiateCompatibleStringEncodingNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=11, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleStringEncodingNode.class)
        @DenyReplace
        private static final class Uncached
        extends EncodingNodes.NegotiateCompatibleStringEncodingNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public RubyEncoding execute(Node arg0Value, AbstractTruffleString arg1Value, RubyEncoding arg2Value, AbstractTruffleString arg3Value, RubyEncoding arg4Value) {
                return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), TruffleString.GetByteCodeRangeNode.getUncached());
            }
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleStringEncodingNode.class)
        @DenyReplace
        private static final class Inlined
        extends EncodingNodes.NegotiateCompatibleStringEncodingNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<TruffleString.GetByteCodeRangeNode> codeRangeNode_;
            private final InlinedConditionProfile equalEncodingsProfile_;
            private final InlinedConditionProfile first7BitProfile_;
            private final InlinedConditionProfile firstAsciiCompatProfile_;
            private final InlinedConditionProfile second7BitProfile_;
            private final InlinedConditionProfile secondAsciiCompatProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(EncodingNodes.NegotiateCompatibleStringEncodingNode.class));
                this.state_0_ = target.getState(0, 11);
                this.codeRangeNode_ = target.getReference(1, TruffleString.GetByteCodeRangeNode.class);
                this.equalEncodingsProfile_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(1, 2)}));
                this.first7BitProfile_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(3, 2)}));
                this.firstAsciiCompatProfile_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(5, 2)}));
                this.second7BitProfile_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(7, 2)}));
                this.secondAsciiCompatProfile_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(9, 2)}));
            }

            @Override
            public RubyEncoding execute(Node arg0Value, AbstractTruffleString arg1Value, RubyEncoding arg2Value, AbstractTruffleString arg3Value, RubyEncoding arg4Value) {
                TruffleString.GetByteCodeRangeNode codeRangeNode__;
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 1) != 0 && (codeRangeNode__ = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode_.get(arg0Value)) != null) {
                    assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_, this.state_0_, this.state_0_}));
                    return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.equalEncodingsProfile_, this.first7BitProfile_, this.firstAsciiCompatProfile_, this.second7BitProfile_, this.secondAsciiCompatProfile_, codeRangeNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private RubyEncoding executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, RubyEncoding arg2Value, AbstractTruffleString arg3Value, RubyEncoding arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                TruffleString.GetByteCodeRangeNode codeRangeNode__ = (TruffleString.GetByteCodeRangeNode)arg0Value.insert((Node)TruffleString.GetByteCodeRangeNode.create());
                Objects.requireNonNull(codeRangeNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.codeRangeNode_.set(arg0Value, (Object)codeRangeNode__);
                this.state_0_.set(arg0Value, state_0 |= 1);
                assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_, this.state_0_, this.state_0_}));
                return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.equalEncodingsProfile_, this.first7BitProfile_, this.firstAsciiCompatProfile_, this.second7BitProfile_, this.secondAsciiCompatProfile_, codeRangeNode__);
            }
        }
    }
}

