/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.core.exception.CoreExceptions;
import org.truffleruby.core.format.exceptions.CantCompressNegativeException;
import org.truffleruby.core.format.exceptions.CantConvertException;
import org.truffleruby.core.format.exceptions.FormatException;
import org.truffleruby.core.format.exceptions.InvalidFormatException;
import org.truffleruby.core.format.exceptions.NoImplicitConversionException;
import org.truffleruby.core.format.exceptions.OutsideOfStringException;
import org.truffleruby.core.format.exceptions.RangeException;
import org.truffleruby.core.format.exceptions.TooFewArgumentsException;
import org.truffleruby.language.control.RaiseException;

public abstract class FormatExceptionTranslator {
    @CompilerDirectives.TruffleBoundary
    public static RuntimeException translate(RubyContext context, Node currentNode, FormatException exception) {
        CoreExceptions coreExceptions = context.getCoreExceptions();
        if (exception instanceof TooFewArgumentsException) {
            return new RaiseException(context, coreExceptions.argumentErrorTooFewArguments(currentNode));
        }
        if (exception instanceof NoImplicitConversionException) {
            NoImplicitConversionException e = (NoImplicitConversionException)exception;
            return new RaiseException(context, coreExceptions.typeErrorNoImplicitConversion(e.getObject(), e.getTarget(), currentNode));
        }
        if (exception instanceof OutsideOfStringException) {
            return new RaiseException(context, coreExceptions.argumentErrorXOutsideOfString(currentNode));
        }
        if (exception instanceof CantCompressNegativeException) {
            return new RaiseException(context, coreExceptions.argumentErrorCantCompressNegativeNumbers(currentNode));
        }
        if (exception instanceof RangeException) {
            RangeException e = (RangeException)exception;
            return new RaiseException(context, coreExceptions.rangeError(e.getMessage(), currentNode));
        }
        if (exception instanceof CantConvertException) {
            CantConvertException e = (CantConvertException)exception;
            return new RaiseException(context, coreExceptions.typeError(e.getMessage(), currentNode));
        }
        if (exception instanceof InvalidFormatException) {
            InvalidFormatException e = (InvalidFormatException)exception;
            return new RaiseException(context, coreExceptions.argumentError(e.getMessage(), currentNode));
        }
        throw CompilerDirectives.shouldNotReachHere((Throwable)((Object)exception));
    }
}

