/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.convert;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.convert.ToLongNodeGen;
import org.truffleruby.core.format.exceptions.CantConvertException;
import org.truffleruby.core.format.exceptions.NoImplicitConversionException;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.language.Nil;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;

@NodeChild(value="value")
public abstract class ToLongNode
extends FormatNode {
    protected final boolean errorIfNeedsConversion;

    public static ToLongNode create(boolean errorIfNeedsConversion) {
        return ToLongNodeGen.create(errorIfNeedsConversion, null);
    }

    public ToLongNode(boolean errorIfNeedsConversion) {
        this.errorIfNeedsConversion = errorIfNeedsConversion;
    }

    public abstract long executeToLong(VirtualFrame var1, Object var2);

    @Specialization
    long toLong(boolean object) {
        throw new NoImplicitConversionException(object, "Integer");
    }

    @Specialization
    long toLong(int object) {
        return object;
    }

    @Specialization
    long toLong(long object) {
        return object;
    }

    @Specialization
    long toLong(RubyBignum object) {
        return BigIntegerOps.longValue(object);
    }

    @Specialization
    long toLongNil(Nil nil) {
        throw new NoImplicitConversionException(nil, "Integer");
    }

    @Specialization(guards={"errorIfNeedsConversion", "!isBoolean(object)", "!isRubyInteger(object)", "!isNil(object)"})
    long toLong(VirtualFrame frame, Object object) {
        throw new CantConvertException("can't convert Object to Integer");
    }

    @Specialization(guards={"!errorIfNeedsConversion", "!isBoolean(object)", "!isRubyInteger(object)", "!isNil(object)"})
    static long toLong(VirtualFrame frame, Object object, @Cached DispatchNode toIntNode, @Cached(value="create(true)") ToLongNode redoNode, @Cached InlinedBranchProfile noConversionAvailable, @Bind(value="this") Node node) {
        Object result = toIntNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, object, "to_int");
        if (result == DispatchNode.MISSING) {
            noConversionAvailable.enter(node);
            throw new CantConvertException("can't convert Object to Integer");
        }
        return redoNode.executeToLong(frame, result);
    }
}

