/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.charset.StandardCharsets;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.exceptions.NoImplicitConversionException;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.TStringConstants;
import org.truffleruby.language.Nil;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;

@NodeChild(value="value")
public abstract class ToStringNode
extends FormatNode {
    protected final boolean convertNumbersToStrings;
    private final String conversionMethod;
    private final boolean inspectOnConversionFailure;
    private final Object valueOnNil;
    protected final boolean specialClassBehaviour;
    @Node.Child
    private DispatchNode toStrNode;
    @Node.Child
    private DispatchNode toSNode;
    @Node.Child
    private KernelNodes.ToSNode inspectNode;

    public ToStringNode(boolean convertNumbersToStrings, String conversionMethod, boolean inspectOnConversionFailure, Object valueOnNil) {
        this(convertNumbersToStrings, conversionMethod, inspectOnConversionFailure, valueOnNil, false);
    }

    public ToStringNode(boolean convertNumbersToStrings, String conversionMethod, boolean inspectOnConversionFailure, Object valueOnNil, boolean specialClassBehaviour) {
        this.convertNumbersToStrings = convertNumbersToStrings;
        this.conversionMethod = conversionMethod;
        this.inspectOnConversionFailure = inspectOnConversionFailure;
        this.valueOnNil = valueOnNil;
        this.specialClassBehaviour = specialClassBehaviour;
    }

    public abstract Object executeToString(Object var1);

    @Specialization
    Object toStringNil(Nil nil) {
        return this.valueOnNil;
    }

    @Specialization(guards={"convertNumbersToStrings"})
    RubyString toString(long value, @Cached TruffleString.FromLongNode fromLongNode) {
        TruffleString tstring = fromLongNode.execute(value, Encodings.US_ASCII.tencoding, true);
        return this.createString(tstring, Encodings.US_ASCII);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"convertNumbersToStrings"})
    RubyString toString(double value, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        return this.createString(fromJavaStringNode, Double.toString(value), Encodings.US_ASCII);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"specialClassBehaviour"})
    Object toStringSpecialClass(RubyClass rubyClass, @Cached @Cached.Shared RubyStringLibrary libString) {
        if (rubyClass == this.getContext().getCoreLibrary().trueClass) {
            return this.createString(TStringConstants.TRUE, Encodings.US_ASCII);
        }
        if (rubyClass == this.getContext().getCoreLibrary().falseClass) {
            return this.createString(TStringConstants.FALSE, Encodings.US_ASCII);
        }
        if (rubyClass == this.getContext().getCoreLibrary().nilClass) {
            return this.createString(TStringConstants.NIL, Encodings.US_ASCII);
        }
        return this.toString(rubyClass, libString);
    }

    @Specialization(guards={"argLibString.isRubyString(this, string)"}, limit="1")
    Object toStringString(Object string, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Exclusive RubyStringLibrary argLibString) {
        if ("inspect".equals(this.conversionMethod)) {
            Object value = this.getToStrNode().call(DispatchConfiguration.PRIVATE_RETURN_MISSING, string, this.conversionMethod);
            if (libString.isRubyString(this, value)) {
                return value;
            }
            throw new NoImplicitConversionException(string, "String");
        }
        return string;
    }

    @Specialization
    Object toString(RubyArray array, @Cached @Cached.Shared RubyStringLibrary libString) {
        Object value;
        if (this.toSNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toSNode = (DispatchNode)this.insert(DispatchNode.create());
        }
        if (libString.isRubyString(this, value = this.toSNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, array, "to_s"))) {
            return value;
        }
        throw new NoImplicitConversionException(array, "String");
    }

    @Specialization(guards={"isNotRubyString(object)", "!isRubyArray(object)", "!isForeignObject(object)"})
    Object toString(Object object, @Cached @Cached.Shared RubyStringLibrary libString) {
        Object value = this.getToStrNode().call(DispatchConfiguration.PRIVATE_RETURN_MISSING, object, this.conversionMethod);
        if (libString.isRubyString(this, value)) {
            return value;
        }
        if (this.inspectOnConversionFailure) {
            if (this.inspectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.inspectNode = (KernelNodes.ToSNode)this.insert(KernelNodes.ToSNode.create());
            }
            return this.inspectNode.execute(object);
        }
        throw new NoImplicitConversionException(object, "String");
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isForeignObject(object)"})
    RubyString toStringForeign(Object object, @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
        return this.createString(fromByteArrayNode, object.toString().getBytes(StandardCharsets.UTF_8), Encodings.UTF_8);
    }

    private DispatchNode getToStrNode() {
        if (this.toStrNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toStrNode = (DispatchNode)this.insert(DispatchNode.create());
        }
        return this.toStrNode;
    }
}

