/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.pack;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.format.FormatRootNode;
import org.truffleruby.core.format.LoopRecovery;
import org.truffleruby.core.format.pack.SimplePackParser;
import org.truffleruby.core.format.pack.SimplePackTreeBuilder;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.language.control.DeferredRaiseException;

public final class PackCompiler {
    private final RubyLanguage language;
    private final Node currentNode;

    public PackCompiler(RubyLanguage language, Node currentNode) {
        this.language = language;
        this.currentNode = currentNode;
    }

    public RootCallTarget compile(String format) throws DeferredRaiseException {
        if (format.length() > this.language.options.PACK_RECOVER_LOOP_MIN) {
            format = LoopRecovery.recoverLoop(format);
        }
        SimplePackTreeBuilder builder = new SimplePackTreeBuilder(this.language, this.currentNode);
        builder.enterSequence();
        SimplePackParser parser = new SimplePackParser(builder, StringOperations.encodeAsciiBytes(format));
        parser.parse();
        builder.exitSequence();
        return new FormatRootNode(this.language, this.currentNode.getEncapsulatingSourceSection(), builder.getEncoding(), builder.getNode(), true, true).getCallTarget();
    }
}

