/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.read.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.convert.ToIntegerNode;
import org.truffleruby.core.format.convert.ToIntegerNodeGen;
import org.truffleruby.core.format.read.SourceNode;

@NodeChild(value="source", type=SourceNode.class)
@ImportStatic(value={ArrayGuards.class})
public abstract class ReadIntegerNode
extends FormatNode {
    @Node.Child
    private ToIntegerNode toIntegerNode;
    private final ConditionProfile convertedTypeProfile = ConditionProfile.create();

    @Specialization(limit="storageStrategyLimit()")
    Object read(VirtualFrame frame, Object source, @CachedLibrary(value="source") ArrayStoreLibrary sources) {
        Object value;
        if (this.toIntegerNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toIntegerNode = (ToIntegerNode)this.insert(ToIntegerNodeGen.create(null));
        }
        if (this.convertedTypeProfile.profile((value = this.toIntegerNode.executeToInteger(frame, sources.read(source, this.advanceSourcePosition(frame)))) instanceof Long)) {
            return (int)((Long)value).longValue();
        }
        return (int)((Integer)value);
    }
}

