/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.read.bytes;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.read.SourceNode;
import org.truffleruby.core.format.write.bytes.EncodeUM;

@NodeChild(value="source", type=SourceNode.class)
public abstract class ReadHexStringNode
extends FormatNode {
    @Node.Child
    private TruffleString.FromByteArrayNode fromByteArrayNode = TruffleString.FromByteArrayNode.create();
    private final ByteOrder byteOrder;
    private final boolean star;
    private final int length;

    public ReadHexStringNode(ByteOrder byteOrder, boolean star, int length) {
        this.byteOrder = byteOrder;
        this.star = star;
        this.length = length;
    }

    @Specialization
    Object read(VirtualFrame frame, byte[] source) {
        ByteBuffer encode = this.wrapByteBuffer(frame, source);
        int occurrences = this.length;
        if (this.star || occurrences > encode.remaining() * 2) {
            occurrences = encode.remaining() * 2;
        }
        int bits = 0;
        byte[] lElem = new byte[occurrences];
        int shift = this.byteOrder == ByteOrder.BIG_ENDIAN ? 4 : 0;
        for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
            bits = (lCurByte & 1) != 0 ? (this.byteOrder == ByteOrder.BIG_ENDIAN ? (bits <<= 4) : (bits >>>= 4)) : encode.get();
            lElem[lCurByte] = EncodeUM.sHexDigits[bits >>> shift & 0xF];
        }
        this.setSourcePosition(frame, encode.position());
        return this.createString(this.fromByteArrayNode, lElem, Encodings.US_ASCII);
    }
}

