/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.write.bytes;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteOrder;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.language.library.RubyStringLibrary;

@NodeChild(value="value")
public abstract class WriteHexStringNode
extends FormatNode {
    private final ByteOrder byteOrder;
    private final int length;

    public WriteHexStringNode(ByteOrder byteOrder, int length) {
        this.byteOrder = byteOrder;
        this.length = length;
    }

    @Specialization
    Object write(VirtualFrame frame, Object string, @Bind(value="this") Node node, @Cached RubyStringLibrary libString, @Cached TruffleString.GetInternalByteArrayNode byteArrayNode) {
        AbstractTruffleString tstring = libString.getTString(node, string);
        TruffleString.Encoding encoding = libString.getTEncoding(node, string);
        return this.write(frame, byteArrayNode.execute(tstring, encoding));
    }

    protected Object write(VirtualFrame frame, InternalByteArray byteArray) {
        int currentByte = 0;
        int lengthToUse = this.length == -1 ? byteArray.getLength() : this.length;
        for (int n = 0; n < lengthToUse; ++n) {
            byte currentChar = n < byteArray.getLength() ? byteArray.get(n) : (byte)0;
            currentByte = Character.isJavaIdentifierStart(currentChar) ? (this.byteOrder == ByteOrder.LITTLE_ENDIAN ? (currentByte |= ((currentChar & 0xF) + 9 & 0xF) << 4) : (currentByte |= (currentChar & 0xF) + 9 & 0xF)) : (this.byteOrder == ByteOrder.LITTLE_ENDIAN ? (currentByte |= (currentChar & 0xF) << 4) : (currentByte |= currentChar & 0xF));
            if ((n - 1 & 1) != 0) {
                if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    currentByte >>= 4;
                    continue;
                }
                currentByte <<= 4;
                continue;
            }
            this.writeByte(frame, (byte)currentByte);
            currentByte = 0;
        }
        if ((lengthToUse & 1) != 0) {
            this.writeByte(frame, (byte)(currentByte & 0xFF));
        }
        return null;
    }
}

