/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.write.bytes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.collections.ByteArrayBuilder;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.language.Nil;
import org.truffleruby.language.library.RubyStringLibrary;

@NodeChild(value="value")
public abstract class WriteMIMEStringNode
extends FormatNode {
    final int length;
    private static final byte[] hex_table = StringOperations.encodeAsciiBytes("0123456789ABCDEF");

    public WriteMIMEStringNode(int length) {
        this.length = length;
    }

    @Specialization
    Object write(Nil nil) {
        return null;
    }

    @Specialization(guards={"libString.isRubyString(node, string)"}, limit="1")
    static Object write(VirtualFrame frame, Object string, @Bind(value="this") Node node, @Bind(value="length") int boundLength, @Cached RubyStringLibrary libString, @Cached TruffleString.GetInternalByteArrayNode byteArrayNode) {
        AbstractTruffleString tstring = libString.getTString(node, string);
        TruffleString.Encoding encoding = libString.getTEncoding(node, string);
        WriteMIMEStringNode.writeBytes(frame, WriteMIMEStringNode.encode(byteArrayNode.execute(tstring, encoding), boundLength));
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private static byte[] encode(InternalByteArray byteArray, int length) {
        ByteArrayBuilder output = new ByteArrayBuilder();
        WriteMIMEStringNode.qpencode(output, byteArray, length);
        return output.getBytes();
    }

    public static ByteArrayBuilder qpencode(ByteArrayBuilder io2Append, InternalByteArray i2Encode, int iLength) {
        io2Append.unsafeEnsureSpace(1024);
        int lCurLineLength = 0;
        int lPrevChar = -1;
        try {
            int end = i2Encode.getLength();
            for (int i = 0; i < end; ++i) {
                int lCurChar = i2Encode.get(i) & 0xFF;
                if (lCurChar > 126 || lCurChar < 32 && lCurChar != 10 && lCurChar != 9 || lCurChar == 61) {
                    io2Append.append(61);
                    io2Append.append(hex_table[lCurChar >>> 4]);
                    io2Append.append(hex_table[lCurChar & 0xF]);
                    lCurLineLength += 3;
                    lPrevChar = -1;
                } else if (lCurChar == 10) {
                    if (lPrevChar == 32 || lPrevChar == 9) {
                        io2Append.append(61);
                        io2Append.append(lCurChar);
                    }
                    io2Append.append(lCurChar);
                    lCurLineLength = 0;
                    lPrevChar = lCurChar;
                } else {
                    io2Append.append(lCurChar);
                    ++lCurLineLength;
                    lPrevChar = lCurChar;
                }
                if (lCurLineLength <= iLength) continue;
                io2Append.append(61);
                io2Append.append(10);
                lCurLineLength = 0;
                lPrevChar = 10;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (lCurLineLength > 0) {
            io2Append.append(61);
            io2Append.append(10);
        }
        return io2Append;
    }
}

