/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.EmptyHashStore;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.RubyBignum;

public abstract class HashOperations {
    public static final int BOOLEAN_CLASS_SALT = 55927484;
    public static final int INTEGER_CLASS_SALT = 1028093337;
    public static final int DOUBLE_CLASS_SALT = -1611229937;

    public static RubyHash newEmptyHash(RubyContext context, RubyLanguage language) {
        return new RubyHash(context.getCoreLibrary().hashClass, language.hashShape, context, EmptyHashStore.NULL_HASH_STORE, 0, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> RubyHash toRubyHash(RubyContext context, RubyLanguage language, HashStoreLibrary hashStoreLibrary, Map<K, V> map, Optional<Function<K, Object>> keyMapper, Optional<Function<V, Object>> valueMapper, boolean byIdentity) {
        RubyHash ret = HashOperations.newEmptyHash(context, language);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = keyMapper.isPresent() ? keyMapper.get().apply(entry.getKey()) : entry.getKey();
            V value = valueMapper.isPresent() ? valueMapper.get().apply(entry.getValue()) : entry.getValue();
            hashStoreLibrary.set(ret.store, ret, key, value, byIdentity);
        }
        return ret;
    }

    public static long hashBoolean(boolean value, RubyContext context, Node node) {
        return context.getHashing(node).hash(55927484L, Boolean.hashCode(value));
    }

    public static long hashLong(long value, RubyContext context, Node node) {
        return context.getHashing(node).hash(1028093337L, value);
    }

    public static long hashDouble(double value, RubyContext context, Node node) {
        return context.getHashing(node).hash(-1611229937L, Double.doubleToRawLongBits(value));
    }

    public static long hashBignum(RubyBignum value, RubyContext context, Node node) {
        return context.getHashing(node).hash(1028093337L, BigIntegerOps.hashCode(value));
    }
}

