/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.basicobject.BasicObjectNodes;
import org.truffleruby.core.cast.ToRubyIntegerNode;
import org.truffleruby.core.hash.HashOperations;
import org.truffleruby.core.hash.HashingNodesFactory;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringHelperNodes;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.core.symbol.SymbolNodes;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.dispatch.DispatchNode;

public abstract class HashingNodes {

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class HashCastResultNode
    extends RubyBaseNode {
        public abstract int execute(Node var1, Object var2);

        public final int executeCached(Object key) {
            return this.execute(null, key);
        }

        @Specialization
        static int castInt(int hashed) {
            return hashed;
        }

        @Specialization
        static int castLong(long hashed) {
            return (int)hashed;
        }

        @Specialization
        static int castBignum(RubyBignum hashed) {
            return BigIntegerOps.hashCode(hashed);
        }

        @Specialization(guards={"!isRubyInteger(hashed)"})
        static int castOther(Node node, Object hashed, @Cached ToRubyIntegerNode toRubyInteger, @Cached(inline=false) HashCastResultNode hashCastResult) {
            return hashCastResult.executeCached(toRubyInteger.execute(node, hashed));
        }
    }

    @GenerateUncached
    public static abstract class ToHashByIdentity
    extends RubyBaseNode {
        public static ToHashByIdentity getUncached() {
            return HashingNodesFactory.ToHashByIdentityNodeGen.getUncached();
        }

        public abstract int execute(Object var1);

        @Specialization
        int toHashByIdentity(Object hashed, @Cached BasicObjectNodes.ObjectIDNode objectIDNode, @Cached HashCastResultNode hashCastResultNode) {
            return hashCastResultNode.execute(this, objectIDNode.execute(hashed));
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @ReportPolymorphism
    public static abstract class ToHashByHashCode
    extends RubyBaseNode {
        @NeverDefault
        public static ToHashByHashCode create() {
            return HashingNodesFactory.ToHashByHashCodeNodeGen.create();
        }

        public abstract int execute(Node var1, Object var2);

        public final int executeCached(Object key) {
            return this.execute(this, key);
        }

        @Specialization
        static int hashBoolean(Node node, boolean value) {
            return (int)HashOperations.hashBoolean(value, ToHashByHashCode.getContext(node), node);
        }

        @Specialization
        static int hashInt(Node node, int value) {
            return (int)HashOperations.hashLong(value, ToHashByHashCode.getContext(node), node);
        }

        @Specialization
        static int hashLong(Node node, long value) {
            return (int)HashOperations.hashLong(value, ToHashByHashCode.getContext(node), node);
        }

        @Specialization
        static int hashDouble(Node node, double value) {
            return (int)HashOperations.hashDouble(value, ToHashByHashCode.getContext(node), node);
        }

        @Specialization
        static int hashBignum(Node node, RubyBignum value) {
            return (int)HashOperations.hashBignum(value, ToHashByHashCode.getContext(node), node);
        }

        @Specialization
        static int hashString(Node node, RubyString value, @Cached @Cached.Shared StringHelperNodes.HashStringNode stringHashNode) {
            return (int)stringHashNode.execute(node, (Object)value);
        }

        @Specialization
        static int hashImmutableString(Node node, ImmutableRubyString value, @Cached @Cached.Shared StringHelperNodes.HashStringNode stringHashNode) {
            return (int)stringHashNode.execute(node, value);
        }

        @Specialization
        static int hashSymbol(Node node, RubySymbol value, @Cached SymbolNodes.HashSymbolNode symbolHashNode) {
            return (int)symbolHashNode.execute(node, value);
        }

        @Fallback
        static int hashOther(Node node, Object value, @Cached(inline=false) DispatchNode callHash, @Cached HashCastResultNode cast) {
            return cast.execute(node, callHash.call(value, "hash"));
        }
    }

    @GenerateUncached
    public static abstract class ToHash
    extends RubyBaseNode {
        public static ToHash getUncached() {
            return HashingNodesFactory.ToHashNodeGen.getUncached();
        }

        public abstract int execute(Object var1, boolean var2);

        @Specialization(guards={"!compareByIdentity"})
        int hash(Object key, boolean compareByIdentity, @Cached ToHashByHashCode toHashByHashCode) {
            return toHashByHashCode.execute(this, key);
        }

        @Specialization(guards={"compareByIdentity"})
        int hashCompareByIdentity(Object key, boolean compareByIdentity, @Cached ToHashByIdentity toHashByIdentity) {
            return toHashByIdentity.execute(key);
        }
    }
}

