/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash.library;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import java.util.Set;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.collections.PEBiFunction;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.hash.CompareHashKeysNode;
import org.truffleruby.core.hash.Entry;
import org.truffleruby.core.hash.FreezeHashKeyIfNeededNode;
import org.truffleruby.core.hash.HashLiteralNode;
import org.truffleruby.core.hash.HashLookupResult;
import org.truffleruby.core.hash.HashingNodes;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.shared.PropagateSharingNode;
import org.truffleruby.language.objects.shared.SharedObjects;

@ExportLibrary(value=HashStoreLibrary.class)
@GenerateUncached
public final class BucketsHashStore {
    private final Entry[] entries;
    private Entry firstInSequence;
    private Entry lastInSequence;
    private static final double LOAD_FACTOR = 0.75;
    private static final int OVERALLOCATE_FACTOR = 4;
    private static final int SIGN_BIT_MASK = Integer.MAX_VALUE;
    private static final int[] CAPACITIES = new int[]{11, 19, 37, 67, 131, 283, 521, 1033, 2053, 4099, 8219, 16427, 32771, 65581, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000055};
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int MAX_ENTRIES = 0x5FFFFFF9;

    public BucketsHashStore(Entry[] entries, Entry firstInSequence, Entry lastInSequence) {
        this.entries = entries;
        this.firstInSequence = firstInSequence;
        this.lastInSequence = lastInSequence;
    }

    @CompilerDirectives.TruffleBoundary
    static int growthCapacityGreaterThan(int size) {
        int buckets = 0;
        for (int capacity : CAPACITIES) {
            if (capacity <= size) continue;
            buckets = capacity * 4;
            break;
        }
        if (buckets > 0) {
            assert ((double)buckets * 0.75 > (double)size);
            return buckets;
        }
        if (size < 0x5FFFFFF9) {
            return 0x7FFFFFF7;
        }
        throw new OutOfMemoryError("too big Hash: " + size + " entries");
    }

    static int getBucketIndex(int hashed, int bucketsCount) {
        return (hashed & Integer.MAX_VALUE) % bucketsCount;
    }

    @CompilerDirectives.TruffleBoundary
    private void resize(RubyHash hash, int size) {
        int bucketsCount = BucketsHashStore.growthCapacityGreaterThan(size);
        Entry[] newEntries = new Entry[bucketsCount];
        Entry firstInSequence = this.firstInSequence;
        Entry lastInSequence = null;
        for (Entry entry = firstInSequence; entry != null; entry = entry.getNextInSequence()) {
            int bucketIndex = BucketsHashStore.getBucketIndex(entry.getHashed(), bucketsCount);
            BucketsHashStore.appendToLookupChain(newEntries, entry, bucketIndex);
            entry.setNextInLookup(null);
            lastInSequence = entry;
        }
        hash.store = new BucketsHashStore(newEntries, firstInSequence, lastInSequence);
    }

    public void getAdjacentObjects(Set<Object> reachable) {
        for (Entry entry = this.firstInSequence; entry != null; entry = entry.getNextInSequence()) {
            ObjectGraph.addProperty(reachable, entry.getKey());
            ObjectGraph.addProperty(reachable, entry.getValue());
        }
    }

    private void removeFromSequenceChain(Entry entry) {
        Entry previousInSequence = entry.getPreviousInSequence();
        Entry nextInSequence = entry.getNextInSequence();
        if (previousInSequence == null) {
            assert (this.firstInSequence == entry);
            this.firstInSequence = nextInSequence;
        } else {
            assert (this.firstInSequence != entry);
            previousInSequence.setNextInSequence(nextInSequence);
        }
        if (nextInSequence == null) {
            assert (this.lastInSequence == entry);
            this.lastInSequence = previousInSequence;
        } else {
            assert (this.lastInSequence != entry);
            nextInSequence.setPreviousInSequence(previousInSequence);
        }
    }

    private static void removeFromLookupChain(Entry[] entries, int index, Entry entry, Entry previousEntry) {
        if (previousEntry == null) {
            entries[index] = entry.getNextInLookup();
        } else {
            previousEntry.setNextInLookup(entry.getNextInLookup());
        }
    }

    static void appendToLookupChain(Entry[] entries, Entry entry, int bucketIndex) {
        Entry previousInLookup = entries[bucketIndex];
        if (previousInLookup == null) {
            entries[bucketIndex] = entry;
        } else {
            Entry nextInLookup;
            while ((nextInLookup = previousInLookup.getNextInLookup()) != null) {
                previousInLookup = nextInLookup;
            }
            previousInLookup.setNextInLookup(entry);
        }
    }

    @ExportMessage
    protected Object lookupOrDefault(Frame frame, RubyHash hash, Object key, PEBiFunction defaultNode, @Cached @Cached.Shared LookupEntryNode lookup, @Cached @Cached.Exclusive InlinedConditionProfile found, @Bind(value="$node") Node node) {
        Entry[] entries = this.entries;
        HashLookupResult hashLookupResult = lookup.execute(hash, entries, key);
        if (found.profile(node, hashLookupResult.getEntry() != null)) {
            return hashLookupResult.getEntry().getValue();
        }
        return defaultNode.accept(frame, hash, key);
    }

    @ExportMessage
    protected boolean set(RubyHash hash, Object key, Object value, boolean byIdentity, @Cached FreezeHashKeyIfNeededNode freezeHashKeyIfNeeded, @Cached @Cached.Exclusive PropagateSharingNode propagateSharingKey, @Cached @Cached.Exclusive PropagateSharingNode propagateSharingValue, @Cached @Cached.Shared LookupEntryNode lookup, @Cached @Cached.Exclusive InlinedConditionProfile missing, @Cached @Cached.Exclusive InlinedConditionProfile bucketCollision, @Cached @Cached.Exclusive InlinedConditionProfile appending, @Cached @Cached.Exclusive InlinedConditionProfile resize, @Bind(value="$node") Node node) {
        assert (this.verify(hash));
        Object key2 = freezeHashKeyIfNeeded.executeFreezeIfNeeded(node, key, byIdentity);
        propagateSharingKey.execute(node, hash, key2);
        propagateSharingValue.execute(node, hash, value);
        Entry[] entries = this.entries;
        HashLookupResult result = lookup.execute(hash, entries, key2);
        Entry entry = result.getEntry();
        if (missing.profile(node, entry == null)) {
            Entry newEntry = new Entry(result.getHashed(), key2, value);
            if (bucketCollision.profile(node, result.getPreviousEntry() == null)) {
                entries[result.getIndex()] = newEntry;
            } else {
                result.getPreviousEntry().setNextInLookup(newEntry);
            }
            Entry lastInSequence = this.lastInSequence;
            if (appending.profile(node, lastInSequence == null)) {
                this.firstInSequence = newEntry;
            } else {
                lastInSequence.setNextInSequence(newEntry);
                newEntry.setPreviousInSequence(lastInSequence);
            }
            this.lastInSequence = newEntry;
            int newSize = ++hash.size;
            assert (this.verify(hash));
            if (resize.profile(node, (double)newSize / (double)entries.length > 0.75)) {
                this.resize(hash, newSize);
                assert (((BucketsHashStore)hash.store).verify(hash));
            }
            return true;
        }
        entry.setValue(value);
        assert (this.verify(hash));
        return false;
    }

    @ExportMessage
    protected Object delete(RubyHash hash, Object key, @Cached @Cached.Shared LookupEntryNode lookup, @Cached @Cached.Exclusive InlinedConditionProfile missing, @Bind(value="$node") Node node) {
        assert (this.verify(hash));
        Entry[] entries = this.entries;
        HashLookupResult lookupResult = lookup.execute(hash, entries, key);
        Entry entry = lookupResult.getEntry();
        if (missing.profile(node, entry == null)) {
            return null;
        }
        this.removeFromSequenceChain(entry);
        BucketsHashStore.removeFromLookupChain(entries, lookupResult.getIndex(), entry, lookupResult.getPreviousEntry());
        --hash.size;
        assert (this.verify(hash));
        return entry.getValue();
    }

    @ExportMessage
    protected Object deleteLast(RubyHash hash, Object key, @Cached @Cached.Exclusive InlinedConditionProfile singleEntry, @Bind(value="$node") Node node) {
        Entry entry;
        assert (this.verify(hash));
        Entry[] entries = this.entries;
        Entry lastEntry = this.lastInSequence;
        if (key != lastEntry.getKey()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)("The last key was not " + String.valueOf(key) + " as expected but was " + String.valueOf(lastEntry.getKey())));
        }
        int index = BucketsHashStore.getBucketIndex(lastEntry.getHashed(), entries.length);
        Entry previousEntry = null;
        for (entry = entries[index]; entry != lastEntry; entry = entry.getNextInLookup()) {
            previousEntry = entry;
        }
        assert (entry.getNextInSequence() == null);
        if (singleEntry.profile(node, this.firstInSequence == entry)) {
            assert (entry.getPreviousInSequence() == null);
            this.firstInSequence = null;
            this.lastInSequence = null;
        } else {
            assert (entry.getPreviousInSequence() != null);
            Entry previousInSequence = entry.getPreviousInSequence();
            previousInSequence.setNextInSequence(null);
            this.lastInSequence = previousInSequence;
        }
        BucketsHashStore.removeFromLookupChain(entries, index, entry, previousEntry);
        --hash.size;
        assert (this.verify(hash));
        return entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    protected Object eachEntry(RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state, @CachedLibrary(value="this") HashStoreLibrary hashStoreLibrary, @Cached LoopConditionProfile loopProfile) {
        assert (this.verify(hash));
        int i = 0;
        Entry entry = this.firstInSequence;
        try {
            while (loopProfile.inject(entry != null)) {
                callback.accept(i++, entry.getKey(), entry.getValue(), state);
                entry = entry.getNextInSequence();
                TruffleSafepoint.poll((Node)hashStoreLibrary);
            }
        }
        finally {
            RubyBaseNode.profileAndReportLoopCount(hashStoreLibrary.getNode(), loopProfile, i);
        }
        return state;
    }

    @ExportMessage
    protected Object eachEntrySafe(RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state, @CachedLibrary(value="this") HashStoreLibrary self) {
        return self.eachEntry(this, hash, callback, state);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    protected void replace(RubyHash hash, RubyHash dest, @Cached @Cached.Exclusive PropagateSharingNode propagateSharing, @Bind(value="$node") Node node) {
        if (hash == dest) {
            return;
        }
        propagateSharing.execute(node, dest, hash);
        assert (this.verify(hash));
        Entry[] entries = ((BucketsHashStore)hash.store).entries;
        Entry[] newEntries = new Entry[entries.length];
        Entry firstInSequence = null;
        Entry lastInSequence = null;
        for (Entry entry = this.firstInSequence; entry != null; entry = entry.getNextInSequence()) {
            Entry newEntry = new Entry(entry.getHashed(), entry.getKey(), entry.getValue());
            int index = BucketsHashStore.getBucketIndex(entry.getHashed(), newEntries.length);
            newEntry.setNextInLookup(newEntries[index]);
            newEntries[index] = newEntry;
            if (firstInSequence == null) {
                firstInSequence = newEntry;
            }
            if (lastInSequence != null) {
                lastInSequence.setNextInSequence(newEntry);
                newEntry.setPreviousInSequence(lastInSequence);
            }
            lastInSequence = newEntry;
        }
        dest.store = new BucketsHashStore(newEntries, firstInSequence, lastInSequence);
        dest.size = hash.size;
        dest.defaultBlock = hash.defaultBlock;
        dest.defaultValue = hash.defaultValue;
        dest.compareByIdentity = hash.compareByIdentity;
        assert (this.verify(hash));
    }

    @ExportMessage
    protected RubyArray shift(RubyHash hash, @CachedLibrary(value="this") HashStoreLibrary node) {
        Entry second;
        assert (this.verify(hash));
        Entry[] entries = this.entries;
        Entry first = this.firstInSequence;
        assert (first.getPreviousInSequence() == null);
        Object key = first.getKey();
        Object value = first.getValue();
        this.firstInSequence = second = first.getNextInSequence();
        if (second == null) {
            this.lastInSequence = null;
        } else {
            second.setPreviousInSequence(null);
        }
        int index = BucketsHashStore.getBucketIndex(first.getHashed(), entries.length);
        Entry previous = null;
        for (Entry entry = entries[index]; entry != null; entry = entry.getNextInLookup()) {
            if (entry == first) {
                BucketsHashStore.removeFromLookupChain(entries, index, first, previous);
                break;
            }
            previous = entry;
        }
        --hash.size;
        assert (this.verify(hash));
        RubyLanguage language = RubyLanguage.get((Node)node);
        RubyContext context = RubyContext.get((Node)node);
        return ArrayHelpers.createArray(context, language, new Object[]{key, value});
    }

    @ExportMessage
    protected void rehash(RubyHash hash, @CachedLibrary(value="this") HashStoreLibrary hashStoreLibrary) {
        assert (this.verify(hash));
        Entry[] newEntries = new Entry[this.entries.length];
        BucketsHashStore newStore = new BucketsHashStore(newEntries, null, null);
        hash.store = newStore;
        hash.size = 0;
        for (Entry entry = this.firstInSequence; entry != null; entry = entry.getNextInSequence()) {
            hashStoreLibrary.set(newStore, hash, entry.getKey(), entry.getValue(), hash.compareByIdentity);
        }
        assert (newStore.verify(hash));
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public boolean verify(RubyHash hash) {
        assert (hash.store == this);
        Entry[] entries = this.entries;
        int size = hash.size;
        Entry firstInSequence = this.firstInSequence;
        Entry lastInSequence = this.lastInSequence;
        assert (lastInSequence == null || lastInSequence.getNextInSequence() == null);
        Entry foundFirst = null;
        Entry foundLast = null;
        int foundSizeBuckets = 0;
        Entry[] entryArray = entries;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            for (Entry entry = entryArray[i]; entry != null; entry = entry.getNextInLookup()) {
                assert (SharedObjects.assertPropagateSharing(hash, entry.getKey())) : "unshared key in shared Hash: " + String.valueOf(entry.getKey());
                assert (SharedObjects.assertPropagateSharing(hash, entry.getValue())) : "unshared value in shared Hash: " + String.valueOf(entry.getValue());
                ++foundSizeBuckets;
                if (entry == firstInSequence) {
                    assert (foundFirst == null);
                    foundFirst = entry;
                }
                if (entry != lastInSequence) continue;
                assert (foundLast == null);
                foundLast = entry;
            }
        }
        assert (foundSizeBuckets == size);
        assert (firstInSequence == foundFirst);
        assert (lastInSequence == foundLast);
        int foundSizeSequence = 0;
        for (Entry entry = firstInSequence; entry != null; entry = entry.getNextInSequence()) {
            ++foundSizeSequence;
            if (entry.getNextInSequence() == null ? !$assertionsDisabled && entry != lastInSequence : !$assertionsDisabled && entry.getNextInSequence().getPreviousInSequence() != entry) {
                throw new AssertionError();
            }
        }
        assert (foundSizeSequence == size) : StringUtils.format("%d %d", foundSizeSequence, size);
        return true;
    }

    @GenerateUncached
    static abstract class LookupEntryNode
    extends RubyBaseNode {
        LookupEntryNode() {
        }

        public abstract HashLookupResult execute(RubyHash var1, Entry[] var2, Object var3);

        @Specialization
        HashLookupResult lookup(RubyHash hash, Entry[] entries, Object key, @Cached HashingNodes.ToHash hashNode, @Cached CompareHashKeysNode compareHashKeysNode, @Cached InlinedConditionProfile byIdentityProfile) {
            boolean compareByIdentity = byIdentityProfile.profile((Node)this, hash.compareByIdentity);
            int hashed = hashNode.execute(key, compareByIdentity);
            int index = BucketsHashStore.getBucketIndex(hashed, entries.length);
            Entry previousEntry = null;
            for (Entry entry = entries[index]; entry != null; entry = entry.getNextInLookup()) {
                if (compareHashKeysNode.execute(this, compareByIdentity, key, hashed, entry.getKey(), entry.getHashed())) {
                    return new HashLookupResult(hashed, index, previousEntry, entry);
                }
                previousEntry = entry;
            }
            return new HashLookupResult(hashed, index, previousEntry, null);
        }
    }

    public static final class BucketHashLiteralNode
    extends HashLiteralNode {
        @Node.Child
        HashStoreLibrary hashes;
        private final int bucketsCount = BucketsHashStore.growthCapacityGreaterThan(this.getNumberOfEntries());

        public BucketHashLiteralNode(RubyNode[] keyValues) {
            super(keyValues);
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            if (this.hashes == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.hashes = (HashStoreLibrary)this.insert((Node)HashStoreLibrary.createDispatched());
            }
            RubyHash hash = new RubyHash(this.coreLibrary().hashClass, this.getLanguage().hashShape, this.getContext(), new BucketsHashStore(new Entry[this.bucketsCount], null, null), 0, false);
            for (int n = 0; n < this.keyValues.length; n += 2) {
                Object key = this.keyValues[n].execute(frame);
                Object value = this.keyValues[n + 1].execute(frame);
                this.hashes.set(hash.store, hash, key, value, false);
            }
            return hash;
        }

        @Override
        public RubyNode cloneUninitialized() {
            BucketHashLiteralNode copy = new BucketHashLiteralNode(BucketHashLiteralNode.cloneUninitialized(this.keyValues));
            return copy.copyFlags(this);
        }
    }
}

