/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash.library;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.lang.invoke.MethodHandles;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.truffleruby.collections.PEBiFunction;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.hash.library.PackedHashStoreLibrary;

@GeneratedBy(value=HashStoreLibrary.class)
final class HashStoreLibraryGen
extends LibraryFactory<HashStoreLibrary> {
    private static final Class<HashStoreLibrary> LIBRARY_CLASS = HashStoreLibraryGen.lazyLibraryClass();
    private static final Message LOOKUP_OR_DEFAULT = new MessageImpl("lookupOrDefault", 0, false, Object.class, Object.class, Frame.class, RubyHash.class, Object.class, PEBiFunction.class);
    private static final Message SET = new MessageImpl("set", 1, false, Boolean.TYPE, Object.class, RubyHash.class, Object.class, Object.class, Boolean.TYPE);
    private static final Message CLEAR = new MessageImpl("clear", 2, false, Void.TYPE, Object.class, RubyHash.class);
    private static final Message DELETE = new MessageImpl("delete", 3, false, Object.class, Object.class, RubyHash.class, Object.class);
    private static final Message DELETE_LAST = new MessageImpl("deleteLast", 4, false, Object.class, Object.class, RubyHash.class, Object.class);
    private static final Message EACH_ENTRY = new MessageImpl("eachEntry", 5, false, Object.class, Object.class, RubyHash.class, HashStoreLibrary.EachEntryCallback.class, Object.class);
    private static final Message EACH_ENTRY_SAFE = new MessageImpl("eachEntrySafe", 6, false, Object.class, Object.class, RubyHash.class, HashStoreLibrary.EachEntryCallback.class, Object.class);
    private static final Message REPLACE = new MessageImpl("replace", 7, false, Void.TYPE, Object.class, RubyHash.class, RubyHash.class);
    private static final Message SHIFT = new MessageImpl("shift", 8, false, RubyArray.class, Object.class, RubyHash.class);
    private static final Message REHASH = new MessageImpl("rehash", 9, false, Void.TYPE, Object.class, RubyHash.class);
    private static final Message VERIFY = new MessageImpl("verify", 10, false, Boolean.TYPE, Object.class, RubyHash.class);
    private static final HashStoreLibraryGen INSTANCE = new HashStoreLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private HashStoreLibraryGen() {
        super(LIBRARY_CLASS, List.of(LOOKUP_OR_DEFAULT, SET, CLEAR, DELETE, DELETE_LAST, EACH_ENTRY, EACH_ENTRY_SAFE, REPLACE, SHIFT, REHASH, VERIFY));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        if (receiver instanceof Object[]) {
            return PackedHashStoreLibrary.class;
        }
        return HashStoreLibrary.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected HashStoreLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected HashStoreLibrary createDelegate(HashStoreLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        HashStoreLibrary lib = (HashStoreLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.lookupOrDefault(receiver, (Frame)args[offset], (RubyHash)args[offset + 1], args[offset + 2], (PEBiFunction)args[offset + 3]);
            }
            case 1: {
                return lib.set(receiver, (RubyHash)args[offset], args[offset + 1], args[offset + 2], (Boolean)args[offset + 3]);
            }
            case 2: {
                lib.clear(receiver, (RubyHash)args[offset]);
                return null;
            }
            case 3: {
                return lib.delete(receiver, (RubyHash)args[offset], args[offset + 1]);
            }
            case 4: {
                return lib.deleteLast(receiver, (RubyHash)args[offset], args[offset + 1]);
            }
            case 5: {
                return lib.eachEntry(receiver, (RubyHash)args[offset], (HashStoreLibrary.EachEntryCallback)args[offset + 1], args[offset + 2]);
            }
            case 6: {
                return lib.eachEntrySafe(receiver, (RubyHash)args[offset], (HashStoreLibrary.EachEntryCallback)args[offset + 1], args[offset + 2]);
            }
            case 7: {
                lib.replace(receiver, (RubyHash)args[offset], (RubyHash)args[offset + 1]);
                return null;
            }
            case 8: {
                return lib.shift(receiver, (RubyHash)args[offset]);
            }
            case 9: {
                lib.rehash(receiver, (RubyHash)args[offset]);
                return null;
            }
            case 10: {
                return lib.verify(receiver, (RubyHash)args[offset]);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected HashStoreLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected HashStoreLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<HashStoreLibrary> lazyLibraryClass() {
        try {
            return Class.forName("org.truffleruby.core.hash.library.HashStoreLibrary", false, HashStoreLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=HashStoreLibrary.class)
    private static final class Proxy
    extends HashStoreLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public Object lookupOrDefault(Object receiver_, Frame frame, RubyHash hash, Object key, PEBiFunction defaultNode) {
            try {
                return this.lib.send(receiver_, LOOKUP_OR_DEFAULT, new Object[]{frame, hash, key, defaultNode});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean set(Object receiver_, RubyHash hash, Object key, Object value, boolean byIdentity) {
            try {
                return (Boolean)this.lib.send(receiver_, SET, new Object[]{hash, key, value, byIdentity});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void clear(Object receiver_, RubyHash hash) {
            try {
                this.lib.send(receiver_, CLEAR, new Object[]{hash});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object delete(Object receiver_, RubyHash hash, Object key) {
            try {
                return this.lib.send(receiver_, DELETE, new Object[]{hash, key});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object deleteLast(Object receiver_, RubyHash hash, Object key) {
            try {
                return this.lib.send(receiver_, DELETE_LAST, new Object[]{hash, key});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object eachEntry(Object receiver_, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
            try {
                return this.lib.send(receiver_, EACH_ENTRY, new Object[]{hash, callback, state});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object eachEntrySafe(Object receiver_, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
            try {
                return this.lib.send(receiver_, EACH_ENTRY_SAFE, new Object[]{hash, callback, state});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void replace(Object receiver_, RubyHash hash, RubyHash dest) {
            try {
                this.lib.send(receiver_, REPLACE, new Object[]{hash, dest});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public RubyArray shift(Object receiver_, RubyHash hash) {
            try {
                return (RubyArray)this.lib.send(receiver_, SHIFT, new Object[]{hash});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void rehash(Object receiver_, RubyHash hash) {
            try {
                this.lib.send(receiver_, REHASH, new Object[]{hash});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean verify(Object receiver_, RubyHash hash) {
            try {
                return (Boolean)this.lib.send(receiver_, VERIFY, new Object[]{hash});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=HashStoreLibrary.class)
    private static final class Delegate
    extends HashStoreLibrary {
        @Node.Child
        private HashStoreLibrary delegateLibrary;

        Delegate(HashStoreLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public Object lookupOrDefault(Object receiver_, Frame frame, RubyHash hash, Object key, PEBiFunction defaultNode) {
            if (HashStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = HashStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((HashStoreLibrary)HashStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).lookupOrDefault(delegate, frame, hash, key, defaultNode);
            }
            return this.delegateLibrary.lookupOrDefault(receiver_, frame, hash, key, defaultNode);
        }

        @Override
        public boolean set(Object receiver_, RubyHash hash, Object key, Object value, boolean byIdentity) {
            if (HashStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = HashStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((HashStoreLibrary)HashStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).set(delegate, hash, key, value, byIdentity);
            }
            return this.delegateLibrary.set(receiver_, hash, key, value, byIdentity);
        }

        @Override
        public void clear(Object receiver_, RubyHash hash) {
            if (HashStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = HashStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((HashStoreLibrary)HashStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).clear(delegate, hash);
                return;
            }
            this.delegateLibrary.clear(receiver_, hash);
        }

        @Override
        public Object delete(Object receiver_, RubyHash hash, Object key) {
            if (HashStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)3)) {
                Object delegate = HashStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((HashStoreLibrary)HashStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).delete(delegate, hash, key);
            }
            return this.delegateLibrary.delete(receiver_, hash, key);
        }

        @Override
        public Object deleteLast(Object receiver_, RubyHash hash, Object key) {
            if (HashStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)4)) {
                Object delegate = HashStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((HashStoreLibrary)HashStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).deleteLast(delegate, hash, key);
            }
            return this.delegateLibrary.deleteLast(receiver_, hash, key);
        }

        @Override
        public Object eachEntry(Object receiver_, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
            if (HashStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)5)) {
                Object delegate = HashStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((HashStoreLibrary)HashStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).eachEntry(delegate, hash, callback, state);
            }
            return this.delegateLibrary.eachEntry(receiver_, hash, callback, state);
        }

        @Override
        public Object eachEntrySafe(Object receiver_, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
            if (HashStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)6)) {
                Object delegate = HashStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((HashStoreLibrary)HashStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).eachEntrySafe(delegate, hash, callback, state);
            }
            return this.delegateLibrary.eachEntrySafe(receiver_, hash, callback, state);
        }

        @Override
        public void replace(Object receiver_, RubyHash hash, RubyHash dest) {
            if (HashStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)7)) {
                Object delegate = HashStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((HashStoreLibrary)HashStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).replace(delegate, hash, dest);
                return;
            }
            this.delegateLibrary.replace(receiver_, hash, dest);
        }

        @Override
        public RubyArray shift(Object receiver_, RubyHash hash) {
            if (HashStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)8)) {
                Object delegate = HashStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((HashStoreLibrary)HashStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).shift(delegate, hash);
            }
            return this.delegateLibrary.shift(receiver_, hash);
        }

        @Override
        public void rehash(Object receiver_, RubyHash hash) {
            if (HashStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)9)) {
                Object delegate = HashStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((HashStoreLibrary)HashStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).rehash(delegate, hash);
                return;
            }
            this.delegateLibrary.rehash(receiver_, hash);
        }

        @Override
        public boolean verify(Object receiver_, RubyHash hash) {
            if (HashStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)10)) {
                Object delegate = HashStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((HashStoreLibrary)HashStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).verify(delegate, hash);
            }
            return this.delegateLibrary.verify(receiver_, hash);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=HashStoreLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(HashStoreLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }
    }

    @GeneratedBy(value=HashStoreLibrary.class)
    private static abstract class CachedDispatch
    extends HashStoreLibrary {
        @Node.Child
        HashStoreLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(HashStoreLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public Object lookupOrDefault(Object receiver_, Frame frame, RubyHash hash, Object key, PEBiFunction defaultNode) {
            while (true) {
                CachedDispatch current = this;
                do {
                    HashStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.lookupOrDefault(receiver_, frame, hash, key, defaultNode);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean set(Object receiver_, RubyHash hash, Object key, Object value, boolean byIdentity) {
            while (true) {
                CachedDispatch current = this;
                do {
                    HashStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.set(receiver_, hash, key, value, byIdentity);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void clear(Object receiver_, RubyHash hash) {
            while (true) {
                CachedDispatch current = this;
                do {
                    HashStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.clear(receiver_, hash);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object delete(Object receiver_, RubyHash hash, Object key) {
            while (true) {
                CachedDispatch current = this;
                do {
                    HashStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.delete(receiver_, hash, key);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object deleteLast(Object receiver_, RubyHash hash, Object key) {
            while (true) {
                CachedDispatch current = this;
                do {
                    HashStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.deleteLast(receiver_, hash, key);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object eachEntry(Object receiver_, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
            while (true) {
                CachedDispatch current = this;
                do {
                    HashStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.eachEntry(receiver_, hash, callback, state);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object eachEntrySafe(Object receiver_, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
            while (true) {
                CachedDispatch current = this;
                do {
                    HashStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.eachEntrySafe(receiver_, hash, callback, state);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void replace(Object receiver_, RubyHash hash, RubyHash dest) {
            while (true) {
                CachedDispatch current = this;
                do {
                    HashStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.replace(receiver_, hash, dest);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public RubyArray shift(Object receiver_, RubyHash hash) {
            while (true) {
                CachedDispatch current = this;
                do {
                    HashStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.shift(receiver_, hash);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void rehash(Object receiver_, RubyHash hash) {
            while (true) {
                CachedDispatch current = this;
                do {
                    HashStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.rehash(receiver_, hash);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean verify(Object receiver_, RubyHash hash) {
            while (true) {
                CachedDispatch current = this;
                do {
                    HashStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.verify(receiver_, hash);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                HashStoreLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (HashStoreLibrary)this.insert((Node)((HashStoreLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        HashStoreLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (HashStoreLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((HashStoreLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=HashStoreLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends HashStoreLibrary
    implements UnadoptableNode {
        private UncachedDispatch() {
        }

        @Override
        public Object lookupOrDefault(Object receiver_, Frame frame, RubyHash hash, Object key, PEBiFunction defaultNode) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).lookupOrDefault(receiver_, frame, hash, key, defaultNode);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean set(Object receiver_, RubyHash hash, Object key, Object value, boolean byIdentity) {
            return ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).set(receiver_, hash, key, value, byIdentity);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void clear(Object receiver_, RubyHash hash) {
            ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).clear(receiver_, hash);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object delete(Object receiver_, RubyHash hash, Object key) {
            return ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).delete(receiver_, hash, key);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object deleteLast(Object receiver_, RubyHash hash, Object key) {
            return ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).deleteLast(receiver_, hash, key);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object eachEntry(Object receiver_, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
            return ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).eachEntry(receiver_, hash, callback, state);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object eachEntrySafe(Object receiver_, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
            return ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).eachEntrySafe(receiver_, hash, callback, state);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void replace(Object receiver_, RubyHash hash, RubyHash dest) {
            ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).replace(receiver_, hash, dest);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public RubyArray shift(Object receiver_, RubyHash hash) {
            return ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).shift(receiver_, hash);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void rehash(Object receiver_, RubyHash hash) {
            ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).rehash(receiver_, hash);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean verify(Object receiver_, RubyHash hash) {
            return ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).verify(receiver_, hash);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=HashStoreLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=HashStoreLibrary.class)
    private static final class Default
    extends LibraryExport<HashStoreLibrary> {
        private Default() {
            super(HashStoreLibrary.class, Object.class, false, false, 0);
        }

        protected HashStoreLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected HashStoreLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=HashStoreLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends HashStoreLibrary
        implements UnadoptableNode {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public Object lookupOrDefault(Object receiver, Frame frame, RubyHash hash, Object key, PEBiFunction defaultNode) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean set(Object receiver, RubyHash hash, Object key, Object value, boolean byIdentity) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void clear(Object receiver, RubyHash hash) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.clear(receiver, hash);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object delete(Object receiver, RubyHash hash, Object key) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object deleteLast(Object receiver, RubyHash hash, Object key) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object eachEntry(Object receiver, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object eachEntrySafe(Object receiver, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void replace(Object receiver, RubyHash hash, RubyHash dest) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public RubyArray shift(Object receiver, RubyHash hash) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void rehash(Object receiver, RubyHash hash) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean verify(Object receiver, RubyHash hash) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }

        @GeneratedBy(value=HashStoreLibrary.class)
        private static final class Cached
        extends HashStoreLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public Object lookupOrDefault(Object receiver, Frame frame, RubyHash hash, Object key, PEBiFunction defaultNode) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean set(Object receiver, RubyHash hash, Object key, Object value, boolean byIdentity) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            public void clear(Object receiver, RubyHash hash) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.clear(this.dynamicDispatch_.cast(receiver), hash);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object delete(Object receiver, RubyHash hash, Object key) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object deleteLast(Object receiver, RubyHash hash, Object key) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object eachEntry(Object receiver, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object eachEntrySafe(Object receiver, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void replace(Object receiver, RubyHash hash, RubyHash dest) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public RubyArray shift(Object receiver, RubyHash hash) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void rehash(Object receiver, RubyHash hash) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean verify(Object receiver, RubyHash hash) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }
    }

    @GeneratedBy(value=HashStoreLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(HashStoreLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GeneratedBy(value=HashStoreLibrary.class)
    private static final class CachedToUncachedDispatch
    extends HashStoreLibrary {
        private CachedToUncachedDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object lookupOrDefault(Object receiver_, Frame frame, RubyHash hash, Object key, PEBiFunction defaultNode) {
            assert (HashStoreLibraryGen.assertAdopted((Node)((Node)this)));
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).lookupOrDefault(receiver_, frame, hash, key, defaultNode);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean set(Object receiver_, RubyHash hash, Object key, Object value, boolean byIdentity) {
            assert (HashStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).set(receiver_, hash, key, value, byIdentity);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void clear(Object receiver_, RubyHash hash) {
            assert (HashStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).clear(receiver_, hash);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object delete(Object receiver_, RubyHash hash, Object key) {
            assert (HashStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).delete(receiver_, hash, key);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object deleteLast(Object receiver_, RubyHash hash, Object key) {
            assert (HashStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).deleteLast(receiver_, hash, key);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object eachEntry(Object receiver_, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
            assert (HashStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).eachEntry(receiver_, hash, callback, state);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object eachEntrySafe(Object receiver_, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
            assert (HashStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).eachEntrySafe(receiver_, hash, callback, state);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void replace(Object receiver_, RubyHash hash, RubyHash dest) {
            assert (HashStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).replace(receiver_, hash, dest);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public RubyArray shift(Object receiver_, RubyHash hash) {
            assert (HashStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                RubyArray rubyArray = ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).shift(receiver_, hash);
                return rubyArray;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void rehash(Object receiver_, RubyHash hash) {
            assert (HashStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).rehash(receiver_, hash);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean verify(Object receiver_, RubyHash hash) {
            assert (HashStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((HashStoreLibrary)INSTANCE.getUncached(receiver_)).verify(receiver_, hash);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

