/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash.library;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.collections.PEBiFunction;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.basicobject.ReferenceEqualNode;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.hash.CompareHashKeysNode;
import org.truffleruby.core.hash.Entry;
import org.truffleruby.core.hash.FreezeHashKeyIfNeededNode;
import org.truffleruby.core.hash.HashGuards;
import org.truffleruby.core.hash.HashLiteralNode;
import org.truffleruby.core.hash.HashingNodes;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.BucketsHashStore;
import org.truffleruby.core.hash.library.CompactHashStore;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.hash.library.PackedHashStoreLibraryFactory;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.objects.shared.PropagateSharingNode;
import org.truffleruby.language.objects.shared.SharedObjects;

@ExportLibrary(value=HashStoreLibrary.class, receiverType=Object[].class)
@GenerateUncached
public final class PackedHashStoreLibrary {
    public static final int MAX_ENTRIES = 3;
    private static final int ELEMENTS_PER_ENTRY = 3;
    public static final int TOTAL_ELEMENTS = 9;

    public static Object[] createStore() {
        return new Object[9];
    }

    private static Object[] copyStore(Object[] store) {
        Object[] copied = PackedHashStoreLibrary.createStore();
        System.arraycopy(store, 0, copied, 0, 9);
        return copied;
    }

    private static int getHashed(Object[] store, int n) {
        return (Integer)store[n * 3];
    }

    private static Object getKey(Object[] store, int n) {
        return store[n * 3 + 1];
    }

    private static Object getValue(Object[] store, int n) {
        return store[n * 3 + 2];
    }

    private static void setHashed(Object[] store, int n, int hashed) {
        store[n * 3] = hashed;
    }

    private static void setKey(Object[] store, int n, Object key) {
        store[n * 3 + 1] = key;
    }

    private static void setValue(Object[] store, int n, Object value) {
        store[n * 3 + 2] = value;
    }

    public static void setHashedKeyValue(Object[] store, int n, int hashed, Object key, Object value) {
        PackedHashStoreLibrary.setHashed(store, n, hashed);
        PackedHashStoreLibrary.setKey(store, n, key);
        PackedHashStoreLibrary.setValue(store, n, value);
    }

    private static void removeEntry(Object[] store, int n) {
        assert (PackedHashStoreLibrary.verifyIntegerHashes(store));
        int index = n * 3;
        System.arraycopy(store, index + 3, store, index, 6 - index);
        assert (PackedHashStoreLibrary.verifyIntegerHashes(store));
    }

    private static boolean verifyIntegerHashes(Object[] store) {
        for (int i = 0; i < 9; i += 3) {
            assert (store[i] == null || store[i] instanceof Integer);
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    private static void promoteToBuckets(RubyHash hash, Object[] store, int size) {
        Entry[] buckets = new Entry[BucketsHashStore.growthCapacityGreaterThan(size)];
        Entry firstInSequence = null;
        Entry previousInSequence = null;
        Entry lastInSequence = null;
        for (int n = 0; n < size; ++n) {
            int hashed = PackedHashStoreLibrary.getHashed(store, n);
            Entry entry = new Entry(hashed, PackedHashStoreLibrary.getKey(store, n), PackedHashStoreLibrary.getValue(store, n));
            if (previousInSequence == null) {
                firstInSequence = entry;
            } else {
                previousInSequence.setNextInSequence(entry);
                entry.setPreviousInSequence(previousInSequence);
            }
            previousInSequence = entry;
            lastInSequence = entry;
            int bucketIndex = BucketsHashStore.getBucketIndex(hashed, buckets.length);
            BucketsHashStore.appendToLookupChain(buckets, entry, bucketIndex);
        }
        hash.store = new BucketsHashStore(buckets, firstInSequence, lastInSequence);
        hash.size = size;
    }

    private static void promoteToCompact(RubyHash hash, Object[] store) {
        CompactHashStore newStore = new CompactHashStore(3);
        for (int n = 0; n < 3; ++n) {
            newStore.insertHashKeyValue(PackedHashStoreLibrary.getHashed(store, n), PackedHashStoreLibrary.getKey(store, n), PackedHashStoreLibrary.getValue(store, n));
        }
        hash.store = newStore;
        hash.size = 3;
    }

    @ExportMessage
    static Object lookupOrDefault(Object[] store, Frame frame, RubyHash hash, Object key, PEBiFunction defaultNode, @Cached LookupPackedEntryNode lookupPackedEntryNode, @Cached @Cached.Shared HashingNodes.ToHash hashNode) {
        int hashed = hashNode.execute(key, hash.compareByIdentity);
        return lookupPackedEntryNode.execute(frame, hash, key, hashed, defaultNode);
    }

    @ExportMessage
    static Object delete(Object[] store, RubyHash hash, Object key, @Cached @Cached.Shared HashingNodes.ToHash hashNode, @Cached @Cached.Shared CompareHashKeysNode compareHashKeys, @Bind(value="$node") Node node) {
        assert (PackedHashStoreLibrary.verify(store, hash));
        int hashed = hashNode.execute(key, hash.compareByIdentity);
        int size = hash.size;
        for (int n = 0; n < 3; ++n) {
            if (n >= size) continue;
            int otherHashed = PackedHashStoreLibrary.getHashed(store, n);
            Object otherKey = PackedHashStoreLibrary.getKey(store, n);
            if (!compareHashKeys.execute(node, hash.compareByIdentity, key, hashed, otherKey, otherHashed)) continue;
            Object value = PackedHashStoreLibrary.getValue(store, n);
            PackedHashStoreLibrary.removeEntry(store, n);
            --hash.size;
            return value;
        }
        assert (PackedHashStoreLibrary.verify(store, hash));
        return null;
    }

    @ExportMessage
    static Object deleteLast(Object[] store, RubyHash hash, Object key) {
        assert (PackedHashStoreLibrary.verify(store, hash));
        int n = hash.size - 1;
        Object lastKey = PackedHashStoreLibrary.getKey(store, n);
        if (key != lastKey) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)("The last key was not " + String.valueOf(key) + " as expected but was " + String.valueOf(lastKey)));
        }
        Object value = PackedHashStoreLibrary.getValue(store, n);
        PackedHashStoreLibrary.removeEntry(store, n);
        --hash.size;
        assert (PackedHashStoreLibrary.verify(store, hash));
        return value;
    }

    @ExportMessage
    static Object eachEntrySafe(Object[] store, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state, @CachedLibrary(value="store") HashStoreLibrary self) {
        return self.eachEntry(PackedHashStoreLibrary.copyStore(store), hash, callback, state);
    }

    @ExportMessage
    static void replace(Object[] store, RubyHash hash, RubyHash dest, @Cached @Cached.Exclusive PropagateSharingNode propagateSharing, @Bind(value="$node") Node node) {
        if (hash == dest) {
            return;
        }
        propagateSharing.execute(node, dest, hash);
        Object[] storeCopy = PackedHashStoreLibrary.copyStore(store);
        int size = hash.size;
        dest.store = storeCopy;
        dest.size = size;
        dest.defaultBlock = hash.defaultBlock;
        dest.defaultValue = hash.defaultValue;
        dest.compareByIdentity = hash.compareByIdentity;
        assert (PackedHashStoreLibrary.verify(store, hash));
    }

    @ExportMessage
    static RubyArray shift(Object[] store, RubyHash hash, @CachedLibrary(value="store") HashStoreLibrary node) {
        assert (PackedHashStoreLibrary.verify(store, hash));
        Object key = PackedHashStoreLibrary.getKey(store, 0);
        Object value = PackedHashStoreLibrary.getValue(store, 0);
        PackedHashStoreLibrary.removeEntry(store, 0);
        --hash.size;
        assert (PackedHashStoreLibrary.verify(store, hash));
        RubyLanguage language = RubyLanguage.get((Node)node);
        RubyContext context = RubyContext.get((Node)node);
        return ArrayHelpers.createArray(context, language, new Object[]{key, value});
    }

    @ExportMessage
    static void rehash(Object[] store, RubyHash hash, @Cached @Cached.Shared CompareHashKeysNode compareHashKeys, @Cached @Cached.Shared HashingNodes.ToHash hashNode, @Bind(value="$node") Node node) {
        assert (PackedHashStoreLibrary.verify(store, hash));
        int size = hash.size;
        block0: for (int n = 0; n < size; ++n) {
            Object key = PackedHashStoreLibrary.getKey(store, n);
            int newHash = hashNode.execute(PackedHashStoreLibrary.getKey(store, n), hash.compareByIdentity);
            PackedHashStoreLibrary.setHashed(store, n, newHash);
            for (int m = n - 1; m >= 0; --m) {
                if (PackedHashStoreLibrary.getHashed(store, m) != newHash || !compareHashKeys.execute(node, hash.compareByIdentity, key, newHash, PackedHashStoreLibrary.getKey(store, m), PackedHashStoreLibrary.getHashed(store, m))) continue;
                PackedHashStoreLibrary.removeEntry(store, n);
                --size;
                --n;
                continue block0;
            }
        }
        hash.size = size;
        assert (PackedHashStoreLibrary.verify(store, hash));
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    static boolean verify(Object[] store, RubyHash hash) {
        assert (hash.store == store);
        int size = hash.size;
        assert (store.length == 9) : store.length;
        for (int i = 0; i < size * 3; ++i) {
            assert (store[i] != null);
        }
        for (int n = 0; n < size; ++n) {
            Object key = PackedHashStoreLibrary.getKey(store, n);
            Object value = PackedHashStoreLibrary.getValue(store, n);
            assert (SharedObjects.assertPropagateSharing(hash, key)) : "unshared key in shared Hash: " + String.valueOf(key);
            assert (SharedObjects.assertPropagateSharing(hash, value)) : "unshared value in shared Hash: " + String.valueOf(value);
        }
        return true;
    }

    @GenerateUncached
    @ImportStatic(value={HashGuards.class})
    public static abstract class LookupPackedEntryNode
    extends RubyBaseNode {
        public abstract Object execute(Frame var1, RubyHash var2, Object var3, int var4, PEBiFunction var5);

        @Specialization(guards={"isCompareByIdentity(hash) == cachedByIdentity", "cachedIndex >= 0", "cachedIndex < hash.size", "sameKeysAtIndex(node, refEqual, hash, key, hashed, cachedIndex, cachedByIdentity)"}, limit="1")
        static Object getConstantIndexPackedArray(RubyHash hash, Object key, int hashed, PEBiFunction defaultValueNode, @Cached ReferenceEqualNode refEqual, @Cached(value="isCompareByIdentity(hash)") boolean cachedByIdentity, @Bind(value="this") Node node, @Cached(value="index(node, refEqual, hash, key, hashed, cachedByIdentity)") int cachedIndex) {
            Object[] store = (Object[])hash.store;
            return PackedHashStoreLibrary.getValue(store, cachedIndex);
        }

        protected static int index(Node node, ReferenceEqualNode refEqual, RubyHash hash, Object key, int hashed, boolean compareByIdentity) {
            Object[] store = (Object[])hash.store;
            int size = hash.size;
            for (int n = 0; n < size; ++n) {
                int otherHashed = PackedHashStoreLibrary.getHashed(store, n);
                Object otherKey = PackedHashStoreLibrary.getKey(store, n);
                if (!LookupPackedEntryNode.sameKeys(node, refEqual, compareByIdentity, key, hashed, otherKey, otherHashed)) continue;
                return n;
            }
            return -1;
        }

        protected static boolean sameKeysAtIndex(Node node, ReferenceEqualNode refEqual, RubyHash hash, Object key, int hashed, int cachedIndex, boolean cachedByIdentity) {
            Object[] store = (Object[])hash.store;
            Object otherKey = PackedHashStoreLibrary.getKey(store, cachedIndex);
            int otherHashed = PackedHashStoreLibrary.getHashed(store, cachedIndex);
            return LookupPackedEntryNode.sameKeys(node, refEqual, cachedByIdentity, key, hashed, otherKey, otherHashed);
        }

        private static boolean sameKeys(Node node, ReferenceEqualNode refEqual, boolean compareByIdentity, Object key, int hashed, Object otherKey, int otherHashed) {
            return CompareHashKeysNode.referenceEqualKeys(node, refEqual, compareByIdentity, key, hashed, otherKey, otherHashed);
        }

        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
        @Specialization(replaces={"getConstantIndexPackedArray"})
        Object getPackedArray(Frame frame, RubyHash hash, Object key, int hashed, PEBiFunction defaultValueNode, @Cached CompareHashKeysNode compareHashKeys, @Cached InlinedBranchProfile notInHashProfile, @Cached InlinedConditionProfile byIdentityProfile, @Bind(value="$node") Node node) {
            boolean compareByIdentity = byIdentityProfile.profile(node, hash.compareByIdentity);
            Object[] store = (Object[])hash.store;
            int size = hash.size;
            for (int n = 0; n < 3; ++n) {
                if (n >= size) continue;
                int otherHashed = PackedHashStoreLibrary.getHashed(store, n);
                Object otherKey = PackedHashStoreLibrary.getKey(store, n);
                if (!compareHashKeys.execute(node, compareByIdentity, key, hashed, otherKey, otherHashed)) continue;
                return PackedHashStoreLibrary.getValue(store, n);
            }
            notInHashProfile.enter(node);
            return defaultValueNode.accept(frame, hash, key);
        }
    }

    public static abstract class SmallHashLiteralNode
    extends HashLiteralNode {
        @Node.Child
        private HashingNodes.ToHashByHashCode hashNode;
        @Node.Child
        private DispatchNode equalNode;

        public SmallHashLiteralNode(RubyNode[] keyValues) {
            super(keyValues);
        }

        @Specialization
        @ExplodeLoop
        Object doHash(VirtualFrame frame, @Cached BooleanCastNode booleanCastNode, @Cached InlinedBranchProfile duplicateKeyProfile, @Cached FreezeHashKeyIfNeededNode freezeHashKeyIfNeededNode) {
            Object[] store = PackedHashStoreLibrary.createStore();
            int size = 0;
            for (int n = 0; n < this.keyValues.length / 2; ++n) {
                Object key = this.keyValues[n * 2].execute(frame);
                key = freezeHashKeyIfNeededNode.executeFreezeIfNeeded(this, key, false);
                int hashed = this.hash(key);
                Object value = this.keyValues[n * 2 + 1].execute(frame);
                boolean duplicateKey = false;
                for (int i = 0; i < n; ++i) {
                    if (i >= size || hashed != PackedHashStoreLibrary.getHashed(store, i) || !this.callEqual(key, PackedHashStoreLibrary.getKey(store, i), booleanCastNode)) continue;
                    duplicateKeyProfile.enter((Node)this);
                    PackedHashStoreLibrary.setKey(store, i, key);
                    PackedHashStoreLibrary.setValue(store, i, value);
                    duplicateKey = true;
                    break;
                }
                if (duplicateKey) continue;
                PackedHashStoreLibrary.setHashedKeyValue(store, size, hashed, key, value);
                ++size;
            }
            return new RubyHash(this.coreLibrary().hashClass, this.getLanguage().hashShape, this.getContext(), store, size, false);
        }

        private int hash(Object key) {
            if (this.hashNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.hashNode = (HashingNodes.ToHashByHashCode)this.insert(HashingNodes.ToHashByHashCode.create());
            }
            return this.hashNode.executeCached(key);
        }

        private boolean callEqual(Object receiver, Object key, BooleanCastNode booleanCastNode) {
            if (this.equalNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.equalNode = (DispatchNode)this.insert(DispatchNode.create());
            }
            return booleanCastNode.execute(this, this.equalNode.call(receiver, "eql?", key));
        }

        @Override
        public RubyNode cloneUninitialized() {
            SmallHashLiteralNode copy = PackedHashStoreLibraryFactory.SmallHashLiteralNodeGen.create(SmallHashLiteralNode.cloneUninitialized(this.keyValues));
            return copy.copyFlags(this);
        }
    }

    @ExportMessage
    @ImportStatic(value={HashGuards.class})
    static final class EachEntry {
        EachEntry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"hash.size == cachedSize"}, limit="packedHashLimit()")
        @ExplodeLoop
        static Object eachEntry(Object[] store, RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state, @CachedLibrary(value="store") HashStoreLibrary hashStoreLibrary, @Cached(value="hash.size", allowUncached=true) int cachedSize, @Cached LoopConditionProfile loopProfile) {
            int i = 0;
            try {
                while (loopProfile.inject(i < cachedSize)) {
                    callback.accept(i, PackedHashStoreLibrary.getKey(store, i), PackedHashStoreLibrary.getValue(store, i), state);
                    TruffleSafepoint.poll((Node)hashStoreLibrary);
                    ++i;
                }
            }
            finally {
                RubyBaseNode.profileAndReportLoopCount(hashStoreLibrary.getNode(), loopProfile, i);
            }
            return state;
        }
    }

    @ExportMessage
    @ImportStatic(value={HashGuards.class})
    protected static final class Set {
        protected Set() {
        }

        @Specialization(guards={"hash.size == 0"})
        static boolean setFirst(Object[] store, RubyHash hash, Object key, Object value, boolean byIdentity, @Cached @Cached.Shared FreezeHashKeyIfNeededNode freezeHashKeyIfNeeded, @Cached @Cached.Shared HashingNodes.ToHash hashNode, @Cached @Cached.Shared PropagateSharingNode propagateSharingKey, @Cached @Cached.Shared PropagateSharingNode propagateSharingValue, @Bind(value="this") Node node) {
            Object key2 = freezeHashKeyIfNeeded.executeFreezeIfNeeded(node, key, byIdentity);
            propagateSharingKey.execute(node, hash, key2);
            propagateSharingValue.execute(node, hash, value);
            PackedHashStoreLibrary.setHashedKeyValue(store, 0, hashNode.execute(key2, byIdentity), key2, value);
            hash.size = 1;
            assert (PackedHashStoreLibrary.verify(store, hash));
            return true;
        }

        @Specialization(guards={"hash.size > 0"})
        static boolean set(Object[] store, RubyHash hash, Object key, Object value, boolean byIdentity, @Cached @Cached.Shared FreezeHashKeyIfNeededNode freezeHashKeyIfNeeded, @Cached @Cached.Shared HashingNodes.ToHash hashNode, @Cached @Cached.Shared PropagateSharingNode propagateSharingKey, @Cached @Cached.Shared PropagateSharingNode propagateSharingValue, @Cached @Cached.Shared CompareHashKeysNode compareHashKeys, @CachedLibrary(limit="hashStrategyLimit()") HashStoreLibrary hashes, @Cached InlinedConditionProfile withinCapacity, @Bind(value="this") Node node) {
            assert (PackedHashStoreLibrary.verify(store, hash));
            int size = hash.size;
            Object key2 = freezeHashKeyIfNeeded.executeFreezeIfNeeded(node, key, byIdentity);
            int hashed = hashNode.execute(key2, byIdentity);
            propagateSharingKey.execute(node, hash, key2);
            propagateSharingValue.execute(node, hash, value);
            for (int n = 0; n < 3; ++n) {
                if (n >= size) continue;
                int otherHashed = PackedHashStoreLibrary.getHashed(store, n);
                Object otherKey = PackedHashStoreLibrary.getKey(store, n);
                if (!compareHashKeys.execute(node, byIdentity, key2, hashed, otherKey, otherHashed)) continue;
                PackedHashStoreLibrary.setValue(store, n, value);
                return false;
            }
            if (withinCapacity.profile(node, size < 3)) {
                PackedHashStoreLibrary.setHashedKeyValue(store, size, hashed, key2, value);
                ++hash.size;
                return true;
            }
            assert (size == 3);
            if (RubyLanguage.get((Node)node).options.BIG_HASH_STRATEGY_IS_BUCKETS) {
                PackedHashStoreLibrary.promoteToBuckets(hash, store, 3);
            } else {
                PackedHashStoreLibrary.promoteToCompact(hash, store);
            }
            hashes.set(hash.store, hash, key2, value, byIdentity);
            return true;
        }
    }
}

