/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.klass;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.inlined.AlwaysInlinedMethodNode;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.objects.InitializeClassNode;
import org.truffleruby.language.objects.shared.SharedObjects;

@CoreModule(value="Class", isClass=true)
public abstract class ClassNodes {
    @CompilerDirectives.TruffleBoundary
    public static RubyClass createClassClassAndBootClasses(RubyLanguage language) {
        RubyClass rubyClass = new RubyClass(language, language.classShape);
        assert (rubyClass.getLogicalClass() == rubyClass);
        assert (rubyClass.getMetaClass() == rubyClass);
        return rubyClass;
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyClass createBootClass(RubyLanguage language, RubyClass classClass, Object superclass, String name) {
        return new RubyClass(classClass, language, null, null, name, false, null, superclass);
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyClass createSingletonClassOfObject(RubyContext context, SourceSection sourceSection, RubyClass superclass, RubyDynamicObject attached) {
        assert (attached != null);
        RubyClass rubyClass = ClassNodes.createRubyClass(context, sourceSection, ClassNodes.getClassClass(superclass), null, superclass, null, true, attached, null);
        return ClassNodes.ensureItHasSingletonClassCreated(context, rubyClass);
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyClass createInitializedRubyClass(RubyContext context, SourceSection sourceSection, RubyModule lexicalParent, RubyClass superclass, String name, Node currentNode) {
        assert (superclass != null);
        RubyClass rubyClass = ClassNodes.createRubyClass(context, sourceSection, ClassNodes.getClassClass(superclass), lexicalParent, superclass, name, false, null, currentNode);
        return ClassNodes.ensureItHasSingletonClassCreated(context, rubyClass);
    }

    @CompilerDirectives.TruffleBoundary
    private static RubyClass createRubyClass(RubyContext context, SourceSection sourceSection, RubyClass classClass, RubyModule lexicalParent, RubyClass superclass, String name, boolean isSingleton, RubyDynamicObject attached, Node currentNode) {
        assert (superclass != null);
        RubyClass rubyClass = new RubyClass(classClass, context.getLanguageSlow(), sourceSection, lexicalParent, name, isSingleton, attached, superclass);
        if (lexicalParent != null) {
            lexicalParent.fields.setConstant(context, currentNode, name, rubyClass);
        }
        return rubyClass;
    }

    @CompilerDirectives.TruffleBoundary
    public static void initialize(RubyContext context, RubyClass rubyClass) {
        assert (!rubyClass.isSingleton) : "Singleton classes can only be created internally";
        ClassNodes.ensureItHasSingletonClassCreated(context, rubyClass);
    }

    private static RubyClass ensureItHasSingletonClassCreated(RubyContext context, RubyClass rubyClass) {
        ClassNodes.getLazyCreatedSingletonClass(context, rubyClass);
        return rubyClass;
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyClass getSingletonClassOfClass(RubyContext context, RubyClass rubyClass) {
        return ClassNodes.ensureItHasSingletonClassCreated(context, ClassNodes.getLazyCreatedSingletonClass(context, rubyClass));
    }

    public static RubyClass getSingletonClassOfClassOrNull(RubyContext context, RubyClass rubyClass) {
        RubyClass metaClass = rubyClass.getMetaClass();
        if (metaClass.isSingleton) {
            return ClassNodes.ensureItHasSingletonClassCreated(context, metaClass);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RubyClass getLazyCreatedSingletonClass(RubyContext context, RubyClass rubyClass) {
        RubyClass rubyClass2 = rubyClass;
        synchronized (rubyClass2) {
            RubyClass metaClass = rubyClass.getMetaClass();
            if (metaClass.isSingleton) {
                return metaClass;
            }
            return ClassNodes.createSingletonClass(context, rubyClass);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static RubyClass createSingletonClass(RubyContext context, RubyClass rubyClass) {
        Object superclass = rubyClass.superclass;
        RubyClass singletonSuperclass = superclass == RubyBaseNode.nil ? rubyClass.getLogicalClass() : ClassNodes.getLazyCreatedSingletonClass(context, (RubyClass)superclass);
        RubyClass metaClass = ClassNodes.createRubyClass(context, rubyClass.fields.getSourceSection(), ClassNodes.getClassClass(rubyClass), null, singletonSuperclass, null, true, rubyClass, null);
        SharedObjects.propagate(context.getLanguageSlow(), rubyClass, metaClass);
        rubyClass.setMetaClass(metaClass);
        return rubyClass.getMetaClass();
    }

    private static RubyClass getClassClass(RubyClass rubyClass) {
        return rubyClass.getLogicalClass();
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object allocate(RubyClass rubyClass) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"superclass"})
    public static abstract class SuperClassNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object getSuperClass(RubyClass rubyClass) {
            return rubyClass.superclass;
        }
    }

    @CoreMethod(names={"subclasses"})
    public static abstract class SubclassesNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyArray subclasses(RubyClass rubyClass) {
            return this.createArray(rubyClass.directNonSingletonSubclasses.toArray());
        }
    }

    @CoreMethod(names={"inherited"}, needsSelf=false, required=1, visibility=Visibility.PRIVATE)
    public static abstract class InheritedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object inherited(Object subclass) {
            return nil;
        }
    }

    @CoreMethod(names={"initialize"}, optional=1)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object initialize(RubyClass rubyClass, Object maybeSuperclass) {
            throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().typeErrorAlreadyInitializedClass(this));
        }
    }

    @CoreMethod(names={"new"}, rest=true, alwaysInlined=true)
    @GenerateUncached
    public static abstract class NewNode
    extends AlwaysInlinedMethodNode {
        @Specialization(guards={"!rubyClass.isSingleton"})
        Object newInstance(Frame callerFrame, RubyClass rubyClass, Object[] rubyArgs, RootCallTarget target, @Cached DispatchNode allocateNode, @Cached DispatchNode initializeNode) {
            Object instance = allocateNode.call(rubyClass, "__allocate__");
            initializeNode.execute(null, instance, "initialize", RubyArguments.repack(rubyArgs, instance), DispatchConfiguration.PRIVATE);
            return instance;
        }

        @Specialization(guards={"rubyClass.isSingleton"})
        RubyClass newSingletonInstance(Frame callerFrame, RubyClass rubyClass, Object[] rubyArgs, RootCallTarget target) {
            throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().typeErrorCantCreateInstanceOfSingletonClass(this));
        }
    }

    @CoreMethod(names={"attached_object"})
    public static abstract class AttachedObjectNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"rubyClass.isSingleton"})
        Object attachedObject(RubyClass rubyClass) {
            return rubyClass.attached;
        }

        @Specialization(guards={"!rubyClass.isSingleton"})
        Object attachedObjectOfNonSingletonClass(RubyClass rubyClass) {
            throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().typeErrorNotASingletonClass(this, rubyClass));
        }
    }

    @CoreMethod(names={"allocate"})
    public static abstract class AllocateInstanceNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"!rubyClass.isSingleton"})
        Object newInstance(RubyClass rubyClass, @Cached DispatchNode allocateNode) {
            return allocateNode.call(rubyClass, "__allocate__");
        }

        @Specialization(guards={"rubyClass.isSingleton"})
        RubyClass newSingletonInstance(RubyClass rubyClass) {
            throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().typeErrorCantCreateInstanceOfSingletonClass(this));
        }
    }

    @Primitive(name="class_new")
    public static abstract class NewClassNode
    extends PrimitiveArrayArgumentsNode {
        private final BranchProfile errorProfile = BranchProfile.create();

        @Specialization
        RubyClass newClass(RubyClass superclass, boolean callInherited, Object maybeBlock, @Cached InitializeClassNode initializeClassNode) {
            if (superclass.isSingleton) {
                this.errorProfile.enter();
                throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorSubclassSingletonClass(this));
            }
            if (superclass == this.coreLibrary().classClass) {
                this.errorProfile.enter();
                throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorSubclassClass(this));
            }
            RubyClass newRubyClass = new RubyClass(this.coreLibrary().classClass, this.getLanguage(), this.getEncapsulatingSourceSection(), null, null, false, null, superclass);
            initializeClassNode.executeInitialize(newRubyClass, superclass, callInherited, maybeBlock);
            return newRubyClass;
        }

        @Specialization(guards={"!isRubyClass(superclass)"})
        RubyClass newClass(Object superclass, boolean callInherited, Object maybeBlock) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorSuperclassMustBeClass(this));
        }
    }
}

