/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.method;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.nodes.Node;
import java.util.Objects;
import org.truffleruby.RubyContext;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.language.PerformanceWarningNode;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.SharedMethodInfo;

public final class MethodEntry {
    public static final String CORE_METHOD_IS_NOT_OVERRIDDEN = "core method is not overridden:";
    private final Assumption assumption;
    private final InternalMethod method;

    public MethodEntry(InternalMethod method) {
        this(method, Assumption.create((String)"method is not overridden:"));
    }

    public MethodEntry(InternalMethod method, Assumption assumption) {
        assert (method != null);
        this.assumption = Objects.requireNonNull(assumption);
        this.method = method;
    }

    public MethodEntry() {
        this.assumption = Assumption.create((String)"method is not defined:");
        this.method = null;
    }

    public MethodEntry withNewAssumption() {
        if (this.method != null) {
            return new MethodEntry(this.method);
        }
        return new MethodEntry();
    }

    public Assumption getAssumption() {
        return this.assumption;
    }

    public InternalMethod getMethod() {
        return this.method;
    }

    public void invalidate(RubyContext context, RubyModule module, String methodName, Node node) {
        this.assumption.invalidate(SharedMethodInfo.moduleAndMethodName(module, methodName));
        if (this.assumption.getName() == CORE_METHOD_IS_NOT_OVERRIDDEN) {
            PerformanceWarningNode.warn(context, StringUtils.format("Redefining '%s#%s' disables interpreter and JIT optimizations", module.getName(), methodName), node);
        }
    }
}

