/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.objectspace;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.Collection;
import org.truffleruby.RubyContext;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.collections.SimpleEntry;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.hash.CompareByRubyIdentityWrapper;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.objectspace.RubyWeakMap;
import org.truffleruby.core.objectspace.WeakMapStorage;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.yield.CallBlockNode;

@CoreModule(value="ObjectSpace::WeakMap", isClass=true)
public abstract class WeakMapNodes {
    @CompilerDirectives.TruffleBoundary
    private static Object[] keys(WeakMapStorage storage) {
        Collection keyWrappers = storage.keys();
        Object[] keys = new Object[keyWrappers.size()];
        int i = 0;
        for (CompareByRubyIdentityWrapper keyWrapper : keyWrappers) {
            keys[i++] = keyWrapper.value;
        }
        return keys;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object[] values(WeakMapStorage storage) {
        return storage.values().toArray();
    }

    @CompilerDirectives.TruffleBoundary
    private static SimpleEntry<?, ?>[] entries(WeakMapStorage storage) {
        Collection wrappedEntries = storage.entries();
        SimpleEntry[] entries = new SimpleEntry[wrappedEntries.size()];
        int i = 0;
        for (SimpleEntry wrappedEntry : wrappedEntries) {
            entries[i++] = new SimpleEntry(((CompareByRubyIdentityWrapper)wrappedEntry.getKey()).value, wrappedEntry.getValue());
        }
        return entries;
    }

    private static RubyWeakMap eachNoBlockProvided(RubyBaseNode node, RubyWeakMap map) {
        if (map.storage.size() == 0) {
            return map;
        }
        RubyContext context = RubyContext.get(node);
        throw new RaiseException(context, context.getCoreExceptions().localJumpError("no block given", node));
    }

    @CoreMethod(names={"each", "each_pair"}, needsBlock=true)
    public static abstract class EachNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyWeakMap each(RubyWeakMap map, Nil block) {
            return WeakMapNodes.eachNoBlockProvided(this, map);
        }

        @Specialization
        RubyWeakMap each(RubyWeakMap map, RubyProc block, @Cached CallBlockNode yieldNode) {
            for (SimpleEntry<?, ?> entry : WeakMapNodes.entries(map.storage)) {
                yieldNode.yield(this, block, entry.getKey(), entry.getValue());
            }
            return map;
        }
    }

    @CoreMethod(names={"each_value"}, needsBlock=true)
    public static abstract class EachValueNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyWeakMap eachValue(RubyWeakMap map, Nil block) {
            return WeakMapNodes.eachNoBlockProvided(this, map);
        }

        @Specialization
        RubyWeakMap eachValue(RubyWeakMap map, RubyProc block, @Cached CallBlockNode yieldNode) {
            for (Object value : WeakMapNodes.values(map.storage)) {
                yieldNode.yield(this, block, value);
            }
            return map;
        }
    }

    @CoreMethod(names={"each_key"}, needsBlock=true)
    public static abstract class EachKeyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyWeakMap eachKey(RubyWeakMap map, Nil block) {
            return WeakMapNodes.eachNoBlockProvided(this, map);
        }

        @Specialization
        RubyWeakMap eachKey(RubyWeakMap map, RubyProc block, @Cached CallBlockNode yieldNode) {
            for (Object key : WeakMapNodes.keys(map.storage)) {
                yieldNode.yield(this, block, key);
            }
            return map;
        }
    }

    @CoreMethod(names={"delete"}, required=1, needsBlock=true)
    public static abstract class DeleteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object delete(RubyWeakMap map, Object key, RubyProc block, @Cached InlinedConditionProfile isContainedProfile, @Cached CallBlockNode yieldNode) {
            Object value = map.storage.remove(new CompareByRubyIdentityWrapper(key));
            if (isContainedProfile.profile((Node)this, value != null)) {
                return value;
            }
            return yieldNode.yield(this, block, key);
        }

        @Specialization
        Object delete(RubyWeakMap map, Object key, Nil block, @Cached InlinedConditionProfile isContainedProfile) {
            Object value = map.storage.remove(new CompareByRubyIdentityWrapper(key));
            if (isContainedProfile.profile((Node)this, value != null)) {
                return value;
            }
            return nil;
        }
    }

    @CoreMethod(names={"values"})
    public static abstract class ValuesNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyArray getValues(RubyWeakMap map) {
            return this.createArray(WeakMapNodes.values(map.storage));
        }
    }

    @CoreMethod(names={"keys"})
    public static abstract class KeysNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyArray getKeys(RubyWeakMap map) {
            return this.createArray(WeakMapNodes.keys(map.storage));
        }
    }

    @Primitive(name="weakmap_aset")
    public static abstract class SetIndexNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object set(RubyWeakMap map, Object key, Object value) {
            map.storage.put(new CompareByRubyIdentityWrapper(key), value);
            return value;
        }
    }

    @CoreMethod(names={"[]"}, required=1)
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object get(RubyWeakMap map, Object key) {
            Object value = map.storage.get(new CompareByRubyIdentityWrapper(key));
            return value == null ? nil : value;
        }
    }

    @CoreMethod(names={"key?", "member?", "include?"}, required=1)
    public static abstract class MemberNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isMember(RubyWeakMap map, Object key) {
            return map.storage.get(new CompareByRubyIdentityWrapper(key)) != null;
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int size(RubyWeakMap map) {
            return map.storage.size();
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyWeakMap allocate(RubyClass rubyClass) {
            RubyWeakMap weakMap = new RubyWeakMap(rubyClass, this.getLanguage().weakMapShape, new WeakMapStorage());
            AllocationTracing.trace(weakMap, this);
            return weakMap;
        }
    }
}

