/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.proc;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Split;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.binding.BindingNodes;
import org.truffleruby.core.binding.RubyBinding;
import org.truffleruby.core.inlined.AlwaysInlinedMethodNode;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.method.UnboundMethodNodes;
import org.truffleruby.core.proc.ProcNodesFactory;
import org.truffleruby.core.proc.ProcOperations;
import org.truffleruby.core.proc.ProcType;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.symbol.SymbolNodes;
import org.truffleruby.language.Nil;
import org.truffleruby.language.arguments.ArgumentDescriptorUtils;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.LogicalClassNode;
import org.truffleruby.language.yield.CallBlockNode;
import org.truffleruby.parser.ArgumentDescriptor;

@CoreModule(value="Proc", isClass=true)
public abstract class ProcNodes {

    @Primitive(name="proc_ruby2_keywords", raiseIfFrozen={0})
    public static abstract class ProcRuby2KeywordsNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object ruby2Keywords(RubyProc proc) {
            return UnboundMethodNodes.MethodRuby2KeywordsNode.ruby2Keywords(proc.getSharedMethodInfo(), proc.callTarget);
        }
    }

    @Primitive(name="single_block_arg")
    public static abstract class SingleBlockArgNode
    extends PrimitiveNode {
        @Specialization
        Object singleBlockArg(VirtualFrame frame, @Cached InlinedConditionProfile emptyArgsProfile, @Cached InlinedConditionProfile singleArgProfile) {
            int userArgumentCount = RubyArguments.getPositionalArgumentsCount(frame.getArguments());
            if (emptyArgsProfile.profile((Node)this, userArgumentCount == 0)) {
                return nil;
            }
            if (singleArgProfile.profile((Node)this, userArgumentCount == 1)) {
                return RubyArguments.getArgument((Frame)frame, 0);
            }
            Object[] extractedArguments = RubyArguments.getPositionalArguments(frame.getArguments());
            return this.createArray(extractedArguments, userArgumentCount);
        }
    }

    @Primitive(name="proc_symbol_to_proc_symbol")
    public static abstract class ProcSymbolToProcSymbolNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object symbolToProcSymbol(RubyProc proc) {
            if (proc.arity == SymbolNodes.ToProcNode.ARITY) {
                return this.getSymbol(proc.getSharedMethodInfo().getOriginalName());
            }
            return nil;
        }
    }

    @Primitive(name="proc_specify_arity", lowerFixnum={1})
    public static abstract class ProcSpecifyArityNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyProc specifyArityProc(RubyProc block, int argc) {
            Arity newArity = argc <= -1 ? new Arity(-(argc + 1), 0, true) : new Arity(argc, 0, false);
            RubyProc composedProc = block.withArity(newArity, null, this.coreLibrary().procClass, this.getLanguage().procShape);
            AllocationTracing.trace(composedProc, this);
            return composedProc;
        }
    }

    @Primitive(name="proc_create_same_arity")
    public static abstract class ProcCreateSameArityNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyProc createSameArityProc(RubyProc userProc, RubyProc block) {
            RubyProc composedProc = block.withArity(userProc.arity, userProc.argumentDescriptors, this.coreLibrary().procClass, this.getLanguage().procShape);
            AllocationTracing.trace(composedProc, this);
            return composedProc;
        }
    }

    @CoreMethod(names={"source_location"})
    public static abstract class SourceLocationNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object sourceLocation(RubyProc proc) {
            SourceSection sourceSection = proc.getSharedMethodInfo().getSourceSection();
            Source source = sourceSection.getSource();
            if (!sourceSection.isAvailable() || RubyLanguage.getPath(source).endsWith("/lib/truffle/truffle/cext.rb")) {
                return nil;
            }
            return this.getLanguage().rubySourceLocation(this.getContext(), sourceSection, this.fromJavaStringNode, this);
        }
    }

    @Primitive(name="proc_parameters")
    public static abstract class ParametersNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray parameters(RubyProc proc, boolean isLambda) {
            ArgumentDescriptor[] argsDesc = proc.getArgumentDescriptors();
            return ArgumentDescriptorUtils.argumentDescriptorsToParameters(this.getLanguage(), this.getContext(), argsDesc, isLambda);
        }
    }

    @CoreMethod(names={"lambda?"})
    public static abstract class LambdaNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean lambda(RubyProc proc) {
            return proc.type == ProcType.LAMBDA;
        }
    }

    @CoreMethod(names={"==", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean equal(RubyProc self, Object otherObj, @Cached LogicalClassNode logicalClassNode, @Cached InlinedConditionProfile classProfile, @Cached InlinedConditionProfile lambdaProfile) {
            if (classProfile.profile((Node)this, logicalClassNode.execute(self) != logicalClassNode.execute(otherObj))) {
                return false;
            }
            RubyProc other = (RubyProc)otherObj;
            if (lambdaProfile.profile((Node)this, self.isLambda() != other.isLambda())) {
                return false;
            }
            return self.callTarget == other.callTarget && self.declarationFrame == other.declarationFrame;
        }
    }

    @CoreMethod(names={"call", "[]", "yield"}, rest=true, needsBlock=true, alwaysInlined=true)
    @GenerateUncached
    public static abstract class CallNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        Object call(Frame callerFrame, RubyProc proc, Object[] rubyArgs, RootCallTarget target, @Cached CallBlockNode callBlockNode) {
            return callBlockNode.executeCallBlock(this, proc.declarationContext, proc, ProcOperations.getSelf(proc), RubyArguments.getBlock(rubyArgs), RubyArguments.getDescriptor(rubyArgs), RubyArguments.getRawArguments(rubyArgs));
        }
    }

    @CoreMethod(names={"binding"})
    public static abstract class BindingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyBinding binding(RubyProc proc) {
            MaterializedFrame frame = proc.declarationFrame;
            SourceSection sourceSection = proc.getSharedMethodInfo().getSourceSection();
            return BindingNodes.createBinding(this.getContext(), this.getLanguage(), frame, sourceSection);
        }
    }

    @CoreMethod(names={"arity"})
    public static abstract class ArityNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int arity(RubyProc proc) {
            return proc.getArityNumber();
        }
    }

    @CoreMethod(names={"dup"})
    public static abstract class DupNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyProc dup(RubyProc proc, @Cached DispatchNode initializeDupNode) {
            RubyProc copy = proc.duplicate(this.getLanguage().procShape, this);
            initializeDupNode.call((Object)copy, "initialize_dup", proc);
            return copy;
        }
    }

    @CoreMethod(names={"clone"})
    public static abstract class CloneNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyProc clone(RubyProc proc, @Cached DispatchNode initializeCloneNode) {
            RubyProc copy = proc.duplicate(this.getLanguage().procShape, this);
            initializeCloneNode.call((Object)copy, "initialize_clone", proc);
            return copy;
        }
    }

    @CoreMethod(names={"new"}, constructor=true, needsBlock=true, rest=true, split=Split.HEURISTIC)
    public static abstract class ProcNewNode
    extends CoreMethodArrayArgumentsNode {
        @NeverDefault
        public static ProcNewNode create() {
            return ProcNodesFactory.ProcNewNodeFactory.create(null);
        }

        public abstract RubyProc executeProcNew(VirtualFrame var1, RubyClass var2, Object[] var3, Object var4);

        @Specialization
        RubyProc proc(VirtualFrame frame, RubyClass procClass, Object[] args, Nil block) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorProcWithoutBlock(this));
        }

        @Specialization(guards={"procClass == metaClass(block)"})
        RubyProc procNormal(RubyClass procClass, Object[] args, RubyProc block) {
            return block;
        }

        @Specialization(guards={"procClass != metaClass(block)"})
        RubyProc procSpecial(VirtualFrame frame, RubyClass procClass, Object[] args, RubyProc block, @Cached DispatchNode initialize) {
            RubyProc proc = block.duplicate(procClass, this.getLanguage().procShape, this);
            initialize.callWithDescriptor(proc, "initialize", block, RubyArguments.getDescriptor((Frame)frame), args);
            return proc;
        }

        protected RubyClass metaClass(RubyProc object) {
            return object.getMetaClass();
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyProc allocate(RubyClass rubyClass) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }
}

