/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.queue;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.truffleruby.collections.ConcurrentOperations;

public final class UnsizedQueue {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition canTake = this.lock.newCondition();
    private Item addEnd;
    private Item takeEnd;
    private int size;
    private boolean closed;
    public static final Object CLOSED = new Object();

    @CompilerDirectives.TruffleBoundary
    public UnsizedQueue() {
    }

    @CompilerDirectives.TruffleBoundary
    public boolean add(Object item) {
        this.lock.lock();
        try {
            if (this.closed) {
                boolean bl = false;
                return bl;
            }
            this.doAdd(item);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doAdd(Object item) {
        Item newItem = new Item(item);
        if (this.addEnd != null) {
            this.addEnd.setNextToTake(newItem);
        }
        this.addEnd = newItem;
        if (this.takeEnd == null) {
            this.takeEnd = this.addEnd;
        }
        ++this.size;
        this.canTake.signal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public boolean addAll(Object[] items) {
        this.lock.lock();
        try {
            if (this.closed) {
                boolean bl = false;
                return bl;
            }
            for (Object i : items) {
                this.doAdd(i);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object take() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.takeEnd == null) {
                if (this.closed) {
                    Object object = CLOSED;
                    return object;
                }
                ConcurrentOperations.awaitAndCheckInterrupt(this.canTake);
            }
            Object object = this.doTake();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Object poll(long timeoutMilliseconds) throws InterruptedException {
        this.lock.lock();
        try {
            long deadline = System.currentTimeMillis() + timeoutMilliseconds;
            while (this.takeEnd == null) {
                long currentTimeout = deadline - System.currentTimeMillis();
                boolean signalled = ConcurrentOperations.awaitAndCheckInterrupt(this.canTake, currentTimeout, TimeUnit.MILLISECONDS);
                if (signalled) continue;
                Object var8_7 = null;
                return var8_7;
            }
            if (this.closed) {
                Object object = CLOSED;
                return object;
            }
            Object object = this.doTake();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object poll() {
        this.lock.lock();
        try {
            if (this.takeEnd == null) {
                Object var1_1 = null;
                return var1_1;
            }
            Object object = this.doTake();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Object doTake() {
        Object item = this.takeEnd.getItem();
        Item nextToTake = this.takeEnd.getNextToTake();
        this.takeEnd.clearNextReference();
        this.takeEnd = nextToTake;
        if (this.takeEnd == null) {
            this.addEnd = null;
        }
        --this.size;
        return item;
    }

    @CompilerDirectives.TruffleBoundary
    public int size() {
        this.lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @CompilerDirectives.TruffleBoundary
    public void clear() {
        this.lock.lock();
        try {
            while (this.takeEnd != null) {
                Item next = this.takeEnd.getNextToTake();
                this.takeEnd.clearNextReference();
                this.takeEnd = next;
            }
            this.addEnd = null;
            this.takeEnd = null;
            this.size = 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public int getNumberWaitingToTake() {
        this.lock.lock();
        try {
            int n = this.lock.getWaitQueueLength(this.canTake);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<Object> getContents() {
        ArrayList<Object> objects = new ArrayList<Object>();
        this.lock.lock();
        try {
            for (Item iterator = this.takeEnd; iterator != null; iterator = iterator.getNextToTake()) {
                objects.add(iterator.getItem());
            }
        }
        finally {
            this.lock.unlock();
        }
        return objects;
    }

    @CompilerDirectives.TruffleBoundary
    public void close() {
        this.lock.lock();
        try {
            this.closed = true;
            this.canTake.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isClosed() {
        this.lock.lock();
        try {
            boolean bl = this.closed;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static final class Item {
        private final Object item;
        private Item nextToTake;

        public Item(Object item) {
            this.item = Objects.requireNonNull(item);
        }

        public Object getItem() {
            return this.item;
        }

        public void setNextToTake(Item nextToTake) {
            this.nextToTake = nextToTake;
        }

        public Item getNextToTake() {
            return this.nextToTake;
        }

        public void clearNextReference() {
            this.nextToTake = null;
        }
    }
}

