/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.regexp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.shadowed.org.joni.MultiRegion;
import org.graalvm.shadowed.org.joni.NameEntry;
import org.graalvm.shadowed.org.joni.Regex;
import org.graalvm.shadowed.org.joni.Region;
import org.graalvm.shadowed.org.joni.exception.ValueException;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.ToIntNode;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.range.RangeNodes;
import org.truffleruby.core.regexp.MatchDataNodesFactory;
import org.truffleruby.core.regexp.RubyMatchData;
import org.truffleruby.core.regexp.RubyRegexp;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringHelperNodes;
import org.truffleruby.core.string.StringSupport;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.objects.AllocationTracing;

@CoreModule(value="MatchData", isClass=true)
public abstract class MatchDataNodes {
    private static int getGroupBound(InteropLibrary interop, RubyMatchData matchData, String member, int group) {
        try {
            int offset = (Integer)interop.invokeMember(matchData.tRegexResult, member, new Object[]{group});
            assert (offset >= 0 || offset == -1);
            return offset;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    private static int getStart(Node node, RubyMatchData matchData, int index, InlinedConditionProfile lazyProfile, InteropLibrary interop) {
        int start = matchData.region.getBeg(index);
        if (lazyProfile.profile(node, start == -2)) {
            return matchData.region.setBeg(index, MatchDataNodes.getGroupBound(interop, matchData, "getStart", index));
        }
        return start;
    }

    private static int getEnd(Node node, RubyMatchData matchData, int index, InlinedConditionProfile lazyProfile, InteropLibrary interop) {
        int end = matchData.region.getEnd(index);
        if (lazyProfile.profile(node, end == -2)) {
            return matchData.region.setEnd(index, MatchDataNodes.getGroupBound(interop, matchData, "getEnd", index));
        }
        return end;
    }

    private static void forceLazyMatchData(RubyMatchData matchData, InteropLibrary interop) {
        for (int i = 0; i < matchData.region.getNumRegs(); ++i) {
            MatchDataNodes.getStart(null, matchData, i, InlinedConditionProfile.getUncached(), interop);
            MatchDataNodes.getEnd(null, matchData, i, InlinedConditionProfile.getUncached(), interop);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static MultiRegion getCharOffsetsManyRegs(RubyMatchData matchData, AbstractTruffleString source, RubyEncoding encoding) {
        assert (!encoding.isSingleByte) : "Should be checked by callers";
        MultiRegion regs = matchData.region;
        int numRegs = regs.getNumRegs();
        if (matchData.tRegexResult != null) {
            MatchDataNodes.forceLazyMatchData(matchData, InteropLibrary.getUncached((Object)matchData.tRegexResult));
        }
        MultiRegion charOffsets = new MultiRegion(numRegs);
        Object[] pairs = new Pair[numRegs * 2];
        for (int i = 0; i < pairs.length; ++i) {
            pairs[i] = new Pair();
        }
        int numPos = 0;
        for (int i = 0; i < numRegs; ++i) {
            if (regs.getBeg(i) == -1) continue;
            pairs[numPos++].bytePos = regs.getBeg(i);
            pairs[numPos++].bytePos = regs.getEnd(i);
        }
        MatchDataNodes.updatePairs(source, encoding, (Pair[])pairs);
        Pair key = new Pair();
        for (int i = 0; i < regs.getNumRegs(); ++i) {
            if (regs.getBeg(i) == -1) {
                charOffsets.setBeg(i, -1);
                charOffsets.setEnd(i, -1);
                continue;
            }
            key.bytePos = regs.getBeg(i);
            charOffsets.setBeg(i, ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key)]).charPos);
            key.bytePos = regs.getEnd(i);
            charOffsets.setEnd(i, ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key)]).charPos);
        }
        return charOffsets;
    }

    @CompilerDirectives.TruffleBoundary
    private static void updatePairs(AbstractTruffleString source, RubyEncoding encoding, Pair[] pairs) {
        int p;
        Arrays.sort(pairs);
        InternalByteArray byteArray = source.getInternalByteArrayUncached(encoding.tencoding);
        byte[] bytes = byteArray.getArray();
        int s = p = byteArray.getOffset();
        int c = 0;
        for (Pair pair : pairs) {
            int q = s + pair.bytePos;
            pair.charPos = c += StringSupport.strLength(encoding, bytes, p, q);
            p = q;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static MultiRegion createCharOffsets(RubyMatchData matchData, AbstractTruffleString source, RubyEncoding encoding) {
        MultiRegion charOffsets;
        matchData.charOffsets = charOffsets = MatchDataNodes.getCharOffsetsManyRegs(matchData, source, encoding);
        return charOffsets;
    }

    private static MultiRegion getCharOffsets(RubyMatchData matchData, AbstractTruffleString source, RubyEncoding encoding) {
        MultiRegion charOffsets = matchData.charOffsets;
        if (charOffsets != null) {
            return charOffsets;
        }
        return MatchDataNodes.createCharOffsets(matchData, source, encoding);
    }

    @CompilerDirectives.TruffleBoundary
    private static void fixupMatchDataForStart(RubyMatchData matchData, int startPos) {
        assert (startPos != 0);
        MultiRegion regs = matchData.region;
        for (int i = 0; i < regs.getNumRegs(); ++i) {
            assert (regs.getBeg(i) != -2 && regs.getEnd(i) != -2) : "Group bounds must be computed before fixupMatchDataForStart()";
            if (regs.getBeg(i) < 0) continue;
            regs.setBeg(i, regs.getBeg(i) + startPos);
            regs.setEnd(i, regs.getEnd(i) + startPos);
        }
    }

    public static final class Pair
    implements Comparable<Pair> {
        int bytePos;
        int charPos;

        @Override
        public int compareTo(Pair pair) {
            return this.bytePos - pair.bytePos;
        }
    }

    @Primitive(name="match_data_get_source")
    public static abstract class GetSourceNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object getSource(RubyMatchData matchData) {
            return matchData.source;
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1, raiseIfFrozenSelf=true)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyMatchData initializeCopy(RubyMatchData self, RubyMatchData from, @Cached InlinedConditionProfile copyFromSelfProfile) {
            if (copyFromSelfProfile.profile((Node)this, self == from)) {
                return self;
            }
            self.source = from.source;
            self.regexp = from.regexp;
            self.region = from.region;
            self.charOffsets = from.charOffsets;
            self.tRegexResult = from.tRegexResult;
            return self;
        }

        @Specialization(guards={"!isRubyMatchData(from)"})
        RubyMatchData initializeCopy(RubyMatchData self, Object from) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeError("initialize_copy should take same class object", this));
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class InternalAllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyMatchData allocate(RubyClass rubyClass) {
            Shape shape = this.getLanguage().matchDataShape;
            RubyMatchData matchData = new RubyMatchData(rubyClass, shape, null, null, null);
            AllocationTracing.trace(matchData, this);
            return matchData;
        }
    }

    @CoreMethod(names={"regexp"})
    public static abstract class RegexpNode
    extends CoreMethodArrayArgumentsNode {
        public static RegexpNode create() {
            return MatchDataNodesFactory.RegexpNodeFactory.create(null);
        }

        public abstract RubyRegexp executeGetRegexp(RubyMatchData var1);

        @Specialization
        RubyRegexp regexp(RubyMatchData matchData, @Cached InlinedConditionProfile profile, @Cached DispatchNode stringToRegexp) {
            Object value = matchData.regexp;
            if (profile.profile((Node)this, value instanceof RubyRegexp)) {
                return (RubyRegexp)value;
            }
            RubyRegexp regexp = (RubyRegexp)stringToRegexp.call(this.coreLibrary().truffleTypeModule, "coerce_to_regexp", value, (Object)true);
            matchData.regexp = regexp;
            return regexp;
        }
    }

    @CoreMethod(names={"to_a"})
    public static abstract class ToANode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        ValuesNode valuesNode = ValuesNode.create();

        @Specialization
        RubyArray toA(RubyMatchData matchData) {
            Object[] objects = this.valuesNode.execute(matchData);
            return this.createArray(objects);
        }
    }

    @CoreMethod(names={"post_match"})
    public static abstract class PostMatchNode
    extends CoreMethodArrayArgumentsNode {
        public abstract RubyString execute(RubyMatchData var1);

        @Specialization
        RubyString postMatch(RubyMatchData matchData, @Cached InlinedConditionProfile lazyProfile, @CachedLibrary(limit="getInteropCacheLimit()") InteropLibrary interop, @Cached RubyStringLibrary strings, @Cached TruffleString.SubstringByteIndexNode substringNode) {
            Object source = matchData.source;
            AbstractTruffleString tstring = strings.getTString(this, source);
            RubyEncoding encoding = strings.getEncoding(this, source);
            int start = MatchDataNodes.getEnd(this, matchData, 0, lazyProfile, interop);
            int length = tstring.byteLength(encoding.tencoding) - start;
            return this.createSubString(substringNode, tstring, encoding, start, length);
        }
    }

    @CoreMethod(names={"pre_match"})
    public static abstract class PreMatchNode
    extends CoreMethodArrayArgumentsNode {
        public abstract RubyString execute(RubyMatchData var1);

        @Specialization
        RubyString preMatch(RubyMatchData matchData, @Cached InlinedConditionProfile lazyProfile, @CachedLibrary(limit="getInteropCacheLimit()") InteropLibrary interop, @Cached RubyStringLibrary strings, @Cached TruffleString.SubstringByteIndexNode substringNode) {
            Object source = matchData.source;
            int length = MatchDataNodes.getStart(this, matchData, 0, lazyProfile, interop);
            return this.createSubString(substringNode, strings, source, 0, length);
        }
    }

    @CoreMethod(names={"length", "size"})
    public static abstract class LengthNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int length(RubyMatchData matchData) {
            return matchData.region.getNumRegs();
        }
    }

    @Primitive(name="match_data_byte_end", lowerFixnum={1})
    public static abstract class ByteEndNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"inBounds(matchData, index)"})
        Object byteEnd(RubyMatchData matchData, int index, @Cached InlinedConditionProfile lazyProfile, @Cached InlinedConditionProfile negativeEndProfile, @CachedLibrary(limit="getInteropCacheLimit()") InteropLibrary interop) {
            int end = MatchDataNodes.getEnd(this, matchData, index, lazyProfile, interop);
            if (negativeEndProfile.profile((Node)this, end < 0)) {
                return nil;
            }
            return end;
        }

        @Specialization(guards={"!inBounds(matchData, index)"})
        Object byteEndError(RubyMatchData matchData, int index) {
            throw new RaiseException(this.getContext(), this.coreExceptions().indexError(StringUtils.format("index %d out of matches", index), this));
        }

        protected boolean inBounds(RubyMatchData matchData, int index) {
            return index >= 0 && index < matchData.region.getNumRegs();
        }
    }

    @Primitive(name="match_data_byte_begin", lowerFixnum={1})
    public static abstract class ByteBeginNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"inBounds(matchData, index)"})
        Object byteBegin(RubyMatchData matchData, int index, @Cached InlinedConditionProfile lazyProfile, @Cached InlinedConditionProfile negativeBeginProfile, @CachedLibrary(limit="getInteropCacheLimit()") InteropLibrary interop) {
            int begin = MatchDataNodes.getStart(this, matchData, index, lazyProfile, interop);
            if (negativeBeginProfile.profile((Node)this, begin < 0)) {
                return nil;
            }
            return begin;
        }

        @Specialization(guards={"!inBounds(matchData, index)"})
        Object byteBeginError(RubyMatchData matchData, int index) {
            throw new RaiseException(this.getContext(), this.coreExceptions().indexError(StringUtils.format("index %d out of matches", index), this));
        }

        protected boolean inBounds(RubyMatchData matchData, int index) {
            return index >= 0 && index < matchData.region.getNumRegs();
        }
    }

    @Primitive(name="match_data_end", lowerFixnum={1})
    public static abstract class EndNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"inBounds(matchData, index)"})
        Object end(RubyMatchData matchData, int index, @Cached InlinedConditionProfile lazyProfile, @Cached InlinedConditionProfile negativeEndProfile, @Cached InlinedConditionProfile multiByteCharacterProfile, @Cached StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached RubyStringLibrary strings, @CachedLibrary(limit="getInteropCacheLimit()") InteropLibrary interop) {
            RubyEncoding encoding;
            int end = MatchDataNodes.getEnd(this, matchData, index, lazyProfile, interop);
            if (negativeEndProfile.profile((Node)this, end < 0)) {
                return nil;
            }
            AbstractTruffleString matchDataSource = strings.getTString(this, matchData.source);
            if (multiByteCharacterProfile.profile((Node)this, !singleByteOptimizableNode.execute(this, matchDataSource, encoding = strings.getEncoding(this, matchData.source)))) {
                return MatchDataNodes.getCharOffsets(matchData, matchDataSource, encoding).getEnd(index);
            }
            return end;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!inBounds(matchData, index)"})
        Object endError(RubyMatchData matchData, int index) {
            throw new RaiseException(this.getContext(), this.coreExceptions().indexError(StringUtils.format("index %d out of matches", index), this));
        }

        protected boolean inBounds(RubyMatchData matchData, int index) {
            return index >= 0 && index < matchData.region.getNumRegs();
        }
    }

    public static abstract class ValuesNode
    extends RubyBaseNode {
        @NeverDefault
        public static ValuesNode create() {
            return MatchDataNodesFactory.ValuesNodeGen.create();
        }

        public abstract Object[] execute(RubyMatchData var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object[] getValues(RubyMatchData matchData, @Cached RubyStringLibrary strings, @Cached InlinedConditionProfile lazyProfile, @CachedLibrary(limit="getInteropCacheLimit()") InteropLibrary interop, @Cached InlinedConditionProfile hasValueProfile, @Cached InlinedLoopConditionProfile loopProfile, @Cached TruffleString.SubstringByteIndexNode substringNode) {
            Object source = matchData.source;
            MultiRegion region = matchData.region;
            Object[] values = new Object[region.getNumRegs()];
            int n = 0;
            try {
                while (loopProfile.inject((Node)this, n < region.getNumRegs())) {
                    int start = MatchDataNodes.getStart(this, matchData, n, lazyProfile, interop);
                    int end = MatchDataNodes.getEnd(this, matchData, n, lazyProfile, interop);
                    values[n] = hasValueProfile.profile((Node)this, start >= 0 && end >= 0) ? this.createSubString(substringNode, strings, source, start, end - start) : nil;
                    TruffleSafepoint.poll((Node)this);
                    ++n;
                }
            }
            finally {
                ValuesNode.profileAndReportLoopCount((Node)this, loopProfile, n);
            }
            return values;
        }
    }

    @Primitive(name="match_data_begin", lowerFixnum={1})
    public static abstract class BeginNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"inBounds(matchData, index)"})
        Object begin(RubyMatchData matchData, int index, @Cached InlinedConditionProfile lazyProfile, @Cached InlinedConditionProfile negativeBeginProfile, @Cached InlinedConditionProfile multiByteCharacterProfile, @Cached StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached RubyStringLibrary strings, @CachedLibrary(limit="getInteropCacheLimit()") InteropLibrary interop) {
            RubyEncoding encoding;
            int begin = MatchDataNodes.getStart(this, matchData, index, lazyProfile, interop);
            if (negativeBeginProfile.profile((Node)this, begin < 0)) {
                return nil;
            }
            AbstractTruffleString matchDataSource = strings.getTString(this, matchData.source);
            if (multiByteCharacterProfile.profile((Node)this, !singleByteOptimizableNode.execute(this, matchDataSource, encoding = strings.getEncoding(this, matchData.source)))) {
                return MatchDataNodes.getCharOffsets(matchData, matchDataSource, encoding).getBeg(index);
            }
            return begin;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!inBounds(matchData, index)"})
        Object beginError(RubyMatchData matchData, int index) {
            throw new RaiseException(this.getContext(), this.coreExceptions().indexError(StringUtils.format("index %d out of matches", index), this));
        }

        protected boolean inBounds(RubyMatchData matchData, int index) {
            return index >= 0 && index < matchData.region.getNumRegs();
        }
    }

    public static final class GetFixedNameMatchNode
    extends RubyContextSourceNode {
        @Node.Child
        RubyNode readMatchNode;
        private final RubySymbol symbol;
        @Node.Child
        GetIndexNode getIndexNode = MatchDataNodesFactory.GetIndexNodeGen.create();

        public GetFixedNameMatchNode(RubyNode readMatchNode, RubySymbol symbol) {
            this.readMatchNode = readMatchNode;
            this.symbol = symbol;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            RubyMatchData matchData = (RubyMatchData)this.readMatchNode.execute(frame);
            return this.getIndexNode.execute(matchData, this.symbol, NotProvided.INSTANCE);
        }

        @Override
        public RubyNode cloneUninitialized() {
            return new GetFixedNameMatchNode(this.readMatchNode.cloneUninitialized(), this.symbol);
        }
    }

    @CoreMethod(names={"[]"}, required=1, optional=1, lowerFixnum={1, 2})
    public static abstract class GetIndexCoreMethodNode
    extends CoreMethodArrayArgumentsNode {
        public static GetIndexCoreMethodNode create(RubyNode ... nodes) {
            return MatchDataNodesFactory.GetIndexCoreMethodNodeFactory.create(nodes);
        }

        @Specialization
        Object getIndex(RubyMatchData matchData, Object index, Object maybeLength, @Cached GetIndexNode getIndexNode) {
            return getIndexNode.execute(matchData, index, maybeLength);
        }
    }

    @ReportPolymorphism
    public static abstract class GetIndexNode
    extends RubyBaseNode {
        @Node.Child
        private RegexpNode regexpNode;
        @Node.Child
        private ValuesNode getValuesNode = ValuesNode.create();

        protected abstract Object execute(RubyMatchData var1, Object var2, Object var3);

        protected abstract Object executeGetIndex(Object var1, int var2, NotProvided var3);

        @Specialization
        Object getIndex(RubyMatchData matchData, int index, NotProvided length, @Cached @Cached.Exclusive RubyStringLibrary strings, @Cached @Cached.Shared InlinedConditionProfile normalizedIndexProfile, @Cached @Cached.Exclusive InlinedConditionProfile indexOutOfBoundsProfile, @Cached @Cached.Shared InlinedConditionProfile lazyProfile, @CachedLibrary(limit="getInteropCacheLimit()") @Cached.Shared InteropLibrary libInterop, @Cached @Cached.Exclusive InlinedConditionProfile hasValueProfile, @Cached TruffleString.SubstringByteIndexNode substringNode) {
            MultiRegion region = matchData.region;
            if (normalizedIndexProfile.profile((Node)this, index < 0)) {
                index += region.getNumRegs();
            }
            if (indexOutOfBoundsProfile.profile((Node)this, index < 0 || index >= region.getNumRegs())) {
                return nil;
            }
            int start = MatchDataNodes.getStart(this, matchData, index, lazyProfile, libInterop);
            int end = MatchDataNodes.getEnd(this, matchData, index, lazyProfile, libInterop);
            if (hasValueProfile.profile((Node)this, start >= 0 && end >= 0)) {
                Object source = matchData.source;
                return this.createSubString(substringNode, strings, source, start, end - start);
            }
            return nil;
        }

        @Specialization
        Object getIndex(RubyMatchData matchData, int index, int length, @Cached @Cached.Exclusive InlinedConditionProfile negativeLengthProfile, @Cached @Cached.Shared InlinedConditionProfile normalizedIndexProfile, @Cached @Cached.Exclusive InlinedConditionProfile negativeIndexProfile, @Cached @Cached.Exclusive InlinedConditionProfile tooLargeIndexProfile, @Cached @Cached.Exclusive InlinedConditionProfile tooLargeTotalProfile) {
            Object[] values = this.getValuesNode.execute(matchData);
            if (negativeLengthProfile.profile((Node)this, length < 0)) {
                return nil;
            }
            if (normalizedIndexProfile.profile((Node)this, index < 0) && negativeIndexProfile.profile((Node)this, (index += values.length) < 0)) {
                return nil;
            }
            if (tooLargeIndexProfile.profile((Node)this, index > values.length)) {
                return nil;
            }
            int endIndex = index + length;
            if (tooLargeTotalProfile.profile((Node)this, endIndex > values.length)) {
                endIndex = values.length;
            }
            Object[] store = Arrays.copyOfRange(values, index, endIndex);
            return this.createArray(store);
        }

        @Specialization(guards={"nameEntry != null", "getRegexp(matchData) == cachedRegexp", "symbol == cachedSymbol"}, limit="getDefaultCacheLimit()")
        Object getIndexSymbolKnownRegexp(RubyMatchData matchData, RubySymbol symbol, NotProvided length, @Cached(value="symbol") RubySymbol cachedSymbol, @Cached(value="getRegexp(matchData)") RubyRegexp cachedRegexp, @Cached(value="findNameEntry(cachedRegexp, cachedSymbol)") NameEntry nameEntry, @Cached(value="numBackRefs(nameEntry)") int backRefs, @Cached(value="backRefIndex(nameEntry)") int backRefIndex, @Cached @Cached.Shared InlinedConditionProfile lazyProfile, @CachedLibrary(limit="getInteropCacheLimit()") @Cached.Shared InteropLibrary libInterop) {
            if (backRefs == 1) {
                return this.executeGetIndex(matchData, backRefIndex, NotProvided.INSTANCE);
            }
            int i = this.getBackRef(matchData, cachedRegexp, (AbstractTruffleString)cachedSymbol.tstring, cachedSymbol.encoding, lazyProfile, libInterop);
            return this.executeGetIndex(matchData, i, NotProvided.INSTANCE);
        }

        @Specialization(replaces={"getIndexSymbolKnownRegexp"})
        Object getIndexSymbol(RubyMatchData matchData, RubySymbol symbol, NotProvided length, @Cached @Cached.Shared InlinedConditionProfile lazyProfile, @CachedLibrary(limit="getInteropCacheLimit()") @Cached.Shared InteropLibrary libInterop) {
            return this.executeGetIndex(matchData, this.getBackRef(matchData, this.getRegexp(matchData), (AbstractTruffleString)symbol.tstring, symbol.encoding, lazyProfile, libInterop), NotProvided.INSTANCE);
        }

        @Specialization(guards={"libIndex.isRubyString(this, index)"}, limit="1")
        Object getIndexString(RubyMatchData matchData, Object index, NotProvided length, @Cached @Cached.Exclusive RubyStringLibrary libIndex, @Cached @Cached.Shared InlinedConditionProfile lazyProfile, @CachedLibrary(limit="getInteropCacheLimit()") @Cached.Shared InteropLibrary libInterop) {
            return this.executeGetIndex(matchData, this.getBackRef(matchData, this.getRegexp(matchData), libIndex.getTString(this, index), libIndex.getEncoding(this, index), lazyProfile, libInterop), NotProvided.INSTANCE);
        }

        @Specialization(guards={"!isInteger(index)", "!isRubySymbol(index)", "isNotRubyString(index)", "!isRubyRange(index)"})
        Object getIndexCoerce(RubyMatchData matchData, Object index, NotProvided length, @Cached ToIntNode toIntNode) {
            return this.executeGetIndex(matchData, toIntNode.execute(index), NotProvided.INSTANCE);
        }

        @Specialization(guards={"isRubyRange(range)"})
        Object getIndexRange(RubyMatchData matchData, Object range, NotProvided other, @Cached RangeNodes.NormalizedStartLengthNode startLengthNode, @Cached @Cached.Exclusive InlinedConditionProfile negativeStart) {
            Object[] values = this.getValuesNode.execute(matchData);
            int[] startLength = startLengthNode.execute(range, values.length);
            int start = startLength[0];
            int length = Math.max(startLength[1], 0);
            if (negativeStart.profile((Node)this, start < 0)) {
                return Nil.INSTANCE;
            }
            int end = Math.min(start + length, values.length);
            return this.createArray(Arrays.copyOfRange(values, start, end));
        }

        @CompilerDirectives.TruffleBoundary
        protected static NameEntry findNameEntry(RubyRegexp regexp, RubySymbol symbol) {
            Regex regex = regexp.regex;
            if (regex.numberOfNames() > 0) {
                InternalByteArray byteArray = symbol.tstring.getInternalByteArrayUncached(symbol.encoding.tencoding);
                Iterator i = regex.namedBackrefIterator();
                while (i.hasNext()) {
                    NameEntry e = (NameEntry)i.next();
                    int nameLen = e.nameEnd - e.nameP;
                    if (nameLen != byteArray.getLength() || !ArrayUtils.regionEquals(byteArray.getArray(), byteArray.getOffset(), e.name, e.nameP, byteArray.getLength())) continue;
                    return e;
                }
            }
            return null;
        }

        protected RubyRegexp getRegexp(RubyMatchData matchData) {
            if (this.regexpNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.regexpNode = (RegexpNode)this.insert(RegexpNode.create());
            }
            return this.regexpNode.executeGetRegexp(matchData);
        }

        private int getBackRef(RubyMatchData matchData, RubyRegexp regexp, AbstractTruffleString name, RubyEncoding enc, InlinedConditionProfile lazyProfile, InteropLibrary libInterop) {
            if (lazyProfile.profile((Node)this, matchData.tRegexResult != null)) {
                MatchDataNodes.forceLazyMatchData(matchData, libInterop);
            }
            return this.nameToBackrefNumber(matchData, regexp, name, enc);
        }

        @CompilerDirectives.TruffleBoundary
        private int nameToBackrefNumber(RubyMatchData matchData, RubyRegexp regexp, AbstractTruffleString name, RubyEncoding enc) {
            InternalByteArray byteArray = name.getInternalByteArrayUncached(enc.tencoding);
            try {
                return regexp.regex.nameToBackrefNumber(byteArray.getArray(), byteArray.getOffset(), byteArray.getEnd(), (Region)matchData.region);
            }
            catch (ValueException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().indexError(StringUtils.format("undefined group name reference: %s", name.toJavaStringUncached()), this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        protected static int numBackRefs(NameEntry nameEntry) {
            return nameEntry == null ? 0 : nameEntry.getBackRefs().length;
        }

        @CompilerDirectives.TruffleBoundary
        protected static int backRefIndex(NameEntry nameEntry) {
            return nameEntry == null ? 0 : nameEntry.getBackRefs()[0];
        }
    }

    @Primitive(name="matchdata_create_single_group", lowerFixnum={2, 3})
    public static abstract class MatchDataCreateSingleGroupNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object create(Object regexp, Object string, int start, int end) {
            MultiRegion region = new MultiRegion(start, end);
            RubyMatchData matchData = new RubyMatchData(this.coreLibrary().matchDataClass, this.getLanguage().matchDataShape, regexp, string, region);
            AllocationTracing.trace(matchData, this);
            return matchData;
        }
    }

    @Primitive(name="matchdata_fixup_positions", lowerFixnum={1})
    public static abstract class FixupMatchData
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyMatchData fixupMatchData(RubyMatchData matchData, int startPos, @Cached InlinedConditionProfile nonZeroPos, @Cached InlinedConditionProfile lazyProfile, @CachedLibrary(limit="getInteropCacheLimit()") InteropLibrary interop) {
            if (nonZeroPos.profile((Node)this, startPos != 0)) {
                if (lazyProfile.profile((Node)this, matchData.tRegexResult != null)) {
                    MatchDataNodes.forceLazyMatchData(matchData, interop);
                }
                MatchDataNodes.fixupMatchDataForStart(matchData, startPos);
            }
            return matchData;
        }
    }
}

