/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.regexp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.graalvm.shadowed.org.joni.Matcher;
import org.graalvm.shadowed.org.joni.MultiRegion;
import org.graalvm.shadowed.org.joni.Regex;
import org.graalvm.shadowed.org.joni.Region;
import org.graalvm.shadowed.org.joni.SingleRegion;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Split;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.collections.ConcurrentOperations;
import org.truffleruby.core.array.ArrayBuilderNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.hash.HashOperations;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.regexp.ClassicRegexp;
import org.truffleruby.core.regexp.EncodingCache;
import org.truffleruby.core.regexp.RegexpNodes;
import org.truffleruby.core.regexp.RegexpOptions;
import org.truffleruby.core.regexp.RegexpSupport;
import org.truffleruby.core.regexp.RubyMatchData;
import org.truffleruby.core.regexp.RubyRegexp;
import org.truffleruby.core.regexp.TruffleRegexpNodesFactory;
import org.truffleruby.core.string.ATStringWithEncoding;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringHelperNodes;
import org.truffleruby.core.string.StringNodes;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.string.TStringBuilder;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.interop.InteropNodes;
import org.truffleruby.interop.TranslateInteropExceptionNode;
import org.truffleruby.language.LazyWarnNode;
import org.truffleruby.language.PerformanceWarningNode;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.WarnNode;
import org.truffleruby.language.control.DeferredRaiseException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.dispatch.LazyDispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.parser.RubyDeferredWarnings;
import org.truffleruby.utils.RunTwiceBranchProfile;

@CoreModule(value="Truffle::RegexpOperations")
public abstract class TruffleRegexpNodes {
    static ConcurrentSkipListSet<RubyRegexp> DYNAMIC_REGEXPS = new ConcurrentSkipListSet();
    static ConcurrentSkipListSet<RubyRegexp> LITERAL_REGEXPS = new ConcurrentSkipListSet();
    private static ConcurrentHashMap<MatchInfo, AtomicInteger> MATCHED_REGEXPS_JONI = new ConcurrentHashMap();
    private static ConcurrentHashMap<MatchInfo, AtomicInteger> MATCHED_REGEXPS_TREGEX = new ConcurrentHashMap();
    private static ConcurrentHashMap<MatchInfo, MatchInfoStats> MATCHED_REGEXP_STATS = new ConcurrentHashMap();

    @CompilerDirectives.TruffleBoundary
    private static void instrumentMatch(ConcurrentHashMap<MatchInfo, AtomicInteger> metricsMap, RubyRegexp regexp, Object string, boolean fromStart, boolean collectDetailedStats) {
        MatchInfo matchInfo = new MatchInfo(regexp, fromStart);
        ConcurrentOperations.getOrCompute(metricsMap, matchInfo, x -> new AtomicInteger()).incrementAndGet();
        if (collectDetailedStats) {
            MatchInfoStats stats = ConcurrentOperations.getOrCompute(MATCHED_REGEXP_STATS, matchInfo, x -> new MatchInfoStats());
            AbstractTruffleString tstring = RubyStringLibrary.getTStringUncached(string);
            RubyEncoding encoding = RubyStringLibrary.getEncodingUncached(string);
            stats.record(new ATStringWithEncoding(tstring, encoding));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static Matcher getMatcher(Regex regex, byte[] stringBytes, int start, int end) {
        return regex.matcher(stringBytes, start, end);
    }

    @CompilerDirectives.TruffleBoundary
    private static Matcher getMatcherNoRegion(Regex regex, byte[] stringBytes, int start, int end) {
        return regex.matcherNoRegion(stringBytes, start, end);
    }

    @CompilerDirectives.TruffleBoundary
    private static Regex makeRegexpForEncoding(RubyContext context, RubyRegexp regexp, RubyEncoding enc, Node currentNode) {
        RubyEncoding[] fixedEnc = new RubyEncoding[]{null};
        TruffleString source = regexp.source;
        TruffleString sourceInOtherEncoding = source.forceEncodingUncached(regexp.encoding.tencoding, enc.tencoding);
        try {
            TStringBuilder preprocessed = ClassicRegexp.preprocess(new TStringWithEncoding(sourceInOtherEncoding, enc), enc, fixedEnc, RegexpSupport.ErrorMode.RAISE);
            RegexpOptions options = regexp.options;
            return ClassicRegexp.makeRegexp(null, preprocessed, options, enc, (AbstractTruffleString)source, currentNode);
        }
        catch (DeferredRaiseException dre) {
            throw dre.getException(context);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static Regex compile(RubyDeferredWarnings rubyDeferredWarnings, TStringWithEncoding bytes, RegexpOptions[] optionsArray, Node currentNode) throws DeferredRaiseException {
        RubyEncoding enc = bytes.getEncoding();
        RubyEncoding[] fixedEnc = new RubyEncoding[]{null};
        TStringBuilder unescaped = ClassicRegexp.preprocess(bytes, enc, fixedEnc, RegexpSupport.ErrorMode.RAISE);
        enc = ClassicRegexp.computeRegexpEncoding(optionsArray, enc, fixedEnc);
        Regex regexp = ClassicRegexp.makeRegexp(rubyDeferredWarnings, unescaped, optionsArray[0], enc, (AbstractTruffleString)bytes.tstring, currentNode);
        regexp.setUserObject((Object)bytes.forceEncoding(enc));
        return regexp;
    }

    static final class MatchInfo {
        private final RubyRegexp regex;
        private final boolean matchStart;

        MatchInfo(RubyRegexp regex, boolean matchStart) {
            assert (regex != null);
            this.regex = regex;
            this.matchStart = matchStart;
        }

        public int hashCode() {
            return Objects.hash(this.regex, this.matchStart);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MatchInfo)) {
                return false;
            }
            MatchInfo other = (MatchInfo)obj;
            return this.matchStart == other.matchStart && this.regex.equals(other.regex);
        }

        public String toString() {
            return String.format("Match (%s, fromStart = %s)", this.regex, this.matchStart);
        }
    }

    static final class MatchInfoStats {
        private final ConcurrentHashMap<Integer, AtomicLong> byteLengthFrequencies = new ConcurrentHashMap();
        private final ConcurrentHashMap<Integer, AtomicLong> characterLengthFrequencies = new ConcurrentHashMap();
        private final ConcurrentHashMap<TruffleString.CodeRange, AtomicLong> codeRangeFrequencies = new ConcurrentHashMap();
        private final ConcurrentHashMap<RubyEncoding, AtomicLong> encodingFrequencies = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, AtomicLong> tstringClassFrequencies = new ConcurrentHashMap();

        MatchInfoStats() {
        }

        private void record(ATStringWithEncoding string) {
            ConcurrentOperations.getOrCompute(this.byteLengthFrequencies, string.byteLength(), x -> new AtomicLong()).incrementAndGet();
            ConcurrentOperations.getOrCompute(this.characterLengthFrequencies, string.characterLength(), x -> new AtomicLong()).incrementAndGet();
            ConcurrentOperations.getOrCompute(this.codeRangeFrequencies, string.getCodeRange(), x -> new AtomicLong()).incrementAndGet();
            ConcurrentOperations.getOrCompute(this.encodingFrequencies, string.encoding, x -> new AtomicLong()).incrementAndGet();
            ConcurrentOperations.getOrCompute(this.tstringClassFrequencies, string.getClass().getSimpleName(), x -> new AtomicLong()).incrementAndGet();
        }
    }

    public static abstract class MatchNode
    extends RubyBaseNode {
        @Node.Child
        private DispatchNode dupNode = DispatchNode.create();

        public abstract Object execute(RubyRegexp var1, Object var2, Matcher var3, int var4, int var5, boolean var6, boolean var7);

        @Specialization
        Object match(RubyRegexp regexp, Object string, Matcher matcher, int startPos, int range, boolean onlyMatchAtStart, boolean createMatchData, @Cached InlinedConditionProfile createMatchDataProfile, @Cached InlinedConditionProfile mismatchProfile) {
            if (this.getContext().getOptions().REGEXP_INSTRUMENT_MATCH) {
                TruffleRegexpNodes.instrumentMatch(MATCHED_REGEXPS_JONI, regexp, string, onlyMatchAtStart, this.getContext().getOptions().REGEXP_INSTRUMENT_MATCH_DETAILED);
            }
            int match = this.runMatch(matcher, startPos, range, onlyMatchAtStart);
            if (createMatchDataProfile.profile((Node)this, createMatchData)) {
                if (mismatchProfile.profile((Node)this, match == -1)) {
                    return nil;
                }
                assert (match >= 0);
                MultiRegion region = this.getMatcherEagerRegion(matcher);
                assert (this.assertValidRegion(region));
                RubyString dupedString = (RubyString)((Object)this.dupNode.call(string, "dup"));
                RubyMatchData result = new RubyMatchData(this.coreLibrary().matchDataClass, this.getLanguage().matchDataShape, regexp, (Object)dupedString, region);
                AllocationTracing.trace(result, this);
                return result;
            }
            return match != -1;
        }

        @CompilerDirectives.TruffleBoundary
        private int runMatch(Matcher matcher, int startPos, int range, boolean onlyMatchAtStart) {
            if (onlyMatchAtStart) {
                return (Integer)this.getContext().getThreadManager().runUntilResultKeepStatus(this, unused -> matcher.matchInterruptible(startPos, range, 0), null);
            }
            return (Integer)this.getContext().getThreadManager().runUntilResultKeepStatus(this, unused -> matcher.searchInterruptible(startPos, range, 0), null);
        }

        private MultiRegion getMatcherEagerRegion(Matcher matcher) {
            Region eagerRegion = matcher.getEagerRegion();
            if (eagerRegion instanceof SingleRegion) {
                SingleRegion singleRegion = (SingleRegion)eagerRegion;
                return new MultiRegion(singleRegion.getBeg(0), singleRegion.getEnd(0));
            }
            if (eagerRegion instanceof MultiRegion) {
                MultiRegion multiRegion = (MultiRegion)eagerRegion;
                return multiRegion;
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        private boolean assertValidRegion(MultiRegion region) {
            for (int i = 0; i < region.getNumRegs(); ++i) {
                assert (region.getBeg(i) >= 0 || region.getBeg(i) == -1);
                assert (region.getEnd(i) >= 0 || region.getEnd(i) == -1);
            }
            return true;
        }
    }

    @CoreMethod(names={"linear_time?"}, onSingleton=true, required=1)
    public static abstract class IsLinearTimeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object isLinearTime(RubyRegexp regexp, @Cached InlinedConditionProfile tRegexCouldNotCompileProfile, @Cached TRegexCompileNode tRegexCompileNode, @CachedLibrary(limit="getInteropCacheLimit()") InteropLibrary regexInterop, @Cached TranslateInteropExceptionNode translateInteropExceptionNode, @Bind(value="this") Node node) {
            Object compiledRegex = tRegexCompileNode.executeTRegexCompile(regexp, false, regexp.encoding);
            if (tRegexCouldNotCompileProfile.profile(node, compiledRegex == nil)) {
                return nil;
            }
            boolean isBacktracking = (Boolean)InteropNodes.readMember(node, regexInterop, compiledRegex, "isBacktracking", translateInteropExceptionNode);
            return !isBacktracking;
        }
    }

    @Primitive(name="regexp_match_in_region_tregex", lowerFixnum={2, 3, 5})
    public static abstract class MatchInRegionTRegexNode
    extends PrimitiveArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object matchInRegionTRegex(RubyRegexp regexp, Object string, int fromPos, int toPos, boolean atStart, int startPos, boolean createMatchData, @Cached StringHelperNodes.StringToTruffleStringInplaceNode stringToTruffleStringInplaceNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached InlinedConditionProfile createMatchDataProfile, @Cached InlinedConditionProfile matchFoundProfile, @Cached InlinedConditionProfile tRegexCouldNotCompileProfile, @Cached InlinedConditionProfile tRegexIncompatibleProfile, @Cached InlinedConditionProfile startPosNotZeroProfile, @Cached InlinedLoopConditionProfile loopProfile, @CachedLibrary(limit="getInteropCacheLimit()") InteropLibrary regexInterop, @CachedLibrary(limit="getInteropCacheLimit()") InteropLibrary resultInterop, @Cached PrepareRegexpEncodingNode prepareRegexpEncodingNode, @Cached TRegexCompileNode tRegexCompileNode, @Cached RubyStringLibrary libString, @Cached InlinedIntValueProfile groupCountProfile, @Cached LazyDispatchNode warnOnFallbackNode, @Cached LazyDispatchNode stringDupNode, @Cached TranslateInteropExceptionNode translateInteropExceptionNode, @Cached LazyMatchInRegionNode fallbackMatchInRegionNode, @Cached LazyTruffleStringSubstringByteIndexNode substringByteIndexNode, @Bind(value="this") Node node) {
            String execMethod;
            TruffleString tstringToMatch;
            Object tRegex;
            stringToTruffleStringInplaceNode.execute(node, string);
            RubyEncoding negotiatedEncoding = prepareRegexpEncodingNode.executePrepare(node, regexp, string);
            TruffleString tstring = switchEncodingNode.execute(libString.getTString(node, string), negotiatedEncoding.tencoding);
            int byteLength = tstring.byteLength(negotiatedEncoding.tencoding);
            if (tRegexIncompatibleProfile.profile(node, toPos < fromPos || toPos != byteLength || fromPos < 0) || tRegexCouldNotCompileProfile.profile(node, (tRegex = tRegexCompileNode.executeTRegexCompile(regexp, atStart, negotiatedEncoding)) == nil)) {
                return MatchInRegionTRegexNode.fallbackToJoni(node, regexp, string, negotiatedEncoding, fromPos, toPos, atStart, startPos, createMatchData, warnOnFallbackNode, fallbackMatchInRegionNode.get(node));
            }
            if (MatchInRegionTRegexNode.getContext((Node)node).getOptions().REGEXP_INSTRUMENT_MATCH) {
                TruffleRegexpNodes.instrumentMatch(MATCHED_REGEXPS_TREGEX, regexp, string, atStart, MatchInRegionTRegexNode.getContext((Node)node).getOptions().REGEXP_INSTRUMENT_MATCH_DETAILED);
            }
            int fromIndex = fromPos;
            if (createMatchDataProfile.profile(node, createMatchData)) {
                if (startPosNotZeroProfile.profile(node, startPos > 0)) {
                    assert (fromPos == startPos);
                    fromIndex = 0;
                    tstringToMatch = substringByteIndexNode.get(node).execute((AbstractTruffleString)tstring, startPos, toPos - startPos, negotiatedEncoding.tencoding, true);
                } else {
                    tstringToMatch = tstring;
                }
                execMethod = "exec";
            } else {
                assert (startPos == 0) : "Simple Boolean match not supported with non-zero startPos";
                tstringToMatch = tstring;
                execMethod = "execBoolean";
            }
            Object[] arguments = new Object[]{tstringToMatch, fromIndex};
            Object result = InteropNodes.invokeMember(node, regexInterop, tRegex, execMethod, arguments, translateInteropExceptionNode);
            if (createMatchDataProfile.profile(node, createMatchData)) {
                boolean isMatch = (Boolean)InteropNodes.readMember(node, resultInterop, result, "isMatch", translateInteropExceptionNode);
                if (matchFoundProfile.profile(node, isMatch)) {
                    int groupCount = groupCountProfile.profile(node, ((Integer)InteropNodes.readMember(node, regexInterop, tRegex, "groupCount", translateInteropExceptionNode)).intValue());
                    MultiRegion region = new MultiRegion(groupCount);
                    try {
                        int group = 0;
                        while (loopProfile.inject(node, group < groupCount)) {
                            region.setBeg(group, -2);
                            region.setEnd(group, -2);
                            TruffleSafepoint.poll((Node)node);
                            ++group;
                        }
                    }
                    finally {
                        MatchInRegionTRegexNode.profileAndReportLoopCount(node, loopProfile, groupCount);
                    }
                    return MatchInRegionTRegexNode.createMatchData(node, regexp, MatchInRegionTRegexNode.dupString(string, stringDupNode.get(node)), region, result);
                }
                return nil;
            }
            return result;
        }

        private static Object fallbackToJoni(Node node, RubyRegexp regexp, Object string, RubyEncoding encoding, int fromPos, int toPos, boolean atStart, int startPos, boolean createMatchData, LazyDispatchNode warnOnFallbackNode, MatchInRegionNode fallbackMatchInRegionNode) {
            if (MatchInRegionTRegexNode.getContext((Node)node).getOptions().WARN_TRUFFLE_REGEX_MATCH_FALLBACK) {
                warnOnFallbackNode.get(node).call((Object)MatchInRegionTRegexNode.getContext((Node)node).getCoreLibrary().truffleRegexpOperationsModule, "warn_fallback", new Object[]{regexp, string, encoding, fromPos, toPos, atStart, startPos});
            }
            return fallbackMatchInRegionNode.executeMatchInRegion(regexp, string, fromPos, toPos, atStart, startPos, createMatchData);
        }

        private static Object createMatchData(Node node, RubyRegexp regexp, Object string, MultiRegion region, Object tRegexResult) {
            RubyMatchData matchData = new RubyMatchData(MatchInRegionTRegexNode.coreLibrary((Node)node).matchDataClass, MatchInRegionTRegexNode.getLanguage((Node)node).matchDataShape, regexp, string, region);
            matchData.tRegexResult = tRegexResult;
            AllocationTracing.trace(matchData, node);
            return matchData;
        }

        private static Object dupString(Object string, DispatchNode stringDupNode) {
            return stringDupNode.call(string, "dup");
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class LazyTruffleStringSubstringByteIndexNode
    extends RubyBaseNode {
        public final TruffleString.SubstringByteIndexNode get(Node node) {
            return this.execute(node);
        }

        protected abstract TruffleString.SubstringByteIndexNode execute(Node var1);

        @Specialization
        static TruffleString.SubstringByteIndexNode doLazy(@Cached(inline=false) TruffleString.SubstringByteIndexNode substringByteIndexNode) {
            return substringByteIndexNode;
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class LazyMatchInRegionNode
    extends RubyBaseNode {
        public final MatchInRegionNode get(Node node) {
            return this.execute(node);
        }

        protected abstract MatchInRegionNode execute(Node var1);

        @Specialization
        static MatchInRegionNode doLazy(@Cached(inline=false) MatchInRegionNode matchInRegionNode) {
            return matchInRegionNode;
        }
    }

    @Primitive(name="regexp_match_in_region", lowerFixnum={2, 3, 5})
    public static abstract class MatchInRegionNode
    extends PrimitiveArrayArgumentsNode {
        @NeverDefault
        public static MatchInRegionNode create() {
            return TruffleRegexpNodesFactory.MatchInRegionNodeFactory.create(null);
        }

        public abstract Object executeMatchInRegion(RubyRegexp var1, Object var2, int var3, int var4, boolean var5, int var6, boolean var7);

        @Specialization
        static Object matchInRegion(RubyRegexp regexp, Object string, int fromPos, int toPos, boolean atStart, int startPos, boolean createMatchData, @Cached InlinedConditionProfile createMatchDataProfile, @Cached InlinedConditionProfile encodingMismatchProfile, @Cached PrepareRegexpEncodingNode prepareRegexpEncodingNode, @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayNode, @Cached InlinedConditionProfile zeroOffsetProfile, @Cached MatchNode matchNode, @Cached RubyStringLibrary libString, @Bind(value="this") Node node) {
            AbstractTruffleString tstring;
            InternalByteArray byteArray;
            Regex regex = regexp.regex;
            RubyEncoding negotiatedEncoding = prepareRegexpEncodingNode.executePrepare(node, regexp, string);
            if (encodingMismatchProfile.profile(node, regexp.encoding != negotiatedEncoding)) {
                EncodingCache encodingCache = regexp.cachedEncodings;
                regex = encodingCache.getOrCreate(negotiatedEncoding, e -> TruffleRegexpNodes.makeRegexpForEncoding(MatchInRegionNode.getContext(node), regexp, e, node));
            }
            int offset = zeroOffsetProfile.profile(node, (byteArray = getInternalByteArrayNode.execute(tstring = libString.getTString(node, string), libString.getTEncoding(node, string))).getOffset() == 0) ? 0 : byteArray.getOffset();
            Matcher matcher = createMatchDataProfile.profile(node, createMatchData) ? TruffleRegexpNodes.getMatcher(regex, byteArray.getArray(), offset + startPos, byteArray.getEnd()) : TruffleRegexpNodes.getMatcherNoRegion(regex, byteArray.getArray(), offset + startPos, byteArray.getEnd());
            return matchNode.execute(regexp, string, matcher, offset + fromPos, offset + toPos, atStart, createMatchData);
        }
    }

    @CoreMethod(names={"matched_regexp_hash_array"}, onSingleton=true, required=0)
    public static abstract class MatchedRegexpHashArray
    extends RegexpStatsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object buildInfoArray(@Cached ArrayBuilderNode arrayBuilderNode, @CachedLibrary(limit="3") HashStoreLibrary hashStoreLibrary) {
            int arraySize = MATCHED_REGEXPS_JONI.size() + MATCHED_REGEXPS_TREGEX.size();
            ArrayBuilderNode.BuilderState state = arrayBuilderNode.start(arraySize);
            this.processGroup(MATCHED_REGEXPS_JONI, false, hashStoreLibrary, arrayBuilderNode, state, 0);
            this.processGroup(MATCHED_REGEXPS_TREGEX, true, hashStoreLibrary, arrayBuilderNode, state, MATCHED_REGEXPS_JONI.size());
            return this.createArray(arrayBuilderNode.finish(state, arraySize), arraySize);
        }

        private void processGroup(ConcurrentHashMap<MatchInfo, AtomicInteger> group, boolean isTRegexMatch, HashStoreLibrary hashStoreLibrary, ArrayBuilderNode arrayBuilderNode, ArrayBuilderNode.BuilderState state, int offset) {
            int n = 0;
            for (Map.Entry<MatchInfo, AtomicInteger> entry : group.entrySet()) {
                arrayBuilderNode.appendValue(state, offset + n, this.buildHash(hashStoreLibrary, isTRegexMatch, entry.getKey(), entry.getValue()));
                ++n;
            }
        }

        private RubyHash buildHash(HashStoreLibrary hashStoreLibrary, boolean isTRegexMatch, MatchInfo matchInfo, AtomicInteger count) {
            RubyHash regexpInfoHash = CompiledRegexpHashArray.buildRegexInfoHash(this.getContext(), this.getLanguage(), hashStoreLibrary, matchInfo.regex, true, Optional.empty(), Optional.empty());
            RubyHash matchInfoHash = HashOperations.newEmptyHash(this.getContext(), this.getLanguage());
            hashStoreLibrary.set(matchInfoHash.store, matchInfoHash, this.getLanguage().getSymbol("regexp"), regexpInfoHash, true);
            hashStoreLibrary.set(matchInfoHash.store, matchInfoHash, this.getLanguage().getSymbol("count"), count.get(), true);
            hashStoreLibrary.set(matchInfoHash.store, matchInfoHash, this.getLanguage().getSymbol("isTRegex"), isTRegexMatch, true);
            hashStoreLibrary.set(matchInfoHash.store, matchInfoHash, this.getLanguage().getSymbol("fromStart"), matchInfo.matchStart, true);
            if (this.getContext().getOptions().REGEXP_INSTRUMENT_MATCH_DETAILED) {
                hashStoreLibrary.set(matchInfoHash.store, matchInfoHash, this.getLanguage().getSymbol("match_stats"), this.buildMatchInfoStatsHash(hashStoreLibrary, matchInfo), true);
            }
            assert (hashStoreLibrary.verify(matchInfoHash.store, matchInfoHash));
            return matchInfoHash;
        }

        private RubyHash buildMatchInfoStatsHash(HashStoreLibrary hashStoreLibrary, MatchInfo matchInfo) {
            MatchInfoStats stats = MATCHED_REGEXP_STATS.get(matchInfo);
            RubyHash ret = HashOperations.newEmptyHash(this.getContext(), this.getLanguage());
            this.buildAndSetDistributionHash(hashStoreLibrary, ret, "byte_lengths", stats.byteLengthFrequencies, Optional.empty(), Optional.of(count -> count.get()));
            this.buildAndSetDistributionHash(hashStoreLibrary, ret, "character_lengths", stats.characterLengthFrequencies, Optional.empty(), Optional.of(count -> count.get()));
            this.buildAndSetDistributionHash(hashStoreLibrary, ret, "code_ranges", stats.codeRangeFrequencies, Optional.of(codeRange -> this.getLanguage().getSymbol(codeRange.toString())), Optional.of(count -> count.get()));
            this.buildAndSetDistributionHash(hashStoreLibrary, ret, "encodings", stats.encodingFrequencies, Optional.empty(), Optional.of(count -> count.get()));
            this.buildAndSetDistributionHash(hashStoreLibrary, ret, "string_types", stats.tstringClassFrequencies, Optional.of(className -> StringOperations.createUTF8String(this.getContext(), this.getLanguage(), className)), Optional.of(count -> count.get()));
            return ret;
        }

        private <K, V> void buildAndSetDistributionHash(HashStoreLibrary hashStoreLibrary, RubyHash hash, String keyName, ConcurrentHashMap<K, V> distribution, Optional<Function<K, Object>> keyMapper, Optional<Function<V, Object>> valueMapper) {
            RubyHash distributionHash = HashOperations.toRubyHash(this.getContext(), this.getLanguage(), hashStoreLibrary, distribution, keyMapper, valueMapper, true);
            hashStoreLibrary.set(hash.store, hash, this.getLanguage().getSymbol(keyName), distributionHash, true);
        }
    }

    @CoreMethod(names={"compiled_regexp_hash_array"}, onSingleton=true, required=0)
    public static abstract class CompiledRegexpHashArray
    extends RegexpStatsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object buildInfoArray(@Cached ArrayBuilderNode arrayBuilderNode, @CachedLibrary(limit="1") HashStoreLibrary hashStoreLibrary) {
            Set<RubyRegexp> matchedRegexps = CompiledRegexpHashArray.allMatchedRegexps();
            int arraySize = LITERAL_REGEXPS.size() + DYNAMIC_REGEXPS.size();
            ArrayBuilderNode.BuilderState state = arrayBuilderNode.start(arraySize);
            this.processGroup(LITERAL_REGEXPS, matchedRegexps, true, hashStoreLibrary, arrayBuilderNode, state, 0);
            this.processGroup(DYNAMIC_REGEXPS, matchedRegexps, false, hashStoreLibrary, arrayBuilderNode, state, LITERAL_REGEXPS.size());
            return this.createArray(arrayBuilderNode.finish(state, arraySize), arraySize);
        }

        private void processGroup(ConcurrentSkipListSet<RubyRegexp> group, Set<RubyRegexp> matchedRegexps, boolean isRegexpLiteral, HashStoreLibrary hashStoreLibrary, ArrayBuilderNode arrayBuilderNode, ArrayBuilderNode.BuilderState state, int offset) {
            int n = 0;
            for (RubyRegexp entry : group) {
                arrayBuilderNode.appendValue(state, offset + n, CompiledRegexpHashArray.buildRegexInfoHash(this.getContext(), this.getLanguage(), hashStoreLibrary, entry, matchedRegexps.contains(entry), Optional.of(isRegexpLiteral), Optional.of(1)));
                ++n;
            }
        }

        protected static RubyHash buildRegexInfoHash(RubyContext context, RubyLanguage language, HashStoreLibrary hashStoreLibrary, RubyRegexp regexpInfo, boolean isUsed, Optional<Boolean> isRegexpLiteral, Optional<Integer> count) {
            RubyHash hash = HashOperations.newEmptyHash(context, language);
            hashStoreLibrary.set(hash.store, hash, language.getSymbol("value"), (Object)StringOperations.createUTF8String(context, language, (AbstractTruffleString)regexpInfo.source), true);
            if (count.isPresent()) {
                hashStoreLibrary.set(hash.store, hash, language.getSymbol("count"), count.get(), true);
            }
            if (isRegexpLiteral.isPresent()) {
                hashStoreLibrary.set(hash.store, hash, language.getSymbol("isLiteral"), isRegexpLiteral.get(), true);
            }
            if (context.getOptions().REGEXP_INSTRUMENT_MATCH) {
                hashStoreLibrary.set(hash.store, hash, language.getSymbol("isUsed"), isUsed, true);
            }
            hashStoreLibrary.set(hash.store, hash, language.getSymbol("encoding"), regexpInfo.encoding, true);
            hashStoreLibrary.set(hash.store, hash, language.getSymbol("options"), RegexpOptions.fromJoniOptions(regexpInfo.options.toJoniOptions()).toOptions(), true);
            assert (hashStoreLibrary.verify(hash.store, hash));
            return hash;
        }
    }

    @CoreMethod(names={"unused_regexps_array"}, onSingleton=true, required=0)
    public static abstract class UnusedRegexpsArray
    extends RegexpStatsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object buildUnusedRegexpsArray() {
            Set<RubyRegexp> compiledRegexps = UnusedRegexpsArray.allCompiledRegexps();
            Set<RubyRegexp> matchedRegexps = UnusedRegexpsArray.allMatchedRegexps();
            HashSet<RubyRegexp> unusedRegexps = new HashSet<RubyRegexp>(compiledRegexps);
            unusedRegexps.removeAll(matchedRegexps);
            Object[] array = new Object[unusedRegexps.size()];
            int n = 0;
            for (RubyRegexp entry : unusedRegexps) {
                array[n++] = StringOperations.createUTF8String(this.getContext(), this.getLanguage(), entry.toString());
            }
            return this.createArray(array);
        }
    }

    @CoreMethod(names={"match_stats_array"}, onSingleton=true, required=1)
    public static abstract class MatchStatsArrayNode
    extends RegexpStatsNode {
        @Specialization
        Object buildStatsArray(boolean joniMatches, @Cached ArrayBuilderNode arrayBuilderNode) {
            return this.fillinInstrumentData(joniMatches ? MATCHED_REGEXPS_JONI : MATCHED_REGEXPS_TREGEX, arrayBuilderNode, this.getContext());
        }
    }

    @CoreMethod(names={"regexp_compilation_stats_array"}, onSingleton=true, required=1)
    public static abstract class RegexpCompilationStatsArrayNode
    extends RegexpStatsNode {
        @Specialization
        Object buildStatsArray(boolean literalRegexps, @Cached ArrayBuilderNode arrayBuilderNode) {
            return this.fillinInstrumentData(literalRegexps ? LITERAL_REGEXPS : DYNAMIC_REGEXPS, arrayBuilderNode);
        }
    }

    public static abstract class RegexpStatsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        protected <T> RubyArray fillinInstrumentData(Map<T, AtomicInteger> map, ArrayBuilderNode arrayBuilderNode, RubyContext context) {
            int arraySize = (LITERAL_REGEXPS.size() + DYNAMIC_REGEXPS.size()) * 2;
            ArrayBuilderNode.BuilderState state = arrayBuilderNode.start(arraySize);
            int n = 0;
            for (Map.Entry<T, AtomicInteger> e : map.entrySet()) {
                arrayBuilderNode.appendValue(state, n++, (Object)StringOperations.createUTF8String(context, this.getLanguage(), e.getKey().toString()));
                arrayBuilderNode.appendValue(state, n++, e.getValue().get());
            }
            return this.createArray(arrayBuilderNode.finish(state, n), n);
        }

        @CompilerDirectives.TruffleBoundary
        protected <T> RubyArray fillinInstrumentData(Set<T> map, ArrayBuilderNode arrayBuilderNode) {
            int arraySize = (LITERAL_REGEXPS.size() + DYNAMIC_REGEXPS.size()) * 2;
            ArrayBuilderNode.BuilderState state = arrayBuilderNode.start(arraySize);
            int n = 0;
            for (T e : map) {
                arrayBuilderNode.appendValue(state, n++, e);
                arrayBuilderNode.appendValue(state, n++, 1);
            }
            return this.createArray(arrayBuilderNode.finish(state, n), n);
        }

        @CompilerDirectives.TruffleBoundary
        protected static Set<RubyRegexp> allCompiledRegexps() {
            HashSet<RubyRegexp> ret = new HashSet<RubyRegexp>();
            ret.addAll(DYNAMIC_REGEXPS);
            ret.addAll(LITERAL_REGEXPS);
            return ret;
        }

        @CompilerDirectives.TruffleBoundary
        protected static Set<RubyRegexp> allMatchedRegexps() {
            HashSet<RubyRegexp> ret = new HashSet<RubyRegexp>();
            for (MatchInfo matchInfo : MATCHED_REGEXPS_JONI.keySet()) {
                ret.add(matchInfo.regex);
            }
            for (MatchInfo matchInfo : MATCHED_REGEXPS_TREGEX.keySet()) {
                ret.add(matchInfo.regex);
            }
            return ret;
        }
    }

    @ImportStatic(value={Encodings.class})
    public static abstract class TRegexCompileNode
    extends RubyBaseNode {
        @Node.Child
        DispatchNode warnOnFallbackNode;

        public abstract Object executeTRegexCompile(RubyRegexp var1, boolean var2, RubyEncoding var3);

        @Specialization(guards={"encoding == US_ASCII"})
        Object usASCII(RubyRegexp regexp, boolean atStart, RubyEncoding encoding, @Cached @Cached.Exclusive RunTwiceBranchProfile compileProfile) {
            Object tregex = regexp.tregexCache.getUSASCIIRegex(atStart);
            if (tregex != null) {
                return tregex;
            }
            compileProfile.enter();
            return regexp.tregexCache.compile(this.getContext(), regexp, atStart, encoding, this);
        }

        @Specialization(guards={"encoding == ISO_8859_1"})
        Object latin1(RubyRegexp regexp, boolean atStart, RubyEncoding encoding, @Cached @Cached.Exclusive RunTwiceBranchProfile compileProfile) {
            Object tregex = regexp.tregexCache.getLatin1Regex(atStart);
            if (tregex != null) {
                return tregex;
            }
            compileProfile.enter();
            return regexp.tregexCache.compile(this.getContext(), regexp, atStart, encoding, this);
        }

        @Specialization(guards={"encoding == UTF_8"})
        Object utf8(RubyRegexp regexp, boolean atStart, RubyEncoding encoding, @Cached @Cached.Exclusive RunTwiceBranchProfile compileProfile) {
            Object tregex = regexp.tregexCache.getUTF8Regex(atStart);
            if (tregex != null) {
                return tregex;
            }
            compileProfile.enter();
            return regexp.tregexCache.compile(this.getContext(), regexp, atStart, encoding, this);
        }

        @Specialization(guards={"encoding == BINARY"})
        Object binary(RubyRegexp regexp, boolean atStart, RubyEncoding encoding, @Cached @Cached.Exclusive RunTwiceBranchProfile compileProfile) {
            Object tregex = regexp.tregexCache.getBinaryRegex(atStart);
            if (tregex != null) {
                return tregex;
            }
            compileProfile.enter();
            return regexp.tregexCache.compile(this.getContext(), regexp, atStart, encoding, this);
        }

        @Fallback
        Object other(RubyRegexp regexp, boolean atStart, RubyEncoding encoding) {
            return nil;
        }

        DispatchNode getWarnOnFallbackNode() {
            if (this.warnOnFallbackNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.warnOnFallbackNode = (DispatchNode)this.insert(DispatchNode.create());
            }
            return this.warnOnFallbackNode;
        }
    }

    @CoreMethod(names={"union"}, onSingleton=true, required=2, rest=true, split=Split.ALWAYS)
    public static abstract class RegexpUnionNode
    extends CoreMethodArrayArgumentsNode {
        static final InlinedBranchProfile UNCACHED_BRANCH_PROFILE = InlinedBranchProfile.getUncached();
        @Node.Child
        StringNodes.StringAppendPrimitiveNode appendNode = StringNodes.StringAppendPrimitiveNode.create();
        @Node.Child
        TruffleString.AsTruffleStringNode asTruffleStringNode = TruffleString.AsTruffleStringNode.create();
        @Node.Child
        RegexpNodes.ToSNode toSNode = RegexpNodes.ToSNode.create();

        @Specialization(guards={"argsMatch(node, frame, cachedArgs, args, sameOrEqualNode)"}, limit="getDefaultCacheLimit()")
        static Object fastUnion(VirtualFrame frame, RubyString str, Object sep, Object[] args, @Bind(value="this") Node node, @Cached KernelNodes.SameOrEqualNode sameOrEqualNode, @Cached(value="args", dimensions=1) Object[] cachedArgs, @Cached @Cached.Exclusive RubyStringLibrary libString, @Cached @Cached.Exclusive RubyStringLibrary libRegexpString, @Cached(value="buildUnion(node, str, sep, args, UNCACHED_BRANCH_PROFILE, libString, libRegexpString)") RubyRegexp union) {
            return union;
        }

        @Specialization(replaces={"fastUnion"})
        Object slowUnion(RubyString str, Object sep, Object[] args, @Cached PerformanceWarningNode performanceWarningNode, @Cached @Cached.Exclusive RubyStringLibrary libString, @Cached @Cached.Exclusive RubyStringLibrary libRegexpString, @Cached InlinedBranchProfile errorProfile) {
            performanceWarningNode.warn("unbounded creation of regexps causes deoptimization loops which hurt performance significantly, avoid creating regexps dynamically where possible or cache them to fix this");
            return this.buildUnion(this, str, sep, args, errorProfile, libString, libRegexpString);
        }

        public RubyRegexp buildUnion(Node node, RubyString str, Object sep, Object[] args, InlinedBranchProfile errorProfile, RubyStringLibrary libString, RubyStringLibrary libRegexpString) {
            assert (args.length > 0);
            RubyString regexpString = null;
            for (Object arg : args) {
                if (regexpString == null) {
                    regexpString = this.appendNode.executeStringAppend(str, this.string(node, arg, libString));
                    continue;
                }
                regexpString = this.appendNode.executeStringAppend(regexpString, sep);
                regexpString = this.appendNode.executeStringAppend(regexpString, this.string(node, arg, libString));
            }
            RubyEncoding encoding = libRegexpString.getEncoding(node, (Object)regexpString);
            TruffleString truffleString = this.asTruffleStringNode.execute(regexpString.tstring, encoding.tencoding);
            try {
                return this.createRegexp(node, truffleString, encoding);
            }
            catch (DeferredRaiseException dre) {
                errorProfile.enter(node);
                throw dre.getException(this.getContext());
            }
        }

        public Object string(Node node, Object obj, RubyStringLibrary libString) {
            if (libString.isRubyString(node, obj)) {
                TStringWithEncoding quotedString = ClassicRegexp.quote19(new ATStringWithEncoding(node, libString, obj));
                return this.createString(quotedString);
            }
            return this.toSNode.execute((RubyRegexp)obj);
        }

        @ExplodeLoop
        protected static boolean argsMatch(Node node, VirtualFrame frame, Object[] cachedArgs, Object[] args, KernelNodes.SameOrEqualNode sameOrEqualNode) {
            if (cachedArgs.length != args.length) {
                return false;
            }
            for (int i = 0; i < cachedArgs.length; ++i) {
                if (sameOrEqualNode.execute(node, cachedArgs[i], args[i])) continue;
                return false;
            }
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        public RubyRegexp createRegexp(Node node, TruffleString pattern, RubyEncoding encoding) throws DeferredRaiseException {
            return RubyRegexp.create(this.getLanguage(), pattern, encoding, RegexpOptions.fromEmbeddedOptions(0), node);
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class PrepareRegexpEncodingNode
    extends RubyBaseNode {
        public abstract RubyEncoding executePrepare(Node var1, RubyRegexp var2, Object var3);

        @Specialization
        static RubyEncoding regexpPrepareEncoding(Node node, RubyRegexp regexp, Object matchString, @Cached RubyStringLibrary stringLibrary, @Cached(inline=false) TruffleString.GetByteCodeRangeNode codeRangeNode, @Cached InlinedBranchProfile asciiOnlyProfile, @Cached InlinedBranchProfile asciiIncompatibleFixedRegexpEncodingProfile, @Cached InlinedBranchProfile asciiIncompatibleMatchStringEncodingProfile, @Cached InlinedBranchProfile brokenMatchStringProfile, @Cached InlinedBranchProfile defaultRegexEncodingProfile, @Cached InlinedBranchProfile fallbackProcessingProfile, @Cached InlinedBranchProfile fixedRegexpEncodingProfile, @Cached InlinedBranchProfile returnMatchStringEncodingProfile, @Cached InlinedBranchProfile sameEncodingProfile, @Cached InlinedBranchProfile validBinaryMatchStringProfile, @Cached InlinedBranchProfile validUtf8MatchStringProfile, @Cached LazyWarnNode lazyWarnNode) {
            RubyEncoding regexpEncoding = regexp.encoding;
            RubyEncoding matchStringEncoding = stringLibrary.getEncoding(node, matchString);
            AbstractTruffleString tstring = stringLibrary.getTString(node, matchString);
            TruffleString.CodeRange matchStringCodeRange = codeRangeNode.execute(tstring, matchStringEncoding.tencoding);
            if (matchStringCodeRange == TruffleString.CodeRange.BROKEN) {
                brokenMatchStringProfile.enter(node);
                throw new RaiseException(PrepareRegexpEncodingNode.getContext(node), PrepareRegexpEncodingNode.coreExceptions(node).argumentErrorInvalidByteSequence(matchStringEncoding, node));
            }
            if (regexpEncoding == Encodings.US_ASCII && regexp.options.canAdaptEncoding()) {
                defaultRegexEncodingProfile.enter(node);
                if (matchStringCodeRange == TruffleString.CodeRange.ASCII) {
                    asciiOnlyProfile.enter(node);
                    return Encodings.US_ASCII;
                }
                if (matchStringEncoding == Encodings.UTF_8) {
                    validUtf8MatchStringProfile.enter(node);
                    assert (matchStringCodeRange == TruffleString.CodeRange.VALID);
                    return Encodings.UTF_8;
                }
                if (matchStringEncoding == Encodings.BINARY) {
                    validBinaryMatchStringProfile.enter(node);
                    assert (matchStringCodeRange == TruffleString.CodeRange.VALID);
                    return Encodings.BINARY;
                }
            }
            fallbackProcessingProfile.enter(node);
            if (regexpEncoding == matchStringEncoding) {
                sameEncodingProfile.enter(node);
                return regexpEncoding;
            }
            if (matchStringCodeRange == TruffleString.CodeRange.ASCII && regexpEncoding == Encodings.US_ASCII) {
                asciiOnlyProfile.enter(node);
                return Encodings.US_ASCII;
            }
            if (!matchStringEncoding.isAsciiCompatible) {
                asciiIncompatibleMatchStringEncodingProfile.enter(node);
                return PrepareRegexpEncodingNode.raiseEncodingCompatibilityError(node, regexp, matchStringEncoding);
            }
            if (regexp.options.isFixed()) {
                fixedRegexpEncodingProfile.enter(node);
                if (!regexpEncoding.isAsciiCompatible || matchStringCodeRange != TruffleString.CodeRange.ASCII) {
                    asciiIncompatibleFixedRegexpEncodingProfile.enter(node);
                    return PrepareRegexpEncodingNode.raiseEncodingCompatibilityError(node, regexp, matchStringEncoding);
                }
                return regexpEncoding;
            }
            returnMatchStringEncodingProfile.enter(node);
            if (regexp.options.isEncodingNone() && matchStringEncoding != Encodings.BINARY && matchStringCodeRange != TruffleString.CodeRange.ASCII) {
                PrepareRegexpEncodingNode.warnHistoricalBinaryRegexpMatch(node, lazyWarnNode.get(node), matchStringEncoding);
            }
            return matchStringEncoding;
        }

        private static RubyEncoding raiseEncodingCompatibilityError(Node node, RubyRegexp regexp, RubyEncoding matchStringEncoding) {
            throw new RaiseException(PrepareRegexpEncodingNode.getContext(node), PrepareRegexpEncodingNode.coreExceptions(node).encodingCompatibilityErrorRegexpIncompatible(regexp.encoding, matchStringEncoding, node));
        }

        private static void warnHistoricalBinaryRegexpMatch(Node node, WarnNode warnNode, RubyEncoding matchStringEncoding) {
            if (warnNode.shouldWarn()) {
                warnNode.warningMessage(PrepareRegexpEncodingNode.getContext(node).getCallStack().getTopMostUserSourceSection(), StringUtils.format("historical binary regexp match /.../n against %s string", PrepareRegexpEncodingNode.getEncodingName(matchStringEncoding)));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static String getEncodingName(RubyEncoding matchStringEncoding) {
            return RubyGuards.getJavaString(matchStringEncoding.name);
        }
    }

    @Primitive(name="regexp_check_encoding")
    public static abstract class RegexpCheckEncodingNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        static RubyEncoding regexpPrepareEncoding(RubyRegexp regexp, Object string, @Cached PrepareRegexpEncodingNode prepareRegexpEncodingNode, @Bind(value="this") Node node) {
            return prepareRegexpEncodingNode.executePrepare(node, regexp, string);
        }
    }
}

