/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.MutableTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Objects;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.string.StringGuards;
import org.truffleruby.core.string.StringHelperNodes;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.library.RubyStringLibrary;

@ExportLibrary(value=InteropLibrary.class)
@ImportStatic(value={RubyBaseNode.class})
public final class RubyString
extends RubyDynamicObject {
    public boolean frozen;
    public boolean locked = false;
    public AbstractTruffleString tstring;
    private RubyEncoding encoding;

    public RubyString(RubyClass rubyClass, Shape shape, boolean frozen, AbstractTruffleString tstring, RubyEncoding rubyEncoding) {
        super(rubyClass, shape);
        assert (tstring.isCompatibleToUncached(rubyEncoding.tencoding));
        this.frozen = frozen;
        this.tstring = Objects.requireNonNull(tstring);
        this.encoding = Objects.requireNonNull(rubyEncoding);
    }

    public void setTString(AbstractTruffleString tstring) {
        assert (tstring.isCompatibleToUncached(this.getEncodingUncached().tencoding));
        this.tstring = Objects.requireNonNull(tstring);
    }

    public void setTString(AbstractTruffleString tstring, RubyEncoding encoding) {
        assert (tstring.isCompatibleToUncached(encoding.tencoding));
        this.tstring = Objects.requireNonNull(tstring);
        this.encoding = Objects.requireNonNull(encoding);
    }

    public void clearCodeRange() {
        assert (this.tstring.isNative());
        ((MutableTruffleString)this.tstring).notifyExternalMutation();
    }

    @Override
    public String toString() {
        return this.tstring.toString();
    }

    public TruffleString asTruffleStringUncached() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return this.tstring.asTruffleStringUncached(this.getEncodingUncached().tencoding);
    }

    public String getJavaString() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return TStringUtils.toJavaStringOrThrow(this.tstring, this.getEncodingUncached());
    }

    public int byteLengthUncached() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return this.tstring.byteLength(this.getEncodingUncached().tencoding);
    }

    public RubyEncoding getEncodingUncached() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return this.encoding;
    }

    public RubyEncoding getEncodingUnprofiled() {
        return this.encoding;
    }

    public void freeze() {
        this.frozen = true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    @ExportMessage
    protected boolean isString() {
        return true;
    }

    @ExportMessage
    protected TruffleString asTruffleString(@Cached TruffleString.AsTruffleStringNode asTruffleStringNode) {
        return asTruffleStringNode.execute(this.tstring, this.encoding.tencoding);
    }

    @ExportMessage
    @ReportPolymorphism
    @ImportStatic(value={RubyBaseNode.class})
    public static final class AsString {
        @Specialization(guards={"equalNode.execute(string.tstring, libString.getEncoding(node, string), cachedTString, cachedEncoding)"}, limit="getLimit()")
        static String asStringCached(RubyString string, @Bind(value="this") Node node, @Cached @Cached.Shared RubyStringLibrary libString, @Cached(value="string.asTruffleStringUncached()") TruffleString cachedTString, @Cached(value="string.getEncodingUncached()") RubyEncoding cachedEncoding, @Cached(value="string.getJavaString()") String javaString, @Cached StringHelperNodes.EqualNode equalNode) {
            return javaString;
        }

        @Specialization(replaces={"asStringCached"})
        static String asStringUncached(RubyString string, @Cached @Cached.Shared RubyStringLibrary libString, @Cached TruffleString.GetByteCodeRangeNode codeRangeNode, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached InlinedConditionProfile binaryNonAsciiProfile, @Bind(value="this") Node node) {
            RubyEncoding encoding = libString.getEncoding(node, (Object)string);
            if (binaryNonAsciiProfile.profile(node, encoding == Encodings.BINARY && !StringGuards.is7Bit(string.tstring, encoding, codeRangeNode))) {
                return AsString.getJavaStringBoundary(string);
            }
            return toJavaStringNode.execute(string.tstring);
        }

        @CompilerDirectives.TruffleBoundary
        private static String getJavaStringBoundary(RubyString string) {
            return string.getJavaString();
        }

        protected static int getLimit() {
            return RubyLanguage.getCurrentLanguage().options.INTEROP_CONVERT_CACHE;
        }
    }
}

