/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.MutableTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import org.graalvm.collections.Pair;
import org.graalvm.shadowed.org.jcodings.Config;
import org.graalvm.shadowed.org.jcodings.Encoding;
import org.graalvm.shadowed.org.jcodings.ascii.AsciiTables;
import org.graalvm.shadowed.org.jcodings.specific.ASCIIEncoding;
import org.truffleruby.Layouts;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Split;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.collections.ByteArrayBuilder;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.cast.ToIntNode;
import org.truffleruby.core.cast.ToLongNode;
import org.truffleruby.core.cast.ToStrNode;
import org.truffleruby.core.encoding.EncodingNodes;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.IsCharacterHeadNode;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.format.FormatExceptionTranslator;
import org.truffleruby.core.format.exceptions.FormatException;
import org.truffleruby.core.format.unpack.ArrayResult;
import org.truffleruby.core.format.unpack.UnpackCompiler;
import org.truffleruby.core.inlined.AlwaysInlinedMethodNode;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.numeric.FixnumLowerNode;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.range.RangeNodes;
import org.truffleruby.core.regexp.RubyRegexp;
import org.truffleruby.core.string.ATStringWithEncoding;
import org.truffleruby.core.string.ConvertBytes;
import org.truffleruby.core.string.DoubleConverter;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringGuards;
import org.truffleruby.core.string.StringHelperNodes;
import org.truffleruby.core.string.StringNodesFactory;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.core.string.StringSupport;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.string.TStringBuilder;
import org.truffleruby.core.string.TStringConstants;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.core.support.RubyByteArray;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.arguments.ReadCallerVariablesNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.DeferredRaiseException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.WriteObjectFieldNode;
import org.truffleruby.language.threadlocal.SpecialVariableStorage;
import org.truffleruby.language.yield.CallBlockNode;
import org.truffleruby.utils.Utils;

@CoreModule(value="String", isClass=true)
public abstract class StringNodes {

    @Primitive(name="string_is_character_head?", lowerFixnum={2})
    public static abstract class IsCharacterHeadPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean isCharacterHead(RubyEncoding enc, Object string, int byteOffset, @Cached RubyStringLibrary libString, @Cached IsCharacterHeadNode isCharacterHeadNode) {
            AbstractTruffleString tstring = libString.getTString(this, string);
            return isCharacterHeadNode.execute(enc, tstring, byteOffset);
        }
    }

    @Primitive(name="string_truncate", lowerFixnum={1})
    public static abstract class TruncateNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"newByteLength < 0"})
        RubyString truncateLengthNegative(RubyString string, int newByteLength) {
            throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().argumentError(this.formatNegativeError(newByteLength), this));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"newByteLength >= 0", "newByteLength > byteLength"})
        RubyString truncateLengthTooLong(RubyString string, int newByteLength, @Cached @Cached.Shared RubyStringLibrary libString, @Bind(value="libString.byteLength(this, string)") int byteLength) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError(this.formatTooLongError(newByteLength, string), this));
        }

        @Specialization(guards={"newByteLength >= 0", "newByteLength <= byteLength"})
        RubyString tuncate(RubyString string, int newByteLength, @Cached @Cached.Shared RubyStringLibrary libString, @Cached TruffleString.SubstringByteIndexNode substringNode, @Bind(value="libString.byteLength(this, string)") int byteLength) {
            TruffleString.Encoding tencoding = libString.getTEncoding(this, (Object)string);
            string.setTString((AbstractTruffleString)substringNode.execute(string.tstring, 0, newByteLength, tencoding, true));
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private String formatNegativeError(int count) {
            return StringUtils.format("Invalid byte count: %d is negative", count);
        }

        @CompilerDirectives.TruffleBoundary
        private String formatTooLongError(int count, RubyString string) {
            return StringUtils.format("Invalid byte count: %d exceeds string size of %d bytes", count, string.byteLengthUncached());
        }
    }

    @Primitive(name="string_intern")
    public static abstract class InternNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        ImmutableRubyString internString(RubyString string, @Cached RubyStringLibrary libString, @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayNode) {
            RubyEncoding encoding = libString.getEncoding(this, (Object)string);
            InternalByteArray byteArray = getInternalByteArrayNode.execute(string.tstring, encoding.tencoding);
            return this.getLanguage().getFrozenStringLiteral(byteArray, TStringUtils.hasImmutableInternalByteArray(string.tstring), encoding);
        }
    }

    @Primitive(name="string_interned?")
    public static abstract class IsInternedNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean isInterned(ImmutableRubyString string) {
            return true;
        }

        @Specialization
        boolean isInterned(RubyString string) {
            return false;
        }
    }

    @Primitive(name="string_to_null_terminated_byte_array")
    public static abstract class StringToNullTerminatedByteArrayNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"libString.isRubyString(node, string)"}, limit="1")
        static Object stringToNullTerminatedByteArray(Object string, @Bind(value="this") Node node, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached RubyStringLibrary libString) {
            RubyEncoding encoding = libString.getEncoding(node, string);
            AbstractTruffleString tstring = libString.getTString(node, string);
            int bytesToCopy = tstring.byteLength(encoding.tencoding);
            byte[] bytesWithNull = new byte[bytesToCopy + 1];
            copyToByteArrayNode.execute(tstring, 0, bytesWithNull, 0, bytesToCopy, encoding.tencoding);
            return StringToNullTerminatedByteArrayNode.getContext(node).getEnv().asGuestValue((Object)bytesWithNull);
        }

        @Specialization
        Object emptyString(Nil string) {
            return this.getContext().getEnv().asGuestValue(null);
        }
    }

    @Primitive(name="string_from_bytearray", lowerFixnum={1, 2})
    public static abstract class StringFromByteArrayPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyString stringFromByteArray(RubyByteArray byteArray, int start, int count, RubyEncoding rubyEncoding, @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
            byte[] bytes = byteArray.bytes;
            byte[] array = ArrayUtils.extractRange(bytes, start, start + count);
            return this.createString(fromByteArrayNode, array, rubyEncoding);
        }
    }

    @Primitive(name="string_substring", lowerFixnum={1, 2})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringSubstringPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        public abstract Object execute(Object var1, int var2, int var3);

        @Specialization
        Object stringSubstringGeneric(Object string, int codePointOffset, int codePointLength, @Cached RubyStringLibrary libString, @Bind(value="libString.getTString(this, string)") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding, @Cached StringHelperNodes.NormalizeIndexNode normalizeIndexNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.SubstringNode substringNode, @Cached InlinedConditionProfile negativeIndexProfile, @Cached InlinedConditionProfile tooLargeTotalProfile, @Cached InlinedConditionProfile triviallyOutOfBoundsProfile) {
            int stringCodePointLength = codePointLengthNode.execute(tstring, encoding.tencoding);
            if (triviallyOutOfBoundsProfile.profile((Node)this, codePointLength < 0 || codePointOffset > stringCodePointLength)) {
                return nil;
            }
            int normalizedCodePointOffset = normalizeIndexNode.executeNormalize(this, codePointOffset, stringCodePointLength);
            if (negativeIndexProfile.profile((Node)this, normalizedCodePointOffset < 0)) {
                return nil;
            }
            int normalizedCodePointLength = codePointLength;
            if (tooLargeTotalProfile.profile((Node)this, normalizedCodePointOffset + normalizedCodePointLength > stringCodePointLength)) {
                normalizedCodePointLength = stringCodePointLength - normalizedCodePointOffset;
            }
            return this.createSubString(substringNode, tstring, encoding, normalizedCodePointOffset, normalizedCodePointLength);
        }
    }

    @Primitive(name="string_binary_append")
    public static abstract class StringBinaryAppendNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"libOther.isRubyString(node, other)"}, limit="1")
        static RubyString stringBinaryAppend(RubyString string, Object other, @Bind(value="this") Node node, @Cached RubyStringLibrary libString, @Cached RubyStringLibrary libOther, @Cached TruffleString.ConcatNode concatNode, @Cached TruffleString.ForceEncodingNode forceEncodingNode) {
            if (libString.getEncoding(node, (Object)string) != Encodings.BINARY) {
                throw CompilerDirectives.shouldNotReachHere((String)"LHS String must be BINARY");
            }
            AbstractTruffleString left = string.tstring;
            TruffleString right = forceEncodingNode.execute(libOther.getTString(node, other), libOther.getTEncoding(node, other), Encodings.BINARY.tencoding);
            string.setTString((AbstractTruffleString)concatNode.execute(left, (AbstractTruffleString)right, Encodings.BINARY.tencoding, true), Encodings.BINARY);
            return string;
        }
    }

    @Primitive(name="string_byte_append")
    public static abstract class StringByteAppendPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"libOther.isRubyString(node, other)"}, limit="1")
        static RubyString stringByteAppend(RubyString string, Object other, @Bind(value="this") Node node, @Cached RubyStringLibrary libString, @Cached RubyStringLibrary libOther, @Cached TruffleString.ConcatNode concatNode, @Cached TruffleString.ForceEncodingNode forceEncodingNode) {
            RubyEncoding leftEncoding = libString.getEncoding(node, (Object)string);
            AbstractTruffleString left = string.tstring;
            TruffleString right = forceEncodingNode.execute(libOther.getTString(node, other), libOther.getTEncoding(node, other), leftEncoding.tencoding);
            string.setTString((AbstractTruffleString)concatNode.execute(left, (AbstractTruffleString)right, leftEncoding.tencoding, true), leftEncoding);
            return string;
        }
    }

    @Primitive(name="string_to_inum", lowerFixnum={1})
    public static abstract class StringToInumPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"base == 10"})
        Object base10(Object string, int base, boolean strict, boolean raiseOnError, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared TruffleString.ParseLongNode parseLongNode, @Cached @Cached.Shared InlinedBranchProfile notLazyLongProfile, @Cached @Cached.Shared InlinedBranchProfile exceptionProfile) {
            AbstractTruffleString tstring = libString.getTString(this, string);
            try {
                return parseLongNode.execute(tstring, 10);
            }
            catch (TruffleString.NumberFormatException e) {
                notLazyLongProfile.enter((Node)this);
                RubyEncoding encoding = libString.getEncoding(this, string);
                return this.bytesToInum(tstring, encoding, base, strict, raiseOnError, exceptionProfile);
            }
        }

        @Specialization(guards={"base == 0"})
        Object base0(Object string, int base, boolean strict, boolean raiseOnError, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared TruffleString.ParseLongNode parseLongNode, @Cached TruffleString.CodePointAtByteIndexNode codePointNode, @Cached InlinedConditionProfile notEmptyProfile, @Cached @Cached.Shared InlinedBranchProfile notLazyLongProfile, @Cached @Cached.Shared InlinedBranchProfile exceptionProfile) {
            int second;
            int first;
            AbstractTruffleString tstring = libString.getTString(this, string);
            RubyEncoding enc = libString.getEncoding(this, string);
            TruffleString.Encoding tenc = enc.tencoding;
            int len = tstring.byteLength(tenc);
            if (notEmptyProfile.profile((Node)this, enc.isAsciiCompatible && len >= 1) && ((first = codePointNode.execute(tstring, 0, tenc, TruffleString.ErrorHandling.RETURN_NEGATIVE)) >= 49 && first <= 57 || len >= 2 && (first == 45 || first == 43) && (second = codePointNode.execute(tstring, 1, tenc, TruffleString.ErrorHandling.RETURN_NEGATIVE)) >= 49 && second <= 57)) {
                try {
                    return parseLongNode.execute(tstring, 10);
                }
                catch (TruffleString.NumberFormatException e) {
                    notLazyLongProfile.enter((Node)this);
                }
            }
            RubyEncoding encoding = libString.getEncoding(this, string);
            return this.bytesToInum(tstring, encoding, base, strict, raiseOnError, exceptionProfile);
        }

        @Specialization(guards={"base != 10", "base != 0"})
        Object otherBase(Object string, int base, boolean strict, boolean raiseOnError, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared InlinedBranchProfile exceptionProfile) {
            AbstractTruffleString tstring = libString.getTString(this, string);
            RubyEncoding encoding = libString.getEncoding(this, string);
            return this.bytesToInum(tstring, encoding, base, strict, raiseOnError, exceptionProfile);
        }

        private Object bytesToInum(AbstractTruffleString tstring, RubyEncoding encoding, int base, boolean strict, boolean raiseOnError, InlinedBranchProfile exceptionProfile) {
            try {
                return ConvertBytes.bytesToInum(this.getContext(), this, tstring, encoding, base, strict);
            }
            catch (RaiseException e) {
                exceptionProfile.enter((Node)this);
                if (!raiseOnError) {
                    return nil;
                }
                throw e;
            }
        }
    }

    @Primitive(name="string_splice", lowerFixnum={2, 3})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringSplicePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"spliceByteIndex == 0"})
        Object splicePrepend(RubyString string, Object other, int spliceByteIndex, int byteCountToReplace, RubyEncoding rubyEncoding, @Cached @Cached.Exclusive RubyStringLibrary libString, @Cached @Cached.Exclusive RubyStringLibrary libOther, @Cached @Cached.Exclusive TruffleString.SubstringByteIndexNode prependSubstringNode, @Cached @Cached.Shared TruffleString.ConcatNode concatNode) {
            AbstractTruffleString original = string.tstring;
            TruffleString.Encoding originalTEncoding = libString.getTEncoding(this, (Object)string);
            AbstractTruffleString left = libOther.getTString(this, other);
            TruffleString right = prependSubstringNode.execute(original, byteCountToReplace, original.byteLength(originalTEncoding) - byteCountToReplace, originalTEncoding, true);
            TruffleString prependResult = concatNode.execute(left, (AbstractTruffleString)right, rubyEncoding.tencoding, true);
            string.setTString((AbstractTruffleString)prependResult, rubyEncoding);
            return string;
        }

        @Specialization(guards={"spliceByteIndex == byteLength"}, limit="1")
        static Object spliceAppend(RubyString string, Object other, int spliceByteIndex, int byteCountToReplace, RubyEncoding rubyEncoding, @Bind(value="this") Node node, @Cached @Cached.Exclusive RubyStringLibrary libString, @Cached @Cached.Exclusive RubyStringLibrary libOther, @Cached @Cached.Shared TruffleString.ConcatNode concatNode, @Bind(value="libString.byteLength(node, string)") int byteLength) {
            AbstractTruffleString left = string.tstring;
            AbstractTruffleString right = libOther.getTString(node, other);
            TruffleString concatResult = concatNode.execute(left, right, rubyEncoding.tencoding, true);
            string.setTString((AbstractTruffleString)concatResult, rubyEncoding);
            return string;
        }

        @Specialization(guards={"spliceByteIndex != 0", "spliceByteIndex != byteLength"}, limit="1")
        static RubyString splice(RubyString string, Object other, int spliceByteIndex, int byteCountToReplace, RubyEncoding rubyEncoding, @Cached @Cached.Exclusive RubyStringLibrary libString, @Cached @Cached.Exclusive RubyStringLibrary libOther, @Cached InlinedConditionProfile insertStringIsEmptyProfile, @Cached InlinedConditionProfile splitRightIsEmptyProfile, @Cached @Cached.Exclusive TruffleString.SubstringByteIndexNode leftSubstringNode, @Cached @Cached.Exclusive TruffleString.SubstringByteIndexNode rightSubstringNode, @Cached @Cached.Shared TruffleString.ConcatNode concatNode, @Cached TruffleString.ForceEncodingNode forceEncodingNode, @Bind(value="libString.byteLength(this, string)") int byteLength, @Bind(value="this") Node node) {
            TruffleString.Encoding sourceTEncoding = libString.getTEncoding(node, (Object)string);
            TruffleString.Encoding resultTEncoding = rubyEncoding.tencoding;
            AbstractTruffleString source = string.tstring;
            AbstractTruffleString insert = libOther.getTString(node, other);
            int rightSideStartingIndex = spliceByteIndex + byteCountToReplace;
            TruffleString splitLeft = leftSubstringNode.execute(source, 0, spliceByteIndex, sourceTEncoding, true);
            TruffleString splitRight = rightSubstringNode.execute(source, rightSideStartingIndex, source.byteLength(sourceTEncoding) - rightSideStartingIndex, sourceTEncoding, true);
            TruffleString joinedLeft = insertStringIsEmptyProfile.profile(node, insert.isEmpty()) ? forceEncodingNode.execute((AbstractTruffleString)splitLeft, sourceTEncoding, resultTEncoding) : concatNode.execute((AbstractTruffleString)splitLeft, insert, resultTEncoding, true);
            TruffleString joinedRight = splitRightIsEmptyProfile.profile(node, splitRight.isEmpty()) ? joinedLeft : concatNode.execute((AbstractTruffleString)joinedLeft, (AbstractTruffleString)splitRight, resultTEncoding, true);
            string.setTString((AbstractTruffleString)joinedRight, rubyEncoding);
            return string;
        }
    }

    @Primitive(name="find_string_reverse", lowerFixnum={2})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringRindexPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object stringRindex(Object rubyString, Object rubyPattern, int byteOffset, @Cached RubyStringLibrary libPattern, @Cached RubyStringLibrary libString, @Cached EncodingNodes.CheckStringEncodingNode checkEncodingNode, @Cached TruffleString.LastByteIndexOfStringNode lastByteIndexOfStringNode, @Cached InlinedBranchProfile startOutOfBoundsProfile, @Cached InlinedBranchProfile startTooCloseToEndProfile, @Cached InlinedBranchProfile noMatchProfile) {
            int result;
            assert (byteOffset >= 0);
            AbstractTruffleString string = libString.getTString(this, rubyString);
            RubyEncoding stringEncoding = libString.getEncoding(this, rubyString);
            int stringByteLength = string.byteLength(stringEncoding.tencoding);
            AbstractTruffleString pattern = libPattern.getTString(this, rubyPattern);
            RubyEncoding patternEncoding = libPattern.getEncoding(this, rubyPattern);
            int patternByteLength = pattern.byteLength(patternEncoding.tencoding);
            RubyEncoding compatibleEncoding = checkEncodingNode.execute(this, string, stringEncoding, pattern, patternEncoding);
            int normalizedStart = byteOffset;
            if (normalizedStart >= stringByteLength) {
                startOutOfBoundsProfile.enter((Node)this);
                normalizedStart = stringByteLength - 1;
            }
            if (stringByteLength - normalizedStart < patternByteLength) {
                startTooCloseToEndProfile.enter((Node)this);
                normalizedStart = stringByteLength - patternByteLength;
            }
            if ((result = lastByteIndexOfStringNode.execute(string, pattern, normalizedStart + patternByteLength, 0, compatibleEncoding.tencoding)) < 0) {
                noMatchProfile.enter((Node)this);
                return nil;
            }
            return result;
        }
    }

    @Primitive(name="string_previous_byte_index", lowerFixnum={1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringPreviousByteIndexNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"index < 0"})
        Object negativeIndex(Object string, int index) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("negative index given", this));
        }

        @Specialization(guards={"index == 0"})
        Object zeroIndex(Object string, int index) {
            return nil;
        }

        @Specialization(guards={"index > 0", "isSingleByteOptimizable(this, strings.getTString(this, string), strings.getEncoding(this, string), singleByteOptimizableNode)"})
        int singleByteOptimizable(Object string, int index, @Cached @Cached.Shared RubyStringLibrary strings, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode) {
            return index - 1;
        }

        @Specialization(guards={"index > 0", "!isSingleByteOptimizable(this, strings.getTString(this, string), strings.getEncoding(this, string), singleByteOptimizableNode)", "isFixedWidthEncoding(strings.getEncoding(this, string))"})
        int fixedWidthEncoding(Object string, int index, @Cached @Cached.Shared RubyStringLibrary strings, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached InlinedConditionProfile firstCharacterProfile) {
            Encoding encoding = strings.getEncoding((Node)this, (Object)string).jcoding;
            if (firstCharacterProfile.profile((Node)this, index < encoding.maxLength())) {
                return 0;
            }
            return (index / encoding.maxLength() - 1) * encoding.maxLength();
        }

        @Specialization(guards={"index > 0", "!isSingleByteOptimizable(this, strings.getTString(this, string), strings.getEncoding(this, string), singleByteOptimizableNode)", "!isFixedWidthEncoding(strings.getEncoding(this, string))"})
        @CompilerDirectives.TruffleBoundary
        Object other(Object string, int index, @Cached @Cached.Shared RubyStringLibrary strings, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached TruffleString.GetInternalByteArrayNode byteArrayNode) {
            RubyEncoding encoding = strings.getEncoding(this, string);
            InternalByteArray byteArray = byteArrayNode.execute(strings.getTString(this, string), encoding.tencoding);
            int p = byteArray.getOffset();
            int end = byteArray.getEnd();
            int b = encoding.jcoding.prevCharHead(byteArray.getArray(), p, p + index, end);
            if (b == -1) {
                return nil;
            }
            return b - p;
        }
    }

    @Primitive(name="string_byte_reverse_index", lowerFixnum={3})
    public static abstract class StringByteReverseIndexNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object stringByteIndex(Object rubyString, Object rubyPattern, RubyEncoding compatibleEncoding, int byteOffset, @Cached RubyStringLibrary libString, @Cached RubyStringLibrary libPattern, @Cached TruffleString.LastByteIndexOfStringNode lastByteIndexOfStringNode, @Cached InlinedConditionProfile indexOutOfBoundsProfile, @Cached InlinedConditionProfile foundProfile) {
            assert (byteOffset >= 0);
            AbstractTruffleString string = libString.getTString(this, rubyString);
            int stringByteLength = libString.byteLength(this, rubyString);
            AbstractTruffleString pattern = libPattern.getTString(this, rubyPattern);
            int patternByteLength = libPattern.byteLength(this, rubyPattern);
            if (indexOutOfBoundsProfile.profile((Node)this, patternByteLength > stringByteLength)) {
                return nil;
            }
            int found = lastByteIndexOfStringNode.execute(string, pattern, byteOffset, 0, compatibleEncoding.tencoding);
            if (foundProfile.profile((Node)this, found >= 0)) {
                return found;
            }
            return nil;
        }
    }

    @Primitive(name="string_byte_index", lowerFixnum={3})
    public static abstract class StringByteIndexNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object stringByteIndex(Object rubyString, Object rubyPattern, RubyEncoding compatibleEncoding, int byteOffset, @Cached RubyStringLibrary libString, @Cached RubyStringLibrary libPattern, @Cached TruffleString.ByteIndexOfStringNode byteIndexOfStringNode, @Cached InlinedConditionProfile indexOutOfBoundsProfile, @Cached InlinedConditionProfile foundProfile) {
            assert (byteOffset >= 0);
            AbstractTruffleString string = libString.getTString(this, rubyString);
            int stringByteLength = libString.byteLength(this, rubyString);
            AbstractTruffleString pattern = libPattern.getTString(this, rubyPattern);
            int patternByteLength = libPattern.byteLength(this, rubyPattern);
            if (indexOutOfBoundsProfile.profile((Node)this, byteOffset + patternByteLength > stringByteLength)) {
                return nil;
            }
            int found = byteIndexOfStringNode.execute(string, pattern, byteOffset, stringByteLength, compatibleEncoding.tencoding);
            if (foundProfile.profile((Node)this, found >= 0)) {
                return found;
            }
            return nil;
        }
    }

    @Primitive(name="string_character_index", lowerFixnum={3})
    public static abstract class StringCharacterIndexNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"singleByteOptimizableNode.execute(this, string, stringEncoding)"})
        Object singleByteOptimizable(Object rubyString, Object rubyPattern, RubyEncoding compatibleEncoding, int codePointOffset, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared RubyStringLibrary libPattern, @Bind(value="libString.getTString(this, rubyString)") AbstractTruffleString string, @Bind(value="libString.getEncoding(this, rubyString)") RubyEncoding stringEncoding, @Bind(value="libPattern.getTString(this, rubyPattern)") AbstractTruffleString pattern, @Bind(value="libPattern.getEncoding(this, rubyPattern)") RubyEncoding patternEncoding, @Cached TruffleString.ByteIndexOfStringNode byteIndexOfStringNode, @Cached @Cached.Shared InlinedConditionProfile foundProfile) {
            assert (codePointOffset >= 0);
            int stringByteLength = string.byteLength(stringEncoding.tencoding);
            assert (codePointOffset + pattern.byteLength(patternEncoding.tencoding) <= stringByteLength) : "already checked in the caller, String#index";
            int found = byteIndexOfStringNode.execute(string, pattern, codePointOffset, stringByteLength, compatibleEncoding.tencoding);
            if (foundProfile.profile((Node)this, found >= 0)) {
                return found;
            }
            return nil;
        }

        @Specialization(guards={"!singleByteOptimizableNode.execute(this, string, stringEncoding)"})
        Object multiByte(Object rubyString, Object rubyPattern, RubyEncoding compatibleEncoding, int codePointOffset, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared RubyStringLibrary libPattern, @Bind(value="libString.getTString(this, rubyString)") AbstractTruffleString string, @Bind(value="libString.getEncoding(this, rubyString)") RubyEncoding stringEncoding, @Bind(value="libPattern.getTString(this, rubyPattern)") AbstractTruffleString pattern, @Bind(value="libPattern.getEncoding(this, rubyPattern)") RubyEncoding patternEncoding, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfStringNode indexOfStringNode, @Cached @Cached.Shared InlinedConditionProfile foundProfile) {
            assert (codePointOffset >= 0);
            assert (codePointOffset + pattern.codePointLengthUncached(patternEncoding.tencoding) <= string.codePointLengthUncached(stringEncoding.tencoding)) : "already checked in the caller, String#index";
            int stringCodePointLength = codePointLengthNode.execute(string, stringEncoding.tencoding);
            int found = indexOfStringNode.execute(string, pattern, codePointOffset, stringCodePointLength, compatibleEncoding.tencoding);
            if (foundProfile.profile((Node)this, found >= 0)) {
                return found;
            }
            return nil;
        }
    }

    @Primitive(name="character_index_to_byte_index", lowerFixnum={1})
    public static abstract class StringByteIndexFromCharIndexNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object byteIndexFromCharIndex(Object string, int characterIndex, @Cached TruffleString.CodePointIndexToByteIndexNode codePointIndexToByteIndexNode, @Cached RubyStringLibrary libString) {
            return codePointIndexToByteIndexNode.execute(libString.getTString(this, string), 0, characterIndex, libString.getTEncoding(this, string));
        }
    }

    @Primitive(name="byte_index_to_character_index", lowerFixnum={1})
    public static abstract class StringByteCharacterIndexNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int byteIndexToCodePointIndex(Object string, int byteIndex, @Cached RubyStringLibrary libString, @Cached TruffleString.ByteIndexToCodePointIndexNode byteIndexToCodePointIndexNode, @Bind(value="libString.getTString(this, string)") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding) {
            return byteIndexToCodePointIndexNode.execute(tstring, 0, byteIndex, encoding.tencoding);
        }
    }

    @Primitive(name="find_string", lowerFixnum={2})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringIndexPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"patternTString.isEmpty()"}, limit="1")
        static int stringIndexEmptyPattern(Object rubyString, Object rubyPattern, int byteOffset, @Bind(value="this") Node node, @Cached @Cached.Exclusive RubyStringLibrary libPattern, @Bind(value="libPattern.getTString(node, rubyPattern)") AbstractTruffleString patternTString) {
            assert (byteOffset >= 0);
            return byteOffset;
        }

        @Specialization(guards={"!patternTString.isEmpty()"}, limit="1")
        static Object findStringByteIndex(Object rubyString, Object rubyPattern, int byteOffset, @Bind(value="this") Node node, @Cached @Cached.Exclusive RubyStringLibrary libString, @Cached @Cached.Exclusive RubyStringLibrary libPattern, @Cached EncodingNodes.CheckStringEncodingNode checkEncodingNode, @Cached TruffleString.ByteIndexOfStringNode indexOfStringNode, @Cached InlinedConditionProfile offsetTooLargeProfile, @Cached InlinedConditionProfile notFoundProfile, @Bind(value="libPattern.getTString(node, rubyPattern)") AbstractTruffleString patternTString) {
            assert (byteOffset >= 0);
            AbstractTruffleString string = libString.getTString(node, rubyString);
            RubyEncoding encoding = libString.getEncoding(node, rubyString);
            RubyEncoding patternEncoding = libPattern.getEncoding(node, rubyPattern);
            RubyEncoding compatibleEncoding = checkEncodingNode.execute(node, string, encoding, patternTString, patternEncoding);
            int stringByteLength = string.byteLength(encoding.tencoding);
            if (offsetTooLargeProfile.profile(node, byteOffset >= stringByteLength)) {
                return nil;
            }
            int patternByteIndex = indexOfStringNode.execute(string, patternTString, byteOffset, stringByteLength, compatibleEncoding.tencoding);
            if (notFoundProfile.profile(node, patternByteIndex < 0)) {
                return nil;
            }
            return patternByteIndex;
        }
    }

    @Primitive(name="string_to_f")
    public static abstract class StringToFPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object stringToF(Object string, @Cached RubyStringLibrary strings) {
            AbstractTruffleString tstring = strings.getTString(this, string);
            RubyEncoding encoding = strings.getEncoding(this, string);
            if (tstring.isEmpty()) {
                return nil;
            }
            String javaString = RubyGuards.getJavaString(string);
            if (javaString.startsWith("0x")) {
                try {
                    return Double.parseDouble(javaString);
                }
                catch (NumberFormatException e) {
                    Object result = ConvertBytes.bytesToInum(this.getContext(), this, tstring, encoding, 16, true);
                    if (result instanceof Integer) {
                        return ((Integer)result).doubleValue();
                    }
                    if (result instanceof Long) {
                        return ((Long)result).doubleValue();
                    }
                    if (result instanceof Double) {
                        return result;
                    }
                    return nil;
                }
            }
            try {
                return new DoubleConverter().parse(tstring, encoding, true, true);
            }
            catch (NumberFormatException e) {
                return nil;
            }
        }
    }

    @Primitive(name="string_from_codepoint", lowerFixnum={0})
    public static abstract class StringFromCodepointPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isSimple(code, encoding)"})
        RubyString stringFromCodepointSimple(int code, RubyEncoding encoding, @Cached InlinedConditionProfile isUTF8Profile, @Cached InlinedConditionProfile isUSAsciiProfile, @Cached InlinedConditionProfile isAscii8BitProfile, @Cached @Cached.Exclusive TruffleString.FromCodePointNode fromCodePointNode) {
            TruffleString tstring;
            if (isUTF8Profile.profile((Node)this, encoding == Encodings.UTF_8)) {
                tstring = TStringConstants.UTF8_SINGLE_BYTE[code];
            } else if (isUSAsciiProfile.profile((Node)this, encoding == Encodings.US_ASCII)) {
                tstring = TStringConstants.US_ASCII_SINGLE_BYTE[code];
            } else if (isAscii8BitProfile.profile((Node)this, encoding == Encodings.BINARY)) {
                tstring = TStringConstants.BINARY_SINGLE_BYTE[code];
            } else {
                tstring = fromCodePointNode.execute(code, encoding.tencoding, false);
                assert (tstring != null);
            }
            return this.createString(tstring, encoding);
        }

        @Specialization(guards={"!isSimple(code, encoding)"})
        RubyString stringFromCodepoint(int code, RubyEncoding encoding, @Cached @Cached.Shared TruffleString.FromCodePointNode fromCodePointNode, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            TruffleString tstring = fromCodePointNode.execute(code, encoding.tencoding, false);
            if (tstring == null) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().rangeError(code, (Node)this));
            }
            return this.createString(tstring, encoding);
        }

        @Specialization(guards={"isCodepoint(code)"})
        RubyString stringFromLongCodepoint(long code, RubyEncoding encoding, @Cached @Cached.Shared TruffleString.FromCodePointNode fromCodePointNode, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            TruffleString tstring = fromCodePointNode.execute((int)code, encoding.tencoding, false);
            if (tstring == null) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().rangeError(code, (Node)this));
            }
            return this.createString(tstring, encoding);
        }

        @Specialization(guards={"!isCodepoint(code)"})
        RubyString tooBig(long code, RubyEncoding encoding) {
            throw new RaiseException(this.getContext(), this.coreExceptions().rangeError(code, (Node)this));
        }

        protected boolean isCodepoint(long code) {
            return code >= 0L && code < 0x100000000L;
        }

        protected boolean isSimple(int codepoint, RubyEncoding encoding) {
            return encoding.isAsciiCompatible && codepoint >= 0 && codepoint < 128 || encoding == Encodings.BINARY && codepoint >= 0 && codepoint <= 255;
        }
    }

    @Primitive(name="string_find_character", lowerFixnum={1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringFindCharacterNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"offset < 0"})
        Object stringFindCharacterNegativeOffset(Object string, int offset) {
            return nil;
        }

        @Specialization(guards={"offsetTooLarge(strings.byteLength(this, string), offset)"})
        Object stringFindCharacterOffsetTooLarge(Object string, int offset, @Cached @Cached.Shared RubyStringLibrary strings) {
            return nil;
        }

        @Specialization(guards={"offset >= 0", "!offsetTooLarge(strings.byteLength(this, string), offset)", "isSingleByteOptimizable(this, strings.getTString(this, string), strings.getEncoding(this, string), singleByteOptimizableNode)"})
        Object stringFindCharacterSingleByte(Object string, int offset, @Cached @Cached.Shared RubyStringLibrary strings, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached @Cached.Exclusive TruffleString.SubstringByteIndexNode substringNode) {
            return this.createSubString(substringNode, strings, string, offset, 1);
        }

        @Specialization(guards={"offset >= 0", "!offsetTooLarge(strings.byteLength(this, string), offset)", "!isSingleByteOptimizable(this, strings.getTString(this, string), strings.getEncoding(this, string), singleByteOptimizableNode)"})
        Object stringFindCharacter(Object string, int offset, @Cached @Cached.Shared RubyStringLibrary strings, @Cached TruffleString.ByteLengthOfCodePointNode byteLengthOfCodePointNode, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached @Cached.Exclusive TruffleString.SubstringByteIndexNode substringNode) {
            AbstractTruffleString tstring = strings.getTString(this, string);
            TruffleString.Encoding tencoding = strings.getTEncoding(this, string);
            int clen = byteLengthOfCodePointNode.execute(tstring, offset, tencoding, TruffleString.ErrorHandling.BEST_EFFORT);
            return this.createSubString(substringNode, strings, string, offset, clen);
        }

        protected static boolean offsetTooLarge(int byteLength, int offset) {
            return offset >= byteLength;
        }
    }

    @Primitive(name="string_escape")
    public static abstract class StringEscapePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyString string_escape(Object string, @Cached RubyStringLibrary strings, @Cached TruffleString.GetInternalByteArrayNode byteArrayNode) {
            AbstractTruffleString tstring = strings.getTString(this, string);
            RubyEncoding encoding = strings.getEncoding(this, string);
            InternalByteArray byteArray = byteArrayNode.execute(tstring, encoding.tencoding);
            TruffleString escaped = StringEscapePrimitiveNode.rbStrEscape(tstring, encoding, byteArray);
            return this.createString(escaped, Encodings.US_ASCII);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString rbStrEscape(AbstractTruffleString tstring, RubyEncoding encoding, InternalByteArray byteArray) {
            TruffleString.Encoding tencoding = encoding.tencoding;
            TStringBuilder result = new TStringBuilder();
            boolean unicode_p = encoding.isUnicode;
            boolean asciicompat = encoding.isAsciiCompatible;
            TruffleStringIterator iterator = TruffleString.CreateCodePointIteratorNode.getUncached().execute(tstring, tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
            while (iterator.hasNext()) {
                int p = iterator.getByteIndex();
                int c = iterator.nextUncached();
                if (c == -1) {
                    int n = iterator.getByteIndex() - p;
                    for (int i = 0; i < n; ++i) {
                        result.append(StringUtils.formatASCIIBytes("\\x%02X", byteArray.get(p + i) & 0xFF));
                    }
                    continue;
                }
                int cc = switch (c) {
                    case 10 -> 110;
                    case 13 -> 114;
                    case 9 -> 116;
                    case 12 -> 102;
                    case 11 -> 118;
                    case 8 -> 98;
                    case 7 -> 97;
                    case 27 -> 101;
                    default -> 0;
                };
                if (cc != 0) {
                    result.append(92);
                    result.append((byte)cc);
                    continue;
                }
                if (asciicompat && Encoding.isAscii((int)c) && c < 127 && c > 31) {
                    result.append(byteArray, p, p - iterator.getByteIndex());
                    continue;
                }
                if (unicode_p && ((long)c & 0xFFFFFFFFL) < 127L && Encoding.isAscii((int)c) && ASCIIEncoding.INSTANCE.isPrint(c)) {
                    result.append(StringUtils.formatASCIIBytes("%c", Character.valueOf((char)((long)c & 0xFFFFFFFFL))));
                    continue;
                }
                result.append(StringUtils.formatASCIIBytes(StringEscapePrimitiveNode.escapedCharFormat(c, unicode_p), (long)c & 0xFFFFFFFFL));
            }
            result.setEncoding(Encodings.US_ASCII);
            return result.toTString();
        }

        private static String escapedCharFormat(int c, boolean isUnicode) {
            String format;
            if (isUnicode) {
                if (((long)c & 0xFFFFFFFFL) < 127L && Encoding.isAscii((int)c) && ASCIIEncoding.INSTANCE.isPrint(c)) {
                    throw new UnsupportedOperationException();
                }
                format = c < 65536 ? "\\u%04X" : "\\u{%X}";
            } else {
                format = ((long)c & 0xFFFFFFFFL) < 256L ? "\\x%02X" : "\\x{%X}";
            }
            return format;
        }
    }

    @Primitive(name="string_chr_at", lowerFixnum={1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringChrAtPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"indexOutOfBounds(strings.byteLength(node, string), byteIndex)"}, limit="1")
        static Object stringChrAtOutOfBounds(Object string, int byteIndex, @Cached @Cached.Exclusive RubyStringLibrary strings, @Bind(value="this") Node node) {
            return nil;
        }

        @Specialization(guards={"!indexOutOfBounds(tstring.byteLength(encoding.tencoding), byteIndex)", "is7Bit(tstring, encoding, codeRangeNode)"}, limit="1")
        static Object stringChrAtSingleByte(Object string, int byteIndex, @Bind(value="this") Node node, @Cached @Cached.Exclusive RubyStringLibrary strings, @Cached @Cached.Shared TruffleString.GetByteCodeRangeNode codeRangeNode, @Cached @Cached.Exclusive TruffleString.SubstringByteIndexNode substringByteIndexNode, @Bind(value="strings.getTString(node, string)") AbstractTruffleString tstring, @Bind(value="strings.getEncoding(node, string)") RubyEncoding encoding) {
            return StringChrAtPrimitiveNode.createSubString(node, substringByteIndexNode, tstring, encoding, byteIndex, 1);
        }

        @Specialization(guards={"!indexOutOfBounds(originalTString.byteLength(originalEncoding.tencoding), byteIndex)", "!is7Bit(originalTString, originalEncoding, codeRangeNode)"}, limit="1")
        static Object stringChrAt(Object string, int byteIndex, @Bind(value="this") Node node, @Cached @Cached.Exclusive RubyStringLibrary strings, @Cached @Cached.Shared TruffleString.GetByteCodeRangeNode codeRangeNode, @Cached EncodingNodes.GetActualEncodingNode getActualEncodingNode, @Cached @Cached.Exclusive TruffleString.SubstringByteIndexNode substringByteIndexNode, @Cached TruffleString.ForceEncodingNode forceEncodingNode, @Cached TruffleString.ByteLengthOfCodePointNode byteLengthOfCodePointNode, @Cached InlinedConditionProfile brokenProfile, @Bind(value="strings.getTString(node, string)") AbstractTruffleString originalTString, @Bind(value="strings.getEncoding(node, string)") RubyEncoding originalEncoding) {
            RubyEncoding actualEncoding = getActualEncodingNode.execute(node, originalTString, originalEncoding);
            TruffleString tstring = forceEncodingNode.execute(originalTString, originalEncoding.tencoding, actualEncoding.tencoding);
            int clen = byteLengthOfCodePointNode.execute((AbstractTruffleString)tstring, byteIndex, actualEncoding.tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
            if (brokenProfile.profile(node, !StringSupport.MBCLEN_CHARFOUND_P(clen))) {
                return nil;
            }
            assert (byteIndex + clen <= tstring.byteLength(actualEncoding.tencoding));
            return StringChrAtPrimitiveNode.createSubString(node, substringByteIndexNode, (AbstractTruffleString)tstring, actualEncoding, byteIndex, clen);
        }

        protected static boolean indexOutOfBounds(int byteLength, int byteIndex) {
            return byteIndex < 0 || byteIndex >= byteLength;
        }
    }

    @Primitive(name="string_byte_substring", lowerFixnum={1, 2})
    public static abstract class StringByteSubstringPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object stringByteSubstring(Object string, int index, NotProvided length, @Cached @Cached.Exclusive InlinedConditionProfile indexOutOfBoundsProfile, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared TruffleString.SubstringByteIndexNode substringNode, @Cached @Cached.Shared StringHelperNodes.NormalizeIndexNode normalizeIndexNode) {
            AbstractTruffleString tString = libString.getTString(this, string);
            RubyEncoding encoding = libString.getEncoding(this, string);
            int stringByteLength = tString.byteLength(encoding.tencoding);
            int normalizedIndex = normalizeIndexNode.executeNormalize(this, index, stringByteLength);
            if (indexOutOfBoundsProfile.profile((Node)this, normalizedIndex < 0 || normalizedIndex >= stringByteLength)) {
                return nil;
            }
            return this.createSubString(substringNode, tString, encoding, normalizedIndex, 1);
        }

        @Specialization
        Object stringByteSubstring(Object string, int index, int length, @Cached @Cached.Exclusive InlinedConditionProfile negativeLengthProfile, @Cached @Cached.Exclusive InlinedConditionProfile indexOutOfBoundsProfile, @Cached @Cached.Exclusive InlinedConditionProfile lengthTooLongProfile, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared TruffleString.SubstringByteIndexNode substringNode, @Cached @Cached.Shared StringHelperNodes.NormalizeIndexNode normalizeIndexNode) {
            if (negativeLengthProfile.profile((Node)this, length < 0)) {
                return nil;
            }
            AbstractTruffleString tString = libString.getTString(this, string);
            RubyEncoding encoding = libString.getEncoding(this, string);
            int stringByteLength = tString.byteLength(encoding.tencoding);
            int normalizedIndex = normalizeIndexNode.executeNormalize(this, index, stringByteLength);
            if (indexOutOfBoundsProfile.profile((Node)this, normalizedIndex < 0 || normalizedIndex > stringByteLength)) {
                return nil;
            }
            if (lengthTooLongProfile.profile((Node)this, normalizedIndex + length > stringByteLength)) {
                length = stringByteLength - normalizedIndex;
            }
            return this.createSubString(substringNode, tString, encoding, normalizedIndex, length);
        }

        @Fallback
        Object stringByteSubstring(Object string, Object range, Object length) {
            return FAILURE;
        }
    }

    @Primitive(name="string_awk_split", lowerFixnum={1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringAwkSplitPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        TruffleString.GetByteCodeRangeNode codeRangeNode = TruffleString.GetByteCodeRangeNode.create();
        private static final int SUBSTRING_CREATED = -1;
        private static final int DEFAULT_SPLIT_VALUES_SIZE = 10;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"is7Bit(tstring, encoding, codeRangeNode)"}, limit="1")
        static Object stringAwkSplitAsciiOnly(Object string, int limit, Object block, @Bind(value="this") Node node, @Cached @Cached.Exclusive RubyStringLibrary strings, @Cached @Cached.Exclusive InlinedConditionProfile executeBlockProfile, @Cached @Cached.Exclusive InlinedConditionProfile growArrayProfile, @Cached @Cached.Exclusive InlinedConditionProfile trailingSubstringProfile, @Cached @Cached.Exclusive InlinedConditionProfile trailingEmptyStringProfile, @Cached TruffleString.MaterializeNode materializeNode, @Cached TruffleString.ReadByteNode readByteNode, @Cached @Cached.Exclusive CallBlockNode yieldNode, @Cached @Cached.Exclusive TruffleString.SubstringByteIndexNode substringNode, @Cached @Cached.Exclusive LoopConditionProfile loopProfile, @Bind(value="strings.getTString(node, string)") AbstractTruffleString tstring, @Bind(value="strings.getEncoding(node, string)") RubyEncoding encoding) {
            RubyString substring;
            int retSize = limit > 0 && limit < 10 ? limit : 10;
            Object[] ret = new Object[retSize];
            int storeIndex = 0;
            int byteLength = tstring.byteLength(encoding.tencoding);
            materializeNode.execute(tstring, encoding.tencoding);
            int substringStart = 0;
            boolean findingSubstringEnd = false;
            int i = 0;
            try {
                while (loopProfile.inject(i < byteLength)) {
                    if (StringSupport.isAsciiSpace(readByteNode.execute(tstring, i, encoding.tencoding))) {
                        if (findingSubstringEnd) {
                            findingSubstringEnd = false;
                            substring = StringAwkSplitPrimitiveNode.createSubString(node, substringNode, tstring, encoding, substringStart, i - substringStart);
                            ret = StringAwkSplitPrimitiveNode.addSubstring(node, yieldNode, ret, storeIndex++, substring, block, executeBlockProfile, growArrayProfile);
                            substringStart = -1;
                        }
                    } else if (!findingSubstringEnd) {
                        substringStart = i;
                        findingSubstringEnd = true;
                        if (storeIndex == limit - 1) {
                            break;
                        }
                    }
                    TruffleSafepoint.poll((Node)node);
                    ++i;
                }
            }
            finally {
                StringAwkSplitPrimitiveNode.profileAndReportLoopCount(node, loopProfile, i);
            }
            if (trailingSubstringProfile.profile(node, findingSubstringEnd)) {
                substring = StringAwkSplitPrimitiveNode.createSubString(node, substringNode, tstring, encoding, substringStart, byteLength - substringStart);
                ret = StringAwkSplitPrimitiveNode.addSubstring(node, yieldNode, ret, storeIndex++, substring, block, executeBlockProfile, growArrayProfile);
            }
            if (trailingEmptyStringProfile.profile(node, (limit < 0 || storeIndex < limit) && StringSupport.isAsciiSpace(readByteNode.execute(tstring, byteLength - 1, encoding.tencoding)))) {
                substring = StringAwkSplitPrimitiveNode.createSubString(node, substringNode, tstring, encoding, byteLength - 1, 0);
                ret = StringAwkSplitPrimitiveNode.addSubstring(node, yieldNode, ret, storeIndex++, substring, block, executeBlockProfile, growArrayProfile);
            }
            if (block == nil) {
                return StringAwkSplitPrimitiveNode.createArray(node, ret, storeIndex);
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isValid(tstring, encoding, codeRangeNode)"}, limit="1")
        static Object stringAwkSplit(Object string, int limit, Object block, @Bind(value="this") Node node, @Cached @Cached.Exclusive RubyStringLibrary strings, @Cached @Cached.Exclusive InlinedConditionProfile executeBlockProfile, @Cached @Cached.Exclusive InlinedConditionProfile growArrayProfile, @Cached @Cached.Exclusive InlinedConditionProfile trailingSubstringProfile, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached @Cached.Exclusive TruffleString.SubstringByteIndexNode substringNode, @Cached @Cached.Exclusive InlinedLoopConditionProfile loopProfile, @Cached @Cached.Exclusive CallBlockNode yieldNode, @Bind(value="strings.getTString(node, string)") AbstractTruffleString tstring, @Bind(value="strings.getEncoding(node, string)") RubyEncoding encoding) {
            int retSize = limit > 0 && limit < 10 ? limit : 10;
            Object[] ret = new Object[retSize];
            int storeIndex = 0;
            boolean limitPositive = limit > 0;
            int i = limit > 0 ? 1 : 0;
            TruffleString.Encoding tencoding = encoding.tencoding;
            int len = tstring.byteLength(tencoding);
            TruffleStringIterator iterator = createCodePointIteratorNode.execute(tstring, tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
            boolean skip = true;
            int e = 0;
            int b = 0;
            int iterations = 0;
            try {
                while (loopProfile.inject(node, iterator.hasNext())) {
                    int c = nextNode.execute(iterator);
                    int p = iterator.getByteIndex();
                    ++iterations;
                    if (skip) {
                        if (StringSupport.isAsciiSpace(c)) {
                            b = p;
                            continue;
                        }
                        e = p;
                        skip = false;
                        if (!limitPositive || limit > i) continue;
                        break;
                    }
                    if (StringSupport.isAsciiSpace(c)) {
                        RubyString substring = StringAwkSplitPrimitiveNode.createSubString(node, substringNode, tstring, encoding, b, e - b);
                        ret = StringAwkSplitPrimitiveNode.addSubstring(node, yieldNode, ret, storeIndex++, substring, block, executeBlockProfile, growArrayProfile);
                        skip = true;
                        b = p;
                        if (!limitPositive) continue;
                        ++i;
                        continue;
                    }
                    e = p;
                }
            }
            finally {
                StringAwkSplitPrimitiveNode.profileAndReportLoopCount(node, loopProfile, iterations);
            }
            if (trailingSubstringProfile.profile(node, len > 0 && (limitPositive || len > b || limit < 0))) {
                RubyString substring = StringAwkSplitPrimitiveNode.createSubString(node, substringNode, tstring, encoding, b, len - b);
                ret = StringAwkSplitPrimitiveNode.addSubstring(node, yieldNode, ret, storeIndex++, substring, block, executeBlockProfile, growArrayProfile);
            }
            if (block == nil) {
                return StringAwkSplitPrimitiveNode.createArray(node, ret, storeIndex);
            }
            return string;
        }

        @Specialization(guards={"isBrokenCodeRange(tstring, encoding, codeRangeNode)"}, limit="1")
        static Object broken(Object string, int limit, Object block, @Bind(value="this") Node node, @Cached @Cached.Exclusive RubyStringLibrary strings, @Bind(value="strings.getTString(node, string)") AbstractTruffleString tstring, @Bind(value="strings.getEncoding(node, string)") RubyEncoding encoding) {
            throw new RaiseException(StringAwkSplitPrimitiveNode.getContext(node), StringAwkSplitPrimitiveNode.coreExceptions(node).argumentErrorInvalidByteSequence(encoding, node));
        }

        private static Object[] addSubstring(Node node, CallBlockNode yieldNode, Object[] store, int index, RubyString substring, Object block, InlinedConditionProfile executeBlockProfile, InlinedConditionProfile growArrayProfile) {
            if (executeBlockProfile.profile(node, block != nil)) {
                yieldNode.yield(node, (RubyProc)block, new Object[]{substring});
            } else if (growArrayProfile.profile(node, index < store.length)) {
                store[index] = substring;
            } else {
                store = ArrayUtils.grow(store, store.length * 2);
                store[index] = substring;
            }
            return store;
        }
    }

    @Primitive(name="string_append")
    public static abstract class StringAppendPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @NeverDefault
        public static StringAppendPrimitiveNode create() {
            return StringNodesFactory.StringAppendPrimitiveNodeFactory.create(null);
        }

        public abstract RubyString executeStringAppend(RubyString var1, Object var2);

        @Specialization
        RubyString stringAppend(RubyString string, Object other, @Cached StringHelperNodes.StringAppendNode stringAppendNode) {
            RubyString result = stringAppendNode.executeStringAppend(this, (Object)string, other);
            string.setTString(result.tstring, result.getEncodingUnprofiled());
            return string;
        }
    }

    @Primitive(name="character_printable?", lowerFixnum={0})
    public static abstract class CharacterPrintablePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean isCharacterPrintable(int codepoint, RubyEncoding encoding, @Cached InlinedConditionProfile asciiPrintableProfile) {
            assert (codepoint >= 0);
            if (asciiPrintableProfile.profile((Node)this, encoding.isAsciiCompatible && StringSupport.isAscii(codepoint))) {
                return StringSupport.isAsciiPrintable(codepoint);
            }
            return this.isMBCPrintable(encoding.jcoding, codepoint);
        }

        @CompilerDirectives.TruffleBoundary
        protected boolean isMBCPrintable(Encoding encoding, int codePoint) {
            return encoding.isPrint(codePoint);
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean empty(Object self, @Cached RubyStringLibrary libString) {
            return libString.getTString(this, self).isEmpty();
        }
    }

    @CoreMethod(names={"clear"}, raiseIfNotMutableSelf=true)
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString clear(RubyString string, @Cached RubyStringLibrary libString) {
            string.setTString((AbstractTruffleString)libString.getTEncoding(this, (Object)string).getEmpty());
            return string;
        }
    }

    @Primitive(name="string_capitalize!", raiseIfNotMutable={0}, lowerFixnum={1})
    @ImportStatic(value={StringGuards.class, Config.class})
    public static abstract class StringCapitalizeBangPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private TruffleString.GetByteCodeRangeNode codeRangeNode;
        @Node.Child
        private TruffleString.CopyToByteArrayNode copyToByteArrayNode;
        @Node.Child
        private TruffleString.FromByteArrayNode fromByteArrayNode;
        private final ConditionProfile dummyEncodingProfile = ConditionProfile.create();
        private final ConditionProfile emptyStringProfile = ConditionProfile.create();

        @Specialization(guards={"!isComplexCaseMapping(this, tstring, encoding, caseMappingOptions, singleByteOptimizableNode)"})
        Object capitalizeAsciiCodePoints(RubyString string, int caseMappingOptions, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached(value="createUpperToLower()") StringHelperNodes.InvertAsciiCaseHelperNode invertAsciiCaseNode, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached @Cached.Exclusive InlinedConditionProfile firstCharIsLowerProfile, @Cached @Cached.Exclusive InlinedConditionProfile modifiedProfile, @Bind(value="string.tstring") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding) {
            TruffleString.Encoding tencoding = encoding.tencoding;
            if (this.emptyStringProfile.profile(tstring.isEmpty())) {
                return nil;
            }
            if (this.dummyEncodingProfile.profile(encoding.isDummy)) {
                throw new RaiseException(this.getContext(), this.coreExceptions().encodingCompatibilityErrorIncompatibleWithOperation(encoding, this));
            }
            byte[] bytes = null;
            TruffleStringIterator iterator = createCodePointIteratorNode.execute(tstring, tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
            int firstCodePoint = nextNode.execute(iterator);
            if (firstCharIsLowerProfile.profile((Node)this, StringSupport.isAsciiLowercase(firstCodePoint))) {
                bytes = this.copyByteArray(tstring, tencoding);
                bytes[0] = (byte)(bytes[0] ^ 0x20);
            }
            if (modifiedProfile.profile((Node)this, (bytes = invertAsciiCaseNode.executeInvert(string, iterator, bytes)) != null)) {
                string.setTString(this.makeTString(bytes, tencoding));
                return string;
            }
            return nil;
        }

        @Specialization(guards={"isComplexCaseMapping(this, tstring, encoding, caseMappingOptions, singleByteOptimizableNode)"})
        Object capitalizeMultiByteComplex(RubyString string, int caseMappingOptions, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached @Cached.Exclusive InlinedConditionProfile modifiedProfile, @Cached TruffleString.GetInternalByteArrayNode byteArrayNode, @Bind(value="string.tstring") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding) {
            if (this.dummyEncodingProfile.profile(encoding.isDummy)) {
                throw new RaiseException(this.getContext(), this.coreExceptions().encodingCompatibilityErrorIncompatibleWithOperation(encoding, this));
            }
            if (this.emptyStringProfile.profile(tstring.isEmpty())) {
                return nil;
            }
            InternalByteArray byteArray = byteArrayNode.execute(tstring, encoding.tencoding);
            ByteArrayBuilder builder = ByteArrayBuilder.create(byteArray);
            TruffleString.CodeRange cr = this.getCodeRange(tstring, encoding.tencoding);
            boolean modified = StringSupport.capitalizeMultiByteComplex(encoding.jcoding, cr, builder, caseMappingOptions, this);
            if (modifiedProfile.profile((Node)this, modified)) {
                string.setTString(this.makeTString(builder.getUnsafeBytes(), encoding.tencoding));
                return string;
            }
            return nil;
        }

        private byte[] copyByteArray(AbstractTruffleString string, TruffleString.Encoding encoding) {
            if (this.copyToByteArrayNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.copyToByteArrayNode = (TruffleString.CopyToByteArrayNode)this.insert((Node)TruffleString.CopyToByteArrayNode.create());
            }
            return this.copyToByteArrayNode.execute(string, encoding);
        }

        private TruffleString.CodeRange getCodeRange(AbstractTruffleString string, TruffleString.Encoding encoding) {
            if (this.codeRangeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.codeRangeNode = (TruffleString.GetByteCodeRangeNode)this.insert((Node)TruffleString.GetByteCodeRangeNode.create());
            }
            return this.codeRangeNode.execute(string, encoding);
        }

        private AbstractTruffleString makeTString(byte[] bytes, TruffleString.Encoding encoding) {
            if (this.fromByteArrayNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.fromByteArrayNode = (TruffleString.FromByteArrayNode)this.insert((Node)TruffleString.FromByteArrayNode.create());
            }
            return this.fromByteArrayNode.execute(bytes, 0, bytes.length, encoding, false);
        }
    }

    @CoreMethod(names={"valid_encoding?"})
    public static abstract class ValidEncodingQueryNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean validEncoding(Object string, @Cached RubyStringLibrary libString, @Cached TruffleString.IsValidNode isValidNode) {
            return isValidNode.execute(libString.getTString(this, string), libString.getTEncoding(this, string));
        }
    }

    @Primitive(name="string_upcase!", raiseIfNotMutable={0}, lowerFixnum={1})
    @ImportStatic(value={StringGuards.class, Config.class})
    public static abstract class StringUpcaseBangPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        private final ConditionProfile dummyEncodingProfile = ConditionProfile.create();

        @Specialization(guards={"!isComplexCaseMapping(this, tstring, encoding, caseMappingOptions, singleByteOptimizableNode)"})
        Object upcaseAsciiCodePoints(RubyString string, int caseMappingOptions, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached @Cached.Shared RubyStringLibrary libString, @Cached(value="createLowerToUpper()") StringHelperNodes.InvertAsciiCaseNode invertAsciiCaseNode, @Bind(value="string.tstring") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding) {
            if (this.dummyEncodingProfile.profile(encoding.isDummy)) {
                throw new RaiseException(this.getContext(), this.coreExceptions().encodingCompatibilityErrorIncompatibleWithOperation(encoding, this));
            }
            return invertAsciiCaseNode.executeInvert(string);
        }

        @Specialization(guards={"isComplexCaseMapping(this, tstring, encoding, caseMappingOptions, singleByteOptimizableNode)"})
        Object upcaseMultiByteComplex(RubyString string, int caseMappingOptions, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached @Cached.Shared RubyStringLibrary libString, @Cached TruffleString.GetByteCodeRangeNode codeRangeNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.GetInternalByteArrayNode byteArrayNode, @Cached InlinedConditionProfile modifiedProfile, @Bind(value="string.tstring") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding) {
            TruffleString.Encoding tencoding = encoding.tencoding;
            if (this.dummyEncodingProfile.profile(encoding.isDummy)) {
                throw new RaiseException(this.getContext(), this.coreExceptions().encodingCompatibilityErrorIncompatibleWithOperation(encoding, this));
            }
            InternalByteArray byteArray = byteArrayNode.execute(tstring, encoding.tencoding);
            ByteArrayBuilder builder = ByteArrayBuilder.create(byteArray);
            boolean modified = StringSupport.upcaseMultiByteComplex(encoding.jcoding, codeRangeNode.execute(string.tstring, tencoding), builder, caseMappingOptions, this);
            if (modifiedProfile.profile((Node)this, modified)) {
                string.setTString((AbstractTruffleString)fromByteArrayNode.execute(builder.getBytes(), tencoding, false));
                return string;
            }
            return nil;
        }
    }

    @Primitive(name="string_unpack")
    @ReportPolymorphism
    public static abstract class UnpackPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"equalNode.execute(libFormat, format, cachedFormat, cachedEncoding)"}, limit="1")
        RubyArray unpackCached(Object string, Object format, Object offsetObject, @Cached @Cached.Shared InlinedBranchProfile exceptionProfile, @Cached @Cached.Shared InlinedBranchProfile negativeOffsetProfile, @Cached @Cached.Shared InlinedBranchProfile tooLargeOffsetProfile, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared RubyStringLibrary libFormat, @Cached(value="asTruffleStringUncached(format)") TruffleString cachedFormat, @Cached(value="libFormat.getEncoding(this, format)") RubyEncoding cachedEncoding, @Cached(value="create(compileFormat(this, getJavaString(format)))") DirectCallNode callUnpackNode, @Cached StringHelperNodes.EqualNode equalNode, @Cached @Cached.Shared StringHelperNodes.StringGetAssociatedNode stringGetAssociatedNode, @Cached @Cached.Shared TruffleString.GetInternalByteArrayNode byteArrayNode) {
            ArrayResult result;
            int offset;
            InternalByteArray byteArray = byteArrayNode.execute(libString.getTString(this, string), libString.getTEncoding(this, string));
            int n = offset = offsetObject == NotProvided.INSTANCE ? 0 : (Integer)offsetObject;
            if (offset < 0) {
                negativeOffsetProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().argumentError("offset can't be negative", (Node)this, null));
            }
            if (offset > byteArray.getLength()) {
                tooLargeOffsetProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().argumentError("offset outside of string", (Node)this, null));
            }
            try {
                result = (ArrayResult)callUnpackNode.call(new Object[]{byteArray.getArray(), byteArray.getEnd(), byteArray.getOffset() + offset, stringGetAssociatedNode.execute(this, string)});
            }
            catch (FormatException e) {
                exceptionProfile.enter((Node)this);
                throw FormatExceptionTranslator.translate(this.getContext(), this, e);
            }
            return UnpackPrimitiveNode.finishUnpack(this, result);
        }

        @Specialization(guards={"libFormat.isRubyString(this, format)"}, replaces={"unpackCached"})
        static RubyArray unpackUncached(Object string, Object format, Object offsetObject, @Cached @Cached.Shared InlinedBranchProfile exceptionProfile, @Cached @Cached.Shared InlinedBranchProfile negativeOffsetProfile, @Cached @Cached.Shared InlinedBranchProfile tooLargeOffsetProfile, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared RubyStringLibrary libFormat, @Cached ToJavaStringNode toJavaStringNode, @Cached IndirectCallNode callUnpackNode, @Cached @Cached.Shared StringHelperNodes.StringGetAssociatedNode stringGetAssociatedNode, @Cached @Cached.Shared TruffleString.GetInternalByteArrayNode byteArrayNode, @Bind(value="this") Node node) {
            ArrayResult result;
            int offset;
            InternalByteArray byteArray = byteArrayNode.execute(libString.getTString(node, string), libString.getTEncoding(node, string));
            int n = offset = offsetObject == NotProvided.INSTANCE ? 0 : (Integer)offsetObject;
            if (offset < 0) {
                negativeOffsetProfile.enter(node);
                throw new RaiseException(UnpackPrimitiveNode.getContext(node), UnpackPrimitiveNode.getContext(node).getCoreExceptions().argumentError("offset can't be negative", node, null));
            }
            if (offset > byteArray.getLength()) {
                tooLargeOffsetProfile.enter(node);
                throw new RaiseException(UnpackPrimitiveNode.getContext(node), UnpackPrimitiveNode.getContext(node).getCoreExceptions().argumentError("offset outside of string", node, null));
            }
            try {
                result = (ArrayResult)callUnpackNode.call((CallTarget)UnpackPrimitiveNode.compileFormat(node, toJavaStringNode.execute(node, format)), new Object[]{byteArray.getArray(), byteArray.getEnd(), byteArray.getOffset() + offset, stringGetAssociatedNode.execute(node, string)});
            }
            catch (FormatException e) {
                exceptionProfile.enter(node);
                throw FormatExceptionTranslator.translate(UnpackPrimitiveNode.getContext(node), node, e);
            }
            return UnpackPrimitiveNode.finishUnpack(node, result);
        }

        private static RubyArray finishUnpack(Node node, ArrayResult result) {
            return UnpackPrimitiveNode.createArray(node, result.getOutput(), result.getOutputLength());
        }

        @CompilerDirectives.TruffleBoundary
        protected static RootCallTarget compileFormat(Node node, String format) {
            try {
                return new UnpackCompiler(UnpackPrimitiveNode.getLanguage(node), node).compile(format);
            }
            catch (DeferredRaiseException dre) {
                throw dre.getException(UnpackPrimitiveNode.getContext(node));
            }
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.UNPACK_CACHE;
        }
    }

    @CoreMethod(names={"tr_s!"}, required=2, raiseIfNotMutableSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class TrSBangNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"self.tstring.isEmpty()"})
        Object trSBangEmpty(RubyString self, Object fromStr, Object toStr) {
            return nil;
        }

        @Specialization(guards={"libFromStr.isRubyString(this, fromStrAsString)", "libToStr.isRubyString(this, toStrAsString)", "!self.tstring.isEmpty()"}, limit="1")
        static Object trSBang(RubyString self, Object fromStr, Object toStr, @Cached ToStrNode fromStrNode, @Cached ToStrNode toStrNode, @Bind(value="this") Node node, @Bind(value="fromStrNode.execute(node, fromStr)") Object fromStrAsString, @Bind(value="toStrNode.execute(node, toStr)") Object toStrAsString, @Cached EncodingNodes.CheckStringEncodingNode checkEncodingNode, @Cached DeleteBangNode deleteBangNode, @Cached RubyStringLibrary libFromStr, @Cached RubyStringLibrary libToStr) {
            if (libToStr.getTString(node, toStrAsString).isEmpty()) {
                return deleteBangNode.execute(node, self, new Object[]{fromStrAsString});
            }
            return StringHelperNodes.trTransHelper(node, checkEncodingNode, self, libFromStr, fromStrAsString, libToStr, toStrAsString, true);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class TrBangNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, RubyString var2, Object var3, Object var4);

        @Specialization(guards={"self.tstring.isEmpty()"})
        static Object trBangSelfEmpty(RubyString self, Object fromStr, Object toStr) {
            return nil;
        }

        @Specialization(guards={"!self.tstring.isEmpty()", "libToStr.getTString(node, toStr).isEmpty()"}, limit="1")
        static Object trBangToEmpty(Node node, RubyString self, Object fromStr, Object toStr, @Cached DeleteBangNode deleteBangNode, @Cached @Cached.Exclusive RubyStringLibrary libToStr) {
            return deleteBangNode.execute(node, self, new Object[]{fromStr});
        }

        @Specialization(guards={"libFromStr.isRubyString(node, fromStr)", "!self.tstring.isEmpty()", "!libToStr.getTString(node, toStr).isEmpty()"}, limit="1")
        static Object trBangNoEmpty(Node node, RubyString self, Object fromStr, Object toStr, @Cached EncodingNodes.CheckStringEncodingNode checkEncodingNode, @Cached @Cached.Exclusive RubyStringLibrary libFromStr, @Cached @Cached.Exclusive RubyStringLibrary libToStr) {
            return StringHelperNodes.trTransHelper(node, checkEncodingNode, self, libFromStr, fromStr, libToStr, toStr, false);
        }
    }

    @CoreMethod(names={"tr!"}, required=2, raiseIfNotMutableSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringTrBangNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object trBang(RubyString self, Object fromStr, Object toStr, @Cached ToStrNode fromStrNode, @Cached ToStrNode toStrNode, @Cached TrBangNode trBangNode) {
            Object fromStrAsString = fromStrNode.execute(this, fromStr);
            Object toStrAsString = toStrNode.execute(this, toStr);
            return trBangNode.execute(this, self, fromStrAsString, toStrAsString);
        }
    }

    @CoreMethod(names={"reverse!"}, raiseIfNotMutableSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class ReverseBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        TruffleString.CodePointLengthNode codePointLengthNode = TruffleString.CodePointLengthNode.create();
        @Node.Child
        private TruffleString.FromByteArrayNode fromByteArrayNode = TruffleString.FromByteArrayNode.create();

        @Specialization(guards={"reverseIsEqualToSelf(tstring, encoding, codePointLengthNode)"})
        RubyString reverseNoOp(RubyString string, @Cached @Cached.Shared RubyStringLibrary libString, @Bind(value="string.tstring") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding) {
            return string;
        }

        @Specialization(guards={"!reverseIsEqualToSelf(tstring, encoding, codePointLengthNode)", "isSingleByteOptimizable(this, tstring, encoding, singleByteOptimizableNode)"})
        RubyString reverseSingleByteOptimizable(RubyString string, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached @Cached.Shared TruffleString.GetInternalByteArrayNode byteArrayNode, @Bind(value="string.tstring") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding) {
            TruffleString.Encoding tencoding = encoding.tencoding;
            InternalByteArray byteArray = byteArrayNode.execute(tstring, tencoding);
            int len = byteArray.getLength();
            byte[] reversedBytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                reversedBytes[len - i - 1] = byteArray.get(i);
            }
            string.setTString((AbstractTruffleString)this.fromByteArrayNode.execute(reversedBytes, tencoding, false));
            return string;
        }

        @Specialization(guards={"!reverseIsEqualToSelf(tstring, encoding, codePointLengthNode)", "!isSingleByteOptimizable(this, tstring, encoding, singleByteOptimizableNode)"})
        RubyString reverse(RubyString string, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached TruffleString.ByteLengthOfCodePointNode byteLengthOfCodePointNode, @Cached @Cached.Shared TruffleString.GetInternalByteArrayNode byteArrayNode, @Bind(value="string.tstring") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding) {
            int byteOffset;
            TruffleString.Encoding tencoding = encoding.tencoding;
            InternalByteArray byteArray = byteArrayNode.execute(tstring, tencoding);
            byte[] originalBytes = byteArray.getArray();
            int p = byteOffset = byteArray.getOffset();
            int len = byteArray.getLength();
            int end = p + len;
            int op = len;
            byte[] reversedBytes = new byte[len];
            while (p < end) {
                int cl = byteLengthOfCodePointNode.execute(tstring, p - byteOffset, tencoding);
                if (cl > 1 || (originalBytes[p] & 0x80) != 0) {
                    System.arraycopy(originalBytes, p, reversedBytes, op -= cl, cl);
                    p += cl;
                    continue;
                }
                reversedBytes[--op] = originalBytes[p++];
            }
            string.setTString((AbstractTruffleString)this.fromByteArrayNode.execute(reversedBytes, tencoding, false));
            return string;
        }

        public static boolean reverseIsEqualToSelf(AbstractTruffleString tstring, RubyEncoding encoding, TruffleString.CodePointLengthNode codePointLengthNode) {
            return codePointLengthNode.execute(tstring, encoding.tencoding) <= 1;
        }
    }

    @Primitive(name="string_to_symbol")
    @ImportStatic(value={StringGuards.class})
    public static abstract class ToSymNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        TruffleString.GetByteCodeRangeNode codeRangeNode = TruffleString.GetByteCodeRangeNode.create();

        @Specialization(guards={"!isBrokenCodeRange(tstring, encoding, codeRangeNode)", "equalNode.execute(node, tstring, encoding, cachedTString, cachedEncoding)", "preserveSymbol == cachedPreserveSymbol"}, limit="getDefaultCacheLimit()")
        static RubySymbol toSymCached(Object string, boolean preserveSymbol, @Bind(value="this") Node node, @Cached @Cached.Exclusive RubyStringLibrary strings, @Cached(value="asTruffleStringUncached(string)") TruffleString cachedTString, @Cached(value="strings.getEncoding(node, string)") RubyEncoding cachedEncoding, @Cached(value="preserveSymbol") boolean cachedPreserveSymbol, @Cached(value="getSymbol(cachedTString, cachedEncoding, cachedPreserveSymbol)") RubySymbol cachedSymbol, @Cached StringHelperNodes.EqualSameEncodingNode equalNode, @Bind(value="strings.getTString(node, string)") AbstractTruffleString tstring, @Bind(value="strings.getEncoding(node, string)") RubyEncoding encoding) {
            return cachedSymbol;
        }

        @Specialization(guards={"!isBrokenCodeRange(tstring, encoding, codeRangeNode)"}, replaces={"toSymCached"}, limit="1")
        static RubySymbol toSym(Object string, boolean preserveSymbol, @Bind(value="this") Node node, @Cached @Cached.Exclusive RubyStringLibrary strings, @Bind(value="strings.getTString(node, string)") AbstractTruffleString tstring, @Bind(value="strings.getEncoding(node, string)") RubyEncoding encoding) {
            return ToSymNode.getSymbol(node, strings.getTString(node, string), strings.getEncoding(node, string), preserveSymbol);
        }

        @Specialization(guards={"isBrokenCodeRange(tstring, encoding, codeRangeNode)"}, limit="1")
        static RubySymbol toSymBroken(Object string, boolean preserveSymbol, @Bind(value="this") Node node, @Cached @Cached.Exclusive RubyStringLibrary strings, @Bind(value="strings.getTString(node, string)") AbstractTruffleString tstring, @Bind(value="strings.getEncoding(node, string)") RubyEncoding encoding) {
            throw new RaiseException(ToSymNode.getContext(node), ToSymNode.coreExceptions(node).encodingError(string, encoding, node));
        }
    }

    @CoreMethod(names={"to_s", "to_str"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        ImmutableRubyString toS(ImmutableRubyString string) {
            return string;
        }

        @Specialization(guards={"!isStringSubclass(string)"})
        RubyString toS(RubyString string) {
            return string;
        }

        @Specialization(guards={"isStringSubclass(string)"})
        RubyString toSOnSubclass(RubyString string, @Cached RubyStringLibrary libString, @Cached TruffleString.AsTruffleStringNode asTruffleStringNode) {
            return this.createStringCopy(asTruffleStringNode, string.tstring, libString.getEncoding(this, (Object)string));
        }

        public boolean isStringSubclass(RubyString string) {
            return string.getLogicalClass() != this.coreLibrary().stringClass;
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        double toF(Object string, @Cached RubyStringLibrary strings) {
            try {
                return this.convertToDouble(strings.getTString(this, string), strings.getEncoding(this, string));
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private double convertToDouble(AbstractTruffleString tstring, RubyEncoding encoding) {
            return new DoubleConverter().parse(tstring, encoding, false, true);
        }
    }

    @CoreMethod(names={"sum"}, optional=1)
    public static abstract class SumNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private DispatchNode addNode = DispatchNode.create();
        @Node.Child
        private TruffleString.GetInternalByteArrayNode byteArrayNode = TruffleString.GetInternalByteArrayNode.create();

        @NeverDefault
        public static SumNode create() {
            return StringNodesFactory.SumNodeFactory.create(null);
        }

        public abstract Object executeSum(Object var1, Object var2);

        @Specialization
        Object sum(Object string, long bits, @Cached @Cached.Shared RubyStringLibrary strings) {
            AbstractTruffleString tstring = strings.getTString(this, string);
            TruffleString.Encoding encoding = strings.getEncoding((Node)this, (Object)string).tencoding;
            InternalByteArray byteArray = this.byteArrayNode.execute(tstring, encoding);
            byte[] bytes = byteArray.getArray();
            int p = byteArray.getOffset();
            int end = byteArray.getEnd();
            if (bits >= 64L) {
                Object sum = 0;
                while (p < end) {
                    sum = this.addNode.call(sum, "+", bytes[p++] & 0xFF);
                }
                return sum;
            }
            long sum = 0L;
            while (p < end) {
                sum += (long)(bytes[p++] & 0xFF);
            }
            return bits == 0L ? sum : sum & (1L << (int)bits) - 1L;
        }

        @Specialization
        Object sum(Object string, NotProvided bits, @Cached @Cached.Shared RubyStringLibrary strings) {
            return this.sum(string, 16L, strings);
        }

        @Specialization(guards={"!isImplicitLong(bits)", "wasProvided(bits)"})
        static Object sum(Object string, Object bits, @Cached ToLongNode toLongNode, @Cached SumNode sumNode, @Bind(value="this") Node node) {
            return sumNode.executeSum(string, toLongNode.execute(node, bits));
        }
    }

    @CoreMethod(names={"succ!"}, raiseIfNotMutableSelf=true)
    public static abstract class SuccBangNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString succBang(RubyString string, @Cached RubyStringLibrary libString, @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
            if (!string.tstring.isEmpty()) {
                TStringBuilder succBuilder = StringSupport.succCommon(string, this);
                string.setTString((AbstractTruffleString)fromByteArrayNode.execute(succBuilder.getBytes(), libString.getTEncoding(this, (Object)string), false));
            }
            return string;
        }
    }

    @CoreMethod(names={"squeeze!"}, rest=true, raiseIfNotMutableSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class SqueezeBangNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"string.tstring.isEmpty()"})
        Object squeezeBangEmptyString(RubyString string, Object[] args) {
            return nil;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!string.tstring.isEmpty()", "noArguments(args)"})
        Object squeezeBangZeroArgs(RubyString string, Object[] args, @Cached StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode) {
            TStringBuilder buffer = TStringBuilder.create(string);
            boolean[] squeeze = new boolean[256];
            for (int i = 0; i < 256; ++i) {
                squeeze[i] = true;
            }
            if (StringGuards.isSingleByteOptimizable(this, string.tstring, string.getEncodingUncached(), singleByteOptimizableNode)) {
                if (!StringSupport.singleByteSqueeze(buffer, squeeze)) {
                    return nil;
                }
                string.setTString((AbstractTruffleString)buffer.toTString(), buffer.getRubyEncoding());
            } else {
                TruffleString.CodeRange codeRange = string.tstring.getByteCodeRangeUncached(RubyStringLibrary.getUncached().getTEncoding(this, (Object)string));
                if (!StringSupport.multiByteSqueeze(buffer, codeRange, squeeze, null, string.getEncodingUncached().jcoding, false, this)) {
                    return nil;
                }
                string.setTString((AbstractTruffleString)buffer.toTString(), buffer.getRubyEncoding());
            }
            return string;
        }

        @Specialization(guards={"!string.tstring.isEmpty()", "!noArguments(args)"})
        static Object squeezeBang(RubyString string, Object[] args, @Cached EncodingNodes.CheckStringEncodingNode checkEncodingNode, @Cached ToStrNode toStrNode, @Bind(value="this") Node node) {
            Object[] otherStrings = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = toStrNode.execute(node, args[i]);
            }
            return SqueezeBangNode.performSqueezeBang(node, string, otherStrings, checkEncodingNode);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object performSqueezeBang(Node node, RubyString string, Object[] otherStrings, EncodingNodes.CheckStringEncodingNode checkEncodingNode) {
            boolean singlebyte;
            TStringBuilder buffer = TStringBuilder.create(string);
            Object otherStr = otherStrings[0];
            AbstractTruffleString otherTString = RubyStringLibrary.getUncached().getTString(node, otherStr);
            RubyEncoding otherEncoding = RubyStringLibrary.getUncached().getEncoding(node, otherStr);
            RubyEncoding enc = checkEncodingNode.execute(node, string.tstring, string.getEncodingUncached(), otherTString, otherEncoding);
            boolean[] squeeze = new boolean[257];
            boolean bl = singlebyte = TStringUtils.isSingleByteOptimizable(string.tstring, string.getEncodingUncached()) && TStringUtils.isSingleByteOptimizable(otherTString, otherEncoding);
            if (singlebyte && otherTString.byteLength(otherEncoding.tencoding) == 1 && otherStrings.length == 1) {
                squeeze[otherTString.readByteUncached((int)0, (TruffleString.Encoding)otherEncoding.tencoding)] = true;
                if (!StringSupport.singleByteSqueeze(buffer, squeeze)) {
                    return nil;
                }
                string.setTString((AbstractTruffleString)buffer.toTString(), buffer.getRubyEncoding());
                return string;
            }
            StringSupport.TrTables tables = StringSupport.trSetupTable(otherTString, otherEncoding, squeeze, null, true, enc.jcoding, node);
            for (int i = 1; i < otherStrings.length; ++i) {
                otherStr = otherStrings[i];
                otherTString = RubyStringLibrary.getUncached().getTString(node, otherStr);
                otherEncoding = RubyStringLibrary.getUncached().getEncoding(node, otherStr);
                enc = checkEncodingNode.execute(node, string.tstring, string.getEncodingUncached(), otherTString, otherEncoding);
                singlebyte = singlebyte && TStringUtils.isSingleByteOptimizable(otherTString, otherEncoding);
                tables = StringSupport.trSetupTable(otherTString, otherEncoding, squeeze, tables, false, enc.jcoding, node);
            }
            if (singlebyte) {
                if (!StringSupport.singleByteSqueeze(buffer, squeeze)) {
                    return nil;
                }
                string.setTString((AbstractTruffleString)buffer.toTString(), buffer.getRubyEncoding());
            } else {
                TruffleString.CodeRange codeRange = string.tstring.getByteCodeRangeUncached(RubyStringLibrary.getUncached().getTEncoding(node, (Object)string));
                if (!StringSupport.multiByteSqueeze(buffer, codeRange, squeeze, tables, enc.jcoding, true, node)) {
                    return nil;
                }
                string.setTString((AbstractTruffleString)buffer.toTString(), buffer.getRubyEncoding());
            }
            return string;
        }
    }

    @CoreMethod(names={"size", "length"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        public static SizeNode create() {
            return StringNodesFactory.SizeNodeFactory.create(null);
        }

        public abstract int execute(Object var1);

        @Specialization
        int size(Object string, @Cached RubyStringLibrary libString, @Cached TruffleString.CodePointLengthNode codePointLengthNode) {
            return codePointLengthNode.execute(libString.getTString(this, string), libString.getTEncoding(this, string));
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetByteNode
    extends RubyBaseNode {
        public abstract int execute(Node var1, RubyString var2, int var3, int var4);

        @Specialization(guards={"tstring.isMutable()"})
        static int mutable(Node node, RubyString string, int index, int value, @Cached @Cached.Shared StringHelperNodes.CheckIndexNode checkIndexNode, @Cached @Cached.Shared RubyStringLibrary libString, @Bind(value="string.tstring") AbstractTruffleString tstring, @Cached(inline=false) @Cached.Shared MutableTruffleString.WriteByteNode writeByteNode) {
            TruffleString.Encoding tencoding = libString.getTEncoding(node, (Object)string);
            int normalizedIndex = checkIndexNode.execute(node, index, tstring.byteLength(tencoding));
            writeByteNode.execute((MutableTruffleString)tstring, normalizedIndex, (byte)value, tencoding);
            return value;
        }

        @Specialization(guards={"!tstring.isMutable()"})
        static int immutable(Node node, RubyString string, int index, int value, @Cached @Cached.Shared StringHelperNodes.CheckIndexNode checkIndexNode, @Cached @Cached.Shared RubyStringLibrary libString, @Bind(value="string.tstring") AbstractTruffleString tstring, @Cached(inline=false) MutableTruffleString.AsMutableTruffleStringNode asMutableTruffleStringNode, @Cached(inline=false) @Cached.Shared MutableTruffleString.WriteByteNode writeByteNode) {
            TruffleString.Encoding tencoding = libString.getTEncoding(node, (Object)string);
            int normalizedIndex = checkIndexNode.execute(node, index, tstring.byteLength(tencoding));
            MutableTruffleString mutableTString = asMutableTruffleStringNode.execute(tstring, tencoding);
            writeByteNode.execute(mutableTString, normalizedIndex, (byte)value, tencoding);
            string.setTString((AbstractTruffleString)mutableTString);
            return value;
        }
    }

    @CoreMethod(names={"setbyte"}, required=2, raiseIfNotMutableSelf=true, lowerFixnum={1, 2})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringSetByteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int doSetByte(RubyString string, Object indexObject, Object valueObject, @Cached ToIntNode toIntIndexNode, @Cached ToIntNode toIntValueNode, @Cached SetByteNode setByteNode) {
            int index = toIntIndexNode.execute(indexObject);
            int value = toIntValueNode.execute(valueObject);
            return setByteNode.execute(this, string, index, value);
        }
    }

    @CoreMethod(names={"undump"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class UndumpNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isAsciiCompatible(libString.getEncoding(this, string))"})
        RubyString undumpAsciiCompatible(Object string, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached @Cached.Shared RubyStringLibrary libString) {
            RubyEncoding encoding = libString.getEncoding(this, string);
            Pair<TStringBuilder, RubyEncoding> outputBytesResult = StringSupport.undump(new ATStringWithEncoding(libString.getTString(this, string), encoding), encoding, this.getContext(), this);
            RubyEncoding rubyEncoding = (RubyEncoding)outputBytesResult.getRight();
            return this.createString(((TStringBuilder)outputBytesResult.getLeft()).toTStringUnsafe(fromByteArrayNode), rubyEncoding);
        }

        @Specialization(guards={"!isAsciiCompatible(libString.getEncoding(this, string))"})
        RubyString undumpNonAsciiCompatible(Object string, @Cached @Cached.Shared RubyStringLibrary libString) {
            throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().encodingCompatibilityError(Utils.concat((Object)"ASCII incompatible encoding: ", (Object)libString.getEncoding(this, string)), this));
        }
    }

    @CoreMethod(names={"dump"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class DumpNode
    extends CoreMethodArrayArgumentsNode {
        private static final byte[] FORCE_ENCODING_CALL_BYTES = StringOperations.encodeAsciiBytes(".force_encoding(\"");

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isAsciiCompatible(libString.getEncoding(this, string))"})
        RubyString dumpAsciiCompatible(Object string, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared TruffleString.FromByteArrayNode fromByteArrayNode) {
            ByteArrayBuilder outputBytes = this.dumpCommon(new ATStringWithEncoding(this, libString, string));
            return this.createString(fromByteArrayNode, outputBytes.getBytes(), libString.getEncoding(this, string));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isAsciiCompatible(libString.getEncoding(this, string))"})
        RubyString dump(Object string, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared TruffleString.FromByteArrayNode fromByteArrayNode) {
            ByteArrayBuilder outputBytes = this.dumpCommon(new ATStringWithEncoding(this, libString, string));
            outputBytes.append(FORCE_ENCODING_CALL_BYTES);
            outputBytes.append(libString.getEncoding((Node)this, (Object)string).jcoding.getName());
            outputBytes.append((byte)34);
            outputBytes.append((byte)41);
            return this.createString(fromByteArrayNode, outputBytes.getBytes(), Encodings.BINARY);
        }

        private ByteArrayBuilder dumpCommon(ATStringWithEncoding string) {
            int offset;
            ByteArrayBuilder buf = null;
            Encoding enc = string.encoding.jcoding;
            TruffleString.CodeRange cr = string.getCodeRange();
            InternalByteArray byteArray = string.getInternalByteArray();
            int p = offset = byteArray.getOffset();
            int end = byteArray.getEnd();
            byte[] bytes = byteArray.getArray();
            int len = 2;
            block4: while (p < end) {
                int n;
                int c = bytes[p++] & 0xFF;
                switch (c) {
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 27: 
                    case 34: 
                    case 92: {
                        len += 2;
                        continue block4;
                    }
                    case 35: {
                        len += p < end && DumpNode.isEVStr(bytes[p] & 0xFF) ? 2 : 1;
                        continue block4;
                    }
                }
                if (ASCIIEncoding.INSTANCE.isPrint(c)) {
                    ++len;
                    continue;
                }
                if (enc.isUTF8() && (n = string.characterLength(p - 1 - offset) - 1) > 0) {
                    if (buf == null) {
                        buf = new ByteArrayBuilder();
                    }
                    int cc = StringSupport.codePoint(enc, cr, bytes, p - 1, end, this);
                    buf.append(StringUtils.formatASCIIBytes("%x", cc));
                    len += buf.getLength() + 4;
                    buf.setLength(0);
                    p += n;
                    continue;
                }
                len += 4;
            }
            if (!enc.isAsciiCompatible()) {
                len += FORCE_ENCODING_CALL_BYTES.length + enc.getName().length + "\")".length();
            }
            TStringBuilder outBytes = new TStringBuilder();
            outBytes.unsafeEnsureSpace(len);
            byte[] out = outBytes.getUnsafeBytes();
            int q = 0;
            p = offset;
            out[q++] = 34;
            while (p < end) {
                int n;
                int c;
                if ((c = bytes[p++] & 0xFF) == 34 || c == 92) {
                    out[q++] = 92;
                    out[q++] = (byte)c;
                    continue;
                }
                if (c == 35) {
                    if (p < end && DumpNode.isEVStr(bytes[p] & 0xFF)) {
                        out[q++] = 92;
                    }
                    out[q++] = 35;
                    continue;
                }
                if (c == 10) {
                    out[q++] = 92;
                    out[q++] = 110;
                    continue;
                }
                if (c == 13) {
                    out[q++] = 92;
                    out[q++] = 114;
                    continue;
                }
                if (c == 9) {
                    out[q++] = 92;
                    out[q++] = 116;
                    continue;
                }
                if (c == 12) {
                    out[q++] = 92;
                    out[q++] = 102;
                    continue;
                }
                if (c == 11) {
                    out[q++] = 92;
                    out[q++] = 118;
                    continue;
                }
                if (c == 8) {
                    out[q++] = 92;
                    out[q++] = 98;
                    continue;
                }
                if (c == 7) {
                    out[q++] = 92;
                    out[q++] = 97;
                    continue;
                }
                if (c == 27) {
                    out[q++] = 92;
                    out[q++] = 101;
                    continue;
                }
                if (ASCIIEncoding.INSTANCE.isPrint(c)) {
                    out[q++] = (byte)c;
                    continue;
                }
                out[q++] = 92;
                if (enc.isUTF8() && (n = string.characterLength(p - 1 - offset) - 1) > 0) {
                    int cc = StringSupport.codePoint(enc, cr, bytes, p - 1, end, this);
                    p += n;
                    outBytes.setLength(q);
                    String format = cc <= 65535 ? "u%04X" : "u{%X}";
                    outBytes.append(StringUtils.formatASCIIBytes(format, cc));
                    q = outBytes.getLength();
                    continue;
                }
                outBytes.setLength(q);
                outBytes.append(StringUtils.formatASCIIBytes("x%02X", c));
                q = outBytes.getLength();
            }
            out[q++] = 34;
            outBytes.setLength(q);
            assert (out == outBytes.getUnsafeBytes());
            return outBytes;
        }

        private static boolean isEVStr(int c) {
            return c == 36 || c == 64 || c == 123;
        }
    }

    @Primitive(name="string_swapcase!", raiseIfNotMutable={0}, lowerFixnum={1})
    @ImportStatic(value={StringGuards.class, Config.class})
    public static abstract class StringSwapcaseBangPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        private final ConditionProfile dummyEncodingProfile = ConditionProfile.create();

        @Specialization(guards={"!isComplexCaseMapping(this, tstring, encoding, caseMappingOptions, singleByteOptimizableNode)"})
        Object swapcaseAsciiCodePoints(RubyString string, int caseMappingOptions, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached @Cached.Shared RubyStringLibrary libString, @Cached(value="createSwapCase()") StringHelperNodes.InvertAsciiCaseNode invertAsciiCaseNode, @Bind(value="string.tstring") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding) {
            if (this.dummyEncodingProfile.profile(encoding.isDummy)) {
                throw new RaiseException(this.getContext(), this.coreExceptions().encodingCompatibilityErrorIncompatibleWithOperation(encoding, this));
            }
            return invertAsciiCaseNode.executeInvert(string);
        }

        @Specialization(guards={"isComplexCaseMapping(this, tstring, encoding, caseMappingOptions, singleByteOptimizableNode)"})
        Object swapcaseMultiByteComplex(RubyString string, int caseMappingOptions, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached @Cached.Shared RubyStringLibrary libString, @Cached TruffleString.GetByteCodeRangeNode codeRangeNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.GetInternalByteArrayNode byteArrayNode, @Cached InlinedConditionProfile modifiedProfile, @Bind(value="string.tstring") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding) {
            if (this.dummyEncodingProfile.profile(encoding.isDummy)) {
                throw new RaiseException(this.getContext(), this.coreExceptions().encodingCompatibilityErrorIncompatibleWithOperation(encoding, this));
            }
            InternalByteArray byteArray = byteArrayNode.execute(tstring, encoding.tencoding);
            ByteArrayBuilder builder = ByteArrayBuilder.create(byteArray);
            TruffleString.CodeRange cr = codeRangeNode.execute(string.tstring, encoding.tencoding);
            boolean modified = StringSupport.swapCaseMultiByteComplex(encoding.jcoding, cr, builder, caseMappingOptions, this);
            if (modifiedProfile.profile((Node)this, modified)) {
                string.setTString((AbstractTruffleString)fromByteArrayNode.execute(builder.getBytes(), encoding.tencoding, false));
                return string;
            }
            return nil;
        }
    }

    @Primitive(name="string_scrub")
    @ImportStatic(value={StringGuards.class})
    public static abstract class ScrubNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        TruffleString.GetByteCodeRangeNode codeRangeNode = TruffleString.GetByteCodeRangeNode.create();
        @Node.Child
        private TruffleString.ConcatNode concatNode = TruffleString.ConcatNode.create();
        @Node.Child
        private TruffleString.GetInternalByteArrayNode byteArrayNode = TruffleString.GetInternalByteArrayNode.create();
        @Node.Child
        TruffleString.SubstringByteIndexNode substringNode = TruffleString.SubstringByteIndexNode.create();

        @Specialization(guards={"isBrokenCodeRange(tstring, encoding, codeRangeNode)", "isAsciiCompatible(encoding)"})
        RubyString scrubAsciiCompat(Object string, RubyProc block, @Cached @Cached.Shared RubyStringLibrary strings, @Cached @Cached.Exclusive TruffleString.ByteLengthOfCodePointNode byteLengthOfCodePointNode, @Bind(value="strings.getTString(this, string)") AbstractTruffleString tstring, @Bind(value="strings.getEncoding(this, string)") RubyEncoding encoding, @Cached @Cached.Shared CallBlockNode yieldNode) {
            int clen;
            int p;
            Encoding enc = encoding.jcoding;
            TruffleString.Encoding tencoding = encoding.tencoding;
            TruffleString buf = TStringConstants.EMPTY_BINARY;
            InternalByteArray byteArray = this.byteArrayNode.execute(tstring, tencoding);
            int e = tstring.byteLength(tencoding);
            int p1 = p = 0;
            if ((p = StringSupport.searchNonAscii(byteArray, p)) < 0) {
                p = e;
            }
            while (p < e && !StringSupport.MBCLEN_NEEDMORE_P(clen = byteLengthOfCodePointNode.execute(tstring, p, tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE))) {
                if (StringSupport.MBCLEN_CHARFOUND_P(clen)) {
                    p += StringSupport.MBCLEN_CHARFOUND_LEN(clen);
                    continue;
                }
                if (!StringSupport.MBCLEN_INVALID_P(clen)) continue;
                clen = enc.maxLength();
                if (p > p1) {
                    buf = this.concatNode.execute((AbstractTruffleString)buf, (AbstractTruffleString)this.substringNode.execute(tstring, p1, p - p1, tencoding, true), tencoding, true);
                }
                if (e - p < clen) {
                    clen = e - p;
                }
                if (clen <= 2) {
                    clen = 1;
                } else {
                    TruffleString subTString;
                    int clen2;
                    --clen;
                    while (clen > 1 && !StringSupport.MBCLEN_NEEDMORE_P(clen2 = byteLengthOfCodePointNode.execute((AbstractTruffleString)(subTString = this.substringNode.execute(tstring, p, clen, tencoding, true)), 0, tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE))) {
                        --clen;
                    }
                }
                Object repl = yieldNode.yield(this, block, new Object[]{this.createSubString(this.substringNode, tstring, encoding, p, clen)});
                buf = this.concatNode.execute((AbstractTruffleString)buf, strings.getTString(this, repl), tencoding, true);
                p1 = p += clen;
                if ((p = StringSupport.searchNonAscii(byteArray, p)) >= 0) continue;
                p = e;
                break;
            }
            if (p1 < p) {
                buf = this.concatNode.execute((AbstractTruffleString)buf, (AbstractTruffleString)this.substringNode.execute(tstring, p1, p - p1, tencoding, true), tencoding, true);
            }
            if (p < e) {
                Object repl = yieldNode.yield(this, block, new Object[]{this.createSubString(this.substringNode, tstring, encoding, p, e - p)});
                buf = this.concatNode.execute((AbstractTruffleString)buf, strings.getTString(this, repl), tencoding, true);
            }
            return this.createString(buf, encoding);
        }

        @Specialization(guards={"isBrokenCodeRange(tstring, encoding, codeRangeNode)", "!isAsciiCompatible(encoding)"})
        RubyString scrubAsciiIncompatible(Object string, RubyProc block, @Cached @Cached.Shared RubyStringLibrary strings, @Cached @Cached.Exclusive TruffleString.ByteLengthOfCodePointNode byteLengthOfCodePointNode, @Bind(value="strings.getTString(this, string)") AbstractTruffleString tstring, @Bind(value="strings.getEncoding(this, string)") RubyEncoding encoding, @Cached @Cached.Shared CallBlockNode yieldNode) {
            int clen;
            int p;
            Encoding enc = encoding.jcoding;
            TruffleString.Encoding tencoding = encoding.tencoding;
            TruffleString buf = TStringConstants.EMPTY_BINARY;
            int e = tstring.byteLength(tencoding);
            int p1 = p = 0;
            int mbminlen = enc.minLength();
            while (p < e && !StringSupport.MBCLEN_NEEDMORE_P(clen = byteLengthOfCodePointNode.execute(tstring, p, tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE))) {
                if (StringSupport.MBCLEN_CHARFOUND_P(clen)) {
                    p += StringSupport.MBCLEN_CHARFOUND_LEN(clen);
                    continue;
                }
                if (!StringSupport.MBCLEN_INVALID_P(clen)) continue;
                int q = p;
                clen = enc.maxLength();
                if (p > p1) {
                    buf = this.concatNode.execute((AbstractTruffleString)buf, (AbstractTruffleString)this.substringNode.execute(tstring, p1, p - p1, tencoding, true), tencoding, true);
                }
                if (e - p < clen) {
                    clen = e - p;
                }
                if (clen <= mbminlen * 2) {
                    clen = mbminlen;
                } else {
                    TruffleString subTString;
                    int clen2;
                    clen -= mbminlen;
                    while (clen > mbminlen && !StringSupport.MBCLEN_NEEDMORE_P(clen2 = byteLengthOfCodePointNode.execute((AbstractTruffleString)(subTString = this.substringNode.execute(tstring, q, clen, tencoding, true)), 0, tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE))) {
                        clen -= mbminlen;
                    }
                }
                RubyString repl = (RubyString)((Object)yieldNode.yield(this, block, new Object[]{this.createSubString(this.substringNode, tstring, encoding, p, clen)}));
                buf = this.concatNode.execute((AbstractTruffleString)buf, repl.tstring, tencoding, true);
                p1 = p += clen;
            }
            if (p1 < p) {
                buf = this.concatNode.execute((AbstractTruffleString)buf, (AbstractTruffleString)this.substringNode.execute(tstring, p1, p - p1, tencoding, true), tencoding, true);
            }
            if (p < e) {
                RubyString repl = (RubyString)((Object)yieldNode.yield(this, block, new Object[]{this.createSubString(this.substringNode, tstring, encoding, p, e - p)}));
                buf = this.concatNode.execute((AbstractTruffleString)buf, repl.tstring, tencoding, true);
            }
            return this.createString(buf, encoding);
        }
    }

    @CoreMethod(names={"rstrip!"}, raiseIfNotMutableSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class RstripBangNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"string.tstring.isEmpty()"})
        Object rstripBangEmptyString(RubyString string) {
            return nil;
        }

        @Specialization(guards={"!string.tstring.isEmpty()"})
        static Object rstripBangNonEmptyString(RubyString string, @Cached RubyStringLibrary libString, @Cached EncodingNodes.GetActualEncodingNode getActualEncodingNode, @Cached TruffleString.CreateBackwardCodePointIteratorNode createBackwardCodePointIteratorNode, @Cached TruffleStringIterator.PreviousNode previousNode, @Cached InlinedBranchProfile allWhitespaceProfile, @Cached InlinedBranchProfile nonSpaceCodePointProfile, @Cached InlinedBranchProfile badCodePointProfile, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached @Cached.Exclusive InlinedConditionProfile noopProfile, @Bind(value="this") Node node) {
            AbstractTruffleString tstring = string.tstring;
            RubyEncoding encoding = getActualEncodingNode.execute(node, tstring, libString.getEncoding(node, (Object)string));
            TruffleString.Encoding tencoding = encoding.tencoding;
            TruffleStringIterator iterator = createBackwardCodePointIteratorNode.execute(tstring, tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
            int codePoint = previousNode.execute(iterator);
            if (codePoint == -1) {
                badCodePointProfile.enter(node);
                throw new RaiseException(RstripBangNode.getContext(node), RstripBangNode.coreExceptions(node).argumentErrorInvalidByteSequence(encoding, node));
            }
            if (noopProfile.profile(node, !StringSupport.isAsciiSpaceOrNull(codePoint))) {
                return nil;
            }
            while (iterator.hasPrevious()) {
                int byteIndex = iterator.getByteIndex();
                codePoint = previousNode.execute(iterator);
                if (codePoint == -1) {
                    badCodePointProfile.enter(node);
                    throw new RaiseException(RstripBangNode.getContext(node), RstripBangNode.coreExceptions(node).argumentErrorInvalidByteSequence(encoding, node));
                }
                if (StringSupport.isAsciiSpaceOrNull(codePoint)) continue;
                nonSpaceCodePointProfile.enter(node);
                string.setTString(RstripBangNode.makeSubstring(substringNode, tstring, tencoding, byteIndex));
                return string;
            }
            allWhitespaceProfile.enter(node);
            string.setTString((AbstractTruffleString)tencoding.getEmpty());
            return string;
        }

        private static AbstractTruffleString makeSubstring(TruffleString.SubstringByteIndexNode substringNode, AbstractTruffleString base, TruffleString.Encoding encoding, int byteEnd) {
            return substringNode.execute(base, 0, byteEnd, encoding, true);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ReplaceNode
    extends RubyBaseNode {
        public abstract RubyString execute(Node var1, RubyString var2, Object var3);

        @Specialization(guards={"string == other"})
        static RubyString replaceStringIsSameAsOther(RubyString string, RubyString other) {
            return string;
        }

        @Specialization(guards={"string != other"})
        static RubyString replace(Node node, RubyString string, RubyString other, @Cached @Cached.Exclusive RubyStringLibrary libOther, @Cached(inline=false) TruffleString.AsTruffleStringNode asTruffleStringNode) {
            RubyEncoding encoding = libOther.getEncoding(node, (Object)other);
            TruffleString immutableCopy = asTruffleStringNode.execute(other.tstring, encoding.tencoding);
            string.setTString((AbstractTruffleString)immutableCopy, encoding);
            return string;
        }

        @Specialization
        static RubyString replace(Node node, RubyString string, ImmutableRubyString other, @Cached @Cached.Exclusive RubyStringLibrary libOther) {
            string.setTString((AbstractTruffleString)other.tstring, libOther.getEncoding(node, other));
            return string;
        }
    }

    @Primitive(name="string_replace", raiseIfNotMutable={0})
    public static abstract class StringReplaceNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object replaceNode(RubyString string, Object other, @Cached ToStrNode toStrNode, @Cached ReplaceNode replaceNode) {
            Object otherAsString = toStrNode.execute(this, other);
            return replaceNode.execute(this, string, otherAsString);
        }
    }

    @CoreMethod(names={"ord"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class OrdNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"strings.getTString(this, string).isEmpty()"})
        int ordEmpty(Object string, @Cached @Cached.Shared RubyStringLibrary strings) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("empty string", this));
        }

        @Specialization(guards={"!strings.getTString(this, string).isEmpty()"})
        int ord(Object string, @Cached @Cached.Shared RubyStringLibrary strings, @Cached StringHelperNodes.GetCodePointNode getCodePointNode) {
            return getCodePointNode.executeGetCodePoint(this, strings.getTString(this, string), strings.getEncoding(this, string), 0);
        }
    }

    @CoreMethod(names={"lstrip!"}, raiseIfNotMutableSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class LstripBangNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"string.tstring.isEmpty()"})
        Object lstripBangEmptyString(RubyString string) {
            return nil;
        }

        @Specialization(guards={"!string.tstring.isEmpty()"})
        static Object lstripBangSingleByte(RubyString string, @Cached RubyStringLibrary libString, @Cached EncodingNodes.GetActualEncodingNode getActualEncodingNode, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached InlinedBranchProfile allWhitespaceProfile, @Cached InlinedBranchProfile nonSpaceCodePointProfile, @Cached InlinedBranchProfile badCodePointProfile, @Cached InlinedConditionProfile noopProfile, @Bind(value="this") Node node) {
            AbstractTruffleString tstring = string.tstring;
            RubyEncoding encoding = getActualEncodingNode.execute(node, tstring, libString.getEncoding(node, (Object)string));
            TruffleString.Encoding tencoding = encoding.tencoding;
            TruffleStringIterator iterator = createCodePointIteratorNode.execute(tstring, tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
            int codePoint = nextNode.execute(iterator);
            if (codePoint == -1) {
                badCodePointProfile.enter(node);
                throw new RaiseException(LstripBangNode.getContext(node), LstripBangNode.coreExceptions(node).argumentErrorInvalidByteSequence(encoding, node));
            }
            if (noopProfile.profile(node, !StringSupport.isAsciiSpaceOrNull(codePoint))) {
                return nil;
            }
            while (iterator.hasNext()) {
                int byteIndex = iterator.getByteIndex();
                codePoint = nextNode.execute(iterator);
                if (codePoint == -1) {
                    badCodePointProfile.enter(node);
                    throw new RaiseException(LstripBangNode.getContext(node), LstripBangNode.coreExceptions(node).argumentErrorInvalidByteSequence(encoding, node));
                }
                if (StringSupport.isAsciiSpaceOrNull(codePoint)) continue;
                nonSpaceCodePointProfile.enter(node);
                string.setTString(LstripBangNode.makeSubstring(substringNode, tstring, tencoding, byteIndex));
                return string;
            }
            allWhitespaceProfile.enter(node);
            string.setTString((AbstractTruffleString)tencoding.getEmpty());
            return string;
        }

        private static AbstractTruffleString makeSubstring(TruffleString.SubstringByteIndexNode substringNode, AbstractTruffleString base, TruffleString.Encoding encoding, int byteOffset) {
            int substringByteLength = base.byteLength(encoding) - byteOffset;
            return substringNode.execute(base, byteOffset, substringByteLength, encoding, true);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1, raiseIfNotMutableSelf=true)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"areEqual(self, from)"})
        Object initializeCopySelfIsSameAsFrom(RubyString self, Object from) {
            return self;
        }

        @Specialization(guards={"stringsFrom.isRubyString(this, from)", "!areEqual(self, from)", "!tstring.isNative()", "tstring.isImmutable()"})
        Object initializeCopyImmutable(RubyString self, Object from, @Cached @Cached.Shared RubyStringLibrary stringsFrom, @Cached @Cached.Shared WriteObjectFieldNode writeAssociatedNode, @Cached @Cached.Shared StringHelperNodes.StringGetAssociatedNode stringGetAssociatedNode, @Bind(value="stringsFrom.getTString(this, from)") AbstractTruffleString tstring) {
            self.setTString(tstring, stringsFrom.getEncoding(this, from));
            Object associated = stringGetAssociatedNode.execute(this, from);
            this.copyAssociated(self, associated, writeAssociatedNode);
            return self;
        }

        @Specialization(guards={"stringsFrom.isRubyString(this, from)", "!areEqual(self, from)", "!tstring.isNative()", "tstring.isMutable()"})
        Object initializeCopyMutable(RubyString self, Object from, @Cached @Cached.Shared RubyStringLibrary stringsFrom, @Cached @Cached.Shared WriteObjectFieldNode writeAssociatedNode, @Cached @Cached.Shared StringHelperNodes.StringGetAssociatedNode stringGetAssociatedNode, @Cached MutableTruffleString.SubstringByteIndexNode copyMutableTruffleStringNode, @Bind(value="stringsFrom.getTString(this, from)") AbstractTruffleString tstring) {
            RubyEncoding encoding = stringsFrom.getEncoding(this, from);
            TruffleString.Encoding tencoding = encoding.tencoding;
            int byteLength = tstring.byteLength(tencoding);
            MutableTruffleString copy = copyMutableTruffleStringNode.execute(tstring, 0, byteLength, tencoding);
            self.setTString((AbstractTruffleString)copy, encoding);
            Object associated = stringGetAssociatedNode.execute(this, from);
            this.copyAssociated(self, associated, writeAssociatedNode);
            return self;
        }

        @Specialization(guards={"!areEqual(self, from)", "tstring.isNative()"})
        Object initializeCopyNative(RubyString self, RubyString from, @Cached @Cached.Shared RubyStringLibrary stringsFrom, @Cached @Cached.Shared StringHelperNodes.StringGetAssociatedNode stringGetAssociatedNode, @Cached @Cached.Shared WriteObjectFieldNode writeAssociatedNode, @Cached TruffleString.GetInternalNativePointerNode getInternalNativePointerNode, @Cached MutableTruffleString.FromNativePointerNode fromNativePointerNode, @Bind(value="from.tstring") AbstractTruffleString tstring) {
            RubyEncoding encoding = stringsFrom.getEncoding(this, (Object)from);
            TruffleString.Encoding tencoding = encoding.tencoding;
            Pointer fromPointer = (Pointer)getInternalNativePointerNode.execute(tstring, tencoding);
            Pointer newPointer = Pointer.mallocAutoRelease(this.getLanguage(), this.getContext(), fromPointer.getSize());
            newPointer.writeBytes(0L, fromPointer, 0, fromPointer.getSize());
            assert (tstring.isMutable());
            MutableTruffleString copy = fromNativePointerNode.execute((Object)newPointer, 0, tstring.byteLength(tencoding), tencoding, false);
            self.setTString((AbstractTruffleString)copy, encoding);
            Object associated = stringGetAssociatedNode.execute(this, (Object)from);
            this.copyAssociated(self, associated, writeAssociatedNode);
            return self;
        }

        protected static boolean areEqual(Object one, Object two) {
            return one == two;
        }

        private void copyAssociated(RubyString self, Object associated, WriteObjectFieldNode writeAssociatedNode) {
            if (associated != null) {
                writeAssociatedNode.execute(this, self, Layouts.ASSOCIATED_IDENTIFIER, associated);
            }
        }
    }

    @Primitive(name="string_get_coderange")
    public static abstract class GetCodeRangeAsIntNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int getCodeRange(Object string, @Cached RubyStringLibrary strings, @Cached TruffleString.GetByteCodeRangeNode codeRangeNode) {
            AbstractTruffleString tstring = strings.getTString(this, string);
            TruffleString.CodeRange codeRange = codeRangeNode.execute(tstring, strings.getTEncoding(this, string));
            if (codeRange == TruffleString.CodeRange.ASCII) {
                return 1;
            }
            if (codeRange == TruffleString.CodeRange.VALID) {
                return 2;
            }
            assert (codeRange == TruffleString.CodeRange.BROKEN);
            return 3;
        }
    }

    @Primitive(name="string_initialize")
    public static abstract class InitializeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyString initializeJavaString(RubyString string, String from, RubyEncoding encoding, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            TruffleString tstring = fromJavaStringNode.execute(from, encoding.tencoding);
            string.setTString((AbstractTruffleString)tstring, encoding);
            return string;
        }

        @Specialization
        RubyString initializeJavaStringNoEncoding(RubyString string, String from, Nil encoding) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("String.new(javaString) needs to be called with an Encoding like String.new(javaString, encoding: someEncoding)", this));
        }

        @Specialization(guards={"stringsFrom.isRubyString(this, from)"}, limit="1")
        RubyString initialize(RubyString string, Object from, Object encoding, @Cached @Cached.Exclusive RubyStringLibrary stringsFrom) {
            string.setTString(stringsFrom.getTString(this, from), stringsFrom.getEncoding(this, from));
            return string;
        }

        @Specialization(guards={"isNotRubyString(from)", "!isString(from)"})
        static RubyString initialize(VirtualFrame frame, RubyString string, Object from, Object encoding, @Cached @Cached.Exclusive RubyStringLibrary stringLibrary, @Cached ToStrNode toStrNode, @Bind(value="this") Node node) {
            Object stringFrom = toStrNode.execute(node, from);
            string.setTString(stringLibrary.getTString(node, stringFrom), stringLibrary.getEncoding(node, stringFrom));
            return string;
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        protected static final int CLASS_SALT = 54008340;

        public static HashNode create() {
            return StringNodesFactory.HashNodeFactory.create(null);
        }

        public abstract long execute(Object var1);

        @Specialization
        long hash(Object string, @Cached StringHelperNodes.HashStringNode hash) {
            return hash.execute(this, string);
        }
    }

    @CoreMethod(names={"getbyte"}, required=1, lowerFixnum={1})
    public static abstract class StringGetByteNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.ReadByteNode readByteNode = TruffleString.ReadByteNode.create();

        @Specialization
        Object getByte(Object string, int index, @Cached InlinedConditionProfile indexOutOfBoundsProfile, @Cached RubyStringLibrary libString, @Cached StringHelperNodes.NormalizeIndexNode normalizeIndexNode) {
            TruffleString.Encoding encoding;
            AbstractTruffleString tstring = libString.getTString(this, string);
            int byteLength = tstring.byteLength(encoding = libString.getEncoding((Node)this, (Object)string).tencoding);
            int normalizedIndex = normalizeIndexNode.executeNormalize(this, index, byteLength);
            if (indexOutOfBoundsProfile.profile((Node)this, normalizedIndex < 0 || normalizedIndex >= byteLength)) {
                return nil;
            }
            return this.readByteNode.execute(tstring, normalizedIndex, encoding);
        }
    }

    @CoreMethod(names={"force_encoding"}, required=1, raiseIfNotMutableSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class ForceEncodingNode
    extends CoreMethodArrayArgumentsNode {
        public abstract RubyString execute(Object var1, Object var2);

        protected abstract RubyString execute(Object var1, RubyEncoding var2);

        public static ForceEncodingNode create() {
            return StringNodesFactory.ForceEncodingNodeFactory.create(null);
        }

        @Specialization(guards={"string.getEncodingUnprofiled() == newEncoding"})
        RubyString sameEncoding(RubyString string, RubyEncoding newEncoding) {
            return string;
        }

        @Specialization(guards={"encoding != newEncoding", "tstring.isImmutable()"})
        RubyString immutable(RubyString string, RubyEncoding newEncoding, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared RubyStringLibrary profileEncoding, @Cached TruffleString.ForceEncodingNode forceEncodingNode, @Bind(value="string.tstring") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding) {
            RubyEncoding newEncodingProfiled = profileEncoding.profileEncoding(this, newEncoding);
            TruffleString newTString = forceEncodingNode.execute(tstring, encoding.tencoding, newEncodingProfiled.tencoding);
            string.setTString((AbstractTruffleString)newTString, newEncodingProfiled);
            return string;
        }

        @Specialization(guards={"encoding != newEncoding", "!tstring.isImmutable()", "!tstring.isNative()"})
        RubyString mutableManaged(RubyString string, RubyEncoding newEncoding, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared RubyStringLibrary profileEncoding, @Cached MutableTruffleString.ForceEncodingNode forceEncodingNode, @Bind(value="string.tstring") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding) {
            RubyEncoding newEncodingProfiled = profileEncoding.profileEncoding(this, newEncoding);
            MutableTruffleString newTString = forceEncodingNode.execute(tstring, encoding.tencoding, newEncodingProfiled.tencoding);
            string.setTString((AbstractTruffleString)newTString, newEncodingProfiled);
            return string;
        }

        @Specialization(guards={"encoding != newEncoding", "!tstring.isImmutable()", "tstring.isNative()"})
        RubyString mutableNative(RubyString string, RubyEncoding newEncoding, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared RubyStringLibrary profileEncoding, @Cached TruffleString.GetInternalNativePointerNode getInternalNativePointerNode, @Cached MutableTruffleString.FromNativePointerNode fromNativePointerNode, @Bind(value="string.tstring") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding) {
            RubyEncoding newEncodingProfiled = profileEncoding.profileEncoding(this, newEncoding);
            TruffleString.Encoding currentEncoding = encoding.tencoding;
            Pointer pointer = (Pointer)getInternalNativePointerNode.execute(tstring, currentEncoding);
            int byteLength = tstring.byteLength(currentEncoding);
            MutableTruffleString newTString = fromNativePointerNode.execute((Object)pointer, 0, byteLength, newEncodingProfiled.tencoding, false);
            string.setTString((AbstractTruffleString)newTString, newEncodingProfiled);
            return string;
        }

        @Specialization(guards={"libEncoding.isRubyString(this, newEncoding)"}, limit="1")
        static RubyString forceEncodingString(RubyString string, Object newEncoding, @Cached @Cached.Exclusive RubyStringLibrary libEncoding, @Cached ToJavaStringNode toJavaStringNode, @Cached InlinedBranchProfile errorProfile, @Cached @Cached.Exclusive ForceEncodingNode forceEncodingNode, @Bind(value="this") Node node) {
            String stringName = toJavaStringNode.execute(node, newEncoding);
            RubyEncoding rubyEncoding = ForceEncodingNode.getContext(node).getEncodingManager().getRubyEncoding(stringName);
            if (rubyEncoding == null) {
                errorProfile.enter(node);
                throw new RaiseException(ForceEncodingNode.getContext(node), ForceEncodingNode.coreExceptions(node).argumentError(Utils.concat((Object)"unknown encoding name - ", (Object)stringName), node));
            }
            return forceEncodingNode.execute((Object)string, rubyEncoding);
        }

        @Specialization(guards={"!isRubyEncoding(newEncoding)", "isNotRubyString(newEncoding)"})
        static RubyString forceEncoding(RubyString string, Object newEncoding, @Cached ToStrNode toStrNode, @Cached @Cached.Exclusive ForceEncodingNode forceEncodingNode, @Bind(value="this") Node node) {
            return forceEncodingNode.execute((Object)string, toStrNode.execute(node, newEncoding));
        }
    }

    @CoreMethod(names={"codepoints"}, needsBlock=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class CodePointsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object codePointsWithoutBlock(Object string, Nil unusedBlock, @Cached RubyStringLibrary strings, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached InlinedBranchProfile invalidCodePointProfile) {
            AbstractTruffleString tstring = strings.getTString(this, string);
            RubyEncoding encoding = strings.getEncoding(this, string);
            TruffleString.Encoding tencoding = encoding.tencoding;
            int codePointLength = codePointLengthNode.execute(tstring, tencoding);
            int[] codePoints = new int[codePointLength];
            TruffleStringIterator iterator = createCodePointIteratorNode.execute(tstring, tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
            int i = 0;
            while (iterator.hasNext()) {
                int codePoint = nextNode.execute(iterator);
                if (codePoint == -1) {
                    invalidCodePointProfile.enter((Node)this);
                    throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorInvalidByteSequence(encoding, this));
                }
                codePoints[i++] = codePoint;
            }
            return this.createArray(codePoints);
        }

        @Specialization
        Object codePointsWithBlock(Object string, RubyProc block, @Cached EachCodePointNode eachCodePointNode) {
            return eachCodePointNode.execute(string, block);
        }
    }

    @CoreMethod(names={"each_codepoint"}, needsBlock=true, enumeratorSize="size")
    @ImportStatic(value={StringGuards.class})
    public static abstract class EachCodePointNode
    extends CoreMethodArrayArgumentsNode {
        @NeverDefault
        public static EachCodePointNode create() {
            return StringNodesFactory.EachCodePointNodeFactory.create(null);
        }

        public abstract Object execute(Object var1, RubyProc var2);

        @Specialization
        Object eachCodePoint(Object string, RubyProc block, @Cached RubyStringLibrary strings, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached InlinedBranchProfile invalidCodePointProfile, @Cached CallBlockNode yieldNode) {
            AbstractTruffleString tstring = strings.getTString(this, string);
            RubyEncoding encoding = strings.getEncoding(this, string);
            TruffleString.Encoding tencoding = encoding.tencoding;
            TruffleStringIterator iterator = createCodePointIteratorNode.execute(tstring, tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
            while (iterator.hasNext()) {
                int codePoint = nextNode.execute(iterator);
                if (codePoint == -1) {
                    invalidCodePointProfile.enter((Node)this);
                    throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorInvalidByteSequence(encoding, this));
                }
                yieldNode.yield(this, block, codePoint);
            }
            return string;
        }
    }

    @CoreMethod(names={"chars"}, needsBlock=true)
    public static abstract class CharsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object charsWithoutBlock(Object string, Nil unusedBlock, @Cached RubyStringLibrary strings, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached TruffleString.ByteLengthOfCodePointNode byteLengthOfCodePointNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode) {
            int clen;
            AbstractTruffleString tstring = strings.getTString(this, string);
            RubyEncoding encoding = strings.getEncoding(this, string);
            TruffleString.Encoding tencoding = encoding.tencoding;
            int byteLength = tstring.byteLength(tencoding);
            int codePointLength = codePointLengthNode.execute(tstring, tencoding);
            Object[] chars = new Object[codePointLength];
            int characterIndex = 0;
            for (int i = 0; i < byteLength; i += clen) {
                clen = byteLengthOfCodePointNode.execute(tstring, i, encoding.tencoding);
                chars[characterIndex++] = this.createSubString(substringNode, tstring, encoding, i, clen);
            }
            return this.createArray(chars);
        }

        @Specialization
        Object charsWithBlock(Object string, RubyProc block, @Cached EachCharNode eachCharNode) {
            return eachCharNode.execute(string, block);
        }
    }

    @CoreMethod(names={"each_char"}, needsBlock=true, enumeratorSize="size")
    public static abstract class EachCharNode
    extends CoreMethodArrayArgumentsNode {
        @NeverDefault
        public static EachCharNode create() {
            return StringNodesFactory.EachCharNodeFactory.create(null);
        }

        public abstract Object execute(Object var1, RubyProc var2);

        @Specialization
        Object eachChar(Object string, RubyProc block, @Cached RubyStringLibrary strings, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached TruffleString.ByteLengthOfCodePointNode byteLengthOfCodePointNode, @Cached CallBlockNode yieldNode) {
            int clen;
            AbstractTruffleString tstring = strings.getTString(this, string);
            RubyEncoding encoding = strings.getEncoding(this, string);
            TruffleString.Encoding tencoding = encoding.tencoding;
            int byteLength = tstring.byteLength(tencoding);
            for (int i = 0; i < byteLength; i += clen) {
                clen = byteLengthOfCodePointNode.execute(tstring, i, tencoding);
                yieldNode.yield(this, block, new Object[]{this.createSubString(substringNode, tstring, encoding, i, clen)});
            }
            return string;
        }
    }

    @CoreMethod(names={"bytes"}, needsBlock=true)
    public static abstract class StringBytesNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"strings.seen(node, string)"}, limit="2")
        static RubyArray bytesWithoutBlock(Object string, Nil block, @Bind(value="this") Node node, @Cached RubyStringLibrary strings, @Cached TruffleString.MaterializeNode materializeNode, @Cached TruffleString.ReadByteNode readByteNode) {
            AbstractTruffleString tstring = strings.getTString(node, string);
            TruffleString.Encoding encoding = strings.getEncoding((Node)node, (Object)string).tencoding;
            int arrayLength = tstring.byteLength(encoding);
            int[] store = new int[arrayLength];
            materializeNode.execute(tstring, encoding);
            for (int i = 0; i < arrayLength; ++i) {
                store[i] = readByteNode.execute(tstring, i, encoding);
            }
            return StringBytesNode.createArray(node, store);
        }

        @Specialization
        Object bytesWithBlock(Object string, RubyProc block, @Cached EachByteNode eachByteNode) {
            return eachByteNode.execute(string, block);
        }
    }

    @CoreMethod(names={"each_byte"}, needsBlock=true, enumeratorSize="bytesize")
    public static abstract class EachByteNode
    extends CoreMethodArrayArgumentsNode {
        @NeverDefault
        public static EachByteNode create() {
            return StringNodesFactory.EachByteNodeFactory.create(null);
        }

        public abstract Object execute(Object var1, RubyProc var2);

        @Specialization(guards={"strings.seen(this, string)"}, limit="2")
        static Object eachByte(Object string, RubyProc block, @Cached RubyStringLibrary strings, @Cached TruffleString.MaterializeNode materializeNode, @Cached TruffleString.ReadByteNode readByteNode, @Cached CallBlockNode yieldNode, @Bind(value="this") Node node) {
            AbstractTruffleString tstring = strings.getTString(node, string);
            TruffleString.Encoding encoding = strings.getEncoding((Node)node, (Object)string).tencoding;
            materializeNode.execute(tstring, encoding);
            for (int i = 0; i < tstring.byteLength(encoding); ++i) {
                int singleByte = readByteNode.execute(tstring, i, encoding);
                yieldNode.yield(node, block, singleByte);
                tstring = strings.getTString(node, string);
                encoding = strings.getEncoding((Node)node, (Object)string).tencoding;
            }
            return string;
        }
    }

    @Primitive(name="string_downcase!", raiseIfNotMutable={0}, lowerFixnum={1})
    @ImportStatic(value={StringGuards.class, Config.class})
    public static abstract class StringDowncaseBangPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        private final ConditionProfile dummyEncodingProfile = ConditionProfile.create();

        @Specialization(guards={"!isComplexCaseMapping(this, tstring, encoding, caseMappingOptions, singleByteOptimizableNode)"})
        Object downcaseAsciiCodePoints(RubyString string, int caseMappingOptions, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached @Cached.Shared RubyStringLibrary libString, @Cached(value="createUpperToLower()") StringHelperNodes.InvertAsciiCaseNode invertAsciiCaseNode, @Bind(value="string.tstring") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding) {
            if (this.dummyEncodingProfile.profile(encoding.isDummy)) {
                throw new RaiseException(this.getContext(), this.coreExceptions().encodingCompatibilityErrorIncompatibleWithOperation(encoding, this));
            }
            return invertAsciiCaseNode.executeInvert(string);
        }

        @Specialization(guards={"isComplexCaseMapping(this, tstring, encoding, caseMappingOptions, singleByteOptimizableNode)"})
        Object downcaseMultiByteComplex(RubyString string, int caseMappingOptions, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Cached @Cached.Shared RubyStringLibrary libString, @Cached TruffleString.GetByteCodeRangeNode codeRangeNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.GetInternalByteArrayNode byteArrayNode, @Cached InlinedConditionProfile modifiedProfile, @Bind(value="string.tstring") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(this, string)") RubyEncoding encoding) {
            if (this.dummyEncodingProfile.profile(encoding.isDummy)) {
                throw new RaiseException(this.getContext(), this.coreExceptions().encodingCompatibilityErrorIncompatibleWithOperation(encoding, this));
            }
            InternalByteArray byteArray = byteArrayNode.execute(tstring, encoding.tencoding);
            ByteArrayBuilder builder = ByteArrayBuilder.create(byteArray);
            TruffleString.CodeRange cr = codeRangeNode.execute(string.tstring, encoding.tencoding);
            boolean modified = StringSupport.downcaseMultiByteComplex(encoding.jcoding, cr, builder, caseMappingOptions, this);
            if (modifiedProfile.profile((Node)this, modified)) {
                string.setTString((AbstractTruffleString)fromByteArrayNode.execute(builder.getBytes(), encoding.tencoding, false));
                return string;
            }
            return nil;
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class DeleteBangNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, RubyString var2, Object[] var3);

        @Specialization(guards={"args.length == size"}, limit="getDefaultCacheLimit()")
        static Object deleteBang(Node node, RubyString string, Object[] args, @Cached @Cached.Shared ToStrNode toStrNode, @Cached(inline=false) @Cached.Shared TruffleString.AsTruffleStringNode asTruffleStringNode, @Cached @Cached.Shared StringHelperNodes.DeleteBangStringsNode deleteBangStringsNode, @Cached @Cached.Shared RubyStringLibrary rubyStringLibrary, @Cached(value="args.length") int size) {
            TStringWithEncoding[] tstringsWithEncs = DeleteBangNode.argTStringsWithEncs(node, args, size, toStrNode, asTruffleStringNode, rubyStringLibrary);
            return deleteBangStringsNode.execute(node, string, tstringsWithEncs);
        }

        @Specialization(replaces={"deleteBang"})
        static Object deleteBangSlow(Node node, RubyString string, Object[] args, @Cached @Cached.Shared StringHelperNodes.DeleteBangStringsNode deleteBangStringsNode, @Cached(inline=false) @Cached.Shared TruffleString.AsTruffleStringNode asTruffleStringNode, @Cached @Cached.Shared RubyStringLibrary rubyStringLibrary, @Cached @Cached.Shared ToStrNode toStrNode) {
            TStringWithEncoding[] tstrings = DeleteBangNode.argTStringsWithEncsSlow(node, args, toStrNode, asTruffleStringNode, rubyStringLibrary);
            return deleteBangStringsNode.execute(node, string, tstrings);
        }

        @ExplodeLoop
        protected static TStringWithEncoding[] argTStringsWithEncs(Node node, Object[] args, int size, ToStrNode toStr, TruffleString.AsTruffleStringNode asTruffleStringNode, RubyStringLibrary rubyStringLibrary) {
            TStringWithEncoding[] strs = new TStringWithEncoding[size];
            for (int i = 0; i < size; ++i) {
                Object string = toStr.execute(node, args[i]);
                strs[i] = new TStringWithEncoding(asTruffleStringNode, rubyStringLibrary.getTString(node, string), rubyStringLibrary.getEncoding(node, string));
            }
            return strs;
        }

        protected static TStringWithEncoding[] argTStringsWithEncsSlow(Node node, Object[] args, ToStrNode toStr, TruffleString.AsTruffleStringNode asTruffleStringNode, RubyStringLibrary rubyStringLibrary) {
            TStringWithEncoding[] strs = new TStringWithEncoding[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object string = toStr.execute(node, args[i]);
                strs[i] = new TStringWithEncoding(asTruffleStringNode, rubyStringLibrary.getTString(node, string), rubyStringLibrary.getEncoding(node, string));
            }
            return strs;
        }
    }

    @CoreMethod(names={"delete!"}, rest=true, raiseIfNotMutableSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringDeleteBangNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object deleteBang(RubyString string, Object[] args, @Cached DeleteBangNode deleteBangNode) {
            return deleteBangNode.execute(this, string, args);
        }
    }

    @CoreMethod(names={"count"}, rest=true)
    public static abstract class CountNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"args.length == size"}, limit="getDefaultCacheLimit()")
        int count(Object string, Object[] args, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared TruffleString.AsTruffleStringNode asTruffleStringNode, @Cached @Cached.Shared StringHelperNodes.CountStringsNode countStringsNode, @Cached @Cached.Shared ToStrNode toStrNode, @Cached(value="args.length") int size) {
            TStringWithEncoding[] tstringsWithEncs = this.argTStringsWithEncs(args, size, toStrNode, libString, asTruffleStringNode);
            return countStringsNode.execute(string, tstringsWithEncs);
        }

        @Specialization(replaces={"count"})
        int countSlow(Object string, Object[] args, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared TruffleString.AsTruffleStringNode asTruffleStringNode, @Cached @Cached.Shared StringHelperNodes.CountStringsNode countStringsNode, @Cached @Cached.Shared ToStrNode toStrNode) {
            TStringWithEncoding[] tstringsWithEncs = this.argTStringsSlow(args, toStrNode, libString, asTruffleStringNode);
            return countStringsNode.execute(string, tstringsWithEncs);
        }

        @ExplodeLoop
        protected TStringWithEncoding[] argTStringsWithEncs(Object[] args, int size, ToStrNode toStr, RubyStringLibrary libString, TruffleString.AsTruffleStringNode asTruffleStringNode) {
            TStringWithEncoding[] strs = new TStringWithEncoding[args.length];
            for (int i = 0; i < size; ++i) {
                Object string = toStr.execute(this, args[i]);
                strs[i] = new TStringWithEncoding(asTruffleStringNode, libString.getTString(this, string), libString.getEncoding(this, string));
            }
            return strs;
        }

        protected TStringWithEncoding[] argTStringsSlow(Object[] args, ToStrNode toStr, RubyStringLibrary libString, TruffleString.AsTruffleStringNode asTruffleStringNode) {
            TStringWithEncoding[] strs = new TStringWithEncoding[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object string = toStr.execute(this, args[i]);
                strs[i] = new TStringWithEncoding(asTruffleStringNode, libString.getTString(this, string), libString.getEncoding(this, string));
            }
            return strs;
        }
    }

    @Primitive(name="string_end_with?")
    public static abstract class EndWithNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean endWithBytes(Object string, Object suffix, RubyEncoding enc, @Cached IsCharacterHeadNode isCharacterHeadNode, @Cached TruffleString.RegionEqualByteIndexNode regionEqualByteIndexNode, @Cached RubyStringLibrary strings, @Cached RubyStringLibrary stringsSuffix, @Cached InlinedConditionProfile isCharacterHeadProfile) {
            TruffleString.Encoding suffixEncoding;
            AbstractTruffleString suffixTString;
            int suffixByteLength;
            AbstractTruffleString stringTString = strings.getTString(this, string);
            RubyEncoding stringEncoding = strings.getEncoding(this, string);
            int stringByteLength = stringTString.byteLength(stringEncoding.tencoding);
            if (stringByteLength < (suffixByteLength = (suffixTString = stringsSuffix.getTString(this, suffix)).byteLength(suffixEncoding = stringsSuffix.getTEncoding(this, suffix)))) {
                return false;
            }
            if (suffixByteLength == 0) {
                return true;
            }
            int offset = stringByteLength - suffixByteLength;
            if (isCharacterHeadProfile.profile((Node)this, !isCharacterHeadNode.execute(stringEncoding, stringTString, offset))) {
                return false;
            }
            return regionEqualByteIndexNode.execute(stringTString, offset, suffixTString, 0, suffixByteLength, enc.tencoding);
        }
    }

    @Primitive(name="string_start_with?")
    public static abstract class StartWithNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean startWithBytes(Object string, Object prefix, RubyEncoding enc, @Cached TruffleString.RegionEqualByteIndexNode regionEqualByteIndexNode, @Cached RubyStringLibrary strings, @Cached RubyStringLibrary stringsSuffix) {
            TruffleString.Encoding prefixEncoding;
            AbstractTruffleString prefixTString;
            int prefixByteLength;
            TruffleString.Encoding stringEncoding;
            AbstractTruffleString stringTString = strings.getTString(this, string);
            int stringByteLength = stringTString.byteLength(stringEncoding = strings.getTEncoding(this, string));
            if (stringByteLength < (prefixByteLength = (prefixTString = stringsSuffix.getTString(this, prefix)).byteLength(prefixEncoding = stringsSuffix.getTEncoding(this, prefix)))) {
                return false;
            }
            if (prefixByteLength == 0) {
                return true;
            }
            return regionEqualByteIndexNode.execute(stringTString, 0, prefixTString, 0, prefixByteLength, enc.tencoding);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CaseCmpNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, Object var2, Object var3);

        @Specialization(guards={"bothSingleByteOptimizable(node, selfTString, selfEncoding, otherTString, otherEncoding, singleByteOptimizableNode)"})
        static Object caseCmpSingleByte(Node node, Object string, Object other, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared RubyStringLibrary libOther, @Cached @Cached.Shared InlinedConditionProfile incompatibleEncodingProfile, @Cached @Cached.Shared InlinedConditionProfile sameProfile, @Cached @Cached.Shared EncodingNodes.NegotiateCompatibleStringEncodingNode negotiateCompatibleEncodingNode, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Bind(value="libString.getTString(this, string)") AbstractTruffleString selfTString, @Bind(value="libString.getEncoding(this, string)") RubyEncoding selfEncoding, @Bind(value="libOther.getTString(this, other)") AbstractTruffleString otherTString, @Bind(value="libOther.getEncoding(this, other)") RubyEncoding otherEncoding, @Cached(inline=false) TruffleString.GetInternalByteArrayNode byteArraySelfNode, @Cached(inline=false) TruffleString.GetInternalByteArrayNode byteArrayOtherNode) {
            RubyEncoding encoding = negotiateCompatibleEncodingNode.execute(node, selfTString, selfEncoding, otherTString, otherEncoding);
            if (incompatibleEncodingProfile.profile(node, encoding == null)) {
                return nil;
            }
            InternalByteArray selfByteArray = byteArraySelfNode.execute(selfTString, selfEncoding.tencoding);
            InternalByteArray otherByteArray = byteArrayOtherNode.execute(otherTString, otherEncoding.tencoding);
            if (sameProfile.profile(node, selfTString == otherTString)) {
                return 0;
            }
            return CaseCmpNode.caseInsensitiveCmp(selfByteArray, otherByteArray);
        }

        @Specialization(guards={"!bothSingleByteOptimizable(node, selfTString, selfEncoding, otherTString, otherEncoding, singleByteOptimizableNode)"})
        static Object caseCmp(Node node, Object string, Object other, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared RubyStringLibrary libOther, @Cached @Cached.Shared InlinedConditionProfile incompatibleEncodingProfile, @Cached @Cached.Shared InlinedConditionProfile sameProfile, @Cached @Cached.Shared EncodingNodes.NegotiateCompatibleStringEncodingNode negotiateCompatibleEncodingNode, @Cached @Cached.Shared StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode, @Bind(value="libString.getTString(this, string)") AbstractTruffleString selfTString, @Bind(value="libString.getEncoding(this, string)") RubyEncoding selfEncoding, @Bind(value="libOther.getTString(this, other)") AbstractTruffleString otherTString, @Bind(value="libOther.getEncoding(this, other)") RubyEncoding otherEncoding) {
            RubyEncoding encoding = negotiateCompatibleEncodingNode.execute(node, selfTString, selfEncoding, otherTString, otherEncoding);
            if (incompatibleEncodingProfile.profile(node, encoding == null)) {
                return nil;
            }
            if (sameProfile.profile(node, selfTString == otherTString)) {
                return 0;
            }
            return StringSupport.multiByteCasecmp(encoding, selfTString, selfEncoding.tencoding, otherTString, otherEncoding.tencoding);
        }

        protected static boolean bothSingleByteOptimizable(Node node, AbstractTruffleString string, RubyEncoding stringEncoding, AbstractTruffleString other, RubyEncoding otherEncoding, StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode) {
            return singleByteOptimizableNode.execute(node, string, stringEncoding) && singleByteOptimizableNode.execute(node, other, otherEncoding);
        }

        @CompilerDirectives.TruffleBoundary
        private static int caseInsensitiveCmp(InternalByteArray value, InternalByteArray other) {
            int size = value.getLength();
            int len = Math.min(size, other.getLength());
            int offset = -1;
            while (++offset < len) {
                int otherCharIgnoreCase;
                int myCharIgnoreCase = AsciiTables.ToLowerCaseTable[value.get(offset) & 0xFF] & 0xFF;
                if (myCharIgnoreCase < (otherCharIgnoreCase = AsciiTables.ToLowerCaseTable[other.get(offset) & 0xFF] & 0xFF)) {
                    return -1;
                }
                if (myCharIgnoreCase <= otherCharIgnoreCase) continue;
                return 1;
            }
            return size == other.getLength() ? 0 : (size == len ? -1 : 1);
        }
    }

    @Primitive(name="string_casecmp")
    public static abstract class StringCaseCmpNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object caseCmp(Object string, Object other, @Cached ToStrNode toStrNode, @Cached CaseCmpNode caseCmpNode) {
            Object otherAsString = toStrNode.execute(this, other);
            return caseCmpNode.execute(this, string, otherAsString);
        }
    }

    @CoreMethod(names={"bytesize"})
    public static abstract class ByteSizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int byteSize(Object string, @Cached RubyStringLibrary libString) {
            return libString.byteLength(this, string);
        }
    }

    @CoreMethod(names={"ascii_only?"})
    public static abstract class ASCIIOnlyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean asciiOnly(Object string, @Cached TruffleString.GetByteCodeRangeNode codeRangeNode, @Cached RubyStringLibrary libString) {
            return StringGuards.is7Bit(libString.getTString(this, string), libString.getEncoding(this, string), codeRangeNode);
        }
    }

    @CoreMethod(names={"[]", "slice"}, required=1, optional=1, lowerFixnum={1, 2}, argumentNames={"index_start_range_string_or_regexp", "length_capture"})
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private StringSubstringPrimitiveNode substringNode;
        @Node.Child
        private ToLongNode toLongNode;
        @Node.Child
        private TruffleString.CodePointLengthNode codePointLengthNode;
        private final BranchProfile outOfBounds = BranchProfile.create();

        @Specialization
        Object getIndex(Object string, int index, NotProvided length, @Cached @Cached.Shared RubyStringLibrary strings) {
            return index == this.codePointLength(strings.getTString(this, string), strings.getEncoding(this, string)) ? this.outOfBoundsNil() : this.substring(string, index, 1);
        }

        @Specialization
        Object getIndex(Object string, long index, NotProvided length) {
            assert ((long)((int)index) != index) : "verified via lowerFixnum";
            return this.outOfBoundsNil();
        }

        @Specialization(guards={"!isRubyRange(index)", "!isRubyRegexp(index)", "isNotRubyString(index)"})
        Object getIndex(Object string, Object index, NotProvided length, @Cached @Cached.Shared ToLongNode toLongNode, @Cached @Cached.Shared RubyStringLibrary strings) {
            long indexLong = toLongNode.execute(this, index);
            int indexInt = (int)indexLong;
            return (long)indexInt != indexLong ? this.outOfBoundsNil() : this.getIndex(string, indexInt, length, strings);
        }

        @Specialization
        Object slice(Object string, int start, int length) {
            return this.substring(string, start, length);
        }

        @Specialization
        Object slice(Object string, long start, long length) {
            int startInt;
            int lengthInt = (int)length;
            if ((long)lengthInt != length) {
                lengthInt = Integer.MAX_VALUE;
            }
            return (long)(startInt = (int)start) != start ? this.outOfBoundsNil() : this.substring(string, startInt, lengthInt);
        }

        @Specialization(guards={"wasProvided(length)"})
        Object slice(Object string, long start, Object length, @Cached @Cached.Shared ToLongNode toLongNode) {
            return this.slice(string, start, toLongNode.execute(this, length));
        }

        @Specialization(guards={"!isRubyRange(start)", "!isRubyRegexp(start)", "isNotRubyString(start)", "wasProvided(length)"})
        Object slice(Object string, Object start, Object length, @Cached @Cached.Shared ToLongNode toLongNode) {
            return this.slice(string, toLongNode.execute(this, start), toLongNode.execute(this, length));
        }

        @Specialization(guards={"isRubyRange(range)"})
        Object sliceRange(Object string, Object range, NotProvided other, @Cached @Cached.Shared RubyStringLibrary strings, @Cached RangeNodes.NormalizedStartLengthNode startLengthNode, @Cached @Cached.Exclusive InlinedConditionProfile negativeStart) {
            int stringLength = this.codePointLength(strings.getTString(this, string), strings.getEncoding(this, string));
            int[] startLength = startLengthNode.execute(range, stringLength);
            int start = startLength[0];
            int length = Math.max(startLength[1], 0);
            if (negativeStart.profile((Node)this, start < 0)) {
                return Nil.INSTANCE;
            }
            return this.substring(string, start, length);
        }

        @Specialization
        static Object sliceCapture(VirtualFrame frame, Object string, RubyRegexp regexp, Object maybeCapture, @Cached @Cached.Exclusive DispatchNode callNode, @Cached ReadCallerVariablesNode readCallerVariablesNode, @Cached @Cached.Exclusive InlinedConditionProfile unsetProfile, @Cached @Cached.Exclusive InlinedConditionProfile sameThreadProfile, @Cached @Cached.Exclusive InlinedConditionProfile notMatchedProfile, @Cached @Cached.Exclusive InlinedConditionProfile captureSetProfile, @Bind(value="this") Node node) {
            Object capture = RubyGuards.wasProvided(maybeCapture) ? maybeCapture : Integer.valueOf(0);
            Object matchStrPair = callNode.call(GetIndexNode.getContext((Node)node).getCoreLibrary().truffleStringOperationsModule, "subpattern", string, (Object)regexp, capture);
            SpecialVariableStorage variables = readCallerVariablesNode.execute((Frame)frame);
            if (notMatchedProfile.profile(node, matchStrPair == nil)) {
                variables.setLastMatch(node, nil, GetIndexNode.getContext(node), unsetProfile, sameThreadProfile);
                return nil;
            }
            Object[] array = (Object[])((RubyArray)matchStrPair).getStore();
            Object matchData = array[0];
            Object captureStringOrNil = array[1];
            variables.setLastMatch(node, matchData, GetIndexNode.getContext(node), unsetProfile, sameThreadProfile);
            if (captureSetProfile.profile(node, captureStringOrNil != nil)) {
                return captureStringOrNil;
            }
            return nil;
        }

        @Specialization(guards={"stringsMatchStr.isRubyString(this, matchStr)"}, limit="1")
        static Object slice2(Object string, Object matchStr, NotProvided length, @Cached @Cached.Exclusive RubyStringLibrary stringsMatchStr, @Cached @Cached.Exclusive DispatchNode includeNode, @Cached BooleanCastNode booleanCastNode, @Cached TruffleString.AsTruffleStringNode asTruffleStringNode, @Bind(value="this") Node node) {
            Object included = includeNode.call(string, "include?", matchStr);
            if (booleanCastNode.execute(node, included)) {
                RubyEncoding encoding = stringsMatchStr.getEncoding(node, matchStr);
                return GetIndexNode.createStringCopy(node, asTruffleStringNode, stringsMatchStr.getTString(node, matchStr), encoding);
            }
            return nil;
        }

        private Object outOfBoundsNil() {
            this.outOfBounds.enter();
            return nil;
        }

        private Object substring(Object string, int start, int length) {
            if (this.substringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.substringNode = (StringSubstringPrimitiveNode)this.insert(StringNodesFactory.StringSubstringPrimitiveNodeFactory.create(null));
            }
            return this.substringNode.execute(string, start, length);
        }

        private int codePointLength(AbstractTruffleString string, RubyEncoding encoding) {
            if (this.codePointLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.codePointLengthNode = (TruffleString.CodePointLengthNode)this.insert((Node)TruffleString.CodePointLengthNode.create());
            }
            return this.codePointLengthNode.execute(string, encoding.tencoding);
        }
    }

    @CoreMethod(names={"concat"}, optional=1, rest=true, raiseIfNotMutableSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringConcatNode
    extends CoreMethodArrayArgumentsNode {
        @NeverDefault
        public static StringConcatNode create() {
            return StringNodesFactory.StringConcatNodeFactory.create(null);
        }

        public abstract Object executeConcat(RubyString var1, Object var2, Object[] var3);

        @Specialization(guards={"rest.length == 0"})
        RubyString concatZero(RubyString string, NotProvided first, Object[] rest) {
            return string;
        }

        @Specialization(guards={"rest.length == 0", "libFirst.isRubyString(node, first)"}, limit="1")
        static RubyString concat(RubyString string, Object first, Object[] rest, @Bind(value="this") Node node, @Cached StringAppendPrimitiveNode stringAppendNode, @Cached @Cached.Exclusive RubyStringLibrary libFirst) {
            return stringAppendNode.executeStringAppend(string, first);
        }

        @Specialization(guards={"rest.length == 0", "isNotRubyString(first)", "wasProvided(first)"})
        Object concatGeneric(RubyString string, Object first, Object[] rest, @Cached DispatchNode callNode) {
            return callNode.call(this.coreLibrary().truffleStringOperationsModule, "concat_internal", (Object)string, first);
        }

        @ExplodeLoop
        @Specialization(guards={"wasProvided(first)", "rest.length > 0", "rest.length == cachedLength", "cachedLength <= MAX_EXPLODE_SIZE"}, limit="getDefaultCacheLimit()")
        Object concatMany(RubyString string, Object first, Object[] rest, @Cached @Cached.Shared RubyStringLibrary libString, @Cached(value="rest.length") int cachedLength, @Cached @Cached.Shared StringConcatNode argConcatNode, @Cached @Cached.Shared TruffleString.AsTruffleStringNode asTruffleStringNode, @Cached @Cached.Shared InlinedConditionProfile selfArgProfile) {
            AbstractTruffleString tstring = string.tstring;
            Object result = argConcatNode.executeConcat(string, first, EMPTY_ARGUMENTS);
            for (int i = 0; i < cachedLength; ++i) {
                Object arg = rest[i];
                Object argOrCopy = selfArgProfile.profile((Node)this, arg == string) ? this.createStringCopy(asTruffleStringNode, tstring, libString.getEncoding(this, (Object)string)) : arg;
                result = argConcatNode.executeConcat(string, argOrCopy, EMPTY_ARGUMENTS);
            }
            return result;
        }

        @Specialization(guards={"wasProvided(first)", "rest.length > 0"}, replaces={"concatMany"})
        Object concatManyGeneral(RubyString string, Object first, Object[] rest, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared StringConcatNode argConcatNode, @Cached @Cached.Shared TruffleString.AsTruffleStringNode asTruffleStringNode, @Cached @Cached.Shared InlinedConditionProfile selfArgProfile) {
            AbstractTruffleString tstring = string.tstring;
            Object result = argConcatNode.executeConcat(string, first, EMPTY_ARGUMENTS);
            for (Object arg : rest) {
                Object argOrCopy = selfArgProfile.profile((Node)this, arg == string) ? this.createStringCopy(asTruffleStringNode, tstring, libString.getEncoding(this, (Object)string)) : arg;
                result = argConcatNode.executeConcat(string, argOrCopy, EMPTY_ARGUMENTS);
            }
            return result;
        }
    }

    @CoreMethod(names={"<<"}, required=1, raiseIfNotMutableSelf=true, split=Split.ALWAYS)
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringConcatOneNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"libFirst.isRubyString(node, first)"}, limit="1")
        static RubyString concat(RubyString string, Object first, @Bind(value="this") Node node, @Cached StringAppendPrimitiveNode stringAppendNode, @Cached RubyStringLibrary libFirst) {
            return stringAppendNode.executeStringAppend(string, first);
        }

        @Specialization(guards={"isNotRubyString(first)"})
        Object concatGeneric(RubyString string, Object first, @Cached DispatchNode callNode) {
            return callNode.call(this.coreLibrary().truffleStringOperationsModule, "concat_internal", (Object)string, first);
        }
    }

    @Primitive(name="dup_as_string_instance")
    public static abstract class StringDupAsStringInstanceNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyString dupAsStringInstance(Object string, @Cached RubyStringLibrary strings, @Cached TruffleString.AsTruffleStringNode asTruffleStringNode) {
            RubyEncoding encoding = strings.getEncoding(this, string);
            return this.createStringCopy(asTruffleStringNode, strings.getTString(this, string), encoding);
        }
    }

    @Primitive(name="string_cmp")
    public static abstract class CompareNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"first.isEmpty() || second.isEmpty()"})
        int empty(Object a, Object b, RubyEncoding compatibleEncoding, @Cached @Cached.Shared RubyStringLibrary libA, @Cached @Cached.Shared RubyStringLibrary libB, @Bind(value="libA.getTString(this, a)") AbstractTruffleString first, @Bind(value="libB.getTString(this, b)") AbstractTruffleString second, @Cached @Cached.Exclusive InlinedConditionProfile bothEmpty) {
            if (bothEmpty.profile((Node)this, first.isEmpty() && second.isEmpty())) {
                return 0;
            }
            return first.isEmpty() ? -1 : 1;
        }

        @Specialization(guards={"!first.isEmpty()", "!second.isEmpty()"})
        int compatible(Object a, Object b, RubyEncoding compatibleEncoding, @Cached @Cached.Shared RubyStringLibrary libA, @Cached @Cached.Shared RubyStringLibrary libB, @Bind(value="libA.getTString(this, a)") AbstractTruffleString first, @Bind(value="libB.getTString(this, b)") AbstractTruffleString second, @Cached @Cached.Shared InlinedConditionProfile sameStringProfile, @Cached @Cached.Shared TruffleString.CompareBytesNode compareBytesNode, @Cached @Cached.Shared InlinedConditionProfile equalProfile, @Cached @Cached.Shared InlinedConditionProfile positiveProfile) {
            if (sameStringProfile.profile((Node)this, first == second)) {
                return 0;
            }
            int result = compareBytesNode.execute(first, second, compatibleEncoding.tencoding);
            if (equalProfile.profile((Node)this, result == 0)) {
                return 0;
            }
            return positiveProfile.profile((Node)this, result > 0) ? 1 : -1;
        }

        @Specialization
        int notCompatible(Object a, Object b, Nil compatibleEncoding, @Cached @Cached.Shared RubyStringLibrary libA, @Cached @Cached.Shared RubyStringLibrary libB, @Cached @Cached.Shared InlinedConditionProfile sameStringProfile, @Cached @Cached.Shared TruffleString.CompareBytesNode compareBytesNode, @Cached TruffleString.ForceEncodingNode forceEncoding1Node, @Cached TruffleString.ForceEncodingNode forceEncoding2Node, @Cached @Cached.Shared InlinedConditionProfile equalProfile, @Cached @Cached.Shared InlinedConditionProfile positiveProfile, @Cached @Cached.Exclusive InlinedConditionProfile encodingIndexGreaterThanProfile) {
            TruffleString secondBinary;
            AbstractTruffleString first = libA.getTString(this, a);
            RubyEncoding firstEncoding = libA.getEncoding(this, a);
            AbstractTruffleString second = libB.getTString(this, b);
            RubyEncoding secondEncoding = libB.getEncoding(this, b);
            if (sameStringProfile.profile((Node)this, first == second)) {
                return 0;
            }
            TruffleString firstBinary = forceEncoding1Node.execute(first, firstEncoding.tencoding, Encodings.BINARY.tencoding);
            int result = compareBytesNode.execute((AbstractTruffleString)firstBinary, (AbstractTruffleString)(secondBinary = forceEncoding2Node.execute(second, secondEncoding.tencoding, Encodings.BINARY.tencoding)), Encodings.BINARY.tencoding);
            if (equalProfile.profile((Node)this, result == 0)) {
                if (encodingIndexGreaterThanProfile.profile((Node)this, firstEncoding.index > secondEncoding.index)) {
                    return 1;
                }
                return -1;
            }
            return positiveProfile.profile((Node)this, result > 0) ? 1 : -1;
        }
    }

    @CoreMethod(names={"==", "===", "eql?"}, required=1, alwaysInlined=true)
    @ImportStatic(value={RubyArguments.class})
    @GenerateUncached
    public static abstract class EqualNode
    extends AlwaysInlinedMethodNode {
        @Specialization(guards={"libOther.isRubyString(this, other)"}, limit="1")
        static boolean equalString(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached RubyStringLibrary libSelf, @Cached RubyStringLibrary libOther, @Cached EncodingNodes.NegotiateCompatibleStringEncodingNode negotiateCompatibleStringEncodingNode, @Cached StringHelperNodes.StringEqualInternalNode stringEqualInternalNode, @Bind(value="getArgument(rubyArgs, 0)") Object other, @Bind(value="this") Node node) {
            AbstractTruffleString tstringSelf = libSelf.getTString(node, self);
            RubyEncoding encSelf = libSelf.getEncoding(node, self);
            AbstractTruffleString tstringOther = libOther.getTString(node, other);
            RubyEncoding encOther = libOther.getEncoding(node, other);
            RubyEncoding compatibleEncoding = negotiateCompatibleStringEncodingNode.execute(node, tstringSelf, encSelf, tstringOther, encOther);
            return stringEqualInternalNode.executeInternal(node, tstringSelf, tstringOther, compatibleEncoding);
        }

        @Specialization(guards={"isNotRubyString(other)"})
        boolean equal(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached KernelNodes.RespondToNode respondToNode, @Cached DispatchNode objectEqualNode, @Cached BooleanCastNode booleanCastNode, @Bind(value="getArgument(rubyArgs, 0)") Object other) {
            if (respondToNode.executeDoesRespondTo(other, this.coreSymbols().TO_STR, false)) {
                return booleanCastNode.execute(this, objectEqualNode.call(other, "==", self));
            }
            return false;
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class MulNode
    extends RubyBaseNode {
        public abstract RubyString execute(Node var1, Object var2, Object var3);

        @Specialization(guards={"times == 0"})
        static RubyString multiplyZero(Node node, Object string, int times, @Cached @Cached.Shared RubyStringLibrary libString) {
            RubyEncoding encoding = libString.getEncoding(node, string);
            return MulNode.createString(node, encoding.tencoding.getEmpty(), encoding);
        }

        @Specialization(guards={"times < 0"})
        static RubyString multiplyTimesNegative(Node node, Object string, long times) {
            throw new RaiseException(MulNode.getContext(node), MulNode.coreExceptions(node).argumentError("negative argument", node));
        }

        @Specialization(guards={"times > 0", "!libString.getTString(this, string).isEmpty()"})
        static RubyString multiply(Node node, Object string, int times, @Cached InlinedBranchProfile tooBigProfile, @Cached @Cached.Shared RubyStringLibrary libString, @Cached(inline=false) TruffleString.RepeatNode repeatNode) {
            AbstractTruffleString tstring = libString.getTString(node, string);
            RubyEncoding encoding = libString.getEncoding(node, string);
            long longLength = (long)times * (long)tstring.byteLength(encoding.tencoding);
            if (longLength > Integer.MAX_VALUE) {
                tooBigProfile.enter(node);
                throw MulNode.tooBig(node);
            }
            return MulNode.createString(node, repeatNode.execute(tstring, times, encoding.tencoding), encoding);
        }

        @Specialization(guards={"times > 0", "libString.getTString(this, string).isEmpty()"})
        static RubyString multiplyEmpty(Node node, Object string, long times, @Cached @Cached.Shared RubyStringLibrary libString) {
            RubyEncoding encoding = libString.getEncoding(node, string);
            return MulNode.createString(node, encoding.tencoding.getEmpty(), encoding);
        }

        @Specialization(guards={"times > 0", "!libString.getTString(this, string).isEmpty()"})
        static RubyString multiplyNonEmpty(Node node, Object string, long times, @Cached @Cached.Shared RubyStringLibrary libString) {
            assert (!CoreLibrary.fitsIntoInteger(times));
            throw MulNode.tooBig(node);
        }

        private static RaiseException tooBig(Node node) {
            return new RaiseException(MulNode.getContext(node), MulNode.coreExceptions(node).argumentError("argument too big", node));
        }
    }

    @CoreMethod(names={"*"}, required=1)
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringMulNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString doMul(Object string, Object timesObject, @Cached FixnumLowerNode fixnumLowerNode, @Cached ToLongNode toLongNode, @Cached MulNode mulNode) {
            Object times = fixnumLowerNode.execute(this, toLongNode.execute(this, timesObject));
            return mulNode.execute(this, string, times);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    @ImportStatic(value={StringGuards.class})
    public static abstract class AddNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString add(Object string, Object other, @Cached ToStrNode toStrNode, @Cached StringHelperNodes.StringAppendNode stringAppendNode) {
            Object otherAsString = toStrNode.execute(this, other);
            return stringAppendNode.executeStringAppend(this, string, otherAsString);
        }
    }

    @CoreMethod(names={"encoding"})
    public static abstract class EncodingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyEncoding encoding(Object string, @Cached RubyStringLibrary libString) {
            return libString.getEncoding(this, string);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class AllocateNode
    extends RubyBaseNode {
        public abstract RubyString execute(Node var1, RubyClass var2);

        @Specialization
        static RubyString allocate(Node node, RubyClass rubyClass) {
            RubyString string = new RubyString(rubyClass, AllocateNode.getLanguage((Node)node).stringShape, false, (AbstractTruffleString)TStringConstants.EMPTY_BINARY, Encodings.BINARY);
            AllocationTracing.trace(string, node);
            return string;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class StringAllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString allocate(RubyClass rubyClass, @Cached AllocateNode allocateNode) {
            return allocateNode.execute(this, rubyClass);
        }
    }
}

