/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.strings.AbstractTruffleString;
import org.graalvm.shadowed.org.jcodings.Encoding;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.RubyString;

public abstract class StringOperations {
    public static RubyString createUTF8String(RubyContext context, RubyLanguage language, String string) {
        RubyString instance = new RubyString(context.getCoreLibrary().stringClass, language.stringShape, false, (AbstractTruffleString)TStringUtils.utf8TString(string), Encodings.UTF_8);
        return instance;
    }

    public static RubyString createUTF8String(RubyContext context, RubyLanguage language, AbstractTruffleString string) {
        RubyString instance = new RubyString(context.getCoreLibrary().stringClass, language.stringShape, false, string, Encodings.UTF_8);
        return instance;
    }

    public static boolean isAsciiOnly(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Encoding.isAscii((int)c)) continue;
            return false;
        }
        return true;
    }

    public static byte[] encodeAsciiBytes(String value) {
        assert (StringOperations.isAsciiOnly(value)) : "String contained non ascii characters \"" + value + "\"";
        byte[] bytes = new byte[value.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)value.charAt(i);
        }
        return bytes;
    }
}

