/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import java.util.Objects;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;

public final class TBytesKey {
    private final byte[] bytes;
    private final int offset;
    private final int length;
    private RubyEncoding encoding;
    private final int bytesHashCode;

    public TBytesKey(byte[] bytes, int offset, int length, int bytesHashCode, RubyEncoding encoding) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.bytesHashCode = bytesHashCode;
        this.encoding = encoding;
    }

    public TBytesKey(byte[] bytes, RubyEncoding encoding) {
        this(bytes, 0, bytes.length, Arrays.hashCode(bytes), encoding);
    }

    public TBytesKey(InternalByteArray byteArray, RubyEncoding encoding) {
        this(byteArray.getArray(), byteArray.getOffset(), byteArray.getLength(), TBytesKey.hashCode(byteArray), encoding);
    }

    public int hashCode() {
        return this.bytesHashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof TBytesKey) {
            TBytesKey other = (TBytesKey)o;
            if (this.encoding == null) {
                if (this.equalBytes(this, other)) {
                    this.encoding = Objects.requireNonNull(other.encoding);
                    return true;
                }
                return false;
            }
            return this.encoding == other.encoding && this.equalBytes(this, other);
        }
        return false;
    }

    public RubyEncoding getMatchedEncoding() {
        return this.encoding;
    }

    public String toString() {
        TruffleString.Encoding encoding = this.encoding != null ? this.encoding.tencoding : TruffleString.Encoding.BYTES;
        return TruffleString.fromByteArrayUncached((byte[])this.bytes, (TruffleString.Encoding)encoding, (boolean)false).toString();
    }

    private static int hashCode(InternalByteArray byteArray) {
        return TBytesKey.hashCode(byteArray.getArray(), byteArray.getOffset(), byteArray.getLength());
    }

    private static int hashCode(byte[] bytes, int offset, int length) {
        int result = 1;
        for (int i = offset; i < offset + length; ++i) {
            result = 31 * result + bytes[i];
        }
        return result;
    }

    private boolean equalBytes(TBytesKey a, TBytesKey b) {
        return Arrays.equals(a.bytes, a.offset, a.offset + a.length, b.bytes, b.offset, b.offset + b.length);
    }

    private boolean isPerfectFit() {
        return this.offset == 0 && this.length == this.bytes.length;
    }

    public TBytesKey makeCacheable(boolean isImmutable) {
        if (isImmutable && this.isPerfectFit()) {
            return this;
        }
        byte[] resolvedSubstring = ArrayUtils.extractRange(this.bytes, this.offset, this.offset + this.length);
        return new TBytesKey(resolvedSubstring, this.encoding);
    }

    public TBytesKey withNewEncoding(RubyEncoding encoding) {
        return new TBytesKey(this.bytes, this.offset, this.length, this.bytesHashCode, encoding);
    }

    public TruffleString toTruffleString() {
        return TStringUtils.fromByteArray(this.bytes, this.offset, this.length, this.encoding.tencoding);
    }
}

