/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.core.numeric.FixnumOrBignumNode;
import org.truffleruby.core.numeric.FixnumOrBignumNodeGen;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.support.GetRandomIntNode;
import org.truffleruby.core.support.RandomizerNodes;
import org.truffleruby.core.support.RubyRandomizer;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyTypesGen;

@GeneratedBy(value=RandomizerNodes.class)
public final class RandomizerNodesFactory {
    public static List<NodeFactory<? extends CoreMethodArrayArgumentsNode>> getFactories() {
        return List.of(RandomFloatNodeFactory.getInstance(), RandomIntNodeFactory.getInstance());
    }

    @GeneratedBy(value=RandomizerNodes.RandomFloatNode.class)
    public static final class RandomFloatNodeFactory
    implements NodeFactory<RandomizerNodes.RandomFloatNode> {
        private static final RandomFloatNodeFactory RANDOM_FLOAT_NODE_FACTORY_INSTANCE = new RandomFloatNodeFactory();

        private RandomFloatNodeFactory() {
        }

        public Class<RandomizerNodes.RandomFloatNode> getNodeClass() {
            return RandomizerNodes.RandomFloatNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public RandomizerNodes.RandomFloatNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return RandomFloatNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RandomizerNodes.RandomFloatNode> getInstance() {
            return RANDOM_FLOAT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static RandomizerNodes.RandomFloatNode create(RubyNode[] argumentNodes) {
            return new RandomFloatNodeGen(argumentNodes);
        }

        @GeneratedBy(value=RandomizerNodes.RandomFloatNode.class)
        public static final class RandomFloatNodeGen
        extends RandomizerNodes.RandomFloatNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GetRandomIntNode getRandomIntNode_;

            private RandomFloatNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyRandomizer) {
                    RubyRandomizer argumentNodes0Value__ = (RubyRandomizer)((Object)argumentNodes0Value_);
                    GetRandomIntNode getRandomIntNode__ = this.getRandomIntNode_;
                    if (getRandomIntNode__ != null) {
                        return this.randomFloat(argumentNodes0Value__, getRandomIntNode__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private double executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyRandomizer) {
                    RubyRandomizer argumentNodes0Value_ = (RubyRandomizer)((Object)argumentNodes0Value);
                    GetRandomIntNode getRandomIntNode__ = (GetRandomIntNode)this.insert(GetRandomIntNode.create());
                    Objects.requireNonNull(getRandomIntNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.getRandomIntNode_ = getRandomIntNode__;
                    this.state_0_ = state_0 |= 1;
                    return this.randomFloat(argumentNodes0Value_, getRandomIntNode__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=RandomizerNodes.RandomIntNode.class)
    public static final class RandomIntNodeFactory
    implements NodeFactory<RandomizerNodes.RandomIntNode> {
        private static final RandomIntNodeFactory RANDOM_INT_NODE_FACTORY_INSTANCE = new RandomIntNodeFactory();

        private RandomIntNodeFactory() {
        }

        public Class<RandomizerNodes.RandomIntNode> getNodeClass() {
            return RandomizerNodes.RandomIntNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public RandomizerNodes.RandomIntNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return RandomIntNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RandomizerNodes.RandomIntNode> getInstance() {
            return RANDOM_INT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static RandomizerNodes.RandomIntNode create(RubyNode[] argumentNodes) {
            return new RandomIntNodeGen(argumentNodes);
        }

        @GeneratedBy(value=RandomizerNodes.RandomIntNode.class)
        public static final class RandomIntNodeGen
        extends RandomizerNodes.RandomIntNode {
            private static final InlineSupport.StateField STATE_0_RandomIntNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final FixnumOrBignumNode INLINED_RANDOMIZER_RAND_INT2_FIXNUM_OR_BIGNUM_ = FixnumOrBignumNodeGen.inline(InlineSupport.InlineTarget.create(FixnumOrBignumNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_RandomIntNode_UPDATER.subUpdater(5, 4)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private RandomIntNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if ((state_0 & 7) != 0 && argumentNodes0Value_ instanceof RubyRandomizer) {
                    RubyRandomizer argumentNodes0Value__ = (RubyRandomizer)((Object)argumentNodes0Value_);
                    if ((state_0 & 1) != 0 && argumentNodes1Value_ instanceof Integer) {
                        int argumentNodes1Value__ = (Integer)argumentNodes1Value_;
                        return this.randomizerRandInt(argumentNodes0Value__, argumentNodes1Value__);
                    }
                    if ((state_0 & 2) != 0 && RubyTypesGen.isImplicitLong((state_0 & 0x18) >>> 3, argumentNodes1Value_)) {
                        long argumentNodes1Value__ = RubyTypesGen.asImplicitLong((state_0 & 0x18) >>> 3, argumentNodes1Value_);
                        return this.randomizerRandInt(argumentNodes0Value__, argumentNodes1Value__);
                    }
                    if ((state_0 & 4) != 0 && argumentNodes1Value_ instanceof RubyBignum) {
                        RubyBignum argumentNodes1Value__ = (RubyBignum)argumentNodes1Value_;
                        return this.randomizerRandInt(argumentNodes0Value__, argumentNodes1Value__, INLINED_RANDOMIZER_RAND_INT2_FIXNUM_OR_BIGNUM_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyRandomizer) {
                    RubyRandomizer argumentNodes0Value_ = (RubyRandomizer)((Object)argumentNodes0Value);
                    if (argumentNodes1Value instanceof Integer) {
                        int argumentNodes1Value_ = (Integer)argumentNodes1Value;
                        this.state_0_ = state_0 |= 1;
                        return this.randomizerRandInt(argumentNodes0Value_, argumentNodes1Value_);
                    }
                    int longCast1 = RubyTypesGen.specializeImplicitLong(argumentNodes1Value);
                    if (longCast1 != 0) {
                        long argumentNodes1Value_ = RubyTypesGen.asImplicitLong(longCast1, argumentNodes1Value);
                        state_0 |= longCast1 << 3;
                        this.state_0_ = state_0 |= 2;
                        return this.randomizerRandInt(argumentNodes0Value_, argumentNodes1Value_);
                    }
                    if (argumentNodes1Value instanceof RubyBignum) {
                        RubyBignum argumentNodes1Value_ = (RubyBignum)argumentNodes1Value;
                        this.state_0_ = state_0 |= 4;
                        return this.randomizerRandInt(argumentNodes0Value_, argumentNodes1Value_, INLINED_RANDOMIZER_RAND_INT2_FIXNUM_OR_BIGNUM_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }
}

