/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.Source;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.language.CallStackManager;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.loader.CodeLoader;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.parser.BlockDescriptorInfo;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.RubySource;
import org.truffleruby.parser.TranslatorEnvironment;

public abstract class DebugHelpers {
    public static Object eval(String code, Object ... arguments) {
        return DebugHelpers.eval(RubyLanguage.getCurrentContext(), code, arguments);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object eval(RubyContext context, String code, Object ... arguments) {
        Frame currentFrame = context.getCallStack().getCurrentFrame(FrameInstance.FrameAccess.MATERIALIZE);
        FrameDescriptor currentFrameDescriptor = currentFrame.getFrameDescriptor();
        assert (CallStackManager.isRubyFrame(currentFrame));
        if (arguments.length % 2 == 1) {
            throw CompilerDirectives.shouldNotReachHere((String)"odd number of name-value pairs for arguments");
        }
        int nArgs = arguments.length / 2;
        DeclarationContext declarationContext = RubyArguments.getDeclarationContext(currentFrame);
        LexicalScope lexicalScope = RubyArguments.getMethod(currentFrame).getLexicalScope();
        Object[] packedArguments = RubyArguments.pack(null, null, RubyArguments.getMethod(currentFrame), declarationContext, null, RubyArguments.getSelf(currentFrame), Nil.INSTANCE, NoKeywordArgumentsDescriptor.INSTANCE, RubyNode.EMPTY_ARGUMENTS);
        FrameDescriptor.Builder builder = TranslatorEnvironment.newFrameDescriptorBuilderForBlock(new BlockDescriptorInfo(currentFrameDescriptor));
        for (int i = 0; i < nArgs; ++i) {
            Object identifier = arguments[i * 2];
            assert (!(identifier == null || identifier instanceof String && ((String)identifier).isEmpty()));
            int slot = builder.addSlot(FrameSlotKind.Object, identifier, null);
            assert (slot == i);
        }
        FrameDescriptor frameDescriptor = builder.build();
        MaterializedFrame evalFrame = Truffle.getRuntime().createMaterializedFrame(packedArguments, frameDescriptor);
        for (int i = 0; i < nArgs; ++i) {
            evalFrame.setObject(i, arguments[i * 2 + 1]);
        }
        Source source = Source.newBuilder((String)"ruby", (CharSequence)code, (String)"debug-eval").build();
        RootCallTarget callTarget = context.getCodeLoader().parse(new RubySource(source, "debug-eval"), ParserContext.INLINE, evalFrame, lexicalScope, null);
        CodeLoader.DeferredCall deferredCall = context.getCodeLoader().prepareExecute(callTarget, ParserContext.INLINE, declarationContext, evalFrame, RubyArguments.getSelf((Frame)evalFrame), lexicalScope);
        return deferredCall.callWithoutCallNode();
    }
}

