/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.extra;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import java.lang.invoke.VarHandle;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Split;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveNode;
import org.truffleruby.core.cast.ToCallTargetNode;
import org.truffleruby.core.proc.ProcCallTargets;
import org.truffleruby.core.proc.ProcType;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.language.RubyLambdaRootNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.literal.ObjectLiteralNode;
import org.truffleruby.language.locals.ReadDeclarationVariableNode;
import org.truffleruby.language.locals.WriteDeclarationVariableNode;
import org.truffleruby.language.threadlocal.SpecialVariableStorage;

@CoreModule(value="Truffle::Graal")
public abstract class TruffleGraalNodes {

    @CoreMethod(names={"total_compilation_time"}, onSingleton=true)
    public static abstract class TotalCompilationTimeNode
    extends CoreMethodArrayArgumentsNode {
        private static CompilationMXBean bean;

        @CompilerDirectives.TruffleBoundary
        @Specialization
        @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC"})
        long totalCompilationTime() {
            if (bean == null) {
                CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
                VarHandle.storeStoreFence();
                bean = compilationMXBean;
            }
            return bean.getTotalCompilationTime();
        }
    }

    @CoreMethod(names={"boundary_allow_inlining"}, onSingleton=true)
    public static abstract class BoundaryAllowInliningNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        @Specialization
        Object boundaryAllowInlining() {
            return nil;
        }
    }

    @CoreMethod(names={"boundary"}, onSingleton=true)
    public static abstract class BoundaryNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary(allowInlining=false)
        @Specialization
        Object boundary() {
            return nil;
        }
    }

    @Primitive(name="blackhole")
    public static abstract class BlackholeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object blackhole(boolean value) {
            CompilerDirectives.blackhole((boolean)value);
            return nil;
        }

        @Specialization
        Object blackhole(int value) {
            CompilerDirectives.blackhole((int)value);
            return nil;
        }

        @Specialization
        Object blackhole(long value) {
            CompilerDirectives.blackhole((long)value);
            return nil;
        }

        @Specialization
        Object blackhole(double value) {
            CompilerDirectives.blackhole((double)value);
            return nil;
        }

        @Specialization
        Object blackhole(Object value) {
            CompilerDirectives.blackhole((Object)value);
            return nil;
        }
    }

    @Primitive(name="compiler_bailout")
    public static abstract class BailoutNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"strings.isRubyString(this, message)"}, limit="1")
        static Object bailout(Object message, @Cached RubyStringLibrary strings, @Cached ToJavaStringNode toJavaStringNode, @Bind(value="this") Node node) {
            CompilerDirectives.bailout((String)toJavaStringNode.execute(node, message));
            return nil;
        }
    }

    @Primitive(name="assert_not_compiled")
    public static abstract class AssertNotCompiledNode
    extends PrimitiveNode {
        @Specialization
        Object assertNotCompiled() {
            if (CompilerDirectives.inCompiledCode()) {
                this.compiledBoundary();
            }
            return nil;
        }

        @CompilerDirectives.TruffleBoundary
        private void compiledBoundary() {
            throw new RaiseException(this.getContext(), this.coreExceptions().graalErrorAssertNotCompiledCompiled(this));
        }
    }

    @Primitive(name="assert_compilation_constant")
    public static abstract class AssertCompilationConstantNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object assertCompilationConstant(Object value) {
            if (!CompilerDirectives.isCompilationConstant((Object)value)) {
                this.notConstantBoundary();
            }
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        private void notConstantBoundary() {
            throw new RaiseException(this.getContext(), this.coreExceptions().graalErrorAssertConstantNotConstant(this));
        }
    }

    @CoreMethod(names={"copy_captured_locals"}, onSingleton=true, required=1)
    public static abstract class CopyCapturedLocalsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"proc.isLambda()"})
        RubyProc copyCapturedLocals(RubyProc proc) {
            RubyLambdaRootNode rootNode = RubyLambdaRootNode.of(proc.callTarget);
            RubyNode newBody = rootNode.copyBody();
            assert (NodeUtil.findAllNodeInstances((Node)newBody, WriteDeclarationVariableNode.class).isEmpty());
            for (ReadDeclarationVariableNode readNode : NodeUtil.findAllNodeInstances((Node)newBody, ReadDeclarationVariableNode.class)) {
                MaterializedFrame frame = RubyArguments.getDeclarationFrame(proc.declarationFrame, readNode.getFrameDepth() - 1);
                Object value = frame.getValue(readNode.getFrameSlot());
                readNode.replace(new ObjectLiteralNode(value));
            }
            RubyLambdaRootNode newRootNode = rootNode.copyRootNode(rootNode.getSharedMethodInfo(), newBody);
            RootCallTarget newCallTarget = newRootNode.getCallTarget();
            SpecialVariableStorage variables = proc.declarationVariables;
            Object[] args = RubyArguments.pack(null, null, RubyArguments.getMethod((Frame)proc.declarationFrame), null, nil, nil, NoKeywordArgumentsDescriptor.INSTANCE, EMPTY_ARGUMENTS);
            MaterializedFrame newDeclarationFrame = this.getLanguage().createEmptyDeclarationFrame(args, variables);
            return new RubyProc(this.coreLibrary().procClass, this.getLanguage().procShape, ProcType.LAMBDA, proc.arity, proc.argumentDescriptors, new ProcCallTargets(newCallTarget), newCallTarget, newDeclarationFrame, variables, proc.declaringMethod, proc.frameOnStackMarker, proc.declarationContext);
        }
    }

    @CoreMethod(names={"never_split"}, onSingleton=true, required=1)
    public static abstract class NeverSplitNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object neverSplit(Object executable, @Cached ToCallTargetNode toCallTargetNode) {
            RootCallTarget callTarget = toCallTargetNode.execute(this, executable);
            if (this.getContext().getOptions().NEVER_SPLIT_HONOR) {
                RubyRootNode.of(callTarget).setSplit(Split.NEVER);
            }
            return executable;
        }
    }

    @CoreMethod(names={"always_split"}, onSingleton=true, required=1)
    public static abstract class AlwaysSplitNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object alwaysSplit(Object executable, @Cached ToCallTargetNode toCallTargetNode) {
            RootCallTarget callTarget = toCallTargetNode.execute(this, executable);
            if (this.getContext().getOptions().ALWAYS_SPLIT_HONOR) {
                RubyRootNode.of(callTarget).setSplit(Split.ALWAYS);
            }
            return executable;
        }
    }
}

