/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.extra.ffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.TStringConstants;
import org.truffleruby.core.support.RubyByteArray;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.extra.ffi.RubyPointer;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.objects.AllocationTracing;

@CoreModule(value="Truffle::FFI::Pointer", isClass=true)
public abstract class PointerNodes {
    public static final BigInteger TWO_POW_64 = BigInteger.valueOf(1L).shiftLeft(64);

    @Primitive(name="pointer_raw_free")
    public static abstract class PointerRawFreePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        long free(long address) {
            Pointer.rawFree(address);
            return address;
        }
    }

    @Primitive(name="pointer_raw_realloc")
    public static abstract class PointerRawReallocPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        long malloc(long address, long size) {
            return Pointer.rawRealloc(address, size);
        }
    }

    @Primitive(name="pointer_raw_malloc")
    public static abstract class PointerRawMallocPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        long realloc(long size) {
            return Pointer.rawMalloc(size);
        }
    }

    @Primitive(name="pointer_write_pointer", lowerFixnum={2})
    public static abstract class PointerWritePointerNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object writePointer(long address, long value, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            ptr.writePointer(0L, value);
            return nil;
        }
    }

    @Primitive(name="pointer_write_double")
    public static abstract class PointerWriteDoubleNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object writeDouble(long address, double value, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            ptr.writeDouble(0L, value);
            return nil;
        }
    }

    @Primitive(name="pointer_write_float")
    public static abstract class PointerWriteFloatNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object writeFloat(long address, double value, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            ptr.writeFloat(0L, (float)value);
            return nil;
        }
    }

    @Primitive(name="pointer_write_ulong")
    public static abstract class PointerWriteULongNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"value >= 0"})
        Object writeLong(long address, long value, @Cached @Cached.Shared CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            ptr.writeLong(0L, value);
            return nil;
        }

        @Specialization
        Object writeUnsignedLong(long address, RubyBignum value, @Cached @Cached.Shared CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            PointerWriteULongNode.writeUnsignedLong(ptr, 0, value);
            return nil;
        }

        @CompilerDirectives.TruffleBoundary
        private static void writeUnsignedLong(Pointer ptr, int offset, RubyBignum value) {
            BigInteger v = value.value;
            assert (v.signum() >= 0);
            assert (v.compareTo(TWO_POW_64) < 0);
            BigInteger signed = v.subtract(TWO_POW_64);
            ptr.writeLong(offset, signed.longValueExact());
        }
    }

    @Primitive(name="pointer_write_long")
    public static abstract class PointerWriteLongNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object writeLong(long address, long value, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            ptr.writeLong(0L, value);
            return nil;
        }
    }

    @Primitive(name="pointer_write_uint", lowerFixnum={1})
    @ImportStatic(value={Integer.class})
    public static abstract class PointerWriteUIntNode
    extends PrimitiveArrayArgumentsNode {
        static final long MAX_UNSIGNED_INT_PLUS_ONE = 0x100000000L;

        @Specialization(guards={"value >= 0"})
        Object writeInt(long address, int value, @Cached @Cached.Shared CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            ptr.writeInt(0L, value);
            return nil;
        }

        @Specialization(guards={"value > MAX_VALUE", "value < MAX_UNSIGNED_INT_PLUS_ONE"})
        Object writeUnsignedInt(long address, long value, @Cached @Cached.Shared CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            int signed = (int)value;
            ptr.writeInt(0L, signed);
            return nil;
        }
    }

    @Primitive(name="pointer_write_int", lowerFixnum={1})
    public static abstract class PointerWriteIntNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object writeInt(long address, int value, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            ptr.writeInt(0L, value);
            return nil;
        }
    }

    @Primitive(name="pointer_write_ushort", lowerFixnum={1})
    @ImportStatic(value={Short.class})
    public static abstract class PointerWriteUShortNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"0 <= value", "value <= MAX_VALUE"})
        Object writeShort(long address, int value, @Cached @Cached.Shared CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            short shortValue = (short)value;
            ptr.writeShort(0L, shortValue);
            return nil;
        }

        @Specialization(guards={"value > MAX_VALUE", "value < 65536"})
        Object writeUnsignedSort(long address, int value, @Cached @Cached.Shared CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            short signed = (short)value;
            ptr.writeShort(0L, signed);
            return nil;
        }
    }

    @Primitive(name="pointer_write_short", lowerFixnum={1})
    @ImportStatic(value={Short.class})
    public static abstract class PointerWriteShortNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"MIN_VALUE <= value", "value <= MAX_VALUE"})
        Object writeShort(long address, int value, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            short shortValue = (short)value;
            ptr.writeShort(0L, shortValue);
            return nil;
        }
    }

    @Primitive(name="pointer_write_uchar", lowerFixnum={1})
    @ImportStatic(value={Byte.class})
    public static abstract class PointerWriteUCharNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"0 <= value", "value <= MAX_VALUE"})
        Object writeChar(long address, int value, @Cached @Cached.Shared CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            byte byteValue = (byte)value;
            ptr.writeByte(0L, byteValue);
            return nil;
        }

        @Specialization(guards={"value > MAX_VALUE", "value < 256"})
        Object writeUnsignedChar(long address, int value, @Cached @Cached.Shared CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            byte signed = (byte)value;
            ptr.writeByte(0L, signed);
            return nil;
        }
    }

    @Primitive(name="pointer_write_char", lowerFixnum={1})
    @ImportStatic(value={Byte.class})
    public static abstract class PointerWriteCharNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"MIN_VALUE <= value", "value <= MAX_VALUE"})
        Object writeChar(long address, int value, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            byte byteValue = (byte)value;
            ptr.writeByte(0L, byteValue);
            return nil;
        }
    }

    @Primitive(name="pointer_read_pointer")
    public static abstract class PointerReadPointerNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyPointer readPointer(long address, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            Pointer readPointer = ptr.readPointer(this.getContext(), 0L);
            RubyPointer instance = new RubyPointer(this.coreLibrary().truffleFFIPointerClass, this.getLanguage().truffleFFIPointerShape, readPointer);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }

    @Primitive(name="pointer_read_double")
    public static abstract class PointerReadDoubleNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        double readDouble(long address, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            return ptr.readDouble(0L);
        }
    }

    @Primitive(name="pointer_read_float")
    public static abstract class PointerReadFloatNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        double readFloat(long address, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            return ptr.readFloat(0L);
        }
    }

    @Primitive(name="pointer_read_ulong")
    public static abstract class PointerReadULongNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object readLongUnsigned(long address, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            return PointerReadULongNode.readUnsignedLong(ptr, 0);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object readUnsignedLong(Pointer ptr, int offset) {
            long signedValue = ptr.readLong(offset);
            return BigIntegerOps.asUnsignedFixnumOrBignum(signedValue);
        }
    }

    @Primitive(name="pointer_read_long")
    public static abstract class PointerReadLongNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        long readLongSigned(long address, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            return ptr.readLong(0L);
        }
    }

    @Primitive(name="pointer_read_uint")
    public static abstract class PointerReadUIntNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        long readIntUnsigned(long address, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            return Integer.toUnsignedLong(ptr.readInt(0L));
        }
    }

    @Primitive(name="pointer_read_int")
    public static abstract class PointerReadIntNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int readIntSigned(long address, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            return ptr.readInt(0L);
        }
    }

    @Primitive(name="pointer_read_ushort")
    public static abstract class PointerReadUShortNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int readShortUnsigned(long address, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            return Short.toUnsignedInt(ptr.readShort(0L));
        }
    }

    @Primitive(name="pointer_read_short")
    public static abstract class PointerReadShortNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int readShortSigned(long address, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            return ptr.readShort(0L);
        }
    }

    @Primitive(name="pointer_read_uchar")
    public static abstract class PointerReadUCharNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int readCharUnsigned(long address, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            return Byte.toUnsignedInt(ptr.readByte(0L));
        }
    }

    @Primitive(name="pointer_read_char")
    public static abstract class PointerReadCharNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int readCharSigned(long address, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            return ptr.readByte(0L);
        }
    }

    @Primitive(name="pointer_write_bytes", lowerFixnum={2, 3})
    public static abstract class PointerWriteBytesNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        static Object writeBytes(long address, Object string, int index, int length, @Cached InlinedConditionProfile nonZeroProfile, @Cached TruffleString.CopyToNativeMemoryNode copyToNativeMemoryNode, @Cached RubyStringLibrary libString, @Cached CheckNullPointerNode checkNullPointerNode, @Bind(value="this") Node node) {
            Pointer ptr = new Pointer(PointerWriteBytesNode.getContext(node), address);
            AbstractTruffleString tstring = libString.getTString(node, string);
            TruffleString.Encoding encoding = libString.getTEncoding(node, string);
            assert (index + length <= tstring.byteLength(encoding));
            if (nonZeroProfile.profile(node, length != 0)) {
                checkNullPointerNode.execute(node, ptr);
                copyToNativeMemoryNode.execute(tstring, index, (Object)ptr, 0, length, encoding);
            }
            return string;
        }
    }

    @Primitive(name="pointer_read_bytes", lowerFixnum={1})
    public static abstract class PointerReadBytesNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyString readBytes(long address, int length, @Cached InlinedConditionProfile zeroProfile, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            if (zeroProfile.profile((Node)this, length == 0)) {
                return this.createString(TStringConstants.EMPTY_BINARY, Encodings.BINARY);
            }
            checkNullPointerNode.execute(this, ptr);
            byte[] bytes = new byte[length];
            ptr.readBytes(0L, bytes, 0, length);
            return this.createString(fromByteArrayNode, bytes, Encodings.BINARY);
        }
    }

    @Primitive(name="pointer_read_bytes_to_byte_array", lowerFixnum={1, 3})
    public static abstract class PointerReadBytesToArrayNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object readBytes(RubyByteArray array, int arrayOffset, long address, int length, @Cached InlinedConditionProfile zeroProfile, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            if (zeroProfile.profile((Node)this, length == 0)) {
                return nil;
            }
            checkNullPointerNode.execute(this, ptr);
            byte[] bytes = array.bytes;
            ptr.readBytes(0L, bytes, arrayOffset, length);
            return nil;
        }
    }

    @Primitive(name="pointer_read_string_to_null")
    public static abstract class PointerReadStringToNullNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"limit == 0"})
        RubyString readNullPointer(long address, long limit) {
            return this.createString(TStringConstants.EMPTY_BINARY, Encodings.BINARY);
        }

        @Specialization(guards={"limit != 0"})
        RubyString readStringToNull(long address, long limit, @Cached @Cached.Shared TruffleString.FromByteArrayNode fromByteArrayNode, @CachedLibrary(limit="1") @Cached.Shared InteropLibrary interop, @Cached @Cached.Shared CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            byte[] bytes = ptr.readZeroTerminatedByteArray(this.getContext(), interop, 0L, limit);
            return this.createString(fromByteArrayNode, bytes, Encodings.BINARY);
        }

        @Specialization
        RubyString readStringToNull(long address, Nil limit, @CachedLibrary(limit="1") @Cached.Shared InteropLibrary interop, @Cached @Cached.Shared TruffleString.FromByteArrayNode fromByteArrayNode, @Cached @Cached.Shared CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), address);
            checkNullPointerNode.execute(this, ptr);
            byte[] bytes = ptr.readZeroTerminatedByteArray(this.getContext(), interop, 0L);
            return this.createString(fromByteArrayNode, bytes, Encodings.BINARY);
        }
    }

    @Primitive(name="pointer_copy_memory")
    public static abstract class PointerCopyMemoryNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object copyMemory(long to, long from, long size, @Cached CheckNullPointerNode checkNullPointerNode) {
            Pointer ptr = new Pointer(this.getContext(), to);
            checkNullPointerNode.execute(this, ptr);
            ptr.writeBytes(0L, new Pointer(this.getContext(), from), 0, size);
            return nil;
        }
    }

    @Primitive(name="pointer_clear", lowerFixnum={1})
    public static abstract class PointerClearNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyPointer clear(RubyPointer pointer, long length) {
            pointer.pointer.writeBytes(0L, length, (byte)0);
            return pointer;
        }
    }

    @CoreMethod(names={"free"})
    public static abstract class PointerFreeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyPointer free(RubyPointer pointer) {
            pointer.pointer.free();
            return pointer;
        }
    }

    @Primitive(name="pointer_malloc")
    public static abstract class PointerMallocPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyPointer malloc(RubyPointer pointer, long size) {
            pointer.pointer = Pointer.malloc(this.getContext(), size);
            return pointer;
        }
    }

    @CoreMethod(names={"autorelease="}, required=1)
    public static abstract class PointerSetAutoreleaseNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"autorelease"})
        boolean enableAutorelease(RubyPointer pointer, boolean autorelease) {
            pointer.pointer.enableAutorelease(this.getLanguage());
            return autorelease;
        }

        @Specialization(guards={"!autorelease"})
        boolean disableAutorelease(RubyPointer pointer, boolean autorelease) {
            pointer.pointer.disableAutorelease();
            return autorelease;
        }
    }

    @CoreMethod(names={"autorelease?"})
    public static abstract class PointerIsAutoreleaseNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isAutorelease(RubyPointer pointer) {
            return pointer.pointer.isAutorelease();
        }
    }

    @CoreMethod(names={"total="}, required=1)
    public static abstract class PointerSetSizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        long setSize(RubyPointer pointer, long size) {
            Pointer old = pointer.pointer;
            pointer.pointer = new Pointer(this.getContext(), old.getAddress(), size);
            return size;
        }
    }

    @Primitive(name="pointer_size")
    public static abstract class PointerSizeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        long size(RubyPointer pointer) {
            return pointer.pointer.getSize();
        }
    }

    @CoreMethod(names={"address", "to_i"})
    public static abstract class PointerAddressNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        long address(RubyPointer pointer) {
            return pointer.pointer.getAddress();
        }
    }

    @CoreMethod(names={"address="}, required=1)
    public static abstract class PointerSetAddressNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        long setAddress(RubyPointer pointer, long address) {
            pointer.pointer = new Pointer(this.getContext(), address);
            return address;
        }
    }

    @Primitive(name="pointer_find_type_size")
    public static abstract class PointerFindTypeSizePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int findTypeSize(RubySymbol type) {
            String typeString = type.getString();
            int size = PointerFindTypeSizePrimitiveNode.typeSize(typeString);
            if (size > 0) {
                return size;
            }
            Object typedef = this.getContext().getTruffleNFI().resolveTypeRaw(this.getContext().getNativeConfiguration(), typeString);
            int typedefSize = PointerFindTypeSizePrimitiveNode.typeSize(RubyGuards.getJavaString(typedef));
            assert (typedefSize > 0) : typedef;
            return typedefSize;
        }

        private static int typeSize(String type) {
            switch (type) {
                case "char": 
                case "uchar": 
                case "bool": {
                    return 1;
                }
                case "short": 
                case "ushort": {
                    return 2;
                }
                case "int": 
                case "uint": 
                case "int32": 
                case "uint32": 
                case "float": {
                    return 4;
                }
                case "long": 
                case "ulong": 
                case "int64": 
                case "uint64": 
                case "long_long": 
                case "ulong_long": 
                case "double": 
                case "pointer": {
                    return 8;
                }
            }
            return -1;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyPointer allocate(RubyClass pointerClass) {
            Shape shape = this.getLanguage().truffleFFIPointerShape;
            RubyPointer instance = new RubyPointer(pointerClass, shape, Pointer.getNullPointer(this.getContext()));
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CheckNullPointerNode
    extends RubyBaseNode {
        public abstract void execute(Node var1, Pointer var2);

        @Specialization
        static void checkNull(Node node, Pointer ptr, @Cached InlinedBranchProfile nullPointerProfile) {
            if (ptr.isNull()) {
                nullPointerProfile.enter(node);
                throw new RaiseException(CheckNullPointerNode.getContext(node), CheckNullPointerNode.getContext(node).getCoreExceptions().ffiNullPointerError("invalid memory access at address=0x0", node));
            }
        }
    }
}

