/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Split;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.control.DynamicReturnException;
import org.truffleruby.language.control.LocalReturnException;
import org.truffleruby.language.control.NextException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.RetryException;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.methods.TranslateExceptionNode;

public final class RubyEvalRootNode
extends RubyRootNode {
    @Node.Child
    private TranslateExceptionNode translateExceptionNode;
    @CompilerDirectives.CompilationFinal
    private boolean nextProfile;
    @CompilerDirectives.CompilationFinal
    private boolean retryProfile;
    @CompilerDirectives.CompilationFinal
    private boolean returnProfile;

    public RubyEvalRootNode(RubyLanguage language, SourceSection sourceSection, FrameDescriptor frameDescriptor, SharedMethodInfo sharedMethodInfo, RubyNode body, Split split, ReturnID returnID) {
        super(language, sourceSection, frameDescriptor, sharedMethodInfo, body, split, returnID);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        TruffleSafepoint.poll((Node)this);
        try {
            return this.body.execute(frame);
        }
        catch (RetryException e) {
            if (!this.retryProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.retryProfile = true;
            }
            throw new RaiseException(this.getContext(), (RubyException)this.getContext().getCoreExceptions().syntaxErrorInvalidRetry((Node)this));
        }
        catch (NextException e) {
            if (!this.nextProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nextProfile = true;
            }
            return e.getResult();
        }
        catch (DynamicReturnException | LocalReturnException e) {
            if (!this.returnProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.returnProfile = true;
            }
            throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().unexpectedReturn((Node)this));
        }
        catch (Throwable t) {
            if (this.translateExceptionNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.translateExceptionNode = (TranslateExceptionNode)this.insert(TranslateExceptionNode.create());
            }
            throw this.translateExceptionNode.executeCached(t);
        }
    }

    @Override
    protected RubyRootNode cloneUninitializedRootNode() {
        return new RubyEvalRootNode(this.getLanguage(), this.getSourceSection(), this.getFrameDescriptor(), this.getSharedMethodInfo(), this.body.cloneUninitialized(), this.getSplit(), this.returnID);
    }
}

