/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyNode;

@GeneratedBy(value=RubyNode.class)
final class RubyNodeWrapper
extends RubyNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private RubyNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    RubyNodeWrapper(RubyNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public RubyNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                returnValue = this.delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, returnValue);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) {
                    returnValue = result;
                    break;
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }

    @Override
    public Nil executeVoid(VirtualFrame frame) {
        Nil returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                returnValue = this.delegateNode.executeVoid(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, (Object)returnValue);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) {
                    returnValue = (Nil)result;
                    break;
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        return this.delegateNode.isDefined(frame, language, context);
    }

    @Override
    protected int getSourceCharIndex() {
        return this.delegateNode.getSourceCharIndex();
    }

    @Override
    protected void setSourceCharIndex(int sourceCharIndex) {
        this.delegateNode.setSourceCharIndex(sourceCharIndex);
    }

    @Override
    protected int getSourceLength() {
        return this.delegateNode.getSourceLength();
    }

    @Override
    protected void setSourceLength(int sourceLength) {
        this.delegateNode.setSourceLength(sourceLength);
    }

    @Override
    protected byte getFlags() {
        return this.delegateNode.getFlags();
    }

    @Override
    protected void setFlags(byte flags) {
        this.delegateNode.setFlags(flags);
    }

    @Override
    public RubyNode cloneUninitialized() {
        return this.delegateNode.cloneUninitialized();
    }
}

