/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.constants;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.constants.GetConstantNode;
import org.truffleruby.language.constants.LookupConstantWithDynamicScopeNode;
import org.truffleruby.language.constants.LookupConstantWithDynamicScopeNodeGen;
import org.truffleruby.language.control.RaiseException;

public final class ReadConstantWithDynamicScopeNode
extends RubyContextSourceNode {
    private final String name;
    @Node.Child
    private LookupConstantWithDynamicScopeNode lookupConstantNode;
    @Node.Child
    private GetConstantNode getConstantNode = GetConstantNode.create();

    public ReadConstantWithDynamicScopeNode(String name) {
        this.name = name;
        this.lookupConstantNode = LookupConstantWithDynamicScopeNodeGen.create(name);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        LexicalScope lexicalScope = RubyArguments.getMethod((Frame)frame).getLexicalScope();
        RubyModule module = lexicalScope.getLiveModule();
        return this.getConstantNode.lookupAndResolveConstant(lexicalScope, module, this.name, this.lookupConstantNode, true);
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        RubyConstant constant;
        LexicalScope lexicalScope = RubyArguments.getMethod((Frame)frame).getLexicalScope();
        try {
            constant = this.lookupConstantNode.executeLookupConstant(lexicalScope);
        }
        catch (RaiseException e) {
            if (e.getException().getLogicalClass() == this.coreLibrary().nameErrorClass) {
                return nil;
            }
            throw e;
        }
        if (ModuleOperations.isConstantDefined(constant)) {
            return FrozenStrings.CONSTANT;
        }
        return nil;
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadConstantWithDynamicScopeNode copy = new ReadConstantWithDynamicScopeNode(this.name);
        return copy.copyFlags(this);
    }
}

