/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.constants;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.core.constant.WarnAlreadyInitializedNode;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.RubyContextSourceAssignableNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;

public final class WriteConstantNode
extends RubyContextSourceAssignableNode {
    private final String name;
    @Node.Child
    private RubyNode moduleNode;
    @Node.Child
    private RubyNode valueNode;
    @Node.Child
    private WarnAlreadyInitializedNode warnAlreadyInitializedNode;
    private final ConditionProfile moduleProfile = ConditionProfile.create();

    public WriteConstantNode(String name, RubyNode moduleNode, RubyNode valueNode) {
        this.name = name;
        this.moduleNode = moduleNode;
        this.valueNode = valueNode;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object moduleObject = this.moduleNode.execute(frame);
        Object value = this.valueNode.execute(frame);
        if (!this.moduleProfile.profile(moduleObject instanceof RubyModule)) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorIsNotAClassModule(moduleObject, this));
        }
        RubyModule module = (RubyModule)moduleObject;
        this.assign(module, value);
        return value;
    }

    public Object execute(VirtualFrame frame, RubyModule module) {
        Object value = this.valueNode.execute(frame);
        this.assign(module, value);
        return value;
    }

    @Override
    public void assign(VirtualFrame frame, Object value) {
        Object moduleObject = this.moduleNode.execute(frame);
        if (!this.moduleProfile.profile(moduleObject instanceof RubyModule)) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorIsNotAClassModule(moduleObject, this));
        }
        this.assign((RubyModule)moduleObject, value);
    }

    private void assign(RubyModule module, Object value) {
        RubyConstant previous = module.fields.setConstant(this.getContext(), this, this.name, value);
        if (previous != null && previous.hasValue()) {
            this.warnAlreadyInitializedConstant(module, this.name, previous.getSourceSection());
        }
    }

    private void warnAlreadyInitializedConstant(RubyModule module, String name, SourceSection prevSourceSection) {
        if (this.warnAlreadyInitializedNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.warnAlreadyInitializedNode = (WarnAlreadyInitializedNode)this.insert(new WarnAlreadyInitializedNode());
        }
        if (this.warnAlreadyInitializedNode.shouldWarn()) {
            this.warnAlreadyInitializedNode.warnAlreadyInitialized(module, name, this.getSourceSection(), prevSourceSection);
        }
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        return FrozenStrings.ASSIGNMENT;
    }

    @Override
    public AssignableNode toAssignableNode() {
        this.valueNode = null;
        return this;
    }

    @Override
    public AssignableNode cloneUninitializedAssignable() {
        return (AssignableNode)((Object)this.cloneUninitialized());
    }

    @Override
    public RubyNode cloneUninitialized() {
        WriteConstantNode copy = new WriteConstantNode(this.name, this.moduleNode.cloneUninitialized(), WriteConstantNode.cloneUninitialized(this.valueNode));
        return copy.copyFlags(this);
    }
}

