/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.Map;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayAppendOneNode;
import org.truffleruby.core.array.ArrayConcatNode;
import org.truffleruby.core.array.ArrayLiteralNode;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.inlined.LambdaToProcNode;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.arguments.SplatToArgsNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.dispatch.LiteralCallAssignableNode;
import org.truffleruby.language.dispatch.RubyCallNodeFactory;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;
import org.truffleruby.language.literal.NilLiteralNode;
import org.truffleruby.language.methods.BlockDefinitionNode;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.LookupMethodOnSelfNode;
import org.truffleruby.parser.DeadNode;

public final class RubyCallNode
extends LiteralCallAssignableNode {
    private final String methodName;
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private RubyNode block;
    @Node.Children
    private final RubyNode[] arguments;
    private final DispatchConfiguration dispatchConfig;
    private final boolean isVCall;
    private final boolean isSafeNavigation;
    private final boolean isAttrAssign;
    @Node.Child
    private DispatchNode dispatch;
    @Node.Child
    private DefinedNode definedNode;
    private final CountingConditionProfile nilProfile;
    @Node.Child
    private SplatToArgsNode splatToArgs;

    public RubyCallNode(RubyCallNodeParameters parameters) {
        this(parameters.isSplatted(), parameters.getDescriptor(), parameters.getMethodName(), parameters.getReceiver(), parameters.getArguments(), parameters.getBlock(), parameters.isIgnoreVisibility() ? DispatchConfiguration.PRIVATE : DispatchConfiguration.PROTECTED, parameters.isVCall(), parameters.isSafeNavigation(), parameters.isAttrAssign());
    }

    public RubyCallNode(boolean isSplatted, ArgumentsDescriptor descriptor, String methodName, RubyNode receiver, RubyNode[] arguments, RubyNode block, DispatchConfiguration dispatchConfig, boolean isVCall, boolean isSafeNavigation, boolean isAttrAssign) {
        super(isSplatted, descriptor);
        this.methodName = methodName;
        this.receiver = receiver;
        this.arguments = arguments;
        this.block = block;
        this.dispatchConfig = dispatchConfig;
        this.isVCall = isVCall;
        this.isSafeNavigation = isSafeNavigation;
        this.isAttrAssign = isAttrAssign;
        this.nilProfile = isSafeNavigation ? CountingConditionProfile.create() : null;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        ArgumentsDescriptor descriptor;
        Object receiverObject = this.receiver.execute(frame);
        if (this.isSafeNavigation && this.nilProfile.profile(receiverObject == nil)) {
            return nil;
        }
        Object[] rubyArgs = RubyArguments.allocate(this.arguments.length);
        RubyArguments.setSelf(rubyArgs, receiverObject);
        this.executeArguments(frame, rubyArgs);
        if (this.isSplatted) {
            rubyArgs = this.splatArgs(receiverObject, rubyArgs);
            descriptor = this.getArgumentsDescriptorAndCheckRuby2KeywordsHash(rubyArgs, RubyArguments.getRawArgumentsCount(rubyArgs));
        } else {
            descriptor = this.descriptor;
        }
        RubyArguments.setBlock(rubyArgs, this.executeBlock(frame));
        return this.doCall(frame, receiverObject, descriptor, rubyArgs);
    }

    @Override
    public void assign(VirtualFrame frame, Object value) {
        assert (this.getLastArgumentNode() instanceof NilLiteralNode || this.getLastArgumentNode() instanceof DeadNode) : this.getLastArgumentNode();
        Object receiverObject = this.receiver.execute(frame);
        if (this.isSafeNavigation && this.nilProfile.profile(receiverObject == nil)) {
            return;
        }
        Object[] rubyArgs = RubyArguments.allocate(this.arguments.length);
        RubyArguments.setSelf(rubyArgs, receiverObject);
        this.executeArgumentsToAssign(frame, rubyArgs);
        if (this.isSplatted) {
            rubyArgs = this.splatArgs(receiverObject, rubyArgs);
        }
        assert (RubyArguments.getLastArgument(rubyArgs) == nil);
        RubyArguments.setLastArgument(rubyArgs, value);
        RubyArguments.setBlock(rubyArgs, this.executeBlock(frame));
        this.doCall(frame, receiverObject, this.descriptor, rubyArgs);
    }

    public Object doCall(VirtualFrame frame, Object receiverObject, ArgumentsDescriptor descriptor, Object[] rubyArgs) {
        if (descriptor instanceof KeywordArgumentsDescriptor && this.emptyKeywordArguments(rubyArgs)) {
            rubyArgs = RubyCallNode.removeEmptyKeywordArguments(rubyArgs);
            descriptor = NoKeywordArgumentsDescriptor.INSTANCE;
        }
        RubyArguments.setDescriptor(rubyArgs, descriptor);
        if (this.dispatch == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.dispatch = (DispatchNode)this.insert(DispatchNode.create());
        }
        Object returnValue = this.dispatch.execute((Frame)frame, receiverObject, this.methodName, rubyArgs, this.dispatchConfig);
        if (this.isAttrAssign) {
            Object value = ArrayUtils.getLast(rubyArgs);
            assert (RubyGuards.assertIsValidRubyValue(value));
            return value;
        }
        assert (RubyGuards.assertIsValidRubyValue(returnValue));
        return returnValue;
    }

    public Object executeWithArgumentsEvaluated(VirtualFrame frame, Object receiverObject, Object blockObject, Object[] argumentsObjects) {
        assert (!this.isSplatted);
        Object[] rubyArgs = RubyArguments.allocate(argumentsObjects.length);
        RubyArguments.setSelf(rubyArgs, receiverObject);
        RubyArguments.setBlock(rubyArgs, blockObject);
        RubyArguments.setArguments(rubyArgs, argumentsObjects);
        return this.doCall(frame, receiverObject, this.descriptor, rubyArgs);
    }

    private Object executeBlock(VirtualFrame frame) {
        if (this.block != null) {
            return this.block.execute(frame);
        }
        return nil;
    }

    @ExplodeLoop
    private void executeArguments(VirtualFrame frame, Object[] rubyArgs) {
        for (int i = 0; i < this.arguments.length; ++i) {
            RubyArguments.setArgument(rubyArgs, i, this.arguments[i].execute(frame));
        }
    }

    @ExplodeLoop
    private void executeArgumentsToAssign(VirtualFrame frame, Object[] rubyArgs) {
        for (int i = 0; i < this.arguments.length - 1; ++i) {
            RubyArguments.setArgument(rubyArgs, i, this.arguments[i].execute(frame));
        }
        int lastIndex = this.arguments.length - 1;
        if (this.arguments[lastIndex] instanceof DeadNode) {
            RubyArguments.setArgument(rubyArgs, lastIndex, nil);
        } else {
            RubyArguments.setArgument(rubyArgs, lastIndex, this.arguments[lastIndex].execute(frame));
        }
    }

    private Object[] splatArgs(Object receiverObject, Object[] rubyArgs) {
        if (this.splatToArgs == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.splatToArgs = this.createSplatToArgsNode();
        }
        return this.splatToArgs.execute(receiverObject, (RubyArray)RubyArguments.getArgument(rubyArgs, 0));
    }

    private SplatToArgsNode createSplatToArgsNode() {
        return (SplatToArgsNode)this.insert(new SplatToArgsNode(this.getLanguage()));
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        if (this.definedNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.definedNode = (DefinedNode)this.insert(RubyCallNodeFactory.DefinedNodeGen.create(this.methodName, this.receiver, this.arguments, this.dispatchConfig));
        }
        return this.definedNode.execute(frame, context);
    }

    public String getName() {
        return this.methodName;
    }

    public boolean isVCall() {
        return this.isVCall;
    }

    public boolean hasLiteralBlock() {
        RubyNode unwrappedBlock = RubyNode.unwrapNode(this.block);
        return unwrappedBlock instanceof BlockDefinitionNode || unwrappedBlock instanceof LambdaToProcNode;
    }

    public RubyNode[] getArguments() {
        return this.arguments;
    }

    private RubyNode getLastArgumentNode() {
        RubyNode lastArg = RubyNode.unwrapNode(ArrayUtils.getLast(this.arguments));
        if (this.isSplatted && lastArg instanceof ArrayAppendOneNode) {
            ArrayAppendOneNode arrayAppendOneNode = (ArrayAppendOneNode)lastArg;
            return RubyNode.unwrapNode(arrayAppendOneNode.getValueNode());
        }
        if (this.isSplatted && lastArg instanceof ArrayConcatNode) {
            ArrayConcatNode arrayConcatNode = (ArrayConcatNode)lastArg;
            RubyNode[] elements = arrayConcatNode.getElements();
            assert (elements.length > 0);
            RubyNode last = RubyNode.unwrapNode(ArrayUtils.getLast(elements));
            if (last instanceof ArrayLiteralNode) {
                ArrayLiteralNode arrayLiteralNode = (ArrayLiteralNode)last;
                RubyNode[] values = arrayLiteralNode.getValues();
                assert (values.length > 0);
                return RubyNode.unwrapNode(ArrayUtils.getLast(values));
            }
            return last;
        }
        return lastArg;
    }

    @Override
    public AssignableNode toAssignableNode() {
        return this;
    }

    @Override
    public AssignableNode cloneUninitializedAssignable() {
        return (AssignableNode)((Object)this.cloneUninitialized());
    }

    public Map<String, Object> getDebugProperties() {
        Map map = super.getDebugProperties();
        map.put("methodName", this.methodName);
        return map;
    }

    @Override
    public RubyNode cloneUninitialized() {
        RubyCallNodeParameters parameters = new RubyCallNodeParameters(this.receiver.cloneUninitialized(), this.methodName, RubyCallNode.cloneUninitialized(this.block), this.descriptor, RubyCallNode.cloneUninitialized(this.arguments), this.isSplatted, this.dispatchConfig == DispatchConfiguration.PRIVATE, this.isVCall, this.isSafeNavigation, this.isAttrAssign);
        RubyContextSourceNode copy = this.getLanguage().coreMethodAssumptions.createCallNode(parameters);
        return copy.copyFlags(this);
    }

    public RubyNode cloneUninitializedWithArguments(RubyNode[] arguments) {
        boolean isVCall = arguments.length == 0;
        RubyCallNodeParameters parameters = new RubyCallNodeParameters(this.receiver.cloneUninitialized(), this.methodName, RubyCallNode.cloneUninitialized(this.block), this.descriptor, arguments, this.isSplatted, this.dispatchConfig == DispatchConfiguration.PRIVATE, isVCall, this.isSafeNavigation, this.isAttrAssign);
        RubyContextSourceNode copy = this.getLanguage().coreMethodAssumptions.createCallNode(parameters);
        return copy.copyFlags(this);
    }

    static abstract class DefinedNode
    extends RubyBaseNode {
        private final RubySymbol methodNameSymbol;
        private final String methodName;
        private final DispatchConfiguration dispatchConfig;
        @Node.Child
        private RubyNode receiver;
        @Node.Children
        private final RubyNode[] arguments;
        @Node.Child
        private DispatchNode respondToMissing = DispatchNode.create();

        public DefinedNode(String methodName, RubyNode receiver, RubyNode[] arguments, DispatchConfiguration dispatchConfig) {
            this.methodName = methodName;
            this.methodNameSymbol = this.getSymbol(methodName);
            this.receiver = receiver;
            this.arguments = arguments;
            this.dispatchConfig = dispatchConfig;
        }

        public abstract Object execute(VirtualFrame var1, RubyContext var2);

        @Specialization
        @ExplodeLoop
        Object isDefined(VirtualFrame frame, RubyContext context, @Cached LookupMethodOnSelfNode lookupMethodNode, @Cached BooleanCastNode respondToMissingCast, @Cached InlinedConditionProfile receiverDefinedProfile, @Cached InlinedBranchProfile allArgumentsDefinedProfile, @Cached InlinedBranchProfile receiverExceptionProfile, @Cached InlinedConditionProfile methodNotFoundProfile, @Cached InlinedBranchProfile argumentNotDefinedProfile) {
            Object r;
            Object receiverObject;
            if (receiverDefinedProfile.profile((Node)this, this.receiver.isDefined(frame, this.getLanguage(), context) == nil)) {
                return nil;
            }
            for (RubyNode argument : this.arguments) {
                if (argument.isDefined(frame, this.getLanguage(), context) != nil) continue;
                argumentNotDefinedProfile.enter((Node)this);
                return nil;
            }
            allArgumentsDefinedProfile.enter((Node)this);
            try {
                receiverObject = this.receiver.execute(frame);
            }
            catch (RaiseException e) {
                receiverExceptionProfile.enter((Node)this);
                return nil;
            }
            InternalMethod method = lookupMethodNode.execute((Frame)frame, receiverObject, this.methodName, this.dispatchConfig);
            if (methodNotFoundProfile.profile((Node)this, method == null) && (r = this.respondToMissing.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, receiverObject, "respond_to_missing?", (Object)this.methodNameSymbol, (Object)false)) != DispatchNode.MISSING && !respondToMissingCast.execute(this, r)) {
                return nil;
            }
            return FrozenStrings.METHOD;
        }
    }
}

