/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.globals;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import org.truffleruby.RubyLanguage;
import org.truffleruby.collections.SharedIndicesMap;
import org.truffleruby.language.globals.GlobalVariableStorage;

public final class GlobalVariableReader {
    private final int index;
    private final SharedIndicesMap.ContextArray<GlobalVariableStorage> globalVariablesArray;
    private final Assumption globalVariableAliasedAssumption;
    private GlobalVariableStorage unaliasedStorage;

    GlobalVariableReader(RubyLanguage language, String name, SharedIndicesMap.ContextArray<GlobalVariableStorage> globalVariablesArray) {
        this.index = language.getGlobalVariableIndex(name);
        this.globalVariablesArray = globalVariablesArray;
        this.globalVariableAliasedAssumption = language.getGlobalVariableNeverAliasedAssumption(this.index);
        this.unaliasedStorage = (GlobalVariableStorage)globalVariablesArray.get(this.index);
    }

    public Object getValue() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        if (this.globalVariableAliasedAssumption.isValid()) {
            return this.unaliasedStorage.getValue();
        }
        return ((GlobalVariableStorage)this.globalVariablesArray.get(this.index)).getValue();
    }
}

