/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.library;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.RubyContext;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.control.RaiseException;

public abstract class RubyStringLibrary {
    public static RubyStringLibrary getUncached() {
        CompilerAsserts.neverPartOfCompilation((String)"uncached libraries must not be used in PE code");
        return Uncached.INSTANCE;
    }

    public abstract boolean seen(Node var1, Object var2);

    public abstract boolean isRubyString(Node var1, Object var2);

    @NeverDefault
    public abstract AbstractTruffleString getTString(Node var1, Object var2);

    @NeverDefault
    public abstract RubyEncoding getEncoding(Node var1, Object var2);

    @NeverDefault
    public final TruffleString.Encoding getTEncoding(Node node, Object object) {
        return this.getEncoding((Node)node, (Object)object).tencoding;
    }

    public abstract int byteLength(Node var1, Object var2);

    public abstract RubyEncoding profileEncoding(Node var1, RubyEncoding var2);

    public static RubyStringLibrary inline(@InlineSupport.RequiredField(value=InlineSupport.StateField.class, bits=6) InlineSupport.InlineTarget target) {
        return new Cached(target);
    }

    public static boolean isRubyStringUncached(Object object) {
        return RubyStringLibrary.getUncached().isRubyString(null, object);
    }

    public static AbstractTruffleString getTStringUncached(Object object) {
        return RubyStringLibrary.getUncached().getTString(null, object);
    }

    public static RubyEncoding getEncodingUncached(Object object) {
        return RubyStringLibrary.getUncached().getEncoding(null, object);
    }

    static final class Uncached
    extends RubyStringLibrary {
        static final Uncached INSTANCE = new Uncached();

        Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean seen(Node node, Object object) {
            assert (object instanceof RubyString || object instanceof ImmutableRubyString);
            return true;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isRubyString(Node node, Object object) {
            return object instanceof RubyString || object instanceof ImmutableRubyString;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public AbstractTruffleString getTString(Node node, Object object) {
            if (object instanceof RubyString) {
                return ((RubyString)((Object)object)).tstring;
            }
            if (object instanceof ImmutableRubyString) {
                return ((ImmutableRubyString)object).tstring;
            }
            RubyContext context = RubyContext.get(node);
            throw new RaiseException(context, context.getCoreExceptions().typeErrorNoImplicitConversion(object, "String", node));
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public RubyEncoding profileEncoding(Node node, RubyEncoding encoding) {
            return encoding;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public RubyEncoding getEncoding(Node node, Object object) {
            if (object instanceof RubyString) {
                return ((RubyString)((Object)object)).getEncodingUncached();
            }
            if (object instanceof ImmutableRubyString) {
                return ((ImmutableRubyString)object).getEncodingUncached();
            }
            RubyContext context = RubyContext.get(node);
            throw new RaiseException(context, context.getCoreExceptions().typeErrorNoImplicitConversion(object, "String", node));
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int byteLength(Node node, Object object) {
            return this.getTString(node, object).byteLength(this.getTEncoding(node, object));
        }
    }

    static final class Cached
    extends RubyStringLibrary {
        private static final int REQUIRED_STATE_BITS = 6;
        private static final int ENCODING_MASK = 7;
        private static final int GENERIC = 4;
        private static final int SEEN_MUTABLE = 8;
        private static final int SEEN_IMMUTABLE = 16;
        private static final int SEEN_OTHER = 32;
        private final InlineSupport.StateField stateField;

        Cached(InlineSupport.InlineTarget target) {
            this.stateField = target.getState(0, 6);
        }

        @Override
        public boolean seen(Node node, Object object) {
            assert (object instanceof RubyString || object instanceof ImmutableRubyString);
            int state = this.stateField.get(node);
            if ((state & 8) != 0) {
                return object instanceof RubyString;
            }
            if ((state & 0x10) != 0) {
                return object instanceof ImmutableRubyString;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getTString(node, object);
            return true;
        }

        @Override
        public boolean isRubyString(Node node, Object object) {
            int state = this.stateField.get(node);
            if ((state & 8) != 0 && object instanceof RubyString) {
                return true;
            }
            if ((state & 0x10) != 0 && object instanceof ImmutableRubyString) {
                return true;
            }
            if ((state & 0x20) != 0 && RubyGuards.isNotRubyString(object)) {
                return false;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.specializeIsRubyString(node, object);
        }

        private boolean specializeIsRubyString(Node node, Object object) {
            int state = this.stateField.get(node);
            if (object instanceof RubyString) {
                this.stateField.set(node, state | 8);
                return true;
            }
            if (object instanceof ImmutableRubyString) {
                this.stateField.set(node, state | 0x10);
                return true;
            }
            if (RubyGuards.isNotRubyString(object)) {
                this.stateField.set(node, state | 0x20);
                return false;
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public AbstractTruffleString getTString(Node node, Object object) {
            int state = this.stateField.get(node);
            if ((state & 8) != 0 && object instanceof RubyString) {
                return ((RubyString)((Object)object)).tstring;
            }
            if ((state & 0x10) != 0 && object instanceof ImmutableRubyString) {
                return ((ImmutableRubyString)object).tstring;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.specializeGetTString(node, object);
        }

        private AbstractTruffleString specializeGetTString(Node node, Object object) {
            int state = this.stateField.get(node);
            if (object instanceof RubyString) {
                this.stateField.set(node, state | 8);
                return ((RubyString)((Object)object)).tstring;
            }
            if (object instanceof ImmutableRubyString) {
                this.stateField.set(node, state | 0x10);
                return ((ImmutableRubyString)object).tstring;
            }
            RubyContext context = RubyContext.get(node);
            throw new RaiseException(context, context.getCoreExceptions().typeErrorNoImplicitConversion(object, "String", node));
        }

        @Override
        public RubyEncoding profileEncoding(Node node, RubyEncoding encoding) {
            int localCachedEncoding = this.stateField.get(node) & 7;
            if (localCachedEncoding == 4) {
                return encoding;
            }
            if (encoding.index == localCachedEncoding - 1) {
                return Encodings.STANDARD_ENCODINGS[localCachedEncoding - 1];
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.specializeProfileEncoding(node, encoding);
        }

        private RubyEncoding specializeProfileEncoding(Node node, RubyEncoding encoding) {
            int state = this.stateField.get(node);
            int localCachedEncoding = state & 7;
            if (localCachedEncoding == 0) {
                if (Encodings.isStandardEncoding(encoding)) {
                    assert (encoding.index >= 0 && encoding.index <= 2);
                    this.stateField.set(node, state | encoding.index + 1);
                } else {
                    this.stateField.set(node, state | 4);
                }
            } else if (encoding.index != localCachedEncoding - 1) {
                this.stateField.set(node, state & 0xFFFFFFF8 | 4);
            }
            return encoding;
        }

        @Override
        public RubyEncoding getEncoding(Node node, Object object) {
            RubyEncoding encoding;
            int state = this.stateField.get(node);
            if ((state & 8) != 0 && object instanceof RubyString) {
                encoding = ((RubyString)((Object)object)).getEncodingUnprofiled();
            } else if ((state & 0x10) != 0 && object instanceof ImmutableRubyString) {
                encoding = ((ImmutableRubyString)object).getEncodingUnprofiled();
            } else {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.specializeGetEncoding(node, object);
            }
            return this.profileEncoding(node, encoding);
        }

        private RubyEncoding specializeGetEncoding(Node node, Object object) {
            RubyEncoding encoding;
            int state = this.stateField.get(node);
            if (object instanceof RubyString) {
                this.stateField.set(node, state | 8);
                encoding = ((RubyString)((Object)object)).getEncodingUnprofiled();
            } else if (object instanceof ImmutableRubyString) {
                this.stateField.set(node, state | 0x10);
                encoding = ((ImmutableRubyString)object).getEncodingUnprofiled();
            } else {
                RubyContext context = RubyContext.get(node);
                throw new RaiseException(context, context.getCoreExceptions().typeErrorNoImplicitConversion(object, "String", node));
            }
            return this.specializeProfileEncoding(node, encoding);
        }

        @Override
        public int byteLength(Node node, Object object) {
            int state = this.stateField.get(node);
            if ((state & 8) != 0 && object instanceof RubyString) {
                RubyString mutable = (RubyString)((Object)object);
                return this.getTString(node, (Object)mutable).byteLength(this.getTEncoding(node, (Object)mutable));
            }
            if ((state & 0x10) != 0 && object instanceof ImmutableRubyString) {
                ImmutableRubyString immutable = (ImmutableRubyString)object;
                return this.getTString(node, immutable).byteLength(this.getTEncoding(node, immutable));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.specializeByteLength(node, object);
        }

        private int specializeByteLength(Node node, Object object) {
            return this.getTString(node, object).byteLength(this.getTEncoding(node, object));
        }
    }
}

