/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.loader;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import org.truffleruby.RubyContext;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.string.CannotConvertBinaryRubyStringToJavaString;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.loader.ByteBasedCharSequence;
import org.truffleruby.parser.MagicCommentParser;
import org.truffleruby.parser.RubySource;

public abstract class EvalLoader {
    @CompilerDirectives.TruffleBoundary
    public static RubySource createEvalSource(RubyContext context, AbstractTruffleString codeTString, RubyEncoding encoding, String method, String file, int line, Node currentNode) {
        TStringWithEncoding code = new TStringWithEncoding(codeTString.asTruffleStringUncached(encoding.tencoding), encoding);
        TStringWithEncoding sourceTString = MagicCommentParser.createSourceTStringBasedOnMagicEncodingComment(code, code.encoding);
        RubyEncoding sourceEncoding = sourceTString.encoding;
        if (!sourceEncoding.isAsciiCompatible) {
            throw new RaiseException(context, context.getCoreExceptions().argumentError(String.valueOf(sourceEncoding) + " is not ASCII compatible", currentNode));
        }
        try {
            sourceTString.toJavaStringOrThrow();
        }
        catch (CannotConvertBinaryRubyStringToJavaString e) {
            String message = file + ":" + line + ": cannot " + method + "() a String with binary encoding, with no magic encoding comment and containing a non-US-ASCII character: \\x" + String.format("%02X", e.getNonAsciiCharacter());
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxErrorAlreadyWithFileLine(message, currentNode, currentNode.getEncapsulatingSourceSection()));
        }
        Source source = Source.newBuilder((String)"ruby", (CharSequence)new ByteBasedCharSequence(sourceTString), (String)file).build();
        RubySource rubySource = new RubySource(source, file, sourceTString, true, line - 1);
        context.getSourceLineOffsets().put(source, line - 1);
        return rubySource;
    }
}

