/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.loader;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.collections.ConcurrentOperations;
import org.truffleruby.core.array.ArrayOperations;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.mutex.MutexOperations;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.core.support.IONodes;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.extra.TruffleRubyNodes;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.interop.InteropNodes;
import org.truffleruby.interop.TranslateInteropExceptionNode;
import org.truffleruby.interop.TranslateInteropExceptionNodeGen;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.loader.FileLoader;
import org.truffleruby.language.loader.ReentrantLockFreeingMap;
import org.truffleruby.language.loader.RequireNode;
import org.truffleruby.platform.NativeConfiguration;
import org.truffleruby.platform.TruffleNFIPlatform;
import org.truffleruby.shared.Metrics;
import org.truffleruby.shared.Platform;

public final class FeatureLoader {
    private static final int PATH_MAX = 1024;
    private static final String[] EXTENSIONS = new String[]{".rb", RubyLanguage.CEXT_EXTENSION};
    private final RubyContext context;
    private final RubyLanguage language;
    private final ReentrantLockFreeingMap<String> fileLocks = new ReentrantLockFreeingMap();
    private final Map<String, Map<String, List<RubyConstant>>> registeredAutoloads = new HashMap<String, Map<String, List<RubyConstant>>>();
    private final ReentrantLock registeredAutoloadsLock = new ReentrantLock();
    private final ReentrantLock cextImplementationLock = new ReentrantLock();
    private boolean cextImplementationLoaded = false;
    private String cwd = null;
    private Object getcwd;
    private Source mainScriptSource;
    private String mainScriptAbsolutePath;
    private final List<Object> keepLibrariesAlive = Collections.synchronizedList(new ArrayList());

    public FeatureLoader(RubyContext context, RubyLanguage language) {
        this.context = context;
        this.language = language;
    }

    public void initialize(NativeConfiguration nativeConfiguration, TruffleNFIPlatform nfi) {
        if (this.context.getOptions().NATIVE_PLATFORM) {
            this.getcwd = nfi.getFunction(this.context, "getcwd", "(pointer," + nfi.size_t() + "):pointer");
        }
    }

    public void setMainScript(Source source, String absolutePath) {
        assert (this.mainScriptSource == null);
        assert (this.mainScriptAbsolutePath == null);
        this.mainScriptSource = source;
        this.mainScriptAbsolutePath = absolutePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAutoload(RubyConstant autoloadConstant) {
        String autoloadPath = autoloadConstant.getAutoloadConstant().getAutoloadPath();
        String basename = this.basenameWithoutExtension(autoloadPath);
        this.registeredAutoloadsLock.lock();
        try {
            Map constants = ConcurrentOperations.getOrCompute(this.registeredAutoloads, basename, k -> new LinkedHashMap());
            List list = ConcurrentOperations.getOrCompute(constants, autoloadPath, k -> new ArrayList());
            list.add(autoloadConstant);
        }
        finally {
            this.registeredAutoloadsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RubyConstant> getAutoloadConstants(String expandedPath) {
        LinkedHashMap<String, RubyConstant[]> constantsMapCopy;
        String basename = this.basenameWithoutExtension(expandedPath);
        this.registeredAutoloadsLock.lock();
        try {
            Map<String, List<RubyConstant>> constantsMap = this.registeredAutoloads.get(basename);
            if (constantsMap == null || constantsMap.isEmpty()) {
                List<RubyConstant> list = Collections.emptyList();
                return list;
            }
            constantsMapCopy = new LinkedHashMap<String, RubyConstant[]>();
            for (Map.Entry<String, List<RubyConstant>> entry : constantsMap.entrySet()) {
                constantsMapCopy.put(entry.getKey(), entry.getValue().toArray(RubyConstant.EMPTY_ARRAY));
            }
        }
        finally {
            this.registeredAutoloadsLock.unlock();
        }
        ArrayList<RubyConstant> constants = new ArrayList<RubyConstant>();
        for (Map.Entry<String, List<RubyConstant>> entry : constantsMapCopy.entrySet()) {
            String expandedAutoloadPath = this.findFeature(entry.getKey());
            if (!expandedPath.equals(expandedAutoloadPath)) continue;
            constants.addAll(Arrays.asList((RubyConstant[])entry.getValue()));
        }
        return constants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAutoload(RubyConstant constant) {
        String autoloadPath = constant.getAutoloadConstant().getAutoloadPath();
        String basename = this.basenameWithoutExtension(autoloadPath);
        this.registeredAutoloadsLock.lock();
        try {
            Map<String, List<RubyConstant>> constantsMap = this.registeredAutoloads.get(basename);
            List<RubyConstant> constants = constantsMap.get(autoloadPath);
            if (constants != null) {
                constants.remove(constant);
            }
        }
        finally {
            this.registeredAutoloadsLock.unlock();
        }
    }

    private String basenameWithoutExtension(String path) {
        String basename = new File(path).getName();
        int i = basename.lastIndexOf(46);
        if (i >= 0) {
            return basename.substring(0, i);
        }
        return basename;
    }

    private boolean hasExtension(String path) {
        return path.endsWith(".rb") || path.endsWith(".so") || !Platform.CEXT_SUFFIX_IS_SO && path.endsWith(RubyLanguage.CEXT_EXTENSION);
    }

    public void setWorkingDirectory(String cwd) {
        this.cwd = cwd;
    }

    @CompilerDirectives.TruffleBoundary
    public String getWorkingDirectory() {
        if (this.cwd != null) {
            return this.cwd;
        }
        this.cwd = this.initializeWorkingDirectory();
        return this.cwd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String initializeWorkingDirectory() {
        TruffleNFIPlatform nfi = this.context.getTruffleNFI();
        if (nfi == null) {
            return this.context.getEnv().getCurrentWorkingDirectory().getPath();
        }
        int bufferSize = 1024;
        RubyThread rubyThread = this.language.getCurrentThread();
        Pointer buffer = IONodes.IOThreadBufferAllocateNode.getBuffer(null, this.context, rubyThread, 1024L, InlinedConditionProfile.getUncached());
        try {
            long address;
            try {
                address = nfi.asPointer(InteropLibrary.getUncached().execute(this.getcwd, new Object[]{buffer.getAddress(), 1024}));
            }
            catch (InteropException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            if (address == 0L) {
                DispatchNode.getUncached().call(this.context.getCoreLibrary().errnoModule, "handle");
            }
            byte[] bytes = buffer.readZeroTerminatedByteArray(this.context, InteropLibrary.getUncached(), 0L);
            RubyEncoding localeEncoding = this.context.getEncodingManager().getLocaleEncoding();
            String string = TStringUtils.toJavaStringOrThrow(bytes, localeEncoding);
            return string;
        }
        finally {
            rubyThread.getIoBuffer(this.context).free(null, rubyThread, buffer, InlinedConditionProfile.getUncached());
        }
    }

    private String makeAbsolute(String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return path;
        }
        String cwd = this.getWorkingDirectory();
        return new File(cwd, path).getPath();
    }

    public String canonicalize(String path, Source source) {
        if (source != null && source.equals((Object)this.mainScriptSource)) {
            return this.mainScriptAbsolutePath;
        }
        String absolutePath = this.makeAbsolute(path);
        try {
            return new File(absolutePath).getCanonicalPath();
        }
        catch (IOException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    public String dirname(String absolutePath) {
        assert (new File(absolutePath).isAbsolute());
        String parent = new File(absolutePath).getParent();
        if (parent == null) {
            return absolutePath;
        }
        return parent;
    }

    public ReentrantLockFreeingMap<String> getFileLocks() {
        return this.fileLocks;
    }

    @CompilerDirectives.TruffleBoundary
    public String findFeature(String feature) {
        return this.context.getMetricsProfiler().callWithMetrics("searching", feature, () -> this.findFeatureImpl(feature));
    }

    @CompilerDirectives.TruffleBoundary
    private String findFeatureImpl(String feature) {
        String found;
        block18: {
            if (this.context.getOptions().LOG_FEATURE_LOCATION) {
                String originalFeature = feature;
                RubyLanguage.LOGGER.info(() -> {
                    SourceSection sourceSection = this.context.getCallStack().getTopMostUserSourceSection();
                    return String.format("starting search from %s for feature %s...", this.context.fileLine(sourceSection), originalFeature);
                });
                RubyLanguage.LOGGER.info(String.format("current directory: %s", this.getWorkingDirectory()));
            }
            if (((String)feature).startsWith("./")) {
                feature = this.getWorkingDirectory() + "/" + ((String)feature).substring(2);
                if (this.context.getOptions().LOG_FEATURE_LOCATION) {
                    RubyLanguage.LOGGER.info(String.format("feature adjusted to %s", feature));
                }
            } else if (((String)feature).startsWith("../")) {
                feature = this.dirname(this.getWorkingDirectory()) + "/" + ((String)feature).substring(3);
                if (this.context.getOptions().LOG_FEATURE_LOCATION) {
                    RubyLanguage.LOGGER.info(String.format("feature adjusted to %s", feature));
                }
            }
            found = null;
            if (((String)feature).startsWith("resource:") || new File((String)feature).isAbsolute()) {
                found = this.findFeatureWithAndWithoutExtension((String)feature);
            } else if (this.hasExtension((String)feature)) {
                String path = this.translateIfNativePath((String)feature);
                RubyArray expandedLoadPath = (RubyArray)DispatchNode.getUncached().call(this.context.getCoreLibrary().truffleFeatureLoaderModule, "get_expanded_load_path");
                for (Object pathObject : ArrayOperations.toIterable(expandedLoadPath)) {
                    String fileWithinPath;
                    String result;
                    String loadPath = RubyGuards.getJavaString(pathObject);
                    if (this.context.getOptions().LOG_FEATURE_LOCATION) {
                        RubyLanguage.LOGGER.info(String.format("from load path %s...", loadPath));
                    }
                    if ((result = this.findFeatureWithExactPath(fileWithinPath = new File(loadPath, path).getPath())) == null) continue;
                    found = result;
                    break;
                }
            } else {
                for (String extension : EXTENSIONS) {
                    RubyArray expandedLoadPath = (RubyArray)DispatchNode.getUncached().call(this.context.getCoreLibrary().truffleFeatureLoaderModule, "get_expanded_load_path");
                    for (Object pathObject : ArrayOperations.toIterable(expandedLoadPath)) {
                        String fileWithinPath;
                        String result;
                        String loadPath = RubyGuards.getJavaString(pathObject);
                        if (this.context.getOptions().LOG_FEATURE_LOCATION) {
                            RubyLanguage.LOGGER.info(String.format("from load path %s...", loadPath));
                        }
                        if ((result = this.findFeatureWithExactPath((fileWithinPath = new File(loadPath, (String)feature).getPath()) + extension)) == null) continue;
                        found = result;
                        break block18;
                    }
                }
            }
        }
        if (this.context.getOptions().LOG_FEATURE_LOCATION) {
            if (found == null) {
                RubyLanguage.LOGGER.info("not found");
            } else {
                RubyLanguage.LOGGER.info(String.format("found in %s", found));
            }
        }
        return found;
    }

    private String translateIfNativePath(String feature) {
        if (!Platform.CEXT_SUFFIX_IS_SO && feature.endsWith(".so")) {
            String base = feature.substring(0, feature.length() - 3);
            return base + RubyLanguage.CEXT_EXTENSION;
        }
        return feature;
    }

    private String findFeatureWithAndWithoutExtension(String path) {
        assert (new File(path).isAbsolute());
        if (this.hasExtension(path)) {
            return this.findFeatureWithExactPath(this.translateIfNativePath(path));
        }
        String asRuby = this.findFeatureWithExactPath(path + ".rb");
        if (asRuby != null) {
            return asRuby;
        }
        return this.findFeatureWithExactPath(path + RubyLanguage.CEXT_EXTENSION);
    }

    private String findFeatureWithExactPath(String path) {
        if (this.context.getOptions().LOG_FEATURE_LOCATION) {
            RubyLanguage.LOGGER.info(String.format("trying %s...", path));
        }
        if (path.startsWith("resource:")) {
            return path;
        }
        File file = new File(path);
        if (!file.isFile()) {
            return null;
        }
        return file.toPath().normalize().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void ensureCExtImplementationLoaded(String feature, RequireNode requireNode) {
        MutexOperations.lockInternal(this.context, this.cextImplementationLock, requireNode);
        try {
            if (this.cextImplementationLoaded) {
                return;
            }
            if (!this.context.getOptions().CEXTS) {
                throw new RaiseException(this.context, this.context.getCoreExceptions().loadError("cannot load as C extensions are disabled with --ruby.cexts=false", feature, null));
            }
            if (!TruffleRubyNodes.SulongNode.isSulongAvailable(this.context)) {
                throw new RaiseException(this.context, this.context.getCoreExceptions().loadError("Sulong is required to support C extensions, and it doesn't appear to be available", feature, (Node)requireNode));
            }
            Metrics.printTime((String)"before-load-cext-support");
            try {
                RubyString cextRb = StringOperations.createUTF8String(this.context, this.language, "truffle/cext");
                DispatchNode.getUncached().call((Object)this.context.getCoreLibrary().mainObject, "gem_original_require", (Object)cextRb);
                RubyModule truffleModule = this.context.getCoreLibrary().truffleModule;
                Object truffleCExt = truffleModule.fields.getConstant("CExt").getValue();
                Object libTrampoline = null;
                if (!this.context.getOptions().CEXTS_SULONG) {
                    String libTrampolinePath = this.language.getRubyHome() + "/lib/cext/libtrufflerubytrampoline" + Platform.LIB_SUFFIX;
                    if (this.context.getOptions().CEXTS_LOG_LOAD) {
                        RubyLanguage.LOGGER.info(() -> String.format("loading libtrufflerubytrampoline %s", libTrampolinePath));
                    }
                    libTrampoline = this.loadCExtLibrary("libtrufflerubytrampoline", libTrampolinePath, requireNode, false);
                }
                String rubyLibPath = this.language.getRubyHome() + "/lib/cext/libtruffleruby" + Platform.LIB_SUFFIX;
                Object library = this.loadCExtLibRuby(rubyLibPath, feature, requireNode);
                InteropLibrary interop = InteropLibrary.getUncached();
                this.language.getCurrentFiber().extensionCallStack.push(false, RubyBaseNode.nil, RubyBaseNode.nil);
                try {
                    interop.invokeMember(truffleCExt, "init_libtruffleruby", new Object[]{library});
                    if (!this.context.getOptions().CEXTS_SULONG) {
                        interop.invokeMember(truffleCExt, "init_libtrufflerubytrampoline", new Object[]{libTrampoline});
                    }
                }
                catch (InteropException e) {
                    throw TranslateInteropExceptionNode.executeUncached(e);
                }
                finally {
                    this.language.getCurrentFiber().extensionCallStack.pop();
                }
            }
            finally {
                Metrics.printTime((String)"after-load-cext-support");
            }
            this.cextImplementationLoaded = true;
        }
        finally {
            MutexOperations.unlockInternal(this.cextImplementationLock);
        }
    }

    private Object loadCExtLibRuby(String rubyLibPath, String feature, Node currentNode) {
        if (this.context.getOptions().CEXTS_LOG_LOAD) {
            RubyLanguage.LOGGER.info(() -> String.format("loading cext implementation %s", rubyLibPath));
        }
        if (!new File(rubyLibPath).exists()) {
            throw new RaiseException(this.context, this.context.getCoreExceptions().loadError("this TruffleRuby distribution does not have the C extension implementation file " + rubyLibPath, feature, null));
        }
        return this.loadCExtLibrary("libtruffleruby", rubyLibPath, currentNode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Object loadCExtLibrary(String feature, String path, Node currentNode, boolean sulong) {
        Metrics.printTime((String)("before-load-cext-" + feature));
        try {
            TruffleFile truffleFile = FileLoader.getSafeTruffleFile(this.language, this.context, path);
            FileLoader.ensureReadable(this.context, truffleFile, currentNode);
            Source source = sulong ? Source.newBuilder((String)"nfi", (CharSequence)("with llvm load (RTLD_GLOBAL) '" + path + "'"), (String)"load RTLD_GLOBAL with Sulong through NFI").build() : Source.newBuilder((String)"nfi", (CharSequence)("load (RTLD_GLOBAL | RTLD_LAZY) '" + path + "'"), (String)"load RTLD_GLOBAL with NFI").build();
            Object library = this.context.getEnv().parseInternal(source, new String[0]).call(new Object[0]);
            this.keepLibrariesAlive.add(library);
            Object embeddedABIVersion = this.getEmbeddedABIVersion(library);
            DispatchNode.getUncached().call(this.context.getCoreLibrary().truffleCExtModule, "check_abi_version", embeddedABIVersion, (Object)path);
            Object object = library;
            return object;
        }
        finally {
            Metrics.printTime((String)("after-load-cext-" + feature));
        }
    }

    private Object getEmbeddedABIVersion(Object library) {
        long address;
        Object abiVersionFunction;
        InteropLibrary interop = InteropLibrary.getUncached();
        try {
            abiVersionFunction = interop.readMember(library, "rb_tr_abi_version");
        }
        catch (UnknownIdentifierException e) {
            return RubyBaseNode.nil;
        }
        catch (UnsupportedMessageException e) {
            throw TranslateInteropExceptionNode.executeUncached((InteropException)((Object)e));
        }
        abiVersionFunction = TruffleNFIPlatform.bind(this.context, abiVersionFunction, "():string");
        Object abiVersionNativeString = InteropNodes.execute(null, abiVersionFunction, ArrayUtils.EMPTY_ARRAY, interop, TranslateInteropExceptionNodeGen.getUncached());
        try {
            address = interop.asPointer(abiVersionNativeString);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
        Pointer pointer = new Pointer(this.context, address);
        byte[] bytes = pointer.readZeroTerminatedByteArray(this.context, interop, 0L);
        String abiVersion = new String(bytes, StandardCharsets.US_ASCII);
        return StringOperations.createUTF8String(this.context, this.language, abiVersion);
    }

    Object findFunctionInLibrary(Object library, String functionName, String path) {
        Object function;
        try {
            function = ((InteropLibrary)InteropLibrary.getFactory().getUncached(library)).readMember(library, functionName);
        }
        catch (UnknownIdentifierException e) {
            throw new RaiseException(this.context, this.context.getCoreExceptions().loadError(String.format("function %s() not found in %s", functionName, path), path, null));
        }
        catch (UnsupportedMessageException e) {
            throw TranslateInteropExceptionNode.executeUncached((InteropException)((Object)e));
        }
        if (function == null) {
            throw new RaiseException(this.context, this.context.getCoreExceptions().loadError(String.format("%s() not found (readMember() returned null)", functionName), path, null));
        }
        return function;
    }
}

