/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.truffleruby.core.kernel.TruffleKernelNodes;
import org.truffleruby.core.proc.ProcCallTargets;
import org.truffleruby.core.proc.ProcOperations;
import org.truffleruby.core.proc.ProcType;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.BreakID;
import org.truffleruby.language.control.FrameOnStackMarker;
import org.truffleruby.language.methods.BlockDefinitionNodeGen;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.methods.WithoutVisibilityNode;

public abstract class BlockDefinitionNode
extends RubyContextSourceNode {
    private final ProcType type;
    private final SharedMethodInfo sharedMethodInfo;
    private final ProcCallTargets callTargets;
    private final BreakID breakID;
    private final int frameOnStackMarkerSlot;

    public BlockDefinitionNode(ProcType type, SharedMethodInfo sharedMethodInfo, ProcCallTargets callTargets, BreakID breakID, int frameOnStackMarkerSlot) {
        assert (type == ProcType.PROC == (frameOnStackMarkerSlot != -1));
        this.type = type;
        this.sharedMethodInfo = sharedMethodInfo;
        this.callTargets = callTargets;
        this.breakID = breakID;
        this.frameOnStackMarkerSlot = frameOnStackMarkerSlot;
    }

    public BreakID getBreakID() {
        return this.breakID;
    }

    @Override
    public abstract RubyProc execute(VirtualFrame var1);

    @Specialization
    RubyProc doBlockDefinition(VirtualFrame frame, @Cached TruffleKernelNodes.GetSpecialVariableStorage readSpecialVariableStorageNode, @Cached WithoutVisibilityNode withoutVisibilityNode) {
        FrameOnStackMarker frameOnStackMarker;
        if (this.frameOnStackMarkerSlot != -1) {
            frameOnStackMarker = (FrameOnStackMarker)frame.getObject(this.frameOnStackMarkerSlot);
            assert (frameOnStackMarker != null);
        } else {
            frameOnStackMarker = null;
        }
        return ProcOperations.createRubyProc(this.coreLibrary().procClass, this.getLanguage().procShape, this.type, this.sharedMethodInfo, this.callTargets, frame.materialize(), readSpecialVariableStorageNode.execute((Frame)frame, this), RubyArguments.getMethod((Frame)frame), frameOnStackMarker, withoutVisibilityNode.executeWithoutVisibility(this, RubyArguments.getDeclarationContext((Frame)frame)));
    }

    @Override
    public RubyNode cloneUninitialized() {
        BlockDefinitionNode copy = BlockDefinitionNodeGen.create(this.type, this.sharedMethodInfo, this.callTargets, this.breakID, this.frameOnStackMarkerSlot);
        return copy.copyFlags(this);
    }
}

