/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects.shared;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.collections.BoundaryIterable;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.basicobject.RubyBasicObject;
import org.truffleruby.core.queue.RubyQueue;
import org.truffleruby.core.queue.UnsizedQueue;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.objects.shared.SharedObjects;
import org.truffleruby.language.objects.shared.WriteBarrierNode;

@GenerateInline
@GenerateCached(value=false)
@ImportStatic(value={ArrayGuards.class})
public abstract class ShareInternalFieldsNode
extends RubyBaseNode {
    protected static final int CACHE_LIMIT = 8;

    public final void execute(Node node, RubyDynamicObject object, int depth) {
        CompilerAsserts.partialEvaluationConstant((int)depth);
        this.executeInternal(node, object, depth);
    }

    protected abstract void executeInternal(Node var1, RubyDynamicObject var2, int var3);

    @Specialization(limit="CACHE_LIMIT")
    static void shareArray(RubyArray array, int depth, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
        array.setStore(stores.makeShared(store, array.size));
    }

    @Specialization
    static void shareCachedQueue(Node node, RubyQueue object, int depth, @Cached InlinedConditionProfile profileEmpty, @Cached(inline=false) WriteBarrierNode writeBarrierNode) {
        UnsizedQueue queue = object.queue;
        if (!profileEmpty.profile(node, queue.isEmpty())) {
            for (Object e : BoundaryIterable.wrap(queue.getContents())) {
                writeBarrierNode.executeCached(e, depth);
            }
        }
    }

    @Specialization
    static void shareCachedBasicObject(RubyBasicObject object, int depth) {
    }

    @Specialization(replaces={"shareArray", "shareCachedQueue", "shareCachedBasicObject"})
    static void shareUncached(RubyDynamicObject object, int depth) {
        SharedObjects.shareInternalFields(object);
    }
}

