/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects.shared;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.PropertyGetter;
import com.oracle.truffle.api.object.Shape;
import java.util.ArrayList;
import java.util.Objects;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.shared.ShareInternalFieldsNode;
import org.truffleruby.language.objects.shared.SharedObjects;
import org.truffleruby.language.objects.shared.WriteBarrierNode;
import org.truffleruby.language.objects.shared.WriteBarrierNodeGen;
import org.truffleruby.utils.RunTwiceBranchProfile;

@GenerateInline
@GenerateCached(value=false)
@ReportPolymorphism
public abstract class ShareObjectNode
extends RubyBaseNode {
    protected static final int CACHE_LIMIT = 8;

    public final void execute(Node node, RubyDynamicObject object, int depth) {
        CompilerAsserts.partialEvaluationConstant((int)depth);
        this.executeInternal(node, object, depth);
    }

    protected abstract void executeInternal(Node var1, RubyDynamicObject var2, int var3);

    @ExplodeLoop
    @Specialization(guards={"object.getShape() == cachedShape", "propertyGetters.length <= MAX_EXPLODE_SIZE"}, assumptions={"cachedShape.getValidAssumption()", "sharedShape.getValidAssumption()"}, limit="CACHE_LIMIT")
    static void shareCached(Node node, RubyDynamicObject object, int depth, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="createSharedShape(cachedShape)") Shape sharedShape, @CachedLibrary(limit="1") DynamicObjectLibrary objectLibrary, @Cached(value="new()") RunTwiceBranchProfile shareMetaClassProfile, @Cached ShareInternalFieldsNode shareInternalFieldsNode, @Cached(value="getObjectProperties(sharedShape)", dimensions=1) PropertyGetter[] propertyGetters, @Cached(value="createWriteBarrierNodes(propertyGetters)") WriteBarrierNode[] writeBarrierNodes) {
        assert (object.getShape() == cachedShape);
        objectLibrary.markShared((DynamicObject)object);
        assert (object.getShape() == sharedShape);
        if (!object.getMetaClass().getShape().isShared()) {
            shareMetaClassProfile.enter();
            SharedObjects.writeBarrier(ShareObjectNode.getLanguage(node), object.getMetaClass());
        }
        assert (SharedObjects.isShared(object.getLogicalClass())) : "the logical class should have been shared by the metaclass";
        shareInternalFieldsNode.execute(node, object, depth);
        for (int i = 0; i < propertyGetters.length; ++i) {
            PropertyGetter propertyGetter = propertyGetters[i];
            Object value = propertyGetter.get((DynamicObject)object);
            writeBarrierNodes[i].executeCached(value, depth);
        }
        assert (ShareObjectNode.allFieldsAreShared(object));
    }

    private static boolean allFieldsAreShared(RubyDynamicObject object) {
        for (Object value : ObjectGraph.getAdjacentObjects(object)) {
            assert (SharedObjects.isShared(value)) : "unshared field in shared object: " + String.valueOf(value);
        }
        return true;
    }

    @Specialization(replaces={"shareCached"})
    static void shareUncached(Node node, RubyDynamicObject object, int depth) {
        SharedObjects.writeBarrier(ShareObjectNode.getLanguage(node), (Object)object);
    }

    protected static PropertyGetter[] getObjectProperties(Shape shape) {
        ArrayList<PropertyGetter> objectProperties = new ArrayList<PropertyGetter>();
        for (Property property : shape.getPropertyListInternal(false)) {
            if (property.getLocation().isPrimitive()) continue;
            objectProperties.add(Objects.requireNonNull(shape.makePropertyGetter(property.getKey())));
        }
        return objectProperties.toArray(KernelNodes.CopyInstanceVariablesNode.EMPTY_PROPERTY_GETTER_ARRAY);
    }

    protected static WriteBarrierNode[] createWriteBarrierNodes(PropertyGetter[] propertyGetters) {
        WriteBarrierNode[] nodes = propertyGetters.length == 0 ? WriteBarrierNode.EMPTY_ARRAY : new WriteBarrierNode[propertyGetters.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = WriteBarrierNodeGen.create();
        }
        return nodes;
    }

    protected static Shape createSharedShape(Shape cachedShape) {
        if (cachedShape.isShared()) {
            throw new UnsupportedOperationException("Thread-safety bug: the object is already shared. This means another thread marked the object as shared concurrently.");
        }
        return cachedShape.makeSharedShape();
    }
}

