/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.yield;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.proc.ProcOperations;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.yield.CallBlockNodeGen;

@ReportPolymorphism
@GenerateUncached
@GenerateInline(inlineByDefault=true)
public abstract class CallBlockNode
extends RubyBaseNode {
    @NeverDefault
    public static CallBlockNode create() {
        return CallBlockNodeGen.create();
    }

    public static Object executeUncached(DeclarationContext declarationContext, RubyProc block, Object self, Object blockArgument, ArgumentsDescriptor descriptor, Object[] arguments) {
        return CallBlockNodeGen.getUncached().executeCallBlock(null, declarationContext, block, self, blockArgument, descriptor, arguments);
    }

    public static Object yieldUncached(RubyProc block, Object ... args) {
        return CallBlockNodeGen.getUncached().executeCallBlock(null, block.declarationContext, block, ProcOperations.getSelf(block), nil, NoKeywordArgumentsDescriptor.INSTANCE, args);
    }

    public final Object yieldCached(RubyProc block, ArgumentsDescriptor descriptor, Object ... args) {
        return this.executeCallBlock(this, block.declarationContext, block, ProcOperations.getSelf(block), nil, descriptor, args);
    }

    public final Object yield(Node node, RubyProc block, Object ... args) {
        return this.executeCallBlock(node, block.declarationContext, block, ProcOperations.getSelf(block), nil, NoKeywordArgumentsDescriptor.INSTANCE, args);
    }

    public final Object yieldCached(RubyProc block, Object ... args) {
        return this.executeCallBlock(this, block.declarationContext, block, ProcOperations.getSelf(block), nil, NoKeywordArgumentsDescriptor.INSTANCE, args);
    }

    public abstract Object executeCallBlock(Node var1, DeclarationContext var2, RubyProc var3, Object var4, Object var5, ArgumentsDescriptor var6, Object[] var7);

    @Specialization(guards={"block.callTarget == cachedCallTarget"}, limit="getCacheLimit()")
    static Object callBlockCached(Node node, DeclarationContext declarationContext, RubyProc block, Object self, Object blockArgument, ArgumentsDescriptor descriptor, Object[] arguments, @Cached(value="block.callTarget") RootCallTarget cachedCallTarget, @Cached(value="createBlockCallNode(node, cachedCallTarget)") DirectCallNode callNode) {
        Object[] frameArguments = CallBlockNode.packArguments(declarationContext, block, self, blockArgument, descriptor, arguments);
        return callNode.call(frameArguments);
    }

    @Specialization(replaces={"callBlockCached"})
    static Object callBlockUncached(DeclarationContext declarationContext, RubyProc block, Object self, Object blockArgument, ArgumentsDescriptor descriptor, Object[] arguments, @Cached(inline=false) IndirectCallNode callNode) {
        Object[] frameArguments = CallBlockNode.packArguments(declarationContext, block, self, blockArgument, descriptor, arguments);
        return callNode.call((CallTarget)block.callTarget, frameArguments);
    }

    private static Object[] packArguments(DeclarationContext declarationContext, RubyProc block, Object self, Object blockArgument, ArgumentsDescriptor descriptor, Object[] arguments) {
        return RubyArguments.pack(block.declarationFrame, null, block.declaringMethod, declarationContext, block.frameOnStackMarker, self, blockArgument, descriptor, arguments);
    }

    protected static DirectCallNode createBlockCallNode(Node node, RootCallTarget callTarget) {
        DirectCallNode callNode = Truffle.getRuntime().createDirectCallNode((CallTarget)callTarget);
        if (callNode.isCallTargetCloningAllowed() && RubyRootNode.of(callTarget).shouldAlwaysClone()) {
            callNode.cloneCallTarget();
        }
        if (CallBlockNode.getContext((Node)node).getOptions().YIELD_ALWAYS_INLINE && callNode.isInlinable()) {
            callNode.forceInlining();
        }
        return callNode;
    }

    protected int getCacheLimit() {
        return this.getLanguage().options.YIELD_CACHE;
    }
}

