/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import org.prism.Nodes;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Split;
import org.truffleruby.language.RubyMethodRootNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.CachedLazyCallTargetSupplier;
import org.truffleruby.parser.RubyDeferredWarnings;
import org.truffleruby.parser.TranslatorEnvironment;
import org.truffleruby.parser.YARPLoadArgumentsTranslator;
import org.truffleruby.parser.YARPTranslator;

public final class YARPDefNodeTranslator
extends YARPTranslator {
    private final boolean shouldLazyTranslate;

    public YARPDefNodeTranslator(RubyLanguage language, TranslatorEnvironment environment, RubyDeferredWarnings rubyWarnings) {
        super(environment, rubyWarnings);
        this.shouldLazyTranslate = this.parseEnvironment.parserContext.isEval() || this.parseEnvironment.isCoverageEnabled() ? false : (language.getSourcePath(this.source).startsWith(language.coreLoadPath) ? language.options.LAZY_TRANSLATION_CORE : language.options.LAZY_TRANSLATION_USER);
    }

    private RubyNode compileMethodBody(Nodes.DefNode node, Nodes.ParametersNode parameters, Arity arity) {
        this.declareLocalVariables(node);
        RubyNode loadArguments = new YARPLoadArgumentsTranslator(this.environment, parameters, arity, false, true, this).translate();
        RubyNode body = this.translateNodeOrNil(node.body).simplifyAsTailExpression();
        body = YARPDefNodeTranslator.sequence(loadArguments, body);
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = YARPDefNodeTranslator.sequence(YARPDefNodeTranslator.initFlipFlopStates(this.environment), body);
        }
        return body;
    }

    private RubyMethodRootNode translateMethodNode(Nodes.DefNode node, Nodes.ParametersNode parameters, Arity arity) {
        RubyNode body = this.compileMethodBody(node, parameters, arity);
        return new RubyMethodRootNode(this.language, this.getSourceSection(node), this.environment.computeFrameDescriptor(), this.environment.getSharedMethodInfo(), body, Split.HEURISTIC, this.environment.getReturnID(), arity);
    }

    public CachedLazyCallTargetSupplier buildMethodNodeCompiler(Nodes.DefNode node, Nodes.ParametersNode parameters, Arity arity) {
        if (this.shouldLazyTranslate) {
            return new CachedLazyCallTargetSupplier(() -> this.translateMethodNode(node, parameters, arity).getCallTarget());
        }
        RubyMethodRootNode root = this.translateMethodNode(node, parameters, arity);
        return new CachedLazyCallTargetSupplier(() -> root.getCallTarget());
    }

    private void declareLocalVariables(Nodes.DefNode node) {
        for (String name : node.locals) {
            assert (!(name.equals("*") || name.equals("**") || name.equals("&") || name.equals("..."))) : name;
            this.environment.declareVar(name);
        }
    }
}

