/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.Collections;
import org.prism.Nodes;
import org.truffleruby.core.hash.ConcatHashLiteralNode;
import org.truffleruby.core.hash.HashLiteralNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.MissingArgumentBehavior;
import org.truffleruby.language.arguments.ReadPreArgumentNode;
import org.truffleruby.language.literal.ObjectLiteralNode;
import org.truffleruby.language.locals.ReadLocalNode;
import org.truffleruby.parser.TranslatorEnvironment;
import org.truffleruby.parser.YARPBaseTranslator;
import org.truffleruby.parser.YARPTranslator;

public final class YARPReloadArgumentsTranslator
extends YARPBaseTranslator {
    private final YARPTranslator yarpTranslator;
    private final boolean hasKeywordArguments;
    private int index = 0;
    private int restParameterIndex = -1;
    private int repeatedParameterCounter = 2;

    public YARPReloadArgumentsTranslator(TranslatorEnvironment environment, YARPTranslator yarpTranslator, Nodes.ParametersNode parametersNode) {
        super(environment);
        this.yarpTranslator = yarpTranslator;
        this.hasKeywordArguments = parametersNode.keywords.length > 0 || parametersNode.keyword_rest != null;
    }

    public int getRestParameterIndex() {
        return this.restParameterIndex;
    }

    public RubyNode[] reload(Nodes.ParametersNode parameters) {
        ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
        for (Nodes.Node node : parameters.requireds) {
            sequence.add(node.accept(this));
            ++this.index;
        }
        for (Nodes.Node node : parameters.optionals) {
            sequence.add(((Nodes.OptionalParameterNode)node).accept(this));
            ++this.index;
        }
        if (parameters.rest != null) {
            this.restParameterIndex = this.index;
            sequence.add(parameters.rest.accept(this));
        }
        this.index = -1;
        ArrayList<RubyNode> postsSequence = new ArrayList<RubyNode>();
        for (int i = parameters.posts.length - 1; i >= 0; --i) {
            postsSequence.add(parameters.posts[i].accept(this));
            --this.index;
        }
        Collections.reverse(postsSequence);
        sequence.addAll(postsSequence);
        RubyNode kwArgsNode = null;
        if (parameters.keywords.length > 0) {
            int keywordsCount = parameters.keywords.length;
            RubyNode[] rubyNodeArray = new RubyNode[keywordsCount * 2];
            for (int i = 0; i < keywordsCount; ++i) {
                String name;
                Nodes.Node keyword = parameters.keywords[i];
                if (keyword instanceof Nodes.OptionalKeywordParameterNode) {
                    Nodes.OptionalKeywordParameterNode optional = (Nodes.OptionalKeywordParameterNode)keyword;
                    name = optional.name;
                } else if (keyword instanceof Nodes.RequiredKeywordParameterNode) {
                    Nodes.RequiredKeywordParameterNode required = (Nodes.RequiredKeywordParameterNode)keyword;
                    name = required.name;
                } else {
                    throw CompilerDirectives.shouldNotReachHere();
                }
                ObjectLiteralNode nameNode = new ObjectLiteralNode(this.language.getSymbol(name));
                RubyNode readValueNode = keyword.accept(this);
                rubyNodeArray[2 * i] = nameNode;
                rubyNodeArray[2 * i + 1] = readValueNode;
            }
            kwArgsNode = HashLiteralNode.create(rubyNodeArray, this.language);
        }
        if (parameters.keyword_rest != null) {
            if (parameters.keyword_rest instanceof Nodes.KeywordRestParameterNode) {
                RubyNode keyRest = parameters.keyword_rest.accept(this);
                kwArgsNode = kwArgsNode == null ? keyRest : new ConcatHashLiteralNode(new RubyNode[]{kwArgsNode, keyRest});
            } else if (!(parameters.keyword_rest instanceof Nodes.NoKeywordsParameterNode) && !(parameters.keyword_rest instanceof Nodes.ForwardingParameterNode)) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        if (kwArgsNode != null) {
            sequence.add(kwArgsNode);
        }
        if (parameters.keyword_rest instanceof Nodes.ForwardingParameterNode) {
            this.restParameterIndex = parameters.requireds.length + parameters.optionals.length;
            ReadLocalNode readRestNode = this.environment.findLocalVarNode("%forward_rest");
            sequence.add(readRestNode);
            ReadLocalNode readLocalNode = this.environment.findLocalVarNode("%forward_kwrest");
            sequence.add(readLocalNode);
        }
        return sequence.toArray(RubyNode.EMPTY_ARRAY);
    }

    @Override
    public RubyNode visitRequiredParameterNode(Nodes.RequiredParameterNode node) {
        String name = node.isRepeatedParameter() ? this.createNameForRepeatedParameter(node.name) : node.name;
        return this.environment.findLocalVarNode(name);
    }

    @Override
    public RubyNode visitOptionalParameterNode(Nodes.OptionalParameterNode node) {
        String name = node.isRepeatedParameter() ? this.createNameForRepeatedParameter(node.name) : node.name;
        return this.environment.findLocalVarNode(name);
    }

    @Override
    public RubyNode visitMultiTargetNode(Nodes.MultiTargetNode node) {
        return YARPTranslator.profileArgument(this.language, new ReadPreArgumentNode(this.index, this.hasKeywordArguments, MissingArgumentBehavior.NIL));
    }

    @Override
    public RubyNode visitRestParameterNode(Nodes.RestParameterNode node) {
        String name = node.name != null ? (node.isRepeatedParameter() ? this.createNameForRepeatedParameter(node.name) : node.name) : "%unnamed_rest";
        return this.environment.findLocalVarNode(name);
    }

    @Override
    public RubyNode visitRequiredKeywordParameterNode(Nodes.RequiredKeywordParameterNode node) {
        return this.environment.findLocalVarNode(node.name);
    }

    @Override
    public RubyNode visitOptionalKeywordParameterNode(Nodes.OptionalKeywordParameterNode node) {
        return this.environment.findLocalVarNode(node.name);
    }

    @Override
    public RubyNode visitKeywordRestParameterNode(Nodes.KeywordRestParameterNode node) {
        String name = node.name != null ? node.name : "%kwrest";
        return this.environment.findLocalVarNode(name);
    }

    @Override
    public RubyNode visitNoKeywordsParameterNode(Nodes.NoKeywordsParameterNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitForwardingParameterNode(Nodes.ForwardingParameterNode node) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RubyNode defaultVisit(Nodes.Node node) {
        return this.yarpTranslator.defaultVisit(node);
    }

    private String createNameForRepeatedParameter(String name) {
        int count = this.repeatedParameterCounter++;
        return "%" + name + count;
    }
}

