/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.platform;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.platform.DarwinAArch64NativeConfiguration;
import org.truffleruby.platform.DarwinAMD64NativeConfiguration;
import org.truffleruby.platform.LinuxAArch64NativeConfiguration;
import org.truffleruby.platform.LinuxAMD64NativeConfiguration;
import org.truffleruby.shared.Platform;
import org.truffleruby.shared.TruffleRuby;

public final class NativeConfiguration {
    public static final String PREFIX = "platform.";
    private final Map<String, Object> configuration = new HashMap<String, Object>();

    public static NativeConfiguration loadNativeConfiguration(RubyContext context) {
        NativeConfiguration nativeConfiguration = new NativeConfiguration();
        switch (Platform.OS) {
            case LINUX: {
                switch (Platform.ARCHITECTURE) {
                    case AMD64: {
                        LinuxAMD64NativeConfiguration.load(nativeConfiguration, context);
                        return nativeConfiguration;
                    }
                    case AARCH64: {
                        LinuxAArch64NativeConfiguration.load(nativeConfiguration, context);
                        return nativeConfiguration;
                    }
                }
                break;
            }
            case DARWIN: {
                switch (Platform.ARCHITECTURE) {
                    case AMD64: {
                        DarwinAMD64NativeConfiguration.load(nativeConfiguration, context);
                        return nativeConfiguration;
                    }
                    case AARCH64: {
                        DarwinAArch64NativeConfiguration.load(nativeConfiguration, context);
                        return nativeConfiguration;
                    }
                }
            }
        }
        RubyLanguage.LOGGER.severe("no native configuration for platform " + TruffleRuby.RUBY_PLATFORM);
        return nativeConfiguration;
    }

    public void config(String key, Object value) {
        this.configuration.put(key, value);
    }

    @CompilerDirectives.TruffleBoundary
    public Object get(String key) {
        return this.configuration.get(key);
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<Map.Entry<String, Object>> getSection(String section) {
        ArrayList<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>();
        for (Map.Entry<String, Object> entry : this.configuration.entrySet()) {
            if (!entry.getKey().startsWith(section)) continue;
            entries.add(entry);
        }
        return entries;
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<Object> objectGraphValues() {
        Collection<Object> values = this.configuration.values();
        ArrayList<Object> objects = new ArrayList<Object>(values.size());
        for (Object value : values) {
            if (!ObjectGraph.isRubyObject(value)) continue;
            objects.add(value);
        }
        return objects;
    }
}

