/*
 * Decompiled with CFR 0.152.
 */
package org.prism;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.prism.AbstractNodeVisitor;

public abstract class Nodes {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static ErrorType[] ERROR_TYPES = ErrorType.values();
    public static WarningType[] WARNING_TYPES = WarningType.values();

    public static enum ErrorType {
        ALIAS_ARGUMENT,
        ALIAS_ARGUMENT_NUMBERED_REFERENCE,
        AMPAMPEQ_MULTI_ASSIGN,
        ARGUMENT_AFTER_BLOCK,
        ARGUMENT_AFTER_FORWARDING_ELLIPSES,
        ARGUMENT_BARE_HASH,
        ARGUMENT_BLOCK_FORWARDING,
        ARGUMENT_BLOCK_MULTI,
        ARGUMENT_CONFLICT_AMPERSAND,
        ARGUMENT_CONFLICT_STAR,
        ARGUMENT_CONFLICT_STAR_STAR,
        ARGUMENT_FORMAL_CLASS,
        ARGUMENT_FORMAL_CONSTANT,
        ARGUMENT_FORMAL_GLOBAL,
        ARGUMENT_FORMAL_IVAR,
        ARGUMENT_FORWARDING_UNBOUND,
        ARGUMENT_NO_FORWARDING_AMPERSAND,
        ARGUMENT_NO_FORWARDING_ELLIPSES,
        ARGUMENT_NO_FORWARDING_STAR,
        ARGUMENT_NO_FORWARDING_STAR_STAR,
        ARGUMENT_SPLAT_AFTER_ASSOC_SPLAT,
        ARGUMENT_SPLAT_AFTER_SPLAT,
        ARGUMENT_TERM_PAREN,
        ARGUMENT_UNEXPECTED_BLOCK,
        ARRAY_ELEMENT,
        ARRAY_EXPRESSION,
        ARRAY_EXPRESSION_AFTER_STAR,
        ARRAY_SEPARATOR,
        ARRAY_TERM,
        BEGIN_LONELY_ELSE,
        BEGIN_TERM,
        BEGIN_UPCASE_BRACE,
        BEGIN_UPCASE_TERM,
        BEGIN_UPCASE_TOPLEVEL,
        BLOCK_PARAM_LOCAL_VARIABLE,
        BLOCK_PARAM_PIPE_TERM,
        BLOCK_TERM_BRACE,
        BLOCK_TERM_END,
        CANNOT_PARSE_EXPRESSION,
        CANNOT_PARSE_STRING_PART,
        CASE_EXPRESSION_AFTER_CASE,
        CASE_EXPRESSION_AFTER_WHEN,
        CASE_MATCH_MISSING_PREDICATE,
        CASE_MISSING_CONDITIONS,
        CASE_TERM,
        CLASS_IN_METHOD,
        CLASS_NAME,
        CLASS_SUPERCLASS,
        CLASS_TERM,
        CLASS_UNEXPECTED_END,
        CLASS_VARIABLE_BARE,
        CONDITIONAL_ELSIF_PREDICATE,
        CONDITIONAL_IF_PREDICATE,
        CONDITIONAL_PREDICATE_TERM,
        CONDITIONAL_TERM,
        CONDITIONAL_TERM_ELSE,
        CONDITIONAL_UNLESS_PREDICATE,
        CONDITIONAL_UNTIL_PREDICATE,
        CONDITIONAL_WHILE_PREDICATE,
        CONSTANT_PATH_COLON_COLON_CONSTANT,
        DEF_ENDLESS,
        DEF_ENDLESS_SETTER,
        DEF_NAME,
        DEF_PARAMS_TERM,
        DEF_PARAMS_TERM_PAREN,
        DEF_RECEIVER,
        DEF_RECEIVER_TERM,
        DEF_TERM,
        DEFINED_EXPRESSION,
        EMBDOC_TERM,
        EMBEXPR_END,
        EMBVAR_INVALID,
        END_UPCASE_BRACE,
        END_UPCASE_TERM,
        ESCAPE_INVALID_CONTROL,
        ESCAPE_INVALID_CONTROL_REPEAT,
        ESCAPE_INVALID_HEXADECIMAL,
        ESCAPE_INVALID_META,
        ESCAPE_INVALID_META_REPEAT,
        ESCAPE_INVALID_UNICODE,
        ESCAPE_INVALID_UNICODE_CM_FLAGS,
        ESCAPE_INVALID_UNICODE_LIST,
        ESCAPE_INVALID_UNICODE_LITERAL,
        ESCAPE_INVALID_UNICODE_LONG,
        ESCAPE_INVALID_UNICODE_SHORT,
        ESCAPE_INVALID_UNICODE_TERM,
        EXPECT_ARGUMENT,
        EXPECT_EOL_AFTER_STATEMENT,
        EXPECT_EXPRESSION_AFTER_AMPAMPEQ,
        EXPECT_EXPRESSION_AFTER_COMMA,
        EXPECT_EXPRESSION_AFTER_EQUAL,
        EXPECT_EXPRESSION_AFTER_LESS_LESS,
        EXPECT_EXPRESSION_AFTER_LPAREN,
        EXPECT_EXPRESSION_AFTER_OPERATOR,
        EXPECT_EXPRESSION_AFTER_PIPEPIPEEQ,
        EXPECT_EXPRESSION_AFTER_QUESTION,
        EXPECT_EXPRESSION_AFTER_SPLAT,
        EXPECT_EXPRESSION_AFTER_SPLAT_HASH,
        EXPECT_EXPRESSION_AFTER_STAR,
        EXPECT_FOR_DELIMITER,
        EXPECT_IDENT_REQ_PARAMETER,
        EXPECT_IN_DELIMITER,
        EXPECT_LPAREN_REQ_PARAMETER,
        EXPECT_MESSAGE,
        EXPECT_RBRACKET,
        EXPECT_RPAREN,
        EXPECT_RPAREN_AFTER_MULTI,
        EXPECT_RPAREN_REQ_PARAMETER,
        EXPECT_SINGLETON_CLASS_DELIMITER,
        EXPECT_STRING_CONTENT,
        EXPECT_WHEN_DELIMITER,
        EXPRESSION_BARE_HASH,
        EXPRESSION_NOT_WRITABLE,
        EXPRESSION_NOT_WRITABLE_ENCODING,
        EXPRESSION_NOT_WRITABLE_FALSE,
        EXPRESSION_NOT_WRITABLE_FILE,
        EXPRESSION_NOT_WRITABLE_LINE,
        EXPRESSION_NOT_WRITABLE_NIL,
        EXPRESSION_NOT_WRITABLE_NUMBERED,
        EXPRESSION_NOT_WRITABLE_SELF,
        EXPRESSION_NOT_WRITABLE_TRUE,
        FLOAT_PARSE,
        FOR_COLLECTION,
        FOR_IN,
        FOR_INDEX,
        FOR_TERM,
        GLOBAL_VARIABLE_BARE,
        HASH_EXPRESSION_AFTER_LABEL,
        HASH_KEY,
        HASH_ROCKET,
        HASH_TERM,
        HASH_VALUE,
        HEREDOC_IDENTIFIER,
        HEREDOC_TERM,
        INCOMPLETE_QUESTION_MARK,
        INCOMPLETE_VARIABLE_CLASS,
        INCOMPLETE_VARIABLE_CLASS_3_3,
        INCOMPLETE_VARIABLE_INSTANCE,
        INCOMPLETE_VARIABLE_INSTANCE_3_3,
        INSTANCE_VARIABLE_BARE,
        INVALID_BLOCK_EXIT,
        INVALID_CHARACTER,
        INVALID_ENCODING_MAGIC_COMMENT,
        INVALID_ESCAPE_CHARACTER,
        INVALID_FLOAT_EXPONENT,
        INVALID_LOCAL_VARIABLE_READ,
        INVALID_LOCAL_VARIABLE_WRITE,
        INVALID_MULTIBYTE_CHAR,
        INVALID_MULTIBYTE_CHARACTER,
        INVALID_MULTIBYTE_ESCAPE,
        INVALID_NUMBER_BINARY,
        INVALID_NUMBER_DECIMAL,
        INVALID_NUMBER_FRACTION,
        INVALID_NUMBER_HEXADECIMAL,
        INVALID_NUMBER_OCTAL,
        INVALID_NUMBER_UNDERSCORE_INNER,
        INVALID_NUMBER_UNDERSCORE_TRAILING,
        INVALID_PERCENT,
        INVALID_PERCENT_EOF,
        INVALID_PRINTABLE_CHARACTER,
        INVALID_RETRY_AFTER_ELSE,
        INVALID_RETRY_AFTER_ENSURE,
        INVALID_RETRY_WITHOUT_RESCUE,
        INVALID_SYMBOL,
        INVALID_VARIABLE_GLOBAL,
        INVALID_VARIABLE_GLOBAL_3_3,
        INVALID_YIELD,
        IT_NOT_ALLOWED_NUMBERED,
        IT_NOT_ALLOWED_ORDINARY,
        LAMBDA_OPEN,
        LAMBDA_TERM_BRACE,
        LAMBDA_TERM_END,
        LIST_I_LOWER_ELEMENT,
        LIST_I_LOWER_TERM,
        LIST_I_UPPER_ELEMENT,
        LIST_I_UPPER_TERM,
        LIST_W_LOWER_ELEMENT,
        LIST_W_LOWER_TERM,
        LIST_W_UPPER_ELEMENT,
        LIST_W_UPPER_TERM,
        MALLOC_FAILED,
        MIXED_ENCODING,
        MODULE_IN_METHOD,
        MODULE_NAME,
        MODULE_TERM,
        MULTI_ASSIGN_MULTI_SPLATS,
        MULTI_ASSIGN_UNEXPECTED_REST,
        NESTING_TOO_DEEP,
        NO_LOCAL_VARIABLE,
        NON_ASSOCIATIVE_OPERATOR,
        NOT_EXPRESSION,
        NUMBER_LITERAL_UNDERSCORE,
        NUMBERED_PARAMETER_INNER_BLOCK,
        NUMBERED_PARAMETER_IT,
        NUMBERED_PARAMETER_ORDINARY,
        NUMBERED_PARAMETER_OUTER_BLOCK,
        OPERATOR_MULTI_ASSIGN,
        OPERATOR_WRITE_ARGUMENTS,
        OPERATOR_WRITE_BLOCK,
        PARAMETER_ASSOC_SPLAT_MULTI,
        PARAMETER_BLOCK_MULTI,
        PARAMETER_CIRCULAR,
        PARAMETER_FORWARDING_AFTER_REST,
        PARAMETER_METHOD_NAME,
        PARAMETER_NAME_DUPLICATED,
        PARAMETER_NO_DEFAULT,
        PARAMETER_NO_DEFAULT_KW,
        PARAMETER_NUMBERED_RESERVED,
        PARAMETER_ORDER,
        PARAMETER_SPLAT_MULTI,
        PARAMETER_STAR,
        PARAMETER_UNEXPECTED_FWD,
        PARAMETER_UNEXPECTED_NO_KW,
        PARAMETER_WILD_LOOSE_COMMA,
        PATTERN_ARRAY_MULTIPLE_RESTS,
        PATTERN_CAPTURE_DUPLICATE,
        PATTERN_EXPRESSION_AFTER_BRACKET,
        PATTERN_EXPRESSION_AFTER_COMMA,
        PATTERN_EXPRESSION_AFTER_HROCKET,
        PATTERN_EXPRESSION_AFTER_IN,
        PATTERN_EXPRESSION_AFTER_KEY,
        PATTERN_EXPRESSION_AFTER_PAREN,
        PATTERN_EXPRESSION_AFTER_PIN,
        PATTERN_EXPRESSION_AFTER_PIPE,
        PATTERN_EXPRESSION_AFTER_RANGE,
        PATTERN_EXPRESSION_AFTER_REST,
        PATTERN_FIND_MISSING_INNER,
        PATTERN_HASH_IMPLICIT,
        PATTERN_HASH_KEY,
        PATTERN_HASH_KEY_DUPLICATE,
        PATTERN_HASH_KEY_INTERPOLATED,
        PATTERN_HASH_KEY_LABEL,
        PATTERN_HASH_KEY_LOCALS,
        PATTERN_IDENT_AFTER_HROCKET,
        PATTERN_LABEL_AFTER_COMMA,
        PATTERN_REST,
        PATTERN_TERM_BRACE,
        PATTERN_TERM_BRACKET,
        PATTERN_TERM_PAREN,
        PIPEPIPEEQ_MULTI_ASSIGN,
        REGEXP_ENCODING_OPTION_MISMATCH,
        REGEXP_INCOMPAT_CHAR_ENCODING,
        REGEXP_INVALID_UNICODE_RANGE,
        REGEXP_NON_ESCAPED_MBC,
        REGEXP_PARSE_ERROR,
        REGEXP_TERM,
        REGEXP_UNKNOWN_OPTIONS,
        REGEXP_UTF8_CHAR_NON_UTF8_REGEXP,
        RESCUE_EXPRESSION,
        RESCUE_MODIFIER_VALUE,
        RESCUE_TERM,
        RESCUE_VARIABLE,
        RETURN_INVALID,
        SCRIPT_NOT_FOUND,
        SINGLETON_FOR_LITERALS,
        STATEMENT_ALIAS,
        STATEMENT_POSTEXE_END,
        STATEMENT_PREEXE_BEGIN,
        STATEMENT_UNDEF,
        STRING_CONCATENATION,
        STRING_INTERPOLATED_TERM,
        STRING_LITERAL_EOF,
        STRING_LITERAL_TERM,
        SYMBOL_INVALID,
        SYMBOL_TERM_DYNAMIC,
        SYMBOL_TERM_INTERPOLATED,
        TERNARY_COLON,
        TERNARY_EXPRESSION_FALSE,
        TERNARY_EXPRESSION_TRUE,
        UNARY_DISALLOWED,
        UNARY_RECEIVER,
        UNDEF_ARGUMENT,
        UNEXPECTED_BLOCK_ARGUMENT,
        UNEXPECTED_INDEX_BLOCK,
        UNEXPECTED_INDEX_KEYWORDS,
        UNEXPECTED_LABEL,
        UNEXPECTED_MULTI_WRITE,
        UNEXPECTED_RANGE_OPERATOR,
        UNEXPECTED_SAFE_NAVIGATION,
        UNEXPECTED_TOKEN_CLOSE_CONTEXT,
        UNEXPECTED_TOKEN_IGNORE,
        UNTIL_TERM,
        VOID_EXPRESSION,
        WHILE_TERM,
        WRITE_TARGET_IN_METHOD,
        WRITE_TARGET_READONLY,
        WRITE_TARGET_UNEXPECTED,
        XSTRING_TERM;

    }

    public static enum WarningType {
        AMBIGUOUS_BINARY_OPERATOR,
        AMBIGUOUS_FIRST_ARGUMENT_MINUS,
        AMBIGUOUS_FIRST_ARGUMENT_PLUS,
        AMBIGUOUS_PREFIX_AMPERSAND,
        AMBIGUOUS_PREFIX_STAR,
        AMBIGUOUS_PREFIX_STAR_STAR,
        AMBIGUOUS_SLASH,
        COMPARISON_AFTER_COMPARISON,
        DOT_DOT_DOT_EOL,
        EQUAL_IN_CONDITIONAL,
        EQUAL_IN_CONDITIONAL_3_3,
        END_IN_METHOD,
        DUPLICATED_HASH_KEY,
        DUPLICATED_WHEN_CLAUSE,
        FLOAT_OUT_OF_RANGE,
        IGNORED_FROZEN_STRING_LITERAL,
        INDENTATION_MISMATCH,
        INTEGER_IN_FLIP_FLOP,
        INVALID_CHARACTER,
        INVALID_MAGIC_COMMENT_VALUE,
        INVALID_NUMBERED_REFERENCE,
        KEYWORD_EOL,
        LITERAL_IN_CONDITION_DEFAULT,
        LITERAL_IN_CONDITION_VERBOSE,
        SHAREABLE_CONSTANT_VALUE_LINE,
        SHEBANG_CARRIAGE_RETURN,
        UNEXPECTED_CARRIAGE_RETURN,
        UNREACHABLE_STATEMENT,
        UNUSED_LOCAL_VARIABLE,
        VOID_STATEMENT;

    }

    public static final class YieldNode
    extends Node {
        public final ArgumentsNode arguments;

        public YieldNode(int startOffset, int length, ArgumentsNode arguments) {
            super(startOffset, length);
            this.arguments = arguments;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.arguments};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitYieldNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("arguments: ");
            builder.append(this.arguments == null ? "null\n" : this.arguments.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class XStringNode
    extends Node {
        public final short flags;
        public final byte[] unescaped;

        public XStringNode(int startOffset, int length, short flags, byte[] unescaped) {
            super(startOffset, length);
            this.flags = flags;
            this.unescaped = unescaped;
        }

        public boolean isForcedUtf8Encoding() {
            return EncodingFlags.isForcedUtf8Encoding(this.flags);
        }

        public boolean isForcedBinaryEncoding() {
            return EncodingFlags.isForcedBinaryEncoding(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitXStringNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("EncodingFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("unescaped: ");
            builder.append('\"' + new String(this.unescaped, StandardCharsets.UTF_8) + '\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class WhileNode
    extends Node {
        public final short flags;
        public final Node predicate;
        public final StatementsNode statements;

        public WhileNode(int startOffset, int length, short flags, Node predicate, StatementsNode statements) {
            super(startOffset, length);
            this.flags = flags;
            this.predicate = predicate;
            this.statements = statements;
        }

        public boolean isBeginModifier() {
            return LoopFlags.isBeginModifier(this.flags);
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            this.predicate.setNewLineFlag(source, newlineMarked);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.predicate.accept(visitor);
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.predicate, this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitWhileNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("LoopFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("predicate: ");
            builder.append(this.predicate.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("statements: ");
            builder.append(this.statements == null ? "null\n" : this.statements.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class WhenNode
    extends Node {
        public final Node[] conditions;
        public final StatementsNode statements;

        public WhenNode(int startOffset, int length, Node[] conditions, StatementsNode statements) {
            super(startOffset, length);
            this.conditions = conditions;
            this.statements = statements;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.conditions) {
                child.accept(visitor);
            }
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.conditions));
            childNodes.add(this.statements);
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitWhenNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("conditions: ");
            builder.append('\n');
            for (Node child : this.conditions) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            builder.append(nextIndent);
            builder.append("statements: ");
            builder.append(this.statements == null ? "null\n" : this.statements.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class UntilNode
    extends Node {
        public final short flags;
        public final Node predicate;
        public final StatementsNode statements;

        public UntilNode(int startOffset, int length, short flags, Node predicate, StatementsNode statements) {
            super(startOffset, length);
            this.flags = flags;
            this.predicate = predicate;
            this.statements = statements;
        }

        public boolean isBeginModifier() {
            return LoopFlags.isBeginModifier(this.flags);
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            this.predicate.setNewLineFlag(source, newlineMarked);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.predicate.accept(visitor);
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.predicate, this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitUntilNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("LoopFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("predicate: ");
            builder.append(this.predicate.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("statements: ");
            builder.append(this.statements == null ? "null\n" : this.statements.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class UnlessNode
    extends Node {
        public final Node predicate;
        public final StatementsNode statements;
        public final ElseNode else_clause;

        public UnlessNode(int startOffset, int length, Node predicate, StatementsNode statements, ElseNode else_clause) {
            super(startOffset, length);
            this.predicate = predicate;
            this.statements = statements;
            this.else_clause = else_clause;
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            this.predicate.setNewLineFlag(source, newlineMarked);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.predicate.accept(visitor);
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
            if (this.else_clause != null) {
                this.else_clause.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.predicate, this.statements, this.else_clause};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitUnlessNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("predicate: ");
            builder.append(this.predicate.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("statements: ");
            builder.append(this.statements == null ? "null\n" : this.statements.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("else_clause: ");
            builder.append(this.else_clause == null ? "null\n" : this.else_clause.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class UndefNode
    extends Node {
        public final Node[] names;

        public UndefNode(int startOffset, int length, Node[] names) {
            super(startOffset, length);
            this.names = names;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.names) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.names));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitUndefNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("names: ");
            builder.append('\n');
            for (Node child : this.names) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            return builder.toString();
        }
    }

    public static final class TrueNode
    extends Node {
        public TrueNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitTrueNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            return builder.toString();
        }
    }

    public static final class SymbolNode
    extends Node {
        public final short flags;
        public final byte[] unescaped;

        public SymbolNode(int startOffset, int length, short flags, byte[] unescaped) {
            super(startOffset, length);
            this.flags = flags;
            this.unescaped = unescaped;
        }

        public boolean isForcedUtf8Encoding() {
            return SymbolFlags.isForcedUtf8Encoding(this.flags);
        }

        public boolean isForcedBinaryEncoding() {
            return SymbolFlags.isForcedBinaryEncoding(this.flags);
        }

        public boolean isForcedUsAsciiEncoding() {
            return SymbolFlags.isForcedUsAsciiEncoding(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSymbolNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("SymbolFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("unescaped: ");
            builder.append('\"' + new String(this.unescaped, StandardCharsets.UTF_8) + '\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class SuperNode
    extends Node {
        public final ArgumentsNode arguments;
        public final Node block;

        public SuperNode(int startOffset, int length, ArgumentsNode arguments, Node block) {
            super(startOffset, length);
            this.arguments = arguments;
            this.block = block;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
            if (this.block != null) {
                this.block.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.arguments, this.block};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSuperNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("arguments: ");
            builder.append(this.arguments == null ? "null\n" : this.arguments.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("block: ");
            builder.append(this.block == null ? "null\n" : this.block.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class StringNode
    extends Node {
        public final short flags;
        public final byte[] unescaped;

        public StringNode(int startOffset, int length, short flags, byte[] unescaped) {
            super(startOffset, length);
            this.flags = flags;
            this.unescaped = unescaped;
        }

        public boolean isForcedUtf8Encoding() {
            return StringFlags.isForcedUtf8Encoding(this.flags);
        }

        public boolean isForcedBinaryEncoding() {
            return StringFlags.isForcedBinaryEncoding(this.flags);
        }

        public boolean isFrozen() {
            return StringFlags.isFrozen(this.flags);
        }

        public boolean isMutable() {
            return StringFlags.isMutable(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitStringNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("StringFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("unescaped: ");
            builder.append('\"' + new String(this.unescaped, StandardCharsets.UTF_8) + '\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class StatementsNode
    extends Node {
        public final Node[] body;

        public StatementsNode(int startOffset, int length, Node[] body) {
            super(startOffset, length);
            this.body = body;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.body) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.body));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitStatementsNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("body: ");
            builder.append('\n');
            for (Node child : this.body) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            return builder.toString();
        }
    }

    public static final class SplatNode
    extends Node {
        public final Node expression;

        public SplatNode(int startOffset, int length, Node expression) {
            super(startOffset, length);
            this.expression = expression;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.expression != null) {
                this.expression.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.expression};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSplatNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("expression: ");
            builder.append(this.expression == null ? "null\n" : this.expression.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class SourceLineNode
    extends Node {
        public SourceLineNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSourceLineNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            return builder.toString();
        }
    }

    public static final class SourceFileNode
    extends Node {
        public final short flags;
        public final byte[] filepath;

        public SourceFileNode(int startOffset, int length, short flags, byte[] filepath) {
            super(startOffset, length);
            this.flags = flags;
            this.filepath = filepath;
        }

        public boolean isForcedUtf8Encoding() {
            return StringFlags.isForcedUtf8Encoding(this.flags);
        }

        public boolean isForcedBinaryEncoding() {
            return StringFlags.isForcedBinaryEncoding(this.flags);
        }

        public boolean isFrozen() {
            return StringFlags.isFrozen(this.flags);
        }

        public boolean isMutable() {
            return StringFlags.isMutable(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSourceFileNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("StringFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("filepath: ");
            builder.append('\"' + new String(this.filepath, StandardCharsets.UTF_8) + '\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class SourceEncodingNode
    extends Node {
        public SourceEncodingNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSourceEncodingNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            return builder.toString();
        }
    }

    public static final class SingletonClassNode
    extends Node {
        public final String[] locals;
        public final Node expression;
        public final Node body;

        public SingletonClassNode(int startOffset, int length, String[] locals, Node expression, Node body) {
            super(startOffset, length);
            this.locals = locals;
            this.expression = expression;
            this.body = body;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.expression.accept(visitor);
            if (this.body != null) {
                this.body.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.expression, this.body};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSingletonClassNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("locals: ");
            builder.append('\n');
            for (String constant : this.locals) {
                builder.append(nextNextIndent).append('\"').append(constant).append('\"').append('\n');
            }
            builder.append(nextIndent);
            builder.append("expression: ");
            builder.append(this.expression.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("body: ");
            builder.append(this.body == null ? "null\n" : this.body.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ShareableConstantNode
    extends Node {
        public final short flags;
        public final Node write;

        public ShareableConstantNode(int startOffset, int length, short flags, Node write) {
            super(startOffset, length);
            this.flags = flags;
            this.write = write;
        }

        public boolean isLiteral() {
            return ShareableConstantNodeFlags.isLiteral(this.flags);
        }

        public boolean isExperimentalEverything() {
            return ShareableConstantNodeFlags.isExperimentalEverything(this.flags);
        }

        public boolean isExperimentalCopy() {
            return ShareableConstantNodeFlags.isExperimentalCopy(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.write.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.write};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitShareableConstantNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("ShareableConstantNodeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("write: ");
            builder.append(this.write.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class SelfNode
    extends Node {
        public SelfNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSelfNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            return builder.toString();
        }
    }

    public static final class ReturnNode
    extends Node {
        public final ArgumentsNode arguments;

        public ReturnNode(int startOffset, int length, ArgumentsNode arguments) {
            super(startOffset, length);
            this.arguments = arguments;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.arguments};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitReturnNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("arguments: ");
            builder.append(this.arguments == null ? "null\n" : this.arguments.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class RetryNode
    extends Node {
        public RetryNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRetryNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            return builder.toString();
        }
    }

    public static final class RestParameterNode
    extends Node {
        public final short flags;
        public final String name;

        public RestParameterNode(int startOffset, int length, short flags, String name) {
            super(startOffset, length);
            this.flags = flags;
            this.name = name;
        }

        public boolean isRepeatedParameter() {
            return ParameterFlags.isRepeatedParameter(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRestParameterNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("ParameterFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append(this.name == null ? "null" : "\"" + this.name + "\"");
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class RescueNode
    extends Node {
        public final Node[] exceptions;
        public final Node reference;
        public final StatementsNode statements;
        public final RescueNode subsequent;

        public RescueNode(int startOffset, int length, Node[] exceptions, Node reference, StatementsNode statements, RescueNode subsequent) {
            super(startOffset, length);
            this.exceptions = exceptions;
            this.reference = reference;
            this.statements = statements;
            this.subsequent = subsequent;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.exceptions) {
                child.accept(visitor);
            }
            if (this.reference != null) {
                this.reference.accept(visitor);
            }
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
            if (this.subsequent != null) {
                this.subsequent.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.exceptions));
            childNodes.add(this.reference);
            childNodes.add(this.statements);
            childNodes.add(this.subsequent);
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRescueNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("exceptions: ");
            builder.append('\n');
            for (Node child : this.exceptions) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            builder.append(nextIndent);
            builder.append("reference: ");
            builder.append(this.reference == null ? "null\n" : this.reference.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("statements: ");
            builder.append(this.statements == null ? "null\n" : this.statements.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("subsequent: ");
            builder.append(this.subsequent == null ? "null\n" : this.subsequent.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class RescueModifierNode
    extends Node {
        public final Node expression;
        public final Node rescue_expression;

        public RescueModifierNode(int startOffset, int length, Node expression, Node rescue_expression) {
            super(startOffset, length);
            this.expression = expression;
            this.rescue_expression = rescue_expression;
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            this.expression.setNewLineFlag(source, newlineMarked);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.expression.accept(visitor);
            this.rescue_expression.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.expression, this.rescue_expression};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRescueModifierNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("expression: ");
            builder.append(this.expression.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("rescue_expression: ");
            builder.append(this.rescue_expression.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class RequiredParameterNode
    extends Node {
        public final short flags;
        public final String name;

        public RequiredParameterNode(int startOffset, int length, short flags, String name) {
            super(startOffset, length);
            this.flags = flags;
            this.name = name;
        }

        public boolean isRepeatedParameter() {
            return ParameterFlags.isRepeatedParameter(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRequiredParameterNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("ParameterFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class RequiredKeywordParameterNode
    extends Node {
        public final short flags;
        public final String name;

        public RequiredKeywordParameterNode(int startOffset, int length, short flags, String name) {
            super(startOffset, length);
            this.flags = flags;
            this.name = name;
        }

        public boolean isRepeatedParameter() {
            return ParameterFlags.isRepeatedParameter(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRequiredKeywordParameterNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("ParameterFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class RegularExpressionNode
    extends Node {
        public final short flags;
        public final byte[] unescaped;

        public RegularExpressionNode(int startOffset, int length, short flags, byte[] unescaped) {
            super(startOffset, length);
            this.flags = flags;
            this.unescaped = unescaped;
        }

        public boolean isIgnoreCase() {
            return RegularExpressionFlags.isIgnoreCase(this.flags);
        }

        public boolean isExtended() {
            return RegularExpressionFlags.isExtended(this.flags);
        }

        public boolean isMultiLine() {
            return RegularExpressionFlags.isMultiLine(this.flags);
        }

        public boolean isOnce() {
            return RegularExpressionFlags.isOnce(this.flags);
        }

        public boolean isEucJp() {
            return RegularExpressionFlags.isEucJp(this.flags);
        }

        public boolean isAscii8bit() {
            return RegularExpressionFlags.isAscii8bit(this.flags);
        }

        public boolean isWindows31j() {
            return RegularExpressionFlags.isWindows31j(this.flags);
        }

        public boolean isUtf8() {
            return RegularExpressionFlags.isUtf8(this.flags);
        }

        public boolean isForcedUtf8Encoding() {
            return RegularExpressionFlags.isForcedUtf8Encoding(this.flags);
        }

        public boolean isForcedBinaryEncoding() {
            return RegularExpressionFlags.isForcedBinaryEncoding(this.flags);
        }

        public boolean isForcedUsAsciiEncoding() {
            return RegularExpressionFlags.isForcedUsAsciiEncoding(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRegularExpressionNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("RegularExpressionFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("unescaped: ");
            builder.append('\"' + new String(this.unescaped, StandardCharsets.UTF_8) + '\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class RedoNode
    extends Node {
        public RedoNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRedoNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            return builder.toString();
        }
    }

    public static final class RationalNode
    extends Node {
        public final short flags;
        public final Object numerator;
        public final Object denominator;

        public RationalNode(int startOffset, int length, short flags, Object numerator, Object denominator) {
            super(startOffset, length);
            this.flags = flags;
            this.numerator = numerator;
            this.denominator = denominator;
        }

        public boolean isBinary() {
            return IntegerBaseFlags.isBinary(this.flags);
        }

        public boolean isDecimal() {
            return IntegerBaseFlags.isDecimal(this.flags);
        }

        public boolean isOctal() {
            return IntegerBaseFlags.isOctal(this.flags);
        }

        public boolean isHexadecimal() {
            return IntegerBaseFlags.isHexadecimal(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRationalNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("IntegerBaseFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("numerator: ");
            builder.append(this.numerator);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("denominator: ");
            builder.append(this.denominator);
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class RangeNode
    extends Node {
        public final short flags;
        public final Node left;
        public final Node right;

        public RangeNode(int startOffset, int length, short flags, Node left, Node right) {
            super(startOffset, length);
            this.flags = flags;
            this.left = left;
            this.right = right;
        }

        public boolean isExcludeEnd() {
            return RangeFlags.isExcludeEnd(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.left != null) {
                this.left.accept(visitor);
            }
            if (this.right != null) {
                this.right.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.left, this.right};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRangeNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("RangeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("left: ");
            builder.append(this.left == null ? "null\n" : this.left.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("right: ");
            builder.append(this.right == null ? "null\n" : this.right.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ProgramNode
    extends Node {
        public final String[] locals;
        public final StatementsNode statements;

        public ProgramNode(int startOffset, int length, String[] locals, StatementsNode statements) {
            super(startOffset, length);
            this.locals = locals;
            this.statements = statements;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.statements.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitProgramNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("locals: ");
            builder.append('\n');
            for (String constant : this.locals) {
                builder.append(nextNextIndent).append('\"').append(constant).append('\"').append('\n');
            }
            builder.append(nextIndent);
            builder.append("statements: ");
            builder.append(this.statements.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class PreExecutionNode
    extends Node {
        public final StatementsNode statements;

        public PreExecutionNode(int startOffset, int length, StatementsNode statements) {
            super(startOffset, length);
            this.statements = statements;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitPreExecutionNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("statements: ");
            builder.append(this.statements == null ? "null\n" : this.statements.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class PostExecutionNode
    extends Node {
        public final StatementsNode statements;

        public PostExecutionNode(int startOffset, int length, StatementsNode statements) {
            super(startOffset, length);
            this.statements = statements;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitPostExecutionNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("statements: ");
            builder.append(this.statements == null ? "null\n" : this.statements.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class PinnedVariableNode
    extends Node {
        public final Node variable;

        public PinnedVariableNode(int startOffset, int length, Node variable) {
            super(startOffset, length);
            this.variable = variable;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.variable.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.variable};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitPinnedVariableNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("variable: ");
            builder.append(this.variable.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class PinnedExpressionNode
    extends Node {
        public final Node expression;

        public PinnedExpressionNode(int startOffset, int length, Node expression) {
            super(startOffset, length);
            this.expression = expression;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.expression.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.expression};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitPinnedExpressionNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("expression: ");
            builder.append(this.expression.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ParenthesesNode
    extends Node {
        public final Node body;

        public ParenthesesNode(int startOffset, int length, Node body) {
            super(startOffset, length);
            this.body = body;
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.body != null) {
                this.body.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.body};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitParenthesesNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("body: ");
            builder.append(this.body == null ? "null\n" : this.body.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ParametersNode
    extends Node {
        public final Node[] requireds;
        public final OptionalParameterNode[] optionals;
        public final Node rest;
        public final Node[] posts;
        public final Node[] keywords;
        public final Node keyword_rest;
        public final BlockParameterNode block;

        public ParametersNode(int startOffset, int length, Node[] requireds, OptionalParameterNode[] optionals, Node rest, Node[] posts, Node[] keywords, Node keyword_rest, BlockParameterNode block) {
            super(startOffset, length);
            this.requireds = requireds;
            this.optionals = optionals;
            this.rest = rest;
            this.posts = posts;
            this.keywords = keywords;
            this.keyword_rest = keyword_rest;
            this.block = block;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node node : this.requireds) {
                node.accept(visitor);
            }
            for (Node node : this.optionals) {
                node.accept(visitor);
            }
            if (this.rest != null) {
                this.rest.accept(visitor);
            }
            for (Node node : this.posts) {
                node.accept(visitor);
            }
            for (Node node : this.keywords) {
                node.accept(visitor);
            }
            if (this.keyword_rest != null) {
                this.keyword_rest.accept(visitor);
            }
            if (this.block != null) {
                this.block.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.requireds));
            childNodes.addAll(Arrays.asList(this.optionals));
            childNodes.add(this.rest);
            childNodes.addAll(Arrays.asList(this.posts));
            childNodes.addAll(Arrays.asList(this.keywords));
            childNodes.add(this.keyword_rest);
            childNodes.add(this.block);
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitParametersNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("requireds: ");
            builder.append('\n');
            for (Node node : this.requireds) {
                builder.append(nextNextIndent).append(node.toString(nextNextIndent));
            }
            builder.append(nextIndent);
            builder.append("optionals: ");
            builder.append('\n');
            for (Node node : this.optionals) {
                builder.append(nextNextIndent).append(node.toString(nextNextIndent));
            }
            builder.append(nextIndent);
            builder.append("rest: ");
            builder.append(this.rest == null ? "null\n" : this.rest.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("posts: ");
            builder.append('\n');
            for (Node node : this.posts) {
                builder.append(nextNextIndent).append(node.toString(nextNextIndent));
            }
            builder.append(nextIndent);
            builder.append("keywords: ");
            builder.append('\n');
            for (Node node : this.keywords) {
                builder.append(nextNextIndent).append(node.toString(nextNextIndent));
            }
            builder.append(nextIndent);
            builder.append("keyword_rest: ");
            builder.append(this.keyword_rest == null ? "null\n" : this.keyword_rest.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("block: ");
            builder.append(this.block == null ? "null\n" : this.block.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class OrNode
    extends Node {
        public final Node left;
        public final Node right;

        public OrNode(int startOffset, int length, Node left, Node right) {
            super(startOffset, length);
            this.left = left;
            this.right = right;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.left.accept(visitor);
            this.right.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.left, this.right};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitOrNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("left: ");
            builder.append(this.left.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("right: ");
            builder.append(this.right.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class OptionalParameterNode
    extends Node {
        public final short flags;
        public final String name;
        public final Node value;

        public OptionalParameterNode(int startOffset, int length, short flags, String name, Node value) {
            super(startOffset, length);
            this.flags = flags;
            this.name = name;
            this.value = value;
        }

        public boolean isRepeatedParameter() {
            return ParameterFlags.isRepeatedParameter(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitOptionalParameterNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("ParameterFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class OptionalKeywordParameterNode
    extends Node {
        public final short flags;
        public final String name;
        public final Node value;

        public OptionalKeywordParameterNode(int startOffset, int length, short flags, String name, Node value) {
            super(startOffset, length);
            this.flags = flags;
            this.name = name;
            this.value = value;
        }

        public boolean isRepeatedParameter() {
            return ParameterFlags.isRepeatedParameter(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitOptionalKeywordParameterNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("ParameterFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class NumberedReferenceReadNode
    extends Node {
        public final int number;

        public NumberedReferenceReadNode(int startOffset, int length, int number) {
            super(startOffset, length);
            this.number = number;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitNumberedReferenceReadNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("number: ");
            builder.append(this.number);
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class NumberedParametersNode
    extends Node {
        public final int maximum;

        public NumberedParametersNode(int startOffset, int length, int maximum) {
            super(startOffset, length);
            this.maximum = maximum;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitNumberedParametersNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("maximum: ");
            builder.append(this.maximum);
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class NoKeywordsParameterNode
    extends Node {
        public NoKeywordsParameterNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitNoKeywordsParameterNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            return builder.toString();
        }
    }

    public static final class NilNode
    extends Node {
        public NilNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitNilNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            return builder.toString();
        }
    }

    public static final class NextNode
    extends Node {
        public final ArgumentsNode arguments;

        public NextNode(int startOffset, int length, ArgumentsNode arguments) {
            super(startOffset, length);
            this.arguments = arguments;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.arguments};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitNextNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("arguments: ");
            builder.append(this.arguments == null ? "null\n" : this.arguments.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class MultiWriteNode
    extends Node {
        public final Node[] lefts;
        public final Node rest;
        public final Node[] rights;
        public final Node value;

        public MultiWriteNode(int startOffset, int length, Node[] lefts, Node rest, Node[] rights, Node value) {
            super(startOffset, length);
            this.lefts = lefts;
            this.rest = rest;
            this.rights = rights;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.lefts) {
                child.accept(visitor);
            }
            if (this.rest != null) {
                this.rest.accept(visitor);
            }
            for (Node child : this.rights) {
                child.accept(visitor);
            }
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.lefts));
            childNodes.add(this.rest);
            childNodes.addAll(Arrays.asList(this.rights));
            childNodes.add(this.value);
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitMultiWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("lefts: ");
            builder.append('\n');
            for (Node child : this.lefts) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            builder.append(nextIndent);
            builder.append("rest: ");
            builder.append(this.rest == null ? "null\n" : this.rest.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("rights: ");
            builder.append('\n');
            for (Node child : this.rights) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class MultiTargetNode
    extends Node {
        public final Node[] lefts;
        public final Node rest;
        public final Node[] rights;

        public MultiTargetNode(int startOffset, int length, Node[] lefts, Node rest, Node[] rights) {
            super(startOffset, length);
            this.lefts = lefts;
            this.rest = rest;
            this.rights = rights;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.lefts) {
                child.accept(visitor);
            }
            if (this.rest != null) {
                this.rest.accept(visitor);
            }
            for (Node child : this.rights) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.lefts));
            childNodes.add(this.rest);
            childNodes.addAll(Arrays.asList(this.rights));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitMultiTargetNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("lefts: ");
            builder.append('\n');
            for (Node child : this.lefts) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            builder.append(nextIndent);
            builder.append("rest: ");
            builder.append(this.rest == null ? "null\n" : this.rest.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("rights: ");
            builder.append('\n');
            for (Node child : this.rights) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            return builder.toString();
        }
    }

    public static final class ModuleNode
    extends Node {
        public final String[] locals;
        public final Node constant_path;
        public final Node body;
        public final String name;

        public ModuleNode(int startOffset, int length, String[] locals, Node constant_path, Node body, String name) {
            super(startOffset, length);
            this.locals = locals;
            this.constant_path = constant_path;
            this.body = body;
            this.name = name;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.constant_path.accept(visitor);
            if (this.body != null) {
                this.body.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.constant_path, this.body};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitModuleNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("locals: ");
            builder.append('\n');
            for (String constant : this.locals) {
                builder.append(nextNextIndent).append('\"').append(constant).append('\"').append('\n');
            }
            builder.append(nextIndent);
            builder.append("constant_path: ");
            builder.append(this.constant_path.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("body: ");
            builder.append(this.body == null ? "null\n" : this.body.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class MissingNode
    extends Node {
        public MissingNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitMissingNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            return builder.toString();
        }
    }

    public static final class MatchWriteNode
    extends Node {
        public final CallNode call;
        public final LocalVariableTargetNode[] targets;

        public MatchWriteNode(int startOffset, int length, CallNode call, LocalVariableTargetNode[] targets) {
            super(startOffset, length);
            this.call = call;
            this.targets = targets;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.call.accept(visitor);
            for (LocalVariableTargetNode child : this.targets) {
                ((Node)child).accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.add(this.call);
            childNodes.addAll(Arrays.asList(this.targets));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitMatchWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("call: ");
            builder.append(this.call.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("targets: ");
            builder.append('\n');
            for (LocalVariableTargetNode child : this.targets) {
                builder.append(nextNextIndent).append(((Node)child).toString(nextNextIndent));
            }
            return builder.toString();
        }
    }

    public static final class MatchRequiredNode
    extends Node {
        public final Node value;
        public final Node pattern;

        public MatchRequiredNode(int startOffset, int length, Node value, Node pattern) {
            super(startOffset, length);
            this.value = value;
            this.pattern = pattern;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
            this.pattern.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value, this.pattern};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitMatchRequiredNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("pattern: ");
            builder.append(this.pattern.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class MatchPredicateNode
    extends Node {
        public final Node value;
        public final Node pattern;

        public MatchPredicateNode(int startOffset, int length, Node value, Node pattern) {
            super(startOffset, length);
            this.value = value;
            this.pattern = pattern;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
            this.pattern.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value, this.pattern};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitMatchPredicateNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("pattern: ");
            builder.append(this.pattern.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class MatchLastLineNode
    extends Node {
        public final short flags;
        public final byte[] unescaped;

        public MatchLastLineNode(int startOffset, int length, short flags, byte[] unescaped) {
            super(startOffset, length);
            this.flags = flags;
            this.unescaped = unescaped;
        }

        public boolean isIgnoreCase() {
            return RegularExpressionFlags.isIgnoreCase(this.flags);
        }

        public boolean isExtended() {
            return RegularExpressionFlags.isExtended(this.flags);
        }

        public boolean isMultiLine() {
            return RegularExpressionFlags.isMultiLine(this.flags);
        }

        public boolean isOnce() {
            return RegularExpressionFlags.isOnce(this.flags);
        }

        public boolean isEucJp() {
            return RegularExpressionFlags.isEucJp(this.flags);
        }

        public boolean isAscii8bit() {
            return RegularExpressionFlags.isAscii8bit(this.flags);
        }

        public boolean isWindows31j() {
            return RegularExpressionFlags.isWindows31j(this.flags);
        }

        public boolean isUtf8() {
            return RegularExpressionFlags.isUtf8(this.flags);
        }

        public boolean isForcedUtf8Encoding() {
            return RegularExpressionFlags.isForcedUtf8Encoding(this.flags);
        }

        public boolean isForcedBinaryEncoding() {
            return RegularExpressionFlags.isForcedBinaryEncoding(this.flags);
        }

        public boolean isForcedUsAsciiEncoding() {
            return RegularExpressionFlags.isForcedUsAsciiEncoding(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitMatchLastLineNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("RegularExpressionFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("unescaped: ");
            builder.append('\"' + new String(this.unescaped, StandardCharsets.UTF_8) + '\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class LocalVariableWriteNode
    extends Node {
        public final String name;
        public final int depth;
        public final Node value;

        public LocalVariableWriteNode(int startOffset, int length, String name, int depth, Node value) {
            super(startOffset, length);
            this.name = name;
            this.depth = depth;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitLocalVariableWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("depth: ");
            builder.append(this.depth);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class LocalVariableTargetNode
    extends Node {
        public final String name;
        public final int depth;

        public LocalVariableTargetNode(int startOffset, int length, String name, int depth) {
            super(startOffset, length);
            this.name = name;
            this.depth = depth;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitLocalVariableTargetNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("depth: ");
            builder.append(this.depth);
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class LocalVariableReadNode
    extends Node {
        public final String name;
        public final int depth;

        public LocalVariableReadNode(int startOffset, int length, String name, int depth) {
            super(startOffset, length);
            this.name = name;
            this.depth = depth;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitLocalVariableReadNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("depth: ");
            builder.append(this.depth);
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class LocalVariableOrWriteNode
    extends Node {
        public final Node value;
        public final String name;
        public final int depth;

        public LocalVariableOrWriteNode(int startOffset, int length, Node value, String name, int depth) {
            super(startOffset, length);
            this.value = value;
            this.name = name;
            this.depth = depth;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitLocalVariableOrWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("depth: ");
            builder.append(this.depth);
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class LocalVariableOperatorWriteNode
    extends Node {
        public final Node value;
        public final String name;
        public final String binary_operator;
        public final int depth;

        public LocalVariableOperatorWriteNode(int startOffset, int length, Node value, String name, String binary_operator, int depth) {
            super(startOffset, length);
            this.value = value;
            this.name = name;
            this.binary_operator = binary_operator;
            this.depth = depth;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitLocalVariableOperatorWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("binary_operator: ");
            builder.append('\"').append(this.binary_operator).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("depth: ");
            builder.append(this.depth);
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class LocalVariableAndWriteNode
    extends Node {
        public final Node value;
        public final String name;
        public final int depth;

        public LocalVariableAndWriteNode(int startOffset, int length, Node value, String name, int depth) {
            super(startOffset, length);
            this.value = value;
            this.name = name;
            this.depth = depth;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitLocalVariableAndWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("depth: ");
            builder.append(this.depth);
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class LambdaNode
    extends Node {
        public final String[] locals;
        public final Node parameters;
        public final Node body;

        public LambdaNode(int startOffset, int length, String[] locals, Node parameters, Node body) {
            super(startOffset, length);
            this.locals = locals;
            this.parameters = parameters;
            this.body = body;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.parameters != null) {
                this.parameters.accept(visitor);
            }
            if (this.body != null) {
                this.body.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.parameters, this.body};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitLambdaNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("locals: ");
            builder.append('\n');
            for (String constant : this.locals) {
                builder.append(nextNextIndent).append('\"').append(constant).append('\"').append('\n');
            }
            builder.append(nextIndent);
            builder.append("parameters: ");
            builder.append(this.parameters == null ? "null\n" : this.parameters.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("body: ");
            builder.append(this.body == null ? "null\n" : this.body.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class KeywordRestParameterNode
    extends Node {
        public final short flags;
        public final String name;

        public KeywordRestParameterNode(int startOffset, int length, short flags, String name) {
            super(startOffset, length);
            this.flags = flags;
            this.name = name;
        }

        public boolean isRepeatedParameter() {
            return ParameterFlags.isRepeatedParameter(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitKeywordRestParameterNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("ParameterFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append(this.name == null ? "null" : "\"" + this.name + "\"");
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class KeywordHashNode
    extends Node {
        public final short flags;
        public final Node[] elements;

        public KeywordHashNode(int startOffset, int length, short flags, Node[] elements) {
            super(startOffset, length);
            this.flags = flags;
            this.elements = elements;
        }

        public boolean isSymbolKeys() {
            return KeywordHashNodeFlags.isSymbolKeys(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.elements) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.elements));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitKeywordHashNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("KeywordHashNodeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("elements: ");
            builder.append('\n');
            for (Node child : this.elements) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            return builder.toString();
        }
    }

    public static final class ItParametersNode
    extends Node {
        public ItParametersNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitItParametersNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            return builder.toString();
        }
    }

    public static final class ItLocalVariableReadNode
    extends Node {
        public ItLocalVariableReadNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitItLocalVariableReadNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            return builder.toString();
        }
    }

    public static final class InterpolatedXStringNode
    extends Node {
        public final Node[] parts;

        public InterpolatedXStringNode(int startOffset, int length, Node[] parts) {
            super(startOffset, length);
            this.parts = parts;
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            Node first;
            Node node = first = this.parts.length > 0 ? this.parts[0] : null;
            if (first != null) {
                first.setNewLineFlag(source, newlineMarked);
            }
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.parts) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.parts));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInterpolatedXStringNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("parts: ");
            builder.append('\n');
            for (Node child : this.parts) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            return builder.toString();
        }
    }

    public static final class InterpolatedSymbolNode
    extends Node {
        public final Node[] parts;

        public InterpolatedSymbolNode(int startOffset, int length, Node[] parts) {
            super(startOffset, length);
            this.parts = parts;
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            Node first;
            Node node = first = this.parts.length > 0 ? this.parts[0] : null;
            if (first != null) {
                first.setNewLineFlag(source, newlineMarked);
            }
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.parts) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.parts));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInterpolatedSymbolNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("parts: ");
            builder.append('\n');
            for (Node child : this.parts) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            return builder.toString();
        }
    }

    public static final class InterpolatedStringNode
    extends Node {
        public final short flags;
        public final Node[] parts;

        public InterpolatedStringNode(int startOffset, int length, short flags, Node[] parts) {
            super(startOffset, length);
            this.flags = flags;
            this.parts = parts;
        }

        public boolean isFrozen() {
            return InterpolatedStringNodeFlags.isFrozen(this.flags);
        }

        public boolean isMutable() {
            return InterpolatedStringNodeFlags.isMutable(this.flags);
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            Node first;
            Node node = first = this.parts.length > 0 ? this.parts[0] : null;
            if (first != null) {
                first.setNewLineFlag(source, newlineMarked);
            }
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.parts) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.parts));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInterpolatedStringNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("InterpolatedStringNodeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("parts: ");
            builder.append('\n');
            for (Node child : this.parts) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            return builder.toString();
        }
    }

    public static final class InterpolatedRegularExpressionNode
    extends Node {
        public final short flags;
        public final Node[] parts;

        public InterpolatedRegularExpressionNode(int startOffset, int length, short flags, Node[] parts) {
            super(startOffset, length);
            this.flags = flags;
            this.parts = parts;
        }

        public boolean isIgnoreCase() {
            return RegularExpressionFlags.isIgnoreCase(this.flags);
        }

        public boolean isExtended() {
            return RegularExpressionFlags.isExtended(this.flags);
        }

        public boolean isMultiLine() {
            return RegularExpressionFlags.isMultiLine(this.flags);
        }

        public boolean isOnce() {
            return RegularExpressionFlags.isOnce(this.flags);
        }

        public boolean isEucJp() {
            return RegularExpressionFlags.isEucJp(this.flags);
        }

        public boolean isAscii8bit() {
            return RegularExpressionFlags.isAscii8bit(this.flags);
        }

        public boolean isWindows31j() {
            return RegularExpressionFlags.isWindows31j(this.flags);
        }

        public boolean isUtf8() {
            return RegularExpressionFlags.isUtf8(this.flags);
        }

        public boolean isForcedUtf8Encoding() {
            return RegularExpressionFlags.isForcedUtf8Encoding(this.flags);
        }

        public boolean isForcedBinaryEncoding() {
            return RegularExpressionFlags.isForcedBinaryEncoding(this.flags);
        }

        public boolean isForcedUsAsciiEncoding() {
            return RegularExpressionFlags.isForcedUsAsciiEncoding(this.flags);
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            Node first;
            Node node = first = this.parts.length > 0 ? this.parts[0] : null;
            if (first != null) {
                first.setNewLineFlag(source, newlineMarked);
            }
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.parts) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.parts));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInterpolatedRegularExpressionNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("RegularExpressionFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("parts: ");
            builder.append('\n');
            for (Node child : this.parts) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            return builder.toString();
        }
    }

    public static final class InterpolatedMatchLastLineNode
    extends Node {
        public final short flags;
        public final Node[] parts;

        public InterpolatedMatchLastLineNode(int startOffset, int length, short flags, Node[] parts) {
            super(startOffset, length);
            this.flags = flags;
            this.parts = parts;
        }

        public boolean isIgnoreCase() {
            return RegularExpressionFlags.isIgnoreCase(this.flags);
        }

        public boolean isExtended() {
            return RegularExpressionFlags.isExtended(this.flags);
        }

        public boolean isMultiLine() {
            return RegularExpressionFlags.isMultiLine(this.flags);
        }

        public boolean isOnce() {
            return RegularExpressionFlags.isOnce(this.flags);
        }

        public boolean isEucJp() {
            return RegularExpressionFlags.isEucJp(this.flags);
        }

        public boolean isAscii8bit() {
            return RegularExpressionFlags.isAscii8bit(this.flags);
        }

        public boolean isWindows31j() {
            return RegularExpressionFlags.isWindows31j(this.flags);
        }

        public boolean isUtf8() {
            return RegularExpressionFlags.isUtf8(this.flags);
        }

        public boolean isForcedUtf8Encoding() {
            return RegularExpressionFlags.isForcedUtf8Encoding(this.flags);
        }

        public boolean isForcedBinaryEncoding() {
            return RegularExpressionFlags.isForcedBinaryEncoding(this.flags);
        }

        public boolean isForcedUsAsciiEncoding() {
            return RegularExpressionFlags.isForcedUsAsciiEncoding(this.flags);
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            Node first;
            Node node = first = this.parts.length > 0 ? this.parts[0] : null;
            if (first != null) {
                first.setNewLineFlag(source, newlineMarked);
            }
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.parts) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.parts));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInterpolatedMatchLastLineNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("RegularExpressionFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("parts: ");
            builder.append('\n');
            for (Node child : this.parts) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            return builder.toString();
        }
    }

    public static final class IntegerNode
    extends Node {
        public final short flags;
        public final Object value;

        public IntegerNode(int startOffset, int length, short flags, Object value) {
            super(startOffset, length);
            this.flags = flags;
            this.value = value;
        }

        public boolean isBinary() {
            return IntegerBaseFlags.isBinary(this.flags);
        }

        public boolean isDecimal() {
            return IntegerBaseFlags.isDecimal(this.flags);
        }

        public boolean isOctal() {
            return IntegerBaseFlags.isOctal(this.flags);
        }

        public boolean isHexadecimal() {
            return IntegerBaseFlags.isHexadecimal(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitIntegerNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("IntegerBaseFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value);
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class InstanceVariableWriteNode
    extends Node {
        public final String name;
        public final Node value;

        public InstanceVariableWriteNode(int startOffset, int length, String name, Node value) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInstanceVariableWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class InstanceVariableTargetNode
    extends Node {
        public final String name;

        public InstanceVariableTargetNode(int startOffset, int length, String name) {
            super(startOffset, length);
            this.name = name;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInstanceVariableTargetNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class InstanceVariableReadNode
    extends Node {
        public final String name;

        public InstanceVariableReadNode(int startOffset, int length, String name) {
            super(startOffset, length);
            this.name = name;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInstanceVariableReadNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class InstanceVariableOrWriteNode
    extends Node {
        public final String name;
        public final Node value;

        public InstanceVariableOrWriteNode(int startOffset, int length, String name, Node value) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInstanceVariableOrWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class InstanceVariableOperatorWriteNode
    extends Node {
        public final String name;
        public final Node value;
        public final String binary_operator;

        public InstanceVariableOperatorWriteNode(int startOffset, int length, String name, Node value, String binary_operator) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
            this.binary_operator = binary_operator;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInstanceVariableOperatorWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("binary_operator: ");
            builder.append('\"').append(this.binary_operator).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class InstanceVariableAndWriteNode
    extends Node {
        public final String name;
        public final Node value;

        public InstanceVariableAndWriteNode(int startOffset, int length, String name, Node value) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInstanceVariableAndWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class IndexTargetNode
    extends Node {
        public final short flags;
        public final Node receiver;
        public final ArgumentsNode arguments;
        public final BlockArgumentNode block;

        public IndexTargetNode(int startOffset, int length, short flags, Node receiver, ArgumentsNode arguments, BlockArgumentNode block) {
            super(startOffset, length);
            this.flags = flags;
            this.receiver = receiver;
            this.arguments = arguments;
            this.block = block;
        }

        public boolean isSafeNavigation() {
            return CallNodeFlags.isSafeNavigation(this.flags);
        }

        public boolean isVariableCall() {
            return CallNodeFlags.isVariableCall(this.flags);
        }

        public boolean isAttributeWrite() {
            return CallNodeFlags.isAttributeWrite(this.flags);
        }

        public boolean isIgnoreVisibility() {
            return CallNodeFlags.isIgnoreVisibility(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.receiver.accept(visitor);
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
            if (this.block != null) {
                this.block.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.receiver, this.arguments, this.block};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitIndexTargetNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("CallNodeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("receiver: ");
            builder.append(this.receiver.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("arguments: ");
            builder.append(this.arguments == null ? "null\n" : this.arguments.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("block: ");
            builder.append(this.block == null ? "null\n" : this.block.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class IndexOrWriteNode
    extends Node {
        public final short flags;
        public final Node receiver;
        public final ArgumentsNode arguments;
        public final BlockArgumentNode block;
        public final Node value;

        public IndexOrWriteNode(int startOffset, int length, short flags, Node receiver, ArgumentsNode arguments, BlockArgumentNode block, Node value) {
            super(startOffset, length);
            this.flags = flags;
            this.receiver = receiver;
            this.arguments = arguments;
            this.block = block;
            this.value = value;
        }

        public boolean isSafeNavigation() {
            return CallNodeFlags.isSafeNavigation(this.flags);
        }

        public boolean isVariableCall() {
            return CallNodeFlags.isVariableCall(this.flags);
        }

        public boolean isAttributeWrite() {
            return CallNodeFlags.isAttributeWrite(this.flags);
        }

        public boolean isIgnoreVisibility() {
            return CallNodeFlags.isIgnoreVisibility(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.receiver != null) {
                this.receiver.accept(visitor);
            }
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
            if (this.block != null) {
                this.block.accept(visitor);
            }
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.receiver, this.arguments, this.block, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitIndexOrWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("CallNodeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("receiver: ");
            builder.append(this.receiver == null ? "null\n" : this.receiver.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("arguments: ");
            builder.append(this.arguments == null ? "null\n" : this.arguments.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("block: ");
            builder.append(this.block == null ? "null\n" : this.block.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class IndexOperatorWriteNode
    extends Node {
        public final short flags;
        public final Node receiver;
        public final ArgumentsNode arguments;
        public final BlockArgumentNode block;
        public final String binary_operator;
        public final Node value;

        public IndexOperatorWriteNode(int startOffset, int length, short flags, Node receiver, ArgumentsNode arguments, BlockArgumentNode block, String binary_operator, Node value) {
            super(startOffset, length);
            this.flags = flags;
            this.receiver = receiver;
            this.arguments = arguments;
            this.block = block;
            this.binary_operator = binary_operator;
            this.value = value;
        }

        public boolean isSafeNavigation() {
            return CallNodeFlags.isSafeNavigation(this.flags);
        }

        public boolean isVariableCall() {
            return CallNodeFlags.isVariableCall(this.flags);
        }

        public boolean isAttributeWrite() {
            return CallNodeFlags.isAttributeWrite(this.flags);
        }

        public boolean isIgnoreVisibility() {
            return CallNodeFlags.isIgnoreVisibility(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.receiver != null) {
                this.receiver.accept(visitor);
            }
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
            if (this.block != null) {
                this.block.accept(visitor);
            }
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.receiver, this.arguments, this.block, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitIndexOperatorWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("CallNodeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("receiver: ");
            builder.append(this.receiver == null ? "null\n" : this.receiver.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("arguments: ");
            builder.append(this.arguments == null ? "null\n" : this.arguments.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("block: ");
            builder.append(this.block == null ? "null\n" : this.block.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("binary_operator: ");
            builder.append('\"').append(this.binary_operator).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class IndexAndWriteNode
    extends Node {
        public final short flags;
        public final Node receiver;
        public final ArgumentsNode arguments;
        public final BlockArgumentNode block;
        public final Node value;

        public IndexAndWriteNode(int startOffset, int length, short flags, Node receiver, ArgumentsNode arguments, BlockArgumentNode block, Node value) {
            super(startOffset, length);
            this.flags = flags;
            this.receiver = receiver;
            this.arguments = arguments;
            this.block = block;
            this.value = value;
        }

        public boolean isSafeNavigation() {
            return CallNodeFlags.isSafeNavigation(this.flags);
        }

        public boolean isVariableCall() {
            return CallNodeFlags.isVariableCall(this.flags);
        }

        public boolean isAttributeWrite() {
            return CallNodeFlags.isAttributeWrite(this.flags);
        }

        public boolean isIgnoreVisibility() {
            return CallNodeFlags.isIgnoreVisibility(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.receiver != null) {
                this.receiver.accept(visitor);
            }
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
            if (this.block != null) {
                this.block.accept(visitor);
            }
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.receiver, this.arguments, this.block, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitIndexAndWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("CallNodeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("receiver: ");
            builder.append(this.receiver == null ? "null\n" : this.receiver.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("arguments: ");
            builder.append(this.arguments == null ? "null\n" : this.arguments.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("block: ");
            builder.append(this.block == null ? "null\n" : this.block.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class InNode
    extends Node {
        public final Node pattern;
        public final StatementsNode statements;

        public InNode(int startOffset, int length, Node pattern, StatementsNode statements) {
            super(startOffset, length);
            this.pattern = pattern;
            this.statements = statements;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.pattern.accept(visitor);
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.pattern, this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("pattern: ");
            builder.append(this.pattern.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("statements: ");
            builder.append(this.statements == null ? "null\n" : this.statements.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ImplicitRestNode
    extends Node {
        public ImplicitRestNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitImplicitRestNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            return builder.toString();
        }
    }

    public static final class ImplicitNode
    extends Node {
        public final Node value;

        public ImplicitNode(int startOffset, int length, Node value) {
            super(startOffset, length);
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitImplicitNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ImaginaryNode
    extends Node {
        public final Node numeric;

        public ImaginaryNode(int startOffset, int length, Node numeric) {
            super(startOffset, length);
            this.numeric = numeric;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.numeric.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.numeric};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitImaginaryNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("numeric: ");
            builder.append(this.numeric.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class IfNode
    extends Node {
        public final Node predicate;
        public final StatementsNode statements;
        public final Node subsequent;

        public IfNode(int startOffset, int length, Node predicate, StatementsNode statements, Node subsequent) {
            super(startOffset, length);
            this.predicate = predicate;
            this.statements = statements;
            this.subsequent = subsequent;
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            this.predicate.setNewLineFlag(source, newlineMarked);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.predicate.accept(visitor);
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
            if (this.subsequent != null) {
                this.subsequent.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.predicate, this.statements, this.subsequent};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitIfNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("predicate: ");
            builder.append(this.predicate.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("statements: ");
            builder.append(this.statements == null ? "null\n" : this.statements.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("subsequent: ");
            builder.append(this.subsequent == null ? "null\n" : this.subsequent.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class HashPatternNode
    extends Node {
        public final Node constant;
        public final AssocNode[] elements;
        public final Node rest;

        public HashPatternNode(int startOffset, int length, Node constant, AssocNode[] elements, Node rest) {
            super(startOffset, length);
            this.constant = constant;
            this.elements = elements;
            this.rest = rest;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.constant != null) {
                this.constant.accept(visitor);
            }
            for (AssocNode child : this.elements) {
                ((Node)child).accept(visitor);
            }
            if (this.rest != null) {
                this.rest.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.add(this.constant);
            childNodes.addAll(Arrays.asList(this.elements));
            childNodes.add(this.rest);
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitHashPatternNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("constant: ");
            builder.append(this.constant == null ? "null\n" : this.constant.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("elements: ");
            builder.append('\n');
            for (AssocNode child : this.elements) {
                builder.append(nextNextIndent).append(((Node)child).toString(nextNextIndent));
            }
            builder.append(nextIndent);
            builder.append("rest: ");
            builder.append(this.rest == null ? "null\n" : this.rest.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class HashNode
    extends Node {
        public final Node[] elements;

        public HashNode(int startOffset, int length, Node[] elements) {
            super(startOffset, length);
            this.elements = elements;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.elements) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.elements));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitHashNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("elements: ");
            builder.append('\n');
            for (Node child : this.elements) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            return builder.toString();
        }
    }

    public static final class GlobalVariableWriteNode
    extends Node {
        public final String name;
        public final Node value;

        public GlobalVariableWriteNode(int startOffset, int length, String name, Node value) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitGlobalVariableWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class GlobalVariableTargetNode
    extends Node {
        public final String name;

        public GlobalVariableTargetNode(int startOffset, int length, String name) {
            super(startOffset, length);
            this.name = name;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitGlobalVariableTargetNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class GlobalVariableReadNode
    extends Node {
        public final String name;

        public GlobalVariableReadNode(int startOffset, int length, String name) {
            super(startOffset, length);
            this.name = name;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitGlobalVariableReadNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class GlobalVariableOrWriteNode
    extends Node {
        public final String name;
        public final Node value;

        public GlobalVariableOrWriteNode(int startOffset, int length, String name, Node value) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitGlobalVariableOrWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class GlobalVariableOperatorWriteNode
    extends Node {
        public final String name;
        public final Node value;
        public final String binary_operator;

        public GlobalVariableOperatorWriteNode(int startOffset, int length, String name, Node value, String binary_operator) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
            this.binary_operator = binary_operator;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitGlobalVariableOperatorWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("binary_operator: ");
            builder.append('\"').append(this.binary_operator).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class GlobalVariableAndWriteNode
    extends Node {
        public final String name;
        public final Node value;

        public GlobalVariableAndWriteNode(int startOffset, int length, String name, Node value) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitGlobalVariableAndWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ForwardingSuperNode
    extends Node {
        public final BlockNode block;

        public ForwardingSuperNode(int startOffset, int length, BlockNode block) {
            super(startOffset, length);
            this.block = block;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.block != null) {
                this.block.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.block};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitForwardingSuperNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("block: ");
            builder.append(this.block == null ? "null\n" : this.block.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ForwardingParameterNode
    extends Node {
        public ForwardingParameterNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitForwardingParameterNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            return builder.toString();
        }
    }

    public static final class ForwardingArgumentsNode
    extends Node {
        public ForwardingArgumentsNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitForwardingArgumentsNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            return builder.toString();
        }
    }

    public static final class ForNode
    extends Node {
        public final Node index;
        public final Node collection;
        public final StatementsNode statements;

        public ForNode(int startOffset, int length, Node index, Node collection, StatementsNode statements) {
            super(startOffset, length);
            this.index = index;
            this.collection = collection;
            this.statements = statements;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.index.accept(visitor);
            this.collection.accept(visitor);
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.index, this.collection, this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitForNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("index: ");
            builder.append(this.index.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("collection: ");
            builder.append(this.collection.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("statements: ");
            builder.append(this.statements == null ? "null\n" : this.statements.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class FloatNode
    extends Node {
        public final double value;

        public FloatNode(int startOffset, int length, double value) {
            super(startOffset, length);
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitFloatNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value);
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class FlipFlopNode
    extends Node {
        public final short flags;
        public final Node left;
        public final Node right;

        public FlipFlopNode(int startOffset, int length, short flags, Node left, Node right) {
            super(startOffset, length);
            this.flags = flags;
            this.left = left;
            this.right = right;
        }

        public boolean isExcludeEnd() {
            return RangeFlags.isExcludeEnd(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.left != null) {
                this.left.accept(visitor);
            }
            if (this.right != null) {
                this.right.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.left, this.right};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitFlipFlopNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("RangeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("left: ");
            builder.append(this.left == null ? "null\n" : this.left.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("right: ");
            builder.append(this.right == null ? "null\n" : this.right.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class FindPatternNode
    extends Node {
        public final Node constant;
        public final SplatNode left;
        public final Node[] requireds;
        public final SplatNode right;

        public FindPatternNode(int startOffset, int length, Node constant, SplatNode left, Node[] requireds, SplatNode right) {
            super(startOffset, length);
            this.constant = constant;
            this.left = left;
            this.requireds = requireds;
            this.right = right;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.constant != null) {
                this.constant.accept(visitor);
            }
            this.left.accept(visitor);
            for (Node child : this.requireds) {
                child.accept(visitor);
            }
            this.right.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.add(this.constant);
            childNodes.add(this.left);
            childNodes.addAll(Arrays.asList(this.requireds));
            childNodes.add(this.right);
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitFindPatternNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("constant: ");
            builder.append(this.constant == null ? "null\n" : this.constant.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("left: ");
            builder.append(this.left.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("requireds: ");
            builder.append('\n');
            for (Node child : this.requireds) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            builder.append(nextIndent);
            builder.append("right: ");
            builder.append(this.right.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class FalseNode
    extends Node {
        public FalseNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitFalseNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            return builder.toString();
        }
    }

    public static final class EnsureNode
    extends Node {
        public final StatementsNode statements;

        public EnsureNode(int startOffset, int length, StatementsNode statements) {
            super(startOffset, length);
            this.statements = statements;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitEnsureNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("statements: ");
            builder.append(this.statements == null ? "null\n" : this.statements.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class EmbeddedVariableNode
    extends Node {
        public final Node variable;

        public EmbeddedVariableNode(int startOffset, int length, Node variable) {
            super(startOffset, length);
            this.variable = variable;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.variable.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.variable};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitEmbeddedVariableNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("variable: ");
            builder.append(this.variable.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class EmbeddedStatementsNode
    extends Node {
        public final StatementsNode statements;

        public EmbeddedStatementsNode(int startOffset, int length, StatementsNode statements) {
            super(startOffset, length);
            this.statements = statements;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitEmbeddedStatementsNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("statements: ");
            builder.append(this.statements == null ? "null\n" : this.statements.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ElseNode
    extends Node {
        public final StatementsNode statements;

        public ElseNode(int startOffset, int length, StatementsNode statements) {
            super(startOffset, length);
            this.statements = statements;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitElseNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("statements: ");
            builder.append(this.statements == null ? "null\n" : this.statements.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class DefinedNode
    extends Node {
        public final Node value;

        public DefinedNode(int startOffset, int length, Node value) {
            super(startOffset, length);
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitDefinedNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class DefNode
    extends Node {
        public final int serializedLength;
        public final String name;
        public final Node receiver;
        public final ParametersNode parameters;
        public final Node body;
        public final String[] locals;

        public DefNode(int startOffset, int length, int serializedLength, String name, Node receiver, ParametersNode parameters, Node body, String[] locals) {
            super(startOffset, length);
            this.serializedLength = serializedLength;
            this.name = name;
            this.receiver = receiver;
            this.parameters = parameters;
            this.body = body;
            this.locals = locals;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.receiver != null) {
                this.receiver.accept(visitor);
            }
            if (this.parameters != null) {
                this.parameters.accept(visitor);
            }
            if (this.body != null) {
                this.body.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.receiver, this.parameters, this.body};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitDefNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("receiver: ");
            builder.append(this.receiver == null ? "null\n" : this.receiver.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("parameters: ");
            builder.append(this.parameters == null ? "null\n" : this.parameters.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("body: ");
            builder.append(this.body == null ? "null\n" : this.body.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("locals: ");
            builder.append('\n');
            for (String constant : this.locals) {
                builder.append(nextNextIndent).append('\"').append(constant).append('\"').append('\n');
            }
            return builder.toString();
        }
    }

    public static final class ConstantWriteNode
    extends Node {
        public final String name;
        public final Node value;

        public ConstantWriteNode(int startOffset, int length, String name, Node value) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ConstantTargetNode
    extends Node {
        public final String name;

        public ConstantTargetNode(int startOffset, int length, String name) {
            super(startOffset, length);
            this.name = name;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantTargetNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class ConstantReadNode
    extends Node {
        public final String name;

        public ConstantReadNode(int startOffset, int length, String name) {
            super(startOffset, length);
            this.name = name;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantReadNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class ConstantPathWriteNode
    extends Node {
        public final ConstantPathNode target;
        public final Node value;

        public ConstantPathWriteNode(int startOffset, int length, ConstantPathNode target, Node value) {
            super(startOffset, length);
            this.target = target;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.target.accept(visitor);
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.target, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantPathWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("target: ");
            builder.append(this.target.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ConstantPathTargetNode
    extends Node {
        public final Node parent;
        public final String name;

        public ConstantPathTargetNode(int startOffset, int length, Node parent, String name) {
            super(startOffset, length);
            this.parent = parent;
            this.name = name;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.parent != null) {
                this.parent.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.parent};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantPathTargetNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("parent: ");
            builder.append(this.parent == null ? "null\n" : this.parent.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append(this.name == null ? "null" : "\"" + this.name + "\"");
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class ConstantPathOrWriteNode
    extends Node {
        public final ConstantPathNode target;
        public final Node value;

        public ConstantPathOrWriteNode(int startOffset, int length, ConstantPathNode target, Node value) {
            super(startOffset, length);
            this.target = target;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.target.accept(visitor);
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.target, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantPathOrWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("target: ");
            builder.append(this.target.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ConstantPathOperatorWriteNode
    extends Node {
        public final ConstantPathNode target;
        public final Node value;
        public final String binary_operator;

        public ConstantPathOperatorWriteNode(int startOffset, int length, ConstantPathNode target, Node value, String binary_operator) {
            super(startOffset, length);
            this.target = target;
            this.value = value;
            this.binary_operator = binary_operator;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.target.accept(visitor);
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.target, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantPathOperatorWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("target: ");
            builder.append(this.target.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("binary_operator: ");
            builder.append('\"').append(this.binary_operator).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class ConstantPathNode
    extends Node {
        public final Node parent;
        public final String name;

        public ConstantPathNode(int startOffset, int length, Node parent, String name) {
            super(startOffset, length);
            this.parent = parent;
            this.name = name;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.parent != null) {
                this.parent.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.parent};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantPathNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("parent: ");
            builder.append(this.parent == null ? "null\n" : this.parent.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append(this.name == null ? "null" : "\"" + this.name + "\"");
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class ConstantPathAndWriteNode
    extends Node {
        public final ConstantPathNode target;
        public final Node value;

        public ConstantPathAndWriteNode(int startOffset, int length, ConstantPathNode target, Node value) {
            super(startOffset, length);
            this.target = target;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.target.accept(visitor);
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.target, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantPathAndWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("target: ");
            builder.append(this.target.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ConstantOrWriteNode
    extends Node {
        public final String name;
        public final Node value;

        public ConstantOrWriteNode(int startOffset, int length, String name, Node value) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantOrWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ConstantOperatorWriteNode
    extends Node {
        public final String name;
        public final Node value;
        public final String binary_operator;

        public ConstantOperatorWriteNode(int startOffset, int length, String name, Node value, String binary_operator) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
            this.binary_operator = binary_operator;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantOperatorWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("binary_operator: ");
            builder.append('\"').append(this.binary_operator).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class ConstantAndWriteNode
    extends Node {
        public final String name;
        public final Node value;

        public ConstantAndWriteNode(int startOffset, int length, String name, Node value) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantAndWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ClassVariableWriteNode
    extends Node {
        public final String name;
        public final Node value;

        public ClassVariableWriteNode(int startOffset, int length, String name, Node value) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitClassVariableWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ClassVariableTargetNode
    extends Node {
        public final String name;

        public ClassVariableTargetNode(int startOffset, int length, String name) {
            super(startOffset, length);
            this.name = name;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitClassVariableTargetNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class ClassVariableReadNode
    extends Node {
        public final String name;

        public ClassVariableReadNode(int startOffset, int length, String name) {
            super(startOffset, length);
            this.name = name;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitClassVariableReadNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class ClassVariableOrWriteNode
    extends Node {
        public final String name;
        public final Node value;

        public ClassVariableOrWriteNode(int startOffset, int length, String name, Node value) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitClassVariableOrWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ClassVariableOperatorWriteNode
    extends Node {
        public final String name;
        public final Node value;
        public final String binary_operator;

        public ClassVariableOperatorWriteNode(int startOffset, int length, String name, Node value, String binary_operator) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
            this.binary_operator = binary_operator;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitClassVariableOperatorWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("binary_operator: ");
            builder.append('\"').append(this.binary_operator).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class ClassVariableAndWriteNode
    extends Node {
        public final String name;
        public final Node value;

        public ClassVariableAndWriteNode(int startOffset, int length, String name, Node value) {
            super(startOffset, length);
            this.name = name;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitClassVariableAndWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ClassNode
    extends Node {
        public final String[] locals;
        public final Node constant_path;
        public final Node superclass;
        public final Node body;
        public final String name;

        public ClassNode(int startOffset, int length, String[] locals, Node constant_path, Node superclass, Node body, String name) {
            super(startOffset, length);
            this.locals = locals;
            this.constant_path = constant_path;
            this.superclass = superclass;
            this.body = body;
            this.name = name;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.constant_path.accept(visitor);
            if (this.superclass != null) {
                this.superclass.accept(visitor);
            }
            if (this.body != null) {
                this.body.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.constant_path, this.superclass, this.body};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitClassNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("locals: ");
            builder.append('\n');
            for (String constant : this.locals) {
                builder.append(nextNextIndent).append('\"').append(constant).append('\"').append('\n');
            }
            builder.append(nextIndent);
            builder.append("constant_path: ");
            builder.append(this.constant_path.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("superclass: ");
            builder.append(this.superclass == null ? "null\n" : this.superclass.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("body: ");
            builder.append(this.body == null ? "null\n" : this.body.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class CaseNode
    extends Node {
        public final Node predicate;
        public final WhenNode[] conditions;
        public final ElseNode else_clause;

        public CaseNode(int startOffset, int length, Node predicate, WhenNode[] conditions, ElseNode else_clause) {
            super(startOffset, length);
            this.predicate = predicate;
            this.conditions = conditions;
            this.else_clause = else_clause;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.predicate != null) {
                this.predicate.accept(visitor);
            }
            for (WhenNode child : this.conditions) {
                ((Node)child).accept(visitor);
            }
            if (this.else_clause != null) {
                this.else_clause.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.add(this.predicate);
            childNodes.addAll(Arrays.asList(this.conditions));
            childNodes.add(this.else_clause);
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitCaseNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("predicate: ");
            builder.append(this.predicate == null ? "null\n" : this.predicate.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("conditions: ");
            builder.append('\n');
            for (WhenNode child : this.conditions) {
                builder.append(nextNextIndent).append(((Node)child).toString(nextNextIndent));
            }
            builder.append(nextIndent);
            builder.append("else_clause: ");
            builder.append(this.else_clause == null ? "null\n" : this.else_clause.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class CaseMatchNode
    extends Node {
        public final Node predicate;
        public final InNode[] conditions;
        public final ElseNode else_clause;

        public CaseMatchNode(int startOffset, int length, Node predicate, InNode[] conditions, ElseNode else_clause) {
            super(startOffset, length);
            this.predicate = predicate;
            this.conditions = conditions;
            this.else_clause = else_clause;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.predicate != null) {
                this.predicate.accept(visitor);
            }
            for (InNode child : this.conditions) {
                ((Node)child).accept(visitor);
            }
            if (this.else_clause != null) {
                this.else_clause.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.add(this.predicate);
            childNodes.addAll(Arrays.asList(this.conditions));
            childNodes.add(this.else_clause);
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitCaseMatchNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("predicate: ");
            builder.append(this.predicate == null ? "null\n" : this.predicate.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("conditions: ");
            builder.append('\n');
            for (InNode child : this.conditions) {
                builder.append(nextNextIndent).append(((Node)child).toString(nextNextIndent));
            }
            builder.append(nextIndent);
            builder.append("else_clause: ");
            builder.append(this.else_clause == null ? "null\n" : this.else_clause.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class CapturePatternNode
    extends Node {
        public final Node value;
        public final LocalVariableTargetNode target;

        public CapturePatternNode(int startOffset, int length, Node value, LocalVariableTargetNode target) {
            super(startOffset, length);
            this.value = value;
            this.target = target;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
            this.target.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value, this.target};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitCapturePatternNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("target: ");
            builder.append(this.target.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class CallTargetNode
    extends Node {
        public final short flags;
        public final Node receiver;
        public final String name;

        public CallTargetNode(int startOffset, int length, short flags, Node receiver, String name) {
            super(startOffset, length);
            this.flags = flags;
            this.receiver = receiver;
            this.name = name;
        }

        public boolean isSafeNavigation() {
            return CallNodeFlags.isSafeNavigation(this.flags);
        }

        public boolean isVariableCall() {
            return CallNodeFlags.isVariableCall(this.flags);
        }

        public boolean isAttributeWrite() {
            return CallNodeFlags.isAttributeWrite(this.flags);
        }

        public boolean isIgnoreVisibility() {
            return CallNodeFlags.isIgnoreVisibility(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.receiver.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.receiver};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitCallTargetNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("CallNodeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("receiver: ");
            builder.append(this.receiver.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class CallOrWriteNode
    extends Node {
        public final short flags;
        public final Node receiver;
        public final String read_name;
        public final String write_name;
        public final Node value;

        public CallOrWriteNode(int startOffset, int length, short flags, Node receiver, String read_name, String write_name, Node value) {
            super(startOffset, length);
            this.flags = flags;
            this.receiver = receiver;
            this.read_name = read_name;
            this.write_name = write_name;
            this.value = value;
        }

        public boolean isSafeNavigation() {
            return CallNodeFlags.isSafeNavigation(this.flags);
        }

        public boolean isVariableCall() {
            return CallNodeFlags.isVariableCall(this.flags);
        }

        public boolean isAttributeWrite() {
            return CallNodeFlags.isAttributeWrite(this.flags);
        }

        public boolean isIgnoreVisibility() {
            return CallNodeFlags.isIgnoreVisibility(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.receiver != null) {
                this.receiver.accept(visitor);
            }
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.receiver, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitCallOrWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("CallNodeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("receiver: ");
            builder.append(this.receiver == null ? "null\n" : this.receiver.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("read_name: ");
            builder.append('\"').append(this.read_name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("write_name: ");
            builder.append('\"').append(this.write_name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class CallOperatorWriteNode
    extends Node {
        public final short flags;
        public final Node receiver;
        public final String read_name;
        public final String write_name;
        public final String binary_operator;
        public final Node value;

        public CallOperatorWriteNode(int startOffset, int length, short flags, Node receiver, String read_name, String write_name, String binary_operator, Node value) {
            super(startOffset, length);
            this.flags = flags;
            this.receiver = receiver;
            this.read_name = read_name;
            this.write_name = write_name;
            this.binary_operator = binary_operator;
            this.value = value;
        }

        public boolean isSafeNavigation() {
            return CallNodeFlags.isSafeNavigation(this.flags);
        }

        public boolean isVariableCall() {
            return CallNodeFlags.isVariableCall(this.flags);
        }

        public boolean isAttributeWrite() {
            return CallNodeFlags.isAttributeWrite(this.flags);
        }

        public boolean isIgnoreVisibility() {
            return CallNodeFlags.isIgnoreVisibility(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.receiver != null) {
                this.receiver.accept(visitor);
            }
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.receiver, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitCallOperatorWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("CallNodeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("receiver: ");
            builder.append(this.receiver == null ? "null\n" : this.receiver.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("read_name: ");
            builder.append('\"').append(this.read_name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("write_name: ");
            builder.append('\"').append(this.write_name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("binary_operator: ");
            builder.append('\"').append(this.binary_operator).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class CallNode
    extends Node {
        public final short flags;
        public final Node receiver;
        public final String name;
        public final ArgumentsNode arguments;
        public final Node block;

        public CallNode(int startOffset, int length, short flags, Node receiver, String name, ArgumentsNode arguments, Node block) {
            super(startOffset, length);
            this.flags = flags;
            this.receiver = receiver;
            this.name = name;
            this.arguments = arguments;
            this.block = block;
        }

        public boolean isSafeNavigation() {
            return CallNodeFlags.isSafeNavigation(this.flags);
        }

        public boolean isVariableCall() {
            return CallNodeFlags.isVariableCall(this.flags);
        }

        public boolean isAttributeWrite() {
            return CallNodeFlags.isAttributeWrite(this.flags);
        }

        public boolean isIgnoreVisibility() {
            return CallNodeFlags.isIgnoreVisibility(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.receiver != null) {
                this.receiver.accept(visitor);
            }
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
            if (this.block != null) {
                this.block.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.receiver, this.arguments, this.block};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitCallNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("CallNodeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("receiver: ");
            builder.append(this.receiver == null ? "null\n" : this.receiver.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("arguments: ");
            builder.append(this.arguments == null ? "null\n" : this.arguments.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("block: ");
            builder.append(this.block == null ? "null\n" : this.block.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class CallAndWriteNode
    extends Node {
        public final short flags;
        public final Node receiver;
        public final String read_name;
        public final String write_name;
        public final Node value;

        public CallAndWriteNode(int startOffset, int length, short flags, Node receiver, String read_name, String write_name, Node value) {
            super(startOffset, length);
            this.flags = flags;
            this.receiver = receiver;
            this.read_name = read_name;
            this.write_name = write_name;
            this.value = value;
        }

        public boolean isSafeNavigation() {
            return CallNodeFlags.isSafeNavigation(this.flags);
        }

        public boolean isVariableCall() {
            return CallNodeFlags.isVariableCall(this.flags);
        }

        public boolean isAttributeWrite() {
            return CallNodeFlags.isAttributeWrite(this.flags);
        }

        public boolean isIgnoreVisibility() {
            return CallNodeFlags.isIgnoreVisibility(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.receiver != null) {
                this.receiver.accept(visitor);
            }
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.receiver, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitCallAndWriteNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("CallNodeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("receiver: ");
            builder.append(this.receiver == null ? "null\n" : this.receiver.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("read_name: ");
            builder.append('\"').append(this.read_name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("write_name: ");
            builder.append('\"').append(this.write_name).append('\"');
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class BreakNode
    extends Node {
        public final ArgumentsNode arguments;

        public BreakNode(int startOffset, int length, ArgumentsNode arguments) {
            super(startOffset, length);
            this.arguments = arguments;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.arguments};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitBreakNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("arguments: ");
            builder.append(this.arguments == null ? "null\n" : this.arguments.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class BlockParametersNode
    extends Node {
        public final ParametersNode parameters;
        public final BlockLocalVariableNode[] locals;

        public BlockParametersNode(int startOffset, int length, ParametersNode parameters, BlockLocalVariableNode[] locals) {
            super(startOffset, length);
            this.parameters = parameters;
            this.locals = locals;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.parameters != null) {
                this.parameters.accept(visitor);
            }
            for (BlockLocalVariableNode child : this.locals) {
                ((Node)child).accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.add(this.parameters);
            childNodes.addAll(Arrays.asList(this.locals));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitBlockParametersNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("parameters: ");
            builder.append(this.parameters == null ? "null\n" : this.parameters.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("locals: ");
            builder.append('\n');
            for (BlockLocalVariableNode child : this.locals) {
                builder.append(nextNextIndent).append(((Node)child).toString(nextNextIndent));
            }
            return builder.toString();
        }
    }

    public static final class BlockParameterNode
    extends Node {
        public final short flags;
        public final String name;

        public BlockParameterNode(int startOffset, int length, short flags, String name) {
            super(startOffset, length);
            this.flags = flags;
            this.name = name;
        }

        public boolean isRepeatedParameter() {
            return ParameterFlags.isRepeatedParameter(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitBlockParameterNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("ParameterFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append(this.name == null ? "null" : "\"" + this.name + "\"");
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class BlockNode
    extends Node {
        public final String[] locals;
        public final Node parameters;
        public final Node body;

        public BlockNode(int startOffset, int length, String[] locals, Node parameters, Node body) {
            super(startOffset, length);
            this.locals = locals;
            this.parameters = parameters;
            this.body = body;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.parameters != null) {
                this.parameters.accept(visitor);
            }
            if (this.body != null) {
                this.body.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.parameters, this.body};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitBlockNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("locals: ");
            builder.append('\n');
            for (String constant : this.locals) {
                builder.append(nextNextIndent).append('\"').append(constant).append('\"').append('\n');
            }
            builder.append(nextIndent);
            builder.append("parameters: ");
            builder.append(this.parameters == null ? "null\n" : this.parameters.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("body: ");
            builder.append(this.body == null ? "null\n" : this.body.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class BlockLocalVariableNode
    extends Node {
        public final short flags;
        public final String name;

        public BlockLocalVariableNode(int startOffset, int length, short flags, String name) {
            super(startOffset, length);
            this.flags = flags;
            this.name = name;
        }

        public boolean isRepeatedParameter() {
            return ParameterFlags.isRepeatedParameter(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitBlockLocalVariableNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("ParameterFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class BlockArgumentNode
    extends Node {
        public final Node expression;

        public BlockArgumentNode(int startOffset, int length, Node expression) {
            super(startOffset, length);
            this.expression = expression;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.expression != null) {
                this.expression.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.expression};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitBlockArgumentNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("expression: ");
            builder.append(this.expression == null ? "null\n" : this.expression.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class BeginNode
    extends Node {
        public final StatementsNode statements;
        public final RescueNode rescue_clause;
        public final ElseNode else_clause;
        public final EnsureNode ensure_clause;

        public BeginNode(int startOffset, int length, StatementsNode statements, RescueNode rescue_clause, ElseNode else_clause, EnsureNode ensure_clause) {
            super(startOffset, length);
            this.statements = statements;
            this.rescue_clause = rescue_clause;
            this.else_clause = else_clause;
            this.ensure_clause = ensure_clause;
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
            if (this.rescue_clause != null) {
                this.rescue_clause.accept(visitor);
            }
            if (this.else_clause != null) {
                this.else_clause.accept(visitor);
            }
            if (this.ensure_clause != null) {
                this.ensure_clause.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.statements, this.rescue_clause, this.else_clause, this.ensure_clause};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitBeginNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("statements: ");
            builder.append(this.statements == null ? "null\n" : this.statements.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("rescue_clause: ");
            builder.append(this.rescue_clause == null ? "null\n" : this.rescue_clause.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("else_clause: ");
            builder.append(this.else_clause == null ? "null\n" : this.else_clause.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("ensure_clause: ");
            builder.append(this.ensure_clause == null ? "null\n" : this.ensure_clause.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class BackReferenceReadNode
    extends Node {
        public final String name;

        public BackReferenceReadNode(int startOffset, int length, String name) {
            super(startOffset, length);
            this.name = name;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitBackReferenceReadNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("name: ");
            builder.append('\"').append(this.name).append('\"');
            builder.append('\n');
            return builder.toString();
        }
    }

    public static final class AssocSplatNode
    extends Node {
        public final Node value;

        public AssocSplatNode(int startOffset, int length, Node value) {
            super(startOffset, length);
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.value != null) {
                this.value.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitAssocSplatNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value == null ? "null\n" : this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class AssocNode
    extends Node {
        public final Node key;
        public final Node value;

        public AssocNode(int startOffset, int length, Node key, Node value) {
            super(startOffset, length);
            this.key = key;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.key.accept(visitor);
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.key, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitAssocNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("key: ");
            builder.append(this.key.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("value: ");
            builder.append(this.value.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class ArrayPatternNode
    extends Node {
        public final Node constant;
        public final Node[] requireds;
        public final Node rest;
        public final Node[] posts;

        public ArrayPatternNode(int startOffset, int length, Node constant, Node[] requireds, Node rest, Node[] posts) {
            super(startOffset, length);
            this.constant = constant;
            this.requireds = requireds;
            this.rest = rest;
            this.posts = posts;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.constant != null) {
                this.constant.accept(visitor);
            }
            for (Node child : this.requireds) {
                child.accept(visitor);
            }
            if (this.rest != null) {
                this.rest.accept(visitor);
            }
            for (Node child : this.posts) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.add(this.constant);
            childNodes.addAll(Arrays.asList(this.requireds));
            childNodes.add(this.rest);
            childNodes.addAll(Arrays.asList(this.posts));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitArrayPatternNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("constant: ");
            builder.append(this.constant == null ? "null\n" : this.constant.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("requireds: ");
            builder.append('\n');
            for (Node child : this.requireds) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            builder.append(nextIndent);
            builder.append("rest: ");
            builder.append(this.rest == null ? "null\n" : this.rest.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("posts: ");
            builder.append('\n');
            for (Node child : this.posts) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            return builder.toString();
        }
    }

    public static final class ArrayNode
    extends Node {
        public final short flags;
        public final Node[] elements;

        public ArrayNode(int startOffset, int length, short flags, Node[] elements) {
            super(startOffset, length);
            this.flags = flags;
            this.elements = elements;
        }

        public boolean isContainsSplat() {
            return ArrayNodeFlags.isContainsSplat(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.elements) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.elements));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitArrayNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("ArrayNodeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("elements: ");
            builder.append('\n');
            for (Node child : this.elements) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            return builder.toString();
        }
    }

    public static final class ArgumentsNode
    extends Node {
        public final short flags;
        public final Node[] arguments;

        public ArgumentsNode(int startOffset, int length, short flags, Node[] arguments) {
            super(startOffset, length);
            this.flags = flags;
            this.arguments = arguments;
        }

        public boolean isContainsForwarding() {
            return ArgumentsNodeFlags.isContainsForwarding(this.flags);
        }

        public boolean isContainsKeywords() {
            return ArgumentsNodeFlags.isContainsKeywords(this.flags);
        }

        public boolean isContainsKeywordSplat() {
            return ArgumentsNodeFlags.isContainsKeywordSplat(this.flags);
        }

        public boolean isContainsSplat() {
            return ArgumentsNodeFlags.isContainsSplat(this.flags);
        }

        public boolean isContainsMultipleSplats() {
            return ArgumentsNodeFlags.isContainsMultipleSplats(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.arguments) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.arguments));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitArgumentsNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            String nextNextIndent = nextIndent + "  ";
            builder.append(nextIndent);
            builder.append("ArgumentsNodeFlags: ");
            builder.append(this.flags);
            builder.append('\n');
            builder.append(nextIndent);
            builder.append("arguments: ");
            builder.append('\n');
            for (Node child : this.arguments) {
                builder.append(nextNextIndent).append(child.toString(nextNextIndent));
            }
            return builder.toString();
        }
    }

    public static final class AndNode
    extends Node {
        public final Node left;
        public final Node right;

        public AndNode(int startOffset, int length, Node left, Node right) {
            super(startOffset, length);
            this.left = left;
            this.right = right;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.left.accept(visitor);
            this.right.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.left, this.right};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitAndNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("left: ");
            builder.append(this.left.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("right: ");
            builder.append(this.right.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class AlternationPatternNode
    extends Node {
        public final Node left;
        public final Node right;

        public AlternationPatternNode(int startOffset, int length, Node left, Node right) {
            super(startOffset, length);
            this.left = left;
            this.right = right;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.left.accept(visitor);
            this.right.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.left, this.right};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitAlternationPatternNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("left: ");
            builder.append(this.left.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("right: ");
            builder.append(this.right.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class AliasMethodNode
    extends Node {
        public final Node new_name;
        public final Node old_name;

        public AliasMethodNode(int startOffset, int length, Node new_name, Node old_name) {
            super(startOffset, length);
            this.new_name = new_name;
            this.old_name = old_name;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.new_name.accept(visitor);
            this.old_name.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.new_name, this.old_name};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitAliasMethodNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("new_name: ");
            builder.append(this.new_name.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("old_name: ");
            builder.append(this.old_name.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class AliasGlobalVariableNode
    extends Node {
        public final Node new_name;
        public final Node old_name;

        public AliasGlobalVariableNode(int startOffset, int length, Node new_name, Node old_name) {
            super(startOffset, length);
            this.new_name = new_name;
            this.old_name = old_name;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.new_name.accept(visitor);
            this.old_name.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.new_name, this.old_name};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitAliasGlobalVariableNode(this);
        }

        @Override
        protected String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            String nextIndent = indent + "  ";
            builder.append(nextIndent);
            builder.append("new_name: ");
            builder.append(this.new_name.toString(nextIndent));
            builder.append(nextIndent);
            builder.append("old_name: ");
            builder.append(this.old_name.toString(nextIndent));
            return builder.toString();
        }
    }

    public static final class SymbolFlags
    implements Comparable<SymbolFlags> {
        public static final short FORCED_UTF8_ENCODING = 4;
        public static final short FORCED_BINARY_ENCODING = 8;
        public static final short FORCED_US_ASCII_ENCODING = 16;
        private final short flags;

        public static boolean isForcedUtf8Encoding(short flags) {
            return (flags & 4) != 0;
        }

        public static boolean isForcedBinaryEncoding(short flags) {
            return (flags & 8) != 0;
        }

        public static boolean isForcedUsAsciiEncoding(short flags) {
            return (flags & 0x10) != 0;
        }

        public SymbolFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof SymbolFlags)) {
                return false;
            }
            return this.flags == ((SymbolFlags)other).flags;
        }

        @Override
        public int compareTo(SymbolFlags other) {
            return this.flags - other.flags;
        }

        public boolean isForcedUtf8Encoding() {
            return (this.flags & 4) != 0;
        }

        public boolean isForcedBinaryEncoding() {
            return (this.flags & 8) != 0;
        }

        public boolean isForcedUsAsciiEncoding() {
            return (this.flags & 0x10) != 0;
        }
    }

    public static final class StringFlags
    implements Comparable<StringFlags> {
        public static final short FORCED_UTF8_ENCODING = 4;
        public static final short FORCED_BINARY_ENCODING = 8;
        public static final short FROZEN = 16;
        public static final short MUTABLE = 32;
        private final short flags;

        public static boolean isForcedUtf8Encoding(short flags) {
            return (flags & 4) != 0;
        }

        public static boolean isForcedBinaryEncoding(short flags) {
            return (flags & 8) != 0;
        }

        public static boolean isFrozen(short flags) {
            return (flags & 0x10) != 0;
        }

        public static boolean isMutable(short flags) {
            return (flags & 0x20) != 0;
        }

        public StringFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof StringFlags)) {
                return false;
            }
            return this.flags == ((StringFlags)other).flags;
        }

        @Override
        public int compareTo(StringFlags other) {
            return this.flags - other.flags;
        }

        public boolean isForcedUtf8Encoding() {
            return (this.flags & 4) != 0;
        }

        public boolean isForcedBinaryEncoding() {
            return (this.flags & 8) != 0;
        }

        public boolean isFrozen() {
            return (this.flags & 0x10) != 0;
        }

        public boolean isMutable() {
            return (this.flags & 0x20) != 0;
        }
    }

    public static final class ShareableConstantNodeFlags
    implements Comparable<ShareableConstantNodeFlags> {
        public static final short LITERAL = 4;
        public static final short EXPERIMENTAL_EVERYTHING = 8;
        public static final short EXPERIMENTAL_COPY = 16;
        private final short flags;

        public static boolean isLiteral(short flags) {
            return (flags & 4) != 0;
        }

        public static boolean isExperimentalEverything(short flags) {
            return (flags & 8) != 0;
        }

        public static boolean isExperimentalCopy(short flags) {
            return (flags & 0x10) != 0;
        }

        public ShareableConstantNodeFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ShareableConstantNodeFlags)) {
                return false;
            }
            return this.flags == ((ShareableConstantNodeFlags)other).flags;
        }

        @Override
        public int compareTo(ShareableConstantNodeFlags other) {
            return this.flags - other.flags;
        }

        public boolean isLiteral() {
            return (this.flags & 4) != 0;
        }

        public boolean isExperimentalEverything() {
            return (this.flags & 8) != 0;
        }

        public boolean isExperimentalCopy() {
            return (this.flags & 0x10) != 0;
        }
    }

    public static final class RegularExpressionFlags
    implements Comparable<RegularExpressionFlags> {
        public static final short IGNORE_CASE = 4;
        public static final short EXTENDED = 8;
        public static final short MULTI_LINE = 16;
        public static final short ONCE = 32;
        public static final short EUC_JP = 64;
        public static final short ASCII_8BIT = 128;
        public static final short WINDOWS_31J = 256;
        public static final short UTF_8 = 512;
        public static final short FORCED_UTF8_ENCODING = 1024;
        public static final short FORCED_BINARY_ENCODING = 2048;
        public static final short FORCED_US_ASCII_ENCODING = 4096;
        private final short flags;

        public static boolean isIgnoreCase(short flags) {
            return (flags & 4) != 0;
        }

        public static boolean isExtended(short flags) {
            return (flags & 8) != 0;
        }

        public static boolean isMultiLine(short flags) {
            return (flags & 0x10) != 0;
        }

        public static boolean isOnce(short flags) {
            return (flags & 0x20) != 0;
        }

        public static boolean isEucJp(short flags) {
            return (flags & 0x40) != 0;
        }

        public static boolean isAscii8bit(short flags) {
            return (flags & 0x80) != 0;
        }

        public static boolean isWindows31j(short flags) {
            return (flags & 0x100) != 0;
        }

        public static boolean isUtf8(short flags) {
            return (flags & 0x200) != 0;
        }

        public static boolean isForcedUtf8Encoding(short flags) {
            return (flags & 0x400) != 0;
        }

        public static boolean isForcedBinaryEncoding(short flags) {
            return (flags & 0x800) != 0;
        }

        public static boolean isForcedUsAsciiEncoding(short flags) {
            return (flags & 0x1000) != 0;
        }

        public RegularExpressionFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof RegularExpressionFlags)) {
                return false;
            }
            return this.flags == ((RegularExpressionFlags)other).flags;
        }

        @Override
        public int compareTo(RegularExpressionFlags other) {
            return this.flags - other.flags;
        }

        public boolean isIgnoreCase() {
            return (this.flags & 4) != 0;
        }

        public boolean isExtended() {
            return (this.flags & 8) != 0;
        }

        public boolean isMultiLine() {
            return (this.flags & 0x10) != 0;
        }

        public boolean isOnce() {
            return (this.flags & 0x20) != 0;
        }

        public boolean isEucJp() {
            return (this.flags & 0x40) != 0;
        }

        public boolean isAscii8bit() {
            return (this.flags & 0x80) != 0;
        }

        public boolean isWindows31j() {
            return (this.flags & 0x100) != 0;
        }

        public boolean isUtf8() {
            return (this.flags & 0x200) != 0;
        }

        public boolean isForcedUtf8Encoding() {
            return (this.flags & 0x400) != 0;
        }

        public boolean isForcedBinaryEncoding() {
            return (this.flags & 0x800) != 0;
        }

        public boolean isForcedUsAsciiEncoding() {
            return (this.flags & 0x1000) != 0;
        }
    }

    public static final class RangeFlags
    implements Comparable<RangeFlags> {
        public static final short EXCLUDE_END = 4;
        private final short flags;

        public static boolean isExcludeEnd(short flags) {
            return (flags & 4) != 0;
        }

        public RangeFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof RangeFlags)) {
                return false;
            }
            return this.flags == ((RangeFlags)other).flags;
        }

        @Override
        public int compareTo(RangeFlags other) {
            return this.flags - other.flags;
        }

        public boolean isExcludeEnd() {
            return (this.flags & 4) != 0;
        }
    }

    public static final class ParameterFlags
    implements Comparable<ParameterFlags> {
        public static final short REPEATED_PARAMETER = 4;
        private final short flags;

        public static boolean isRepeatedParameter(short flags) {
            return (flags & 4) != 0;
        }

        public ParameterFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ParameterFlags)) {
                return false;
            }
            return this.flags == ((ParameterFlags)other).flags;
        }

        @Override
        public int compareTo(ParameterFlags other) {
            return this.flags - other.flags;
        }

        public boolean isRepeatedParameter() {
            return (this.flags & 4) != 0;
        }
    }

    public static final class LoopFlags
    implements Comparable<LoopFlags> {
        public static final short BEGIN_MODIFIER = 4;
        private final short flags;

        public static boolean isBeginModifier(short flags) {
            return (flags & 4) != 0;
        }

        public LoopFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof LoopFlags)) {
                return false;
            }
            return this.flags == ((LoopFlags)other).flags;
        }

        @Override
        public int compareTo(LoopFlags other) {
            return this.flags - other.flags;
        }

        public boolean isBeginModifier() {
            return (this.flags & 4) != 0;
        }
    }

    public static final class KeywordHashNodeFlags
    implements Comparable<KeywordHashNodeFlags> {
        public static final short SYMBOL_KEYS = 4;
        private final short flags;

        public static boolean isSymbolKeys(short flags) {
            return (flags & 4) != 0;
        }

        public KeywordHashNodeFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof KeywordHashNodeFlags)) {
                return false;
            }
            return this.flags == ((KeywordHashNodeFlags)other).flags;
        }

        @Override
        public int compareTo(KeywordHashNodeFlags other) {
            return this.flags - other.flags;
        }

        public boolean isSymbolKeys() {
            return (this.flags & 4) != 0;
        }
    }

    public static final class InterpolatedStringNodeFlags
    implements Comparable<InterpolatedStringNodeFlags> {
        public static final short FROZEN = 4;
        public static final short MUTABLE = 8;
        private final short flags;

        public static boolean isFrozen(short flags) {
            return (flags & 4) != 0;
        }

        public static boolean isMutable(short flags) {
            return (flags & 8) != 0;
        }

        public InterpolatedStringNodeFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof InterpolatedStringNodeFlags)) {
                return false;
            }
            return this.flags == ((InterpolatedStringNodeFlags)other).flags;
        }

        @Override
        public int compareTo(InterpolatedStringNodeFlags other) {
            return this.flags - other.flags;
        }

        public boolean isFrozen() {
            return (this.flags & 4) != 0;
        }

        public boolean isMutable() {
            return (this.flags & 8) != 0;
        }
    }

    public static final class IntegerBaseFlags
    implements Comparable<IntegerBaseFlags> {
        public static final short BINARY = 4;
        public static final short DECIMAL = 8;
        public static final short OCTAL = 16;
        public static final short HEXADECIMAL = 32;
        private final short flags;

        public static boolean isBinary(short flags) {
            return (flags & 4) != 0;
        }

        public static boolean isDecimal(short flags) {
            return (flags & 8) != 0;
        }

        public static boolean isOctal(short flags) {
            return (flags & 0x10) != 0;
        }

        public static boolean isHexadecimal(short flags) {
            return (flags & 0x20) != 0;
        }

        public IntegerBaseFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof IntegerBaseFlags)) {
                return false;
            }
            return this.flags == ((IntegerBaseFlags)other).flags;
        }

        @Override
        public int compareTo(IntegerBaseFlags other) {
            return this.flags - other.flags;
        }

        public boolean isBinary() {
            return (this.flags & 4) != 0;
        }

        public boolean isDecimal() {
            return (this.flags & 8) != 0;
        }

        public boolean isOctal() {
            return (this.flags & 0x10) != 0;
        }

        public boolean isHexadecimal() {
            return (this.flags & 0x20) != 0;
        }
    }

    public static final class EncodingFlags
    implements Comparable<EncodingFlags> {
        public static final short FORCED_UTF8_ENCODING = 4;
        public static final short FORCED_BINARY_ENCODING = 8;
        private final short flags;

        public static boolean isForcedUtf8Encoding(short flags) {
            return (flags & 4) != 0;
        }

        public static boolean isForcedBinaryEncoding(short flags) {
            return (flags & 8) != 0;
        }

        public EncodingFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof EncodingFlags)) {
                return false;
            }
            return this.flags == ((EncodingFlags)other).flags;
        }

        @Override
        public int compareTo(EncodingFlags other) {
            return this.flags - other.flags;
        }

        public boolean isForcedUtf8Encoding() {
            return (this.flags & 4) != 0;
        }

        public boolean isForcedBinaryEncoding() {
            return (this.flags & 8) != 0;
        }
    }

    public static final class CallNodeFlags
    implements Comparable<CallNodeFlags> {
        public static final short SAFE_NAVIGATION = 4;
        public static final short VARIABLE_CALL = 8;
        public static final short ATTRIBUTE_WRITE = 16;
        public static final short IGNORE_VISIBILITY = 32;
        private final short flags;

        public static boolean isSafeNavigation(short flags) {
            return (flags & 4) != 0;
        }

        public static boolean isVariableCall(short flags) {
            return (flags & 8) != 0;
        }

        public static boolean isAttributeWrite(short flags) {
            return (flags & 0x10) != 0;
        }

        public static boolean isIgnoreVisibility(short flags) {
            return (flags & 0x20) != 0;
        }

        public CallNodeFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CallNodeFlags)) {
                return false;
            }
            return this.flags == ((CallNodeFlags)other).flags;
        }

        @Override
        public int compareTo(CallNodeFlags other) {
            return this.flags - other.flags;
        }

        public boolean isSafeNavigation() {
            return (this.flags & 4) != 0;
        }

        public boolean isVariableCall() {
            return (this.flags & 8) != 0;
        }

        public boolean isAttributeWrite() {
            return (this.flags & 0x10) != 0;
        }

        public boolean isIgnoreVisibility() {
            return (this.flags & 0x20) != 0;
        }
    }

    public static final class ArrayNodeFlags
    implements Comparable<ArrayNodeFlags> {
        public static final short CONTAINS_SPLAT = 4;
        private final short flags;

        public static boolean isContainsSplat(short flags) {
            return (flags & 4) != 0;
        }

        public ArrayNodeFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ArrayNodeFlags)) {
                return false;
            }
            return this.flags == ((ArrayNodeFlags)other).flags;
        }

        @Override
        public int compareTo(ArrayNodeFlags other) {
            return this.flags - other.flags;
        }

        public boolean isContainsSplat() {
            return (this.flags & 4) != 0;
        }
    }

    public static final class ArgumentsNodeFlags
    implements Comparable<ArgumentsNodeFlags> {
        public static final short CONTAINS_FORWARDING = 4;
        public static final short CONTAINS_KEYWORDS = 8;
        public static final short CONTAINS_KEYWORD_SPLAT = 16;
        public static final short CONTAINS_SPLAT = 32;
        public static final short CONTAINS_MULTIPLE_SPLATS = 64;
        private final short flags;

        public static boolean isContainsForwarding(short flags) {
            return (flags & 4) != 0;
        }

        public static boolean isContainsKeywords(short flags) {
            return (flags & 8) != 0;
        }

        public static boolean isContainsKeywordSplat(short flags) {
            return (flags & 0x10) != 0;
        }

        public static boolean isContainsSplat(short flags) {
            return (flags & 0x20) != 0;
        }

        public static boolean isContainsMultipleSplats(short flags) {
            return (flags & 0x40) != 0;
        }

        public ArgumentsNodeFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ArgumentsNodeFlags)) {
                return false;
            }
            return this.flags == ((ArgumentsNodeFlags)other).flags;
        }

        @Override
        public int compareTo(ArgumentsNodeFlags other) {
            return this.flags - other.flags;
        }

        public boolean isContainsForwarding() {
            return (this.flags & 4) != 0;
        }

        public boolean isContainsKeywords() {
            return (this.flags & 8) != 0;
        }

        public boolean isContainsKeywordSplat() {
            return (this.flags & 0x10) != 0;
        }

        public boolean isContainsSplat() {
            return (this.flags & 0x20) != 0;
        }

        public boolean isContainsMultipleSplats() {
            return (this.flags & 0x40) != 0;
        }
    }

    public static abstract class Node {
        public static final Node[] EMPTY_ARRAY = new Node[0];
        public final int startOffset;
        public final int length;
        private boolean newLineFlag = false;

        public Node(int startOffset, int length) {
            this.startOffset = startOffset;
            this.length = length;
        }

        public final int endOffset() {
            return this.startOffset + this.length;
        }

        public final boolean hasNewLineFlag() {
            return this.newLineFlag;
        }

        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            int line = source.findLine(this.startOffset);
            if (!newlineMarked[line]) {
                newlineMarked[line] = true;
                this.newLineFlag = true;
            }
        }

        public void setNewLineFlag(boolean newLineFlag) {
            this.newLineFlag = newLineFlag;
        }

        public abstract <T> T accept(AbstractNodeVisitor<T> var1);

        public abstract <T> void visitChildNodes(AbstractNodeVisitor<T> var1);

        public abstract Node[] childNodes();

        public String toString() {
            return this.toString("");
        }

        protected abstract String toString(String var1);
    }

    public static final class Source {
        public final byte[] bytes;
        private int startLine = 1;
        private int[] lineOffsets = null;

        Source(byte[] bytes) {
            this.bytes = bytes;
        }

        void setStartLine(int startLine) {
            this.startLine = startLine;
        }

        void setLineOffsets(int[] lineOffsets) {
            this.lineOffsets = lineOffsets;
        }

        public int line(int byteOffset) {
            return this.startLine + this.findLine(byteOffset);
        }

        public int findLine(int byteOffset) {
            if (byteOffset >= this.bytes.length) {
                byteOffset = this.bytes.length - 1;
            }
            assert (byteOffset >= 0) : byteOffset;
            int index = Arrays.binarySearch(this.lineOffsets, byteOffset);
            int line = index < 0 ? -index - 2 : index;
            assert (line >= 0 && line <= this.getLineCount()) : line;
            return line;
        }

        public int getLineCount() {
            return this.lineOffsets.length;
        }
    }

    public static final class Location {
        public static final Location[] EMPTY_ARRAY = new Location[0];
        public final int startOffset;
        public final int length;

        public Location(int startOffset, int length) {
            this.startOffset = startOffset;
            this.length = length;
        }

        public int endOffset() {
            return this.startOffset + this.length;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UnionType {
        public Class<? extends Node>[] value();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Nullable {
    }
}

