/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.builtins;

import com.oracle.truffle.api.dsl.NodeFactory;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.builtins.CoreMethodNodeManager;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.numeric.FixnumLowerNodeGen;
import org.truffleruby.core.support.TypeNodes;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyNode;

public final class PrimitiveNodeConstructor {
    private final Primitive annotation;
    private final NodeFactory<? extends RubyBaseNode> factory;

    public PrimitiveNodeConstructor(Primitive annotation, NodeFactory<? extends RubyBaseNode> factory) {
        this.annotation = annotation;
        this.factory = factory;
    }

    public int getPrimitiveArity() {
        return this.factory.getExecutionSignature().size();
    }

    public NodeFactory<? extends RubyBaseNode> getFactory() {
        return this.factory;
    }

    public RubyNode createInvokePrimitiveNode(RubyNode[] arguments) {
        for (int n = 0; n < arguments.length; ++n) {
            if (ArrayUtils.contains(this.annotation.lowerFixnum(), n)) {
                arguments[n] = FixnumLowerNodeGen.FixnumLowerASTNodeGen.create(arguments[n]);
            }
            if (ArrayUtils.contains(this.annotation.raiseIfFrozen(), n)) {
                arguments[n] = TypeNodes.TypeCheckFrozenNode.create(arguments[n]);
            }
            if (!ArrayUtils.contains(this.annotation.raiseIfNotMutable(), n)) continue;
            arguments[n] = TypeNodes.CheckMutableStringNode.create(arguments[n]);
        }
        return (RubyNode)CoreMethodNodeManager.createNodeFromFactory(this.factory, arguments);
    }
}

