/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.cext;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import org.truffleruby.cext.UnwrapNodeGen;
import org.truffleruby.cext.ValueWrapper;
import org.truffleruby.cext.ValueWrapperManager;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
@ImportStatic(value={ValueWrapperManager.class})
public abstract class UnwrapNode
extends RubyBaseNode {
    public abstract Object execute(Node var1, Object var2);

    @Specialization(guards={"!isTaggedLong(value.getHandle())"})
    static Object unwrapValueObject(ValueWrapper value) {
        return value.getObject();
    }

    @Specialization(guards={"isTaggedLong(value.getHandle())"})
    static long unwrapValueTaggedLong(ValueWrapper value) {
        return ValueWrapperManager.untagTaggedLong(value.getHandle());
    }

    @Specialization
    static Object longToWrapper(Node node, long value, @Cached @Cached.Shared UnwrapNativeNode unwrapNativeNode) {
        return unwrapNativeNode.execute(node, value);
    }

    @Specialization(guards={"!isWrapper(value)", "!isImplicitLong(value)"})
    static Object unwrapGeneric(Node node, Object value, @CachedLibrary(limit="getCacheLimit()") InteropLibrary values, @Cached @Cached.Shared UnwrapNativeNode unwrapNativeNode, @Cached InlinedBranchProfile unsupportedProfile) {
        long handle;
        try {
            handle = values.asPointer(value);
        }
        catch (UnsupportedMessageException e) {
            unsupportedProfile.enter(node);
            throw new RaiseException(UnwrapNode.getContext(node), UnwrapNode.coreExceptions(node).argumentError(e.getMessage(), node, (Throwable)e));
        }
        return unwrapNativeNode.execute(node, handle);
    }

    protected int getCacheLimit() {
        return this.getLanguage().options.DISPATCH_CACHE;
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={ValueWrapperManager.class})
    public static abstract class UnwrapNativeNode
    extends RubyBaseNode {
        public static Object executeUncached(long handle) {
            return UnwrapNodeGen.UnwrapNativeNodeGen.getUncached().execute(null, handle);
        }

        public abstract Object execute(Node var1, long var2);

        @Specialization(guards={"handle == FALSE_HANDLE"})
        static boolean unwrapFalse(long handle) {
            return false;
        }

        @Specialization(guards={"handle == TRUE_HANDLE"})
        static boolean unwrapTrue(long handle) {
            return true;
        }

        @Specialization(guards={"handle == UNDEF_HANDLE"})
        static NotProvided unwrapUndef(long handle) {
            return NotProvided.INSTANCE;
        }

        @Specialization(guards={"handle == NIL_HANDLE"})
        static Object unwrapNil(long handle) {
            return nil;
        }

        @Specialization(guards={"isTaggedLong(handle)"})
        static long unwrapTaggedLong(long handle) {
            return ValueWrapperManager.untagTaggedLong(handle);
        }

        @Specialization(guards={"isTaggedObject(handle)"})
        static Object unwrapTaggedObject(Node node, long handle, @Cached InlinedBranchProfile noHandleProfile) {
            ValueWrapper wrapper = UnwrapNativeNode.getContext(node).getValueWrapperManager().getWrapperFromHandleMap(handle, UnwrapNativeNode.getLanguage(node));
            if (wrapper == null) {
                noHandleProfile.enter(node);
                UnwrapNativeNode.raiseError(handle);
            }
            return wrapper.getObject();
        }

        @Fallback
        static ValueWrapper unWrapUnexpectedHandle(long handle) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)("corrupt handle 0x" + Long.toHexString(handle)));
        }

        @CompilerDirectives.TruffleBoundary
        private static void raiseError(long handle) {
            throw CompilerDirectives.shouldNotReachHere((String)("dead handle 0x" + Long.toHexString(handle)));
        }
    }

    @ImportStatic(value={ValueWrapperManager.class})
    public static abstract class UnwrapCArrayNode
    extends RubyBaseNode {
        public abstract Object[] execute(Object var1);

        @ExplodeLoop
        @Specialization(guards={"size == cachedSize", "cachedSize <= MAX_EXPLODE_SIZE"}, limit="1")
        Object[] unwrapCArrayExplode(Object cArray, @CachedLibrary(value="cArray") InteropLibrary interop, @Bind(value="getArraySize(cArray, interop)") int size, @Cached(value="size") int cachedSize, @Cached @Cached.Shared UnwrapNode unwrapNode) {
            Object[] store = new Object[cachedSize];
            for (int i = 0; i < cachedSize; ++i) {
                Object cValue = UnwrapCArrayNode.readArrayElement(cArray, interop, i);
                store[i] = unwrapNode.execute(this, cValue);
            }
            return store;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(replaces={"unwrapCArrayExplode"}, limit="getDefaultCacheLimit()")
        Object[] unwrapCArray(Object cArray, @CachedLibrary(value="cArray") InteropLibrary interop, @Bind(value="getArraySize(cArray, interop)") int size, @Cached @Cached.Shared UnwrapNode unwrapNode, @Cached LoopConditionProfile loopProfile) {
            Object[] store = new Object[size];
            int i = 0;
            try {
                while (loopProfile.inject(i < size)) {
                    Object cValue = UnwrapCArrayNode.readArrayElement(cArray, interop, i);
                    store[i] = unwrapNode.execute(this, cValue);
                    TruffleSafepoint.poll((Node)this);
                    ++i;
                }
            }
            finally {
                this.profileAndReportLoopCount(loopProfile, i);
            }
            return store;
        }

        protected static int getArraySize(Object cArray, InteropLibrary interop) {
            try {
                return Math.toIntExact(interop.getArraySize(cArray));
            }
            catch (UnsupportedMessageException | ArithmeticException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        private static Object readArrayElement(Object cArray, InteropLibrary interop, int i) {
            try {
                return interop.readArrayElement(cArray, (long)i);
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={ValueWrapperManager.class})
    public static abstract class ToWrapperNode
    extends RubyBaseNode {
        public abstract ValueWrapper execute(Node var1, Object var2);

        @Specialization
        static ValueWrapper wrappedValueWrapper(ValueWrapper value) {
            return value;
        }

        @Specialization
        static ValueWrapper longToWrapper(Node node, long value, @Cached @Cached.Shared NativeToWrapperNode nativeToWrapperNode) {
            return nativeToWrapperNode.execute(node, value);
        }

        @Fallback
        static ValueWrapper genericToWrapper(Node node, Object value, @CachedLibrary(limit="getCacheLimit()") InteropLibrary values, @Cached @Cached.Shared NativeToWrapperNode nativeToWrapperNode, @Cached InlinedBranchProfile unsupportedProfile) {
            long handle;
            try {
                handle = values.asPointer(value);
            }
            catch (UnsupportedMessageException e) {
                unsupportedProfile.enter(node);
                throw new RaiseException(ToWrapperNode.getContext(node), ToWrapperNode.coreExceptions(node).argumentError(e.getMessage(), node, (Throwable)e));
            }
            return nativeToWrapperNode.execute(node, handle);
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.DISPATCH_CACHE;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={ValueWrapperManager.class})
    public static abstract class NativeToWrapperNode
    extends RubyBaseNode {
        public abstract ValueWrapper execute(Node var1, long var2);

        @Specialization(guards={"handle == FALSE_HANDLE"})
        static ValueWrapper unwrapFalse(long handle) {
            return new ValueWrapper(false, 0L, null);
        }

        @Specialization(guards={"handle == TRUE_HANDLE"})
        static ValueWrapper unwrapTrue(long handle) {
            return new ValueWrapper(true, 6L, null);
        }

        @Specialization(guards={"handle == UNDEF_HANDLE"})
        static ValueWrapper unwrapUndef(long handle) {
            return new ValueWrapper(NotProvided.INSTANCE, 10L, null);
        }

        @Specialization(guards={"handle == NIL_HANDLE"})
        static ValueWrapper unwrapNil(long handle) {
            return nil.getValueWrapper();
        }

        @Specialization(guards={"isTaggedLong(handle)"})
        static ValueWrapper unwrapTaggedLong(long handle) {
            return new ValueWrapper(null, handle, null);
        }

        @Specialization(guards={"isTaggedObject(handle)"})
        static ValueWrapper unwrapTaggedObject(Node node, long handle) {
            return NativeToWrapperNode.getContext(node).getValueWrapperManager().getWrapperFromHandleMap(handle, NativeToWrapperNode.getLanguage(node));
        }

        @Fallback
        static ValueWrapper unWrapUnexpectedHandle(long handle) {
            return null;
        }
    }
}

