/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.collections;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.function.Function;
import org.truffleruby.annotations.SuppressFBWarnings;

public abstract class ConcurrentOperations {
    @CompilerDirectives.TruffleBoundary
    public static <K, V> V getOrCompute(Map<K, V> map, K key, Function<? super K, ? extends V> compute) {
        V value = map.get(key);
        if (value != null) {
            return value;
        }
        return map.computeIfAbsent((K)key, compute);
    }

    public static <K, V> boolean replace(Map<K, V> map, K key, V oldValue, V newValue) {
        return oldValue == null ? map.putIfAbsent(key, newValue) == null : map.replace(key, oldValue, newValue);
    }

    @SuppressFBWarnings(value={"WA_AWAIT_NOT_IN_LOOP"})
    public static void awaitAndCheckInterrupt(Condition condition) throws InterruptedException {
        condition.await();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public static boolean awaitAndCheckInterrupt(Condition condition, long time, TimeUnit unit) throws InterruptedException {
        boolean value = condition.await(time, unit);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return value;
    }
}

