/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import java.time.Instant;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.symbol.RubySymbol;
import sun.misc.Signal;

@CoreModule(value="Process")
public abstract class ProcessNodes {

    @Primitive(name="process_kill_raise")
    public static abstract class ProcessKillRaiseNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int raise(RubySymbol signalName) {
            Signal signal = new Signal(signalName.getString());
            try {
                Signal.raise(signal);
            }
            catch (IllegalArgumentException e) {
                return -1;
            }
            return 1;
        }
    }

    @Primitive(name="process_time_instant")
    public static abstract class ProcessTimeInstantNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        long instant() {
            Instant now = Instant.now();
            return now.getEpochSecond() * 1000000000L + (long)now.getNano();
        }
    }

    @Primitive(name="process_time_nanotime")
    public static abstract class ProcessTimeNanoTimeNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        long nanoTime() {
            return System.nanoTime();
        }
    }

    @CoreMethod(names={"argv0"}, onSingleton=true)
    public static abstract class Argv0Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        ImmutableRubyString argv0() {
            return this.getContext().getMainScriptName();
        }
    }
}

